/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.graphics.Rect;
import android.view.View;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.node.LayoutNode;
import androidx.compose.ui.node.LayoutNodeKt;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.platform.AndroidOwner;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.unit.PxBounds;
import androidx.compose.ui.unit.PxKt;
import androidx.test.espresso.matcher.ViewMatchers;
import androidx.ui.test.AndroidAssertionsKt;
import androidx.ui.test.SemanticsNodeInteraction;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000\u0018\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\f\u0010\u0000\u001a\u00020\u0001*\u00020\u0002H\u0000\u001a\f\u0010\u0003\u001a\u00020\u0004*\u00020\u0005H\u0000\u001a\f\u0010\u0006\u001a\u00020\u0001*\u00020\u0005H\u0000\u00a8\u0006\u0007"}, d2={"checkIsDisplayed", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "clippedNodeBoundsInWindow", "Landroidx/compose/ui/geometry/Rect;", "Landroidx/compose/ui/semantics/SemanticsNode;", "isInScreenBounds", "ui-test_release"})
public final class AndroidAssertionsKt {
    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static final boolean checkIsDisplayed(@NotNull SemanticsNodeInteraction $this$checkIsDisplayed) {
        AndroidOwner androidOwner;
        Intrinsics.checkNotNullParameter((Object)$this$checkIsDisplayed, (String)"<this>");
        String errorMessageOnFail = "Failed to perform isDisplayed check.";
        SemanticsNode node = $this$checkIsDisplayed.fetchSemanticsNode(errorMessageOnFail);
        LayoutNode layoutNode = node.getComponentNode();
        if (AndroidAssertionsKt.checkIsDisplayed$isNotPlaced(layoutNode)) return false;
        if (LayoutNodeKt.findClosestParentNode((LayoutNode)layoutNode, (Function1)checkIsDisplayed.1.INSTANCE) != null) {
            return false;
        }
        Owner owner = layoutNode.getOwner();
        AndroidOwner androidOwner2 = androidOwner = owner instanceof AndroidOwner ? (AndroidOwner)owner : null;
        if (androidOwner != null) {
            owner = androidOwner;
            boolean bl = false;
            boolean bl2 = false;
            Owner it = owner;
            boolean bl3 = false;
            if (!ViewMatchers.isDisplayed().matches((Object)it.getView())) {
                return false;
            }
        }
        PxBounds globalRect = node.getGlobalBounds();
        if (!AndroidAssertionsKt.isInScreenBounds(node)) {
            return false;
        }
        PxBounds $this$width$iv = globalRect;
        boolean $i$f$getWidth = false;
        if (!($this$width$iv.getRight() - $this$width$iv.getLeft() > 0.0f)) return false;
        PxBounds $this$height$iv = globalRect;
        boolean $i$f$getHeight = false;
        if (!($this$height$iv.getBottom() - $this$height$iv.getTop() > 0.0f)) return false;
        return true;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final androidx.compose.ui.geometry.Rect clippedNodeBoundsInWindow(@NotNull SemanticsNode $this$clippedNodeBoundsInWindow) {
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$clippedNodeBoundsInWindow, (String)"<this>");
        Owner owner = $this$clippedNodeBoundsInWindow.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.compose.ui.platform.AndroidOwner");
        }
        View composeView = ((AndroidOwner)owner).getView();
        int[] nArray = new int[]{0, 0};
        boolean bl = false;
        boolean bl2 = false;
        int[] it = nArray;
        boolean bl3 = false;
        composeView.getLocationInWindow(it);
        float f = it[0];
        float y$iv = it[1];
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var12_12 = x$iv;
        boolean bl4 = false;
        long v1$iv$iv = Float.floatToIntBits((float)var12_12);
        float f2 = y$iv;
        boolean bl5 = false;
        long v2$iv$iv = Float.floatToIntBits(f2);
        Offset rootLocationInWindow = new Offset(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL);
        return PxKt.toRect((PxBounds)$this$clippedNodeBoundsInWindow.getBoundsInRoot()).shift(rootLocationInWindow);
    }

    public static final boolean isInScreenBounds(@NotNull SemanticsNode $this$isInScreenBounds) {
        Intrinsics.checkNotNullParameter((Object)$this$isInScreenBounds, (String)"<this>");
        Owner owner = $this$isInScreenBounds.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.compose.ui.platform.AndroidOwner");
        }
        View composeView = ((AndroidOwner)owner).getView();
        androidx.compose.ui.geometry.Rect nodeBoundsInWindow = AndroidAssertionsKt.clippedNodeBoundsInWindow($this$isInScreenBounds);
        if (nodeBoundsInWindow.getWidth() == 0.0f || nodeBoundsInWindow.getHeight() == 0.0f) {
            return false;
        }
        Rect globalRootRect = new Rect();
        if (!composeView.getGlobalVisibleRect(globalRootRect)) {
            return false;
        }
        return nodeBoundsInWindow.getTop() >= (float)globalRootRect.top && nodeBoundsInWindow.getLeft() >= (float)globalRootRect.left && nodeBoundsInWindow.getRight() <= (float)globalRootRect.right && nodeBoundsInWindow.getBottom() <= (float)globalRootRect.bottom;
    }

    private static final boolean checkIsDisplayed$isNotPlaced(LayoutNode node) {
        return !node.isPlaced();
    }

    public static final /* synthetic */ boolean access$checkIsDisplayed$isNotPlaced(LayoutNode node) {
        return AndroidAssertionsKt.checkIsDisplayed$isNotPlaced(node);
    }
}

