/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import android.graphics.Bitmap;
import android.graphics.Path;
import android.os.Build;
import android.view.View;
import android.view.ViewParent;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.SizeKt;
import androidx.compose.ui.graphics.AndroidPath;
import androidx.compose.ui.graphics.AndroidPathKt;
import androidx.compose.ui.graphics.Color;
import androidx.compose.ui.graphics.ColorKt;
import androidx.compose.ui.graphics.Outline;
import androidx.compose.ui.graphics.OutlineKt;
import androidx.compose.ui.graphics.Path;
import androidx.compose.ui.graphics.RectangleShapeKt;
import androidx.compose.ui.graphics.Shape;
import androidx.compose.ui.node.Owner;
import androidx.compose.ui.platform.AndroidOwner;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.IntOffset;
import androidx.compose.ui.unit.IntSize;
import androidx.compose.ui.window.DialogWindowProvider;
import androidx.ui.test.AndroidBitmapHelpersKt;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.UtilsKt;
import androidx.ui.test.android.WindowCaptureKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.IntRange;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.Assert;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000\u0088\u0001\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u001a\u0012\u0010\u0000\u001a\u0004\u0018\u00010\u00012\u0006\u0010\u0002\u001a\u00020\u0003H\u0002\u001a2\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000b\u0010\f\u001a2\u0010\r\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\b2\u0006\u0010\n\u001a\u00020\bH\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u000e\u0010\f\u001a\u001c\u0010\u000f\u001a\u00020\u0010*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u0013\u0010\u0014\u001aB\u0010\u0015\u001a\u00020\u0016*\u00020\u00102\u0006\u0010\u0017\u001a\u00020\u00122\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0014\b\u0002\u0010\u001b\u001a\u000e\u0012\u0004\u0012\u00020\u0012\u0012\u0004\u0012\u00020\u001d0\u001c\u00f8\u0001\u0000\u00a2\u0006\u0004\b\u001e\u0010\u001f\u001aC\u0010 \u001a\u00020\u0016*\u00020\u00102\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2#\u0010#\u001a\u001f\u0012\u0013\u0012\u00110$\u00a2\u0006\f\b%\u0012\b\b&\u0012\u0004\b\b('\u0012\u0006\u0012\u0004\u0018\u00010\u00120\u001c\u00f8\u0001\u0000\u00a2\u0006\u0002\b(\u001a\u0084\u0001\u0010)\u001a\u00020\u0016*\u00020\u00102\u0006\u0010*\u001a\u00020+2\u0006\u0010,\u001a\u00020-2\u0006\u0010.\u001a\u00020\u00122\u0006\u0010/\u001a\u00020\u00122\b\b\u0002\u00100\u001a\u00020-2\b\b\u0002\u00101\u001a\u00020\b2\b\b\u0002\u00102\u001a\u00020\b2\b\b\u0002\u0010\u0007\u001a\u00020\b2\b\b\u0002\u0010\t\u001a\u00020\b2\b\b\u0002\u00103\u001a\u00020\b2\b\b\u0002\u00104\u001a\u00020\b2\b\b\u0002\u00105\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b6\u00107\u001aP\u0010)\u001a\u00020\u0016*\u00020\u00102\u0006\u0010*\u001a\u00020+2\u0006\u00108\u001a\u0002092\u0006\u0010:\u001a\u0002092\u0006\u0010/\u001a\u00020\u00122\u0006\u0010.\u001a\u00020\u00122\b\b\u0002\u0010,\u001a\u00020-2\b\b\u0002\u00105\u001a\u00020\b\u00f8\u0001\u0000\u00a2\u0006\u0004\b;\u0010<\u001a\f\u0010=\u001a\u00020\u0010*\u00020\u0003H\u0007\u001a\f\u0010=\u001a\u00020\u0010*\u00020>H\u0007\u001a\u001c\u0010?\u001a\u00020@*\u00020A2\u0006\u0010\u0006\u001a\u00020\u0005\u00f8\u0001\u0000\u00a2\u0006\u0004\bB\u0010C\u001a\u001e\u0010D\u001a\u00020@*\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012H\u0002\u00f8\u0001\u0000\u00a2\u0006\u0004\bE\u0010F\u001a\u0015\u0010G\u001a\u00020H*\u00020\b2\u0006\u0010G\u001a\u00020\bH\u0082\u0004\u0082\u0002\u0004\n\u0002\b\u0019\u00a8\u0006I"}, d2={"findDialogWindowProviderInParent", "Landroidx/compose/ui/window/DialogWindowProvider;", "view", "Landroid/view/View;", "pixelCloserToCenter", "Landroidx/compose/ui/geometry/Offset;", "offset", "shapeSizeX", "", "shapeSizeY", "delta", "pixelCloserToCenter-6Rhqavg", "(JFFF)J", "pixelFartherFromCenter", "pixelFartherFromCenter-6Rhqavg", "assertContainsColor", "Landroid/graphics/Bitmap;", "expectedColor", "Landroidx/compose/ui/graphics/Color;", "assertContainsColor-VZNGtkI", "(Landroid/graphics/Bitmap;J)Landroid/graphics/Bitmap;", "assertPixelColor", "", "expected", "x", "", "y", "error", "Lkotlin/Function1;", "", "assertPixelColor-eWrXCG0", "(Landroid/graphics/Bitmap;JIILkotlin/jvm/functions/Function1;)V", "assertPixels", "expectedSize", "Landroidx/compose/ui/unit/IntSize;", "expectedColorProvider", "Landroidx/compose/ui/unit/IntOffset;", "Lkotlin/ParameterName;", "name", "pos", "assertPixels-mvPU1zk", "assertShape", "density", "Landroidx/compose/ui/unit/Density;", "shape", "Landroidx/compose/ui/graphics/Shape;", "shapeColor", "backgroundColor", "backgroundShape", "sizeX", "sizeY", "centerX", "centerY", "shapeOverlapPixelCount", "assertShape-LBqplUo", "(Landroid/graphics/Bitmap;Landroidx/compose/ui/unit/Density;Landroidx/compose/ui/graphics/Shape;JJLandroidx/compose/ui/graphics/Shape;FFFFFFF)V", "horizontalPadding", "Landroidx/compose/ui/unit/Dp;", "verticalPadding", "assertShape-WOPiG5A", "(Landroid/graphics/Bitmap;Landroidx/compose/ui/unit/Density;FFJJLandroidx/compose/ui/graphics/Shape;F)V", "captureToBitmap", "Landroidx/ui/test/SemanticsNodeInteraction;", "contains", "", "Landroidx/compose/ui/graphics/Path;", "contains-ej0GBII", "(Landroidx/compose/ui/graphics/Path;J)Z", "containsColor", "containsColor-VZNGtkI", "(Landroid/graphics/Bitmap;J)Z", "until", "Lkotlin/ranges/IntRange;", "ui-test_release"})
public final class AndroidBitmapHelpersKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull SemanticsNodeInteraction $this$captureToBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        SemanticsNode node = $this$captureToBitmap.fetchSemanticsNode("Failed to capture a node to bitmap.");
        Window windowToUse = null;
        SemanticsNode popupParentMaybe2 = UtilsKt.findClosestParentNode(node, true, (Function1<? super SemanticsNode, Boolean>)((Function1)captureToBitmap.popupParentMaybe.1.INSTANCE));
        if (popupParentMaybe2 != null) {
            throw new IllegalArgumentException("The node that is being captured to bitmap is in a popup or is a popup itself. Popups currently cannot be captured to bitmap.");
        }
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.compose.ui.platform.AndroidOwner");
        }
        View view = ((AndroidOwner)owner).getView();
        SemanticsNode dialogParentNodeMaybe2 = UtilsKt.findClosestParentNode(node, true, (Function1<? super SemanticsNode, Boolean>)((Function1)captureToBitmap.dialogParentNodeMaybe.1.INSTANCE));
        if (dialogParentNodeMaybe2 != null) {
            DialogWindowProvider dialogWindowProvider = AndroidBitmapHelpersKt.findDialogWindowProviderInParent(view);
            if (dialogWindowProvider == null) {
                throw new IllegalArgumentException("Could not find a dialog window provider to capture its bitmap");
            }
            DialogWindowProvider dialogProvider = dialogWindowProvider;
            windowToUse = dialogProvider.getWindow();
            if (Build.VERSION.SDK_INT < 28) {
                throw new IllegalArgumentException("Cannot currently capture dialogs on API lower than 28!");
            }
        }
        Rect nodeBounds = node.getBoundsInRoot();
        android.graphics.Rect nodeBoundsRect = new android.graphics.Rect(MathKt.roundToInt((float)nodeBounds.getLeft()), MathKt.roundToInt((float)nodeBounds.getTop()), MathKt.roundToInt((float)nodeBounds.getRight()), MathKt.roundToInt((float)nodeBounds.getBottom()));
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        view.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        nodeBoundsRect.offset(x, y);
        return WindowCaptureKt.captureRegionToBitmap(nodeBoundsRect, view, windowToUse);
    }

    private static final DialogWindowProvider findDialogWindowProviderInParent(View view) {
        if (view instanceof DialogWindowProvider) {
            return (DialogWindowProvider)view;
        }
        ViewParent viewParent = view.getParent();
        if (viewParent == null) {
            return null;
        }
        ViewParent parent = viewParent;
        if (parent instanceof View) {
            return AndroidBitmapHelpersKt.findDialogWindowProviderInParent((View)parent);
        }
        return null;
    }

    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureToBitmap(@NotNull View $this$captureToBitmap) {
        Intrinsics.checkNotNullParameter((Object)$this$captureToBitmap, (String)"<this>");
        int[] nArray = new int[]{0, 0};
        int[] locationInWindow = nArray;
        $this$captureToBitmap.getLocationInWindow(locationInWindow);
        int x = locationInWindow[0];
        int y = locationInWindow[1];
        android.graphics.Rect boundsInWindow = new android.graphics.Rect(x, y, x + $this$captureToBitmap.getWidth(), y + $this$captureToBitmap.getHeight());
        return WindowCaptureKt.captureRegionToBitmap$default(boundsInWindow, $this$captureToBitmap, null, 4, null);
    }

    public static final void assertPixels-mvPU1zk(@NotNull Bitmap $this$assertPixels, @Nullable IntSize expectedSize, @NotNull Function1<? super IntOffset, Color> expectedColorProvider) {
        Intrinsics.checkNotNullParameter((Object)$this$assertPixels, (String)"$this$assertPixels");
        Intrinsics.checkNotNullParameter(expectedColorProvider, (String)"expectedColorProvider");
        if (expectedSize != null && ($this$assertPixels.getWidth() != IntSize.getWidth-impl((long)expectedSize.unbox-impl()) || $this$assertPixels.getHeight() != IntSize.getHeight-impl((long)expectedSize.unbox-impl()))) {
            throw new AssertionError((Object)("Bitmap size is wrong! Expected '" + expectedSize + "' but got '" + $this$assertPixels.getWidth() + " x " + $this$assertPixels.getHeight() + '\''));
        }
        int n = $this$assertPixels.getWidth();
        int n2 = 0;
        int n3 = n + -1;
        if (n != Integer.MIN_VALUE && n2 <= n3) {
            do {
                int x = n2++;
                int n4 = $this$assertPixels.getHeight();
                int n5 = 0;
                int n6 = n4 + -1;
                if (n4 == Integer.MIN_VALUE || n5 > n6) continue;
                do {
                    int y = n5++;
                    boolean $i$f$IntOffset = false;
                    boolean $i$f$packInts = false;
                    long pxPos = IntOffset.constructor-impl((long)((long)x << 32 | (long)y & 0xFFFFFFFFL));
                    Color expectedClr = (Color)expectedColorProvider.invoke((Object)IntOffset.box-impl((long)pxPos));
                    if (expectedClr == null) continue;
                    AndroidBitmapHelpersKt.assertPixelColor-eWrXCG0$default($this$assertPixels, expectedClr.unbox-impl(), x, y, null, 8, null);
                } while (n5 <= n6);
            } while (n2 <= n3);
        }
    }

    public static /* synthetic */ void assertPixels-mvPU1zk$default(Bitmap bitmap, IntSize intSize, Function1 function1, int n, Object object) {
        if ((n & 1) != 0) {
            intSize = null;
        }
        AndroidBitmapHelpersKt.assertPixels-mvPU1zk(bitmap, intSize, (Function1<? super IntOffset, Color>)function1);
    }

    public static final void assertPixelColor-eWrXCG0(@NotNull Bitmap $this$assertPixelColor, long expected, int x, int y, @NotNull Function1<? super Color, String> error) {
        Intrinsics.checkNotNullParameter((Object)$this$assertPixelColor, (String)"$this$assertPixelColor");
        Intrinsics.checkNotNullParameter(error, (String)"error");
        long color = ColorKt.Color((int)$this$assertPixelColor.getPixel(x, y));
        String errorString = (String)error.invoke((Object)Color.box-impl((long)color));
        Assert.assertEquals((String)errorString, (float)Color.getRed-impl((long)expected), (float)Color.getRed-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getGreen-impl((long)expected), (float)Color.getGreen-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getBlue-impl((long)expected), (float)Color.getBlue-impl((long)color), (float)0.02f);
        Assert.assertEquals((String)errorString, (float)Color.getAlpha-impl((long)expected), (float)Color.getAlpha-impl((long)color), (float)0.02f);
    }

    public static /* synthetic */ void assertPixelColor-eWrXCG0$default(Bitmap bitmap, long l, int n, int n2, Function1 function1, int n3, Object object) {
        if ((n3 & 8) != 0) {
            function1 = (Function1)new Function1<Color, String>(n, n2, l, null){
                private final /* synthetic */ int $x;
                private final /* synthetic */ int $y;
                private final /* synthetic */ long $expected;
                {
                    this.$x = $x;
                    this.$y = $y;
                    this.$expected = $expected;
                    super(1);
                }

                @NotNull
                public final String invoke(long color) {
                    return "Pixel(" + this.$x + ", " + this.$y + ") expected to be " + Color.toString-impl((long)this.$expected) + ", but was " + Color.toString-impl((long)color);
                }
                {
                    this($x, $y, $expected);
                }
            };
        }
        AndroidBitmapHelpersKt.assertPixelColor-eWrXCG0(bitmap, l, n, n2, (Function1<? super Color, String>)function1);
    }

    @NotNull
    public static final Bitmap assertContainsColor-VZNGtkI(@NotNull Bitmap $this$assertContainsColor, long expectedColor) {
        Intrinsics.checkNotNullParameter((Object)$this$assertContainsColor, (String)"$this$assertContainsColor");
        if (!AndroidBitmapHelpersKt.containsColor-VZNGtkI($this$assertContainsColor, expectedColor)) {
            throw new AssertionError((Object)("The given color " + Color.toString-impl((long)expectedColor) + " was not found in the bitmap."));
        }
        return $this$assertContainsColor;
    }

    private static final boolean containsColor-VZNGtkI(Bitmap $this$containsColor, long expectedColor) {
        int[] nArray = new int[$this$containsColor.getWidth() * $this$containsColor.getHeight()];
        int n = 0;
        int n2 = 0;
        int[] $this$containsColor_VZNGtkI_u24lambda_u2d0 = nArray;
        boolean bl = false;
        $this$containsColor.getPixels($this$containsColor_VZNGtkI_u24lambda_u2d0, 0, $this$containsColor.getWidth(), 0, 0, $this$containsColor.getWidth(), $this$containsColor.getHeight());
        int[] pixels = nArray;
        int n3 = $this$containsColor.getWidth();
        n = 0;
        n2 = n3 + -1;
        if (n3 != Integer.MIN_VALUE && n <= n2) {
            do {
                int x = n++;
                int n4 = $this$containsColor.getHeight();
                int n5 = 0;
                int n6 = n4 + -1;
                if (n4 == Integer.MIN_VALUE || n5 > n6) continue;
                do {
                    int y;
                    long color;
                    if (!Color.equals-impl0((long)(color = ColorKt.Color((int)pixels[x + (y = n5++) * $this$containsColor.getWidth()])), (long)expectedColor)) continue;
                    return true;
                } while (n5 <= n6);
            } while (n <= n2);
        }
        return false;
    }

    public static final boolean contains-ej0GBII(@NotNull Path $this$contains, long offset) {
        Intrinsics.checkNotNullParameter((Object)$this$contains, (String)"$this$contains");
        android.graphics.Path path = new android.graphics.Path();
        path.addRect(Offset.getX-impl((long)offset) - 0.01f, Offset.getY-impl((long)offset) - 0.01f, Offset.getX-impl((long)offset) + 0.01f, Offset.getY-impl((long)offset) + 0.01f, Path.Direction.CW);
        Path $this$asAndroidPath$iv = $this$contains;
        boolean $i$f$asAndroidPath = false;
        if (!($this$asAndroidPath$iv instanceof AndroidPath)) {
            throw (Throwable)new UnsupportedOperationException("Unable to obtain android.graphics.Path");
        }
        if (path.op(((AndroidPath)$this$asAndroidPath$iv).getInternalPath(), Path.Op.INTERSECT)) {
            return !path.isEmpty();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public static final void assertShape-LBqplUo(@NotNull Bitmap $this$assertShape, @NotNull Density density, @NotNull Shape shape, long shapeColor, long backgroundColor, @NotNull Shape backgroundShape, float sizeX, float sizeY, float shapeSizeX, float shapeSizeY, float centerX, float centerY, float shapeOverlapPixelCount) {
        void x$iv;
        Intrinsics.checkNotNullParameter((Object)$this$assertShape, (String)"$this$assertShape");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        Intrinsics.checkNotNullParameter((Object)backgroundShape, (String)"backgroundShape");
        int width = $this$assertShape.getWidth();
        int height = $this$assertShape.getHeight();
        Assert.assertTrue((centerX + sizeX / (float)2 <= (float)width ? 1 : 0) != 0);
        Assert.assertTrue((centerX - sizeX / (float)2 >= 0.0f ? 1 : 0) != 0);
        Assert.assertTrue((centerY + sizeY / (float)2 <= (float)height ? 1 : 0) != 0);
        Assert.assertTrue((centerY - sizeY / (float)2 >= 0.0f ? 1 : 0) != 0);
        Outline outline = shape.createOutline-lwCvPpU(SizeKt.Size((float)shapeSizeX, (float)shapeSizeY), density);
        Path path = AndroidPathKt.Path();
        OutlineKt.addOutline((Path)path, (Outline)outline);
        float f = centerX - shapeSizeX / 2.0f;
        float y$iv = centerY - shapeSizeY / 2.0f;
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        void var25_23 = x$iv;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits((float)var25_23);
        float f2 = y$iv;
        int n = 0;
        long v2$iv$iv = Float.floatToIntBits(f2);
        long shapeOffset = Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
        Path backgroundPath = AndroidPathKt.Path();
        OutlineKt.addOutline((Path)backgroundPath, (Outline)backgroundShape.createOutline-lwCvPpU(SizeKt.Size((float)sizeX, (float)sizeY), density));
        IntRange intRange = AndroidBitmapHelpersKt.until(centerX - sizeX / (float)2, centerX + sizeX / (float)2);
        int n2 = intRange.getFirst();
        int n3 = intRange.getLast();
        int n4 = intRange.getStep();
        if (n4 > 0 && n2 <= n3 || n4 < 0 && n3 <= n2) {
            int x;
            do {
                int y;
                x = n2;
                n2 += n4;
                IntRange intRange2 = AndroidBitmapHelpersKt.until(centerY - sizeY / (float)2, centerY + sizeY / (float)2);
                int n5 = intRange2.getFirst();
                int n6 = intRange2.getLast();
                n = intRange2.getStep();
                if ((n <= 0 || n5 > n6) && (n >= 0 || n6 > n5)) continue;
                do {
                    boolean isOutside;
                    void x$iv2;
                    y = n5;
                    n5 += n;
                    float f3 = x;
                    float y$iv2 = y;
                    boolean $i$f$Offset2 = false;
                    boolean $i$f$packFloats2 = false;
                    void var38_41 = x$iv2;
                    boolean bl2 = false;
                    long v1$iv$iv2 = Float.floatToIntBits((float)var38_41);
                    float f4 = y$iv2;
                    boolean bl3 = false;
                    long v2$iv$iv2 = Float.floatToIntBits(f4);
                    long point = Offset.constructor-impl((long)(v1$iv$iv2 << 32 | v2$iv$iv2 & 0xFFFFFFFFL));
                    if (!AndroidBitmapHelpersKt.contains-ej0GBII(backgroundPath, AndroidBitmapHelpersKt.pixelFartherFromCenter-6Rhqavg(point, sizeX, sizeY, shapeOverlapPixelCount))) continue;
                    long offset = Offset.minus-k-4lQ0M((long)point, (long)shapeOffset);
                    boolean isInside = AndroidBitmapHelpersKt.contains-ej0GBII(path, AndroidBitmapHelpersKt.pixelFartherFromCenter-6Rhqavg(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    boolean bl4 = isOutside = !AndroidBitmapHelpersKt.contains-ej0GBII(path, AndroidBitmapHelpersKt.pixelCloserToCenter-6Rhqavg(offset, shapeSizeX, shapeSizeY, shapeOverlapPixelCount));
                    if (isInside) {
                        AndroidBitmapHelpersKt.assertPixelColor-eWrXCG0$default($this$assertShape, shapeColor, x, y, null, 8, null);
                        continue;
                    }
                    if (!isOutside) continue;
                    AndroidBitmapHelpersKt.assertPixelColor-eWrXCG0$default($this$assertShape, backgroundColor, x, y, null, 8, null);
                } while (y != n6);
            } while (x != n3);
        }
    }

    public static /* synthetic */ void assertShape-LBqplUo$default(Bitmap bitmap, Density density, Shape shape, long l, long l2, Shape shape2, float f, float f2, float f3, float f4, float f5, float f6, float f7, int n, Object object) {
        if ((n & 0x10) != 0) {
            shape2 = RectangleShapeKt.getRectangleShape();
        }
        if ((n & 0x20) != 0) {
            f = bitmap.getWidth();
        }
        if ((n & 0x40) != 0) {
            f2 = bitmap.getHeight();
        }
        if ((n & 0x80) != 0) {
            f3 = f;
        }
        if ((n & 0x100) != 0) {
            f4 = f2;
        }
        if ((n & 0x200) != 0) {
            f5 = (float)bitmap.getWidth() / 2.0f;
        }
        if ((n & 0x400) != 0) {
            f6 = (float)bitmap.getHeight() / 2.0f;
        }
        if ((n & 0x800) != 0) {
            f7 = 1.0f;
        }
        AndroidBitmapHelpersKt.assertShape-LBqplUo(bitmap, density, shape, l, l2, shape2, f, f2, f3, f4, f5, f6, f7);
    }

    public static final void assertShape-WOPiG5A(@NotNull Bitmap $this$assertShape, @NotNull Density density, float horizontalPadding, float verticalPadding, long backgroundColor, long shapeColor, @NotNull Shape shape, float shapeOverlapPixelCount) {
        Intrinsics.checkNotNullParameter((Object)$this$assertShape, (String)"$this$assertShape");
        Intrinsics.checkNotNullParameter((Object)density, (String)"density");
        Intrinsics.checkNotNullParameter((Object)shape, (String)"shape");
        boolean bl = false;
        boolean bl2 = false;
        Density $this$assertShape_WOPiG5A_u24lambda_u2d1 = density;
        boolean bl3 = false;
        float fullHorizontalPadding = $this$assertShape_WOPiG5A_u24lambda_u2d1.toPx-0680j_4(horizontalPadding) * (float)2;
        bl2 = false;
        boolean bl4 = false;
        Density $this$assertShape_WOPiG5A_u24lambda_u2d2 = density;
        boolean bl5 = false;
        float fullVerticalPadding = $this$assertShape_WOPiG5A_u24lambda_u2d2.toPx-0680j_4(verticalPadding) * (float)2;
        AndroidBitmapHelpersKt.assertShape-LBqplUo$default($this$assertShape, density, shape, shapeColor, backgroundColor, RectangleShapeKt.getRectangleShape(), 0.0f, 0.0f, (float)$this$assertShape.getWidth() - fullHorizontalPadding, (float)$this$assertShape.getHeight() - fullVerticalPadding, 0.0f, 0.0f, shapeOverlapPixelCount, 1632, null);
    }

    public static /* synthetic */ void assertShape-WOPiG5A$default(Bitmap bitmap, Density density, float f, float f2, long l, long l2, Shape shape, float f3, int n, Object object) {
        if ((n & 0x20) != 0) {
            shape = RectangleShapeKt.getRectangleShape();
        }
        if ((n & 0x40) != 0) {
            f3 = 1.0f;
        }
        AndroidBitmapHelpersKt.assertShape-WOPiG5A(bitmap, density, f, f2, l, l2, shape, f3);
    }

    private static final IntRange until(float $this$until, float until) {
        int from = MathKt.roundToInt((float)$this$until);
        int to = MathKt.roundToInt((float)until);
        if (from <= Integer.MIN_VALUE) {
            return IntRange.Companion.getEMPTY();
        }
        return new IntRange(from, to - 1);
    }

    private static final long pixelCloserToCenter-6Rhqavg(long offset, float shapeSizeX, float shapeSizeY, float delta) {
        float x;
        float centerX = shapeSizeX / 2.0f;
        float centerY = shapeSizeY / 2.0f;
        float d = delta;
        float f = Offset.getX-impl((long)offset) > centerX ? Offset.getX-impl((long)offset) - d : (x = Offset.getX-impl((long)offset) < centerX ? Offset.getX-impl((long)offset) + d : Offset.getX-impl((long)offset));
        float y = Offset.getY-impl((long)offset) > centerY ? Offset.getY-impl((long)offset) - d : (Offset.getY-impl((long)offset) < centerY ? Offset.getY-impl((long)offset) + d : Offset.getY-impl((long)offset));
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f2 = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f2);
        float f3 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f3);
        return Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
    }

    private static final long pixelFartherFromCenter-6Rhqavg(long offset, float shapeSizeX, float shapeSizeY, float delta) {
        float x;
        float centerX = shapeSizeX / 2.0f;
        float centerY = shapeSizeY / 2.0f;
        float d = delta;
        float f = Offset.getX-impl((long)offset) > centerX ? Offset.getX-impl((long)offset) + d : (x = Offset.getX-impl((long)offset) < centerX ? Offset.getX-impl((long)offset) - d : Offset.getX-impl((long)offset));
        float y = Offset.getY-impl((long)offset) > centerY ? Offset.getY-impl((long)offset) + d : (Offset.getY-impl((long)offset) < centerY ? Offset.getY-impl((long)offset) - d : Offset.getY-impl((long)offset));
        boolean $i$f$Offset = false;
        boolean $i$f$packFloats = false;
        float f2 = x;
        boolean bl = false;
        long v1$iv$iv = Float.floatToIntBits(f2);
        float f3 = y;
        boolean bl2 = false;
        long v2$iv$iv = Float.floatToIntBits(f3);
        return Offset.constructor-impl((long)(v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL));
    }
}

