/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.compose.ui.node.Owner;
import androidx.compose.ui.platform.AndroidOwner;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.text.input.EditOperation;
import androidx.compose.ui.text.input.ImeAction;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.TextInputServiceForTests;
import androidx.ui.test.android.SynchronizedTreeCollector;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u00006\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001a\u0016\u0010\u0000\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u0004H\u0000\u001a\u001c\u0010\u0005\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\u0006\u0010\t\u001a\u00020\nH\u0000\u001a\"\u0010\u000b\u001a\u00020\u0006*\u00020\u00072\u0006\u0010\b\u001a\u00020\u00022\f\u0010\f\u001a\b\u0012\u0004\u0012\u00020\r0\u0001H\u0000\u001a\f\u0010\u000e\u001a\u00020\u000f*\u00020\u0010H\u0000\u00a8\u0006\u0011"}, d2={"getAllSemanticsNodes", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "mergingEnabled", "", "actualPerformImeAction", "", "Landroidx/ui/test/SemanticsNodeInteraction;", "node", "actionSpecified", "Landroidx/compose/ui/text/input/ImeAction;", "actualSendTextInputCommand", "command", "Landroidx/compose/ui/text/input/EditOperation;", "getTextInputServiceOrDie", "Landroidx/ui/test/TextInputServiceForTests;", "Landroidx/compose/ui/platform/AndroidOwner;", "ui-test_release"})
public final class AndroidSemanticsNodeInteractionKt {
    @NotNull
    public static final List<SemanticsNode> getAllSemanticsNodes(boolean mergingEnabled) {
        return SynchronizedTreeCollector.INSTANCE.getAllSemanticsNodes$ui_test_release(mergingEnabled);
    }

    public static final void actualPerformImeAction(@NotNull SemanticsNodeInteraction $this$actualPerformImeAction, @NotNull SemanticsNode node, @NotNull ImeAction actionSpecified2) {
        Intrinsics.checkNotNullParameter((Object)$this$actualPerformImeAction, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter((Object)actionSpecified2, (String)"actionSpecified");
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.compose.ui.platform.AndroidOwner");
        }
        AndroidOwner owner2 = (AndroidOwner)owner;
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(owner2, actionSpecified2){
            private final /* synthetic */ AndroidOwner $owner;
            private final /* synthetic */ ImeAction $actionSpecified;
            {
                this.$owner = $owner;
                this.$actionSpecified = $actionSpecified;
                super(0);
            }

            public final void invoke() {
                TextInputServiceForTests textInputService = AndroidSemanticsNodeInteractionKt.getTextInputServiceOrDie(this.$owner);
                Function1<ImeAction, Unit> function1 = textInputService.getOnImeActionPerformed();
                if (function1 == null) {
                    throw new IllegalStateException("No input session started. Missing a focus?");
                }
                Function1<ImeAction, Unit> onImeActionPerformed = function1;
                onImeActionPerformed.invoke((Object)this.$actionSpecified);
            }
        });
    }

    public static final void actualSendTextInputCommand(@NotNull SemanticsNodeInteraction $this$actualSendTextInputCommand, @NotNull SemanticsNode node, @NotNull List<? extends EditOperation> command) {
        Intrinsics.checkNotNullParameter((Object)$this$actualSendTextInputCommand, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)node, (String)"node");
        Intrinsics.checkNotNullParameter(command, (String)"command");
        Owner owner = node.getComponentNode().getOwner();
        if (owner == null) {
            throw new NullPointerException("null cannot be cast to non-null type androidx.compose.ui.platform.AndroidOwner");
        }
        AndroidOwner owner2 = (AndroidOwner)owner;
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(owner2, command){
            private final /* synthetic */ AndroidOwner $owner;
            private final /* synthetic */ List<EditOperation> $command;
            {
                this.$owner = $owner;
                this.$command = $command;
                super(0);
            }

            public final void invoke() {
                TextInputServiceForTests textInputService = AndroidSemanticsNodeInteractionKt.getTextInputServiceOrDie(this.$owner);
                Function1<List<? extends EditOperation>, Unit> function1 = textInputService.getOnEditCommand();
                if (function1 == null) {
                    throw new IllegalStateException("No input session started. Missing a focus?");
                }
                Function1<List<? extends EditOperation>, Unit> onEditCommand = function1;
                onEditCommand.invoke(this.$command);
            }
        });
    }

    @NotNull
    public static final TextInputServiceForTests getTextInputServiceOrDie(@NotNull AndroidOwner $this$getTextInputServiceOrDie) {
        Intrinsics.checkNotNullParameter((Object)$this$getTextInputServiceOrDie, (String)"<this>");
        TextInputServiceForTests textInputServiceForTests = (TextInputServiceForTests)$this$getTextInputServiceOrDie.getTextInputService();
        if (textInputServiceForTests == null) {
            throw new IllegalStateException("Text input service wrapper not set up! Did you use ComposeTestRule?");
        }
        return textInputServiceForTests;
    }
}

