/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.compose.ui.semantics.SemanticsNode;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.SelectionResult;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u00002\u00020\u0001B6\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0000\u0012\u0018\u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\bJ\u001c\u0010\u000e\u001a\u00020\u000b2\f\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\t2\u0006\u0010\u0010\u001a\u00020\u0003R\u0010\u0010\u0006\u001a\u0004\u0018\u00010\u0000X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0007\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\n0\t\u0012\u0004\u0012\u00020\u000b0\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Landroidx/ui/test/SemanticsSelector;", "", "description", "", "requiresExactlyOneNode", "", "chainedInputSelector", "selector", "Lkotlin/Function1;", "", "Landroidx/compose/ui/semantics/SemanticsNode;", "Landroidx/ui/test/SelectionResult;", "getDescription", "()Ljava/lang/String;", "map", "nodes", "errorOnFail", "ui-test_release"})
public final class SemanticsSelector {
    private final String description;
    private final boolean requiresExactlyOneNode;
    private final SemanticsSelector chainedInputSelector;
    private final Function1<Iterable<SemanticsNode>, SelectionResult> selector;

    public SemanticsSelector(@NotNull String description, boolean requiresExactlyOneNode, @Nullable SemanticsSelector chainedInputSelector, @NotNull Function1<? super Iterable<SemanticsNode>, SelectionResult> selector) {
        Intrinsics.checkNotNullParameter((Object)description, (String)"description");
        Intrinsics.checkNotNullParameter(selector, (String)"selector");
        this.description = description;
        this.requiresExactlyOneNode = requiresExactlyOneNode;
        this.chainedInputSelector = chainedInputSelector;
        this.selector = selector;
    }

    public /* synthetic */ SemanticsSelector(String string, boolean bl, SemanticsSelector semanticsSelector, Function1 function1, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 4) != 0) {
            semanticsSelector = null;
        }
        this(string, bl, semanticsSelector, (Function1<? super Iterable<SemanticsNode>, SelectionResult>)function1);
    }

    @NotNull
    public final String getDescription() {
        return this.description;
    }

    @NotNull
    public final SelectionResult map(@NotNull Iterable<SemanticsNode> nodes, @NotNull String errorOnFail) {
        Iterable inputNodes;
        Intrinsics.checkNotNullParameter(nodes, (String)"nodes");
        Intrinsics.checkNotNullParameter((Object)errorOnFail, (String)"errorOnFail");
        SemanticsSelector semanticsSelector = this.chainedInputSelector;
        SelectionResult chainedResult = semanticsSelector == null ? (SelectionResult)null : semanticsSelector.map(nodes, errorOnFail);
        Object object = chainedResult;
        Iterable iterable = inputNodes = object == null ? nodes : (Iterable)((SelectionResult)object).getSelectedNodes();
        if (this.requiresExactlyOneNode && CollectionsKt.count((Iterable)inputNodes) != 1) {
            Object object2;
            Object object3 = chainedResult;
            Object object4 = object = object3 == null ? (String)null : ((SelectionResult)object3).getCustomErrorOnNoMatch();
            if (object == null) {
                object3 = CollectionsKt.toList((Iterable)inputNodes);
                SemanticsSelector semanticsSelector2 = this.chainedInputSelector;
                SemanticsSelector semanticsSelector3 = semanticsSelector2 == null ? this : semanticsSelector2;
                object2 = ErrorMessagesKt.buildErrorMessageForCountMismatch(errorOnFail, semanticsSelector3, (List<SemanticsNode>)object3, 1);
            } else {
                object2 = object;
            }
            throw new AssertionError(object2);
        }
        return (SelectionResult)this.selector.invoke((Object)inputNodes);
    }
}

