/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.util.DisplayMetrics;
import androidx.activity.ComponentActivity;
import androidx.compose.animation.TransitionKt;
import androidx.compose.foundation.BaseTextFieldKt;
import androidx.compose.runtime.Composer;
import androidx.compose.runtime.Composition;
import androidx.compose.runtime.Recomposer;
import androidx.compose.ui.platform.WrapperKt;
import androidx.compose.ui.text.input.TextInputServiceKt;
import androidx.compose.ui.unit.Density;
import androidx.compose.ui.unit.DensityKt;
import androidx.test.core.app.ActivityScenario;
import androidx.test.ext.junit.rules.ActivityScenarioRule;
import androidx.ui.test.AndroidSynchronizationKt;
import androidx.ui.test.AnimationClockTestRule;
import androidx.ui.test.ComposeTestRule;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.android.AndroidComposeTestRule;
import androidx.ui.test.android.AndroidOwnerRegistry;
import androidx.ui.test.android.ComposeIdlingResourceKt;
import androidx.ui.test.android.FirstDrawRegistry;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003:\u0001)B\"\u0012\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\u0007J\u001a\u0010\u001e\u001a\u00020\u001f2\u0006\u0010 \u001a\u00020\u001f2\b\u0010!\u001a\u0004\u0018\u00010\"H\u0016J\r\u0010#\u001a\u00028\u0000H\u0002\u00a2\u0006\u0002\u0010$J \u0010%\u001a\u00020\u00192\u0011\u0010&\u001a\r\u0012\u0004\u0012\u00020\u00190\u0018\u00a2\u0006\u0002\b'H\u0016\u00a2\u0006\u0002\u0010(R\u0017\u0010\u0004\u001a\b\u0012\u0004\u0012\u00028\u00000\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0014\u0010\u000b\u001a\u00020\fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0014\u0010\u000f\u001a\u00020\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012R\u000e\u0010\b\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00148VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u0016R\"\u0010\u0017\u001a\n\u0012\u0004\u0012\u00020\u0019\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001a\u0010\u001b\"\u0004\b\u001c\u0010\u001d\u00a8\u0006*"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule;", "T", "Landroidx/activity/ComponentActivity;", "Landroidx/ui/test/ComposeTestRule;", "activityRule", "Landroidx/test/ext/junit/rules/ActivityScenarioRule;", "disableTransitions", "", "disableBlinkingCursor", "getActivityRule", "()Landroidx/test/ext/junit/rules/ActivityScenarioRule;", "clockTestRule", "Landroidx/ui/test/AnimationClockTestRule;", "getClockTestRule", "()Landroidx/ui/test/AnimationClockTestRule;", "density", "Landroidx/compose/ui/unit/Density;", "getDensity", "()Landroidx/compose/ui/unit/Density;", "displayMetrics", "Landroid/util/DisplayMetrics;", "getDisplayMetrics", "()Landroid/util/DisplayMetrics;", "disposeContentHook", "Lkotlin/Function0;", "", "getDisposeContentHook$ui_test_release", "()Lkotlin/jvm/functions/Function0;", "setDisposeContentHook$ui_test_release", "(Lkotlin/jvm/functions/Function0;)V", "apply", "Lorg/junit/runners/model/Statement;", "base", "description", "Lorg/junit/runner/Description;", "getActivity", "()Landroidx/activity/ComponentActivity;", "setContent", "composable", "Landroidx/compose/runtime/Composable;", "(Lkotlin/jvm/functions/Function2;)V", "AndroidComposeStatement", "ui-test_release"})
public final class AndroidComposeTestRule<T extends ComponentActivity>
implements ComposeTestRule {
    private final ActivityScenarioRule<T> activityRule;
    private final boolean disableTransitions;
    private final boolean disableBlinkingCursor;
    private final AnimationClockTestRule clockTestRule;
    private Function0<Unit> disposeContentHook;

    public AndroidComposeTestRule(@NotNull ActivityScenarioRule<T> activityRule, boolean disableTransitions, boolean disableBlinkingCursor) {
        Intrinsics.checkNotNullParameter(activityRule, (String)"activityRule");
        this.activityRule = activityRule;
        this.disableTransitions = disableTransitions;
        this.disableBlinkingCursor = disableBlinkingCursor;
        this.clockTestRule = new AnimationClockTestRule();
    }

    public /* synthetic */ AndroidComposeTestRule(ActivityScenarioRule activityScenarioRule, boolean bl, boolean bl2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 2) != 0) {
            bl = false;
        }
        if ((n & 4) != 0) {
            bl2 = true;
        }
        this(activityScenarioRule, bl, bl2);
    }

    @NotNull
    public final ActivityScenarioRule<T> getActivityRule() {
        return this.activityRule;
    }

    private final T getActivity() {
        Ref.ObjectRef activity = new Ref.ObjectRef();
        if (activity.element == null) {
            this.activityRule.getScenario().onActivity(new ActivityScenario.ActivityAction<T>(activity){
                private final /* synthetic */ Ref.ObjectRef<T> $activity;
                {
                    this.$activity = $activity;
                }

                public final void perform(@Nullable T it) {
                    this.$activity.element = it;
                }
            });
            if (activity.element == null) {
                throw new IllegalStateException("Activity was not set in the ActivityScenarioRule!");
            }
        }
        Intrinsics.checkNotNull((Object)activity.element);
        return (T)((ComponentActivity)activity.element);
    }

    @Override
    @NotNull
    public AnimationClockTestRule getClockTestRule() {
        return this.clockTestRule;
    }

    @Nullable
    public final Function0<Unit> getDisposeContentHook$ui_test_release() {
        return this.disposeContentHook;
    }

    public final void setDisposeContentHook$ui_test_release(@Nullable Function0<Unit> function0) {
        this.disposeContentHook = function0;
    }

    @Override
    @NotNull
    public Density getDensity() {
        return DensityKt.Density$default((float)this.getActivity().getResources().getDisplayMetrics().density, (float)0.0f, (int)2, null);
    }

    @Override
    @NotNull
    public DisplayMetrics getDisplayMetrics() {
        DisplayMetrics displayMetrics = this.getActivity().getResources().getDisplayMetrics();
        Intrinsics.checkNotNullExpressionValue((Object)displayMetrics, (String)"getActivity().resources.displayMetrics");
        return displayMetrics;
    }

    @NotNull
    public Statement apply(@NotNull Statement base, @Nullable Description description) {
        Intrinsics.checkNotNullParameter((Object)base, (String)"base");
        Statement activityTestRuleStatement = this.activityRule.apply(base, description);
        Intrinsics.checkNotNullExpressionValue((Object)activityTestRuleStatement, (String)"activityTestRuleStatement");
        AndroidComposeStatement composeTestRuleStatement = new AndroidComposeStatement(activityTestRuleStatement);
        return this.getClockTestRule().apply(composeTestRuleStatement, description);
    }

    @Override
    public void setContent(@NotNull Function2<? super Composer<?>, ? super Integer, Unit> composable) {
        Intrinsics.checkNotNullParameter(composable, (String)"composable");
        boolean bl = this.disposeContentHook == null;
        boolean bl2 = false;
        boolean bl3 = false;
        if (!bl) {
            boolean bl4 = false;
            String string = "Cannot call setContent twice per test!";
            throw (Throwable)new IllegalStateException(string.toString());
        }
        Ref.ObjectRef activity = new Ref.ObjectRef();
        this.activityRule.getScenario().onActivity(new ActivityScenario.ActivityAction<T>(activity){
            private final /* synthetic */ Ref.ObjectRef<T> $activity;
            {
                this.$activity = $activity;
            }

            public final void perform(@Nullable T it) {
                Intrinsics.checkNotNullExpressionValue(it, (String)"it");
                this.$activity.element = it;
            }
        });
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(activity, composable, this){
            private final /* synthetic */ Ref.ObjectRef<T> $activity;
            private final /* synthetic */ Function2<Composer<?>, Integer, Unit> $composable;
            private final /* synthetic */ AndroidComposeTestRule<T> $this;
            {
                this.$activity = $activity;
                this.$composable = $composable;
                this.$this = $receiver;
                super(0);
            }

            public final void invoke() {
                if (this.$activity.element == null) {
                    Intrinsics.throwUninitializedPropertyAccessException((String)"activity");
                    throw null;
                }
                Composition composition = WrapperKt.setContent((ComponentActivity)((ComponentActivity)this.$activity.element), (Recomposer)Recomposer.Companion.current(), this.$composable);
                this.$this.setDisposeContentHook$ui_test_release((Function0<Unit>)((Function0)new Function0<Unit>(composition){
                    private final /* synthetic */ Composition $composition;
                    {
                        this.$composition = $composition;
                        super(0);
                    }

                    public final void invoke() {
                        this.$composition.dispose();
                    }
                }));
            }
        });
        if (!AndroidSynchronizationKt.isOnUiThread()) {
            SynchronizationKt.waitForIdle();
        }
    }

    @Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=1, xi=16, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0086\u0004\u0018\u00002\u00020\u0001B\b\u0012\u0006\u0010\u0002\u001a\u00020\u0001J\b\u0010\u0003\u001a\u00020\u0004H\u0002J\b\u0010\u0005\u001a\u00020\u0004H\u0002J\b\u0010\u0006\u001a\u00020\u0004H\u0016R\u000e\u0010\u0002\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/ui/test/android/AndroidComposeTestRule$AndroidComposeStatement;", "Lorg/junit/runners/model/Statement;", "base", "afterEvaluate", "", "beforeEvaluate", "evaluate", "ui-test_release"})
    public final class AndroidComposeStatement
    extends Statement {
        private final Statement base;

        public AndroidComposeStatement(Statement base) {
            Intrinsics.checkNotNullParameter((Object)AndroidComposeTestRule.this, (String)"this$0");
            Intrinsics.checkNotNullParameter((Object)base, (String)"base");
            this.base = base;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void evaluate() {
            Function1 oldTextInputFactory = TextInputServiceKt.getTextInputServiceFactory();
            this.beforeEvaluate();
            try {
                this.base.evaluate();
            }
            finally {
                this.afterEvaluate();
                TextInputServiceKt.setTextInputServiceFactory((Function1)oldTextInputFactory);
            }
        }

        private final void beforeEvaluate() {
            TransitionKt.setTransitionsEnabled((!AndroidComposeTestRule.this.disableTransitions ? 1 : 0) != 0);
            BaseTextFieldKt.setBlinkingCursorEnabled((!AndroidComposeTestRule.this.disableBlinkingCursor ? 1 : 0) != 0);
            AndroidOwnerRegistry.INSTANCE.setupRegistry$ui_test_release();
            FirstDrawRegistry.INSTANCE.setupRegistry$ui_test_release();
            ComposeIdlingResourceKt.registerComposeWithEspresso();
            TextInputServiceKt.setTextInputServiceFactory((Function1)beforeEvaluate.1.INSTANCE);
        }

        private final void afterEvaluate() {
            TransitionKt.setTransitionsEnabled((boolean)true);
            BaseTextFieldKt.setBlinkingCursorEnabled((boolean)true);
            AndroidOwnerRegistry.INSTANCE.tearDownRegistry$ui_test_release();
            FirstDrawRegistry.INSTANCE.tearDownRegistry$ui_test_release();
            ComposeIdlingResourceKt.unregisterComposeFromEspresso();
            if (AndroidComposeTestRule.this.getDisposeContentHook$ui_test_release() != null) {
                SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(AndroidComposeTestRule.this){
                    private final /* synthetic */ AndroidComposeTestRule<T> $this;
                    {
                        this.$this = $receiver;
                        super(0);
                    }

                    public final void invoke() {
                        try {
                            Function0<Unit> function0 = this.$this.getDisposeContentHook$ui_test_release();
                            Intrinsics.checkNotNull(function0);
                            function0.invoke();
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        this.$this.setDisposeContentHook$ui_test_release((Function0<Unit>)((Function0)null));
                    }
                });
            }
        }
    }
}

