/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test.android;

import android.app.Activity;
import android.content.Context;
import android.content.ContextWrapper;
import android.graphics.Bitmap;
import android.graphics.Rect;
import android.os.Build;
import android.os.Handler;
import android.os.Looper;
import android.view.PixelCopy;
import android.view.View;
import android.view.ViewTreeObserver;
import android.view.Window;
import androidx.annotation.RequiresApi;
import androidx.ui.test.android.WindowCaptureKt;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u0000\u001a\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a$\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007H\u0001\u00a8\u0006\b"}, d2={"captureRegionToBitmap", "Landroid/graphics/Bitmap;", "captureRectInWindow", "Landroid/graphics/Rect;", "view", "Landroid/view/View;", "window", "Landroid/view/Window;", "ui-test_release"})
public final class WindowCaptureKt {
    @RequiresApi(value=26)
    @NotNull
    public static final Bitmap captureRegionToBitmap(@NotNull Rect captureRectInWindow, @NotNull View view, @Nullable Window window) {
        Window window2;
        Intrinsics.checkNotNullParameter((Object)captureRectInWindow, (String)"captureRectInWindow");
        Intrinsics.checkNotNullParameter((Object)view, (String)"view");
        Window window3 = window;
        if (window3 == null) {
            Context context = view.getContext();
            Intrinsics.checkNotNullExpressionValue((Object)context, (String)"view.context");
            Activity activity = WindowCaptureKt.captureRegionToBitmap$getActivity(context);
            Intrinsics.checkNotNull((Object)activity);
            window2 = activity.getWindow();
        } else {
            window2 = window3;
        }
        Window windowToCapture = window2;
        Handler handler = new Handler(Looper.getMainLooper());
        CountDownLatch drawLatch = new CountDownLatch(1);
        View view2 = windowToCapture.getDecorView();
        Intrinsics.checkNotNullExpressionValue((Object)view2, (String)"windowToCapture.decorView");
        View decorView = view2;
        handler.post(new Runnable(decorView, drawLatch, handler){
            private final /* synthetic */ View $decorView;
            private final /* synthetic */ CountDownLatch $drawLatch;
            private final /* synthetic */ Handler $handler;
            {
                this.$decorView = $decorView;
                this.$drawLatch = $drawLatch;
                this.$handler = $handler;
            }

            public final void run() {
                if (Build.VERSION.SDK_INT >= 29) {
                    this.$decorView.getViewTreeObserver().registerFrameCommitCallback(new Runnable(this.$drawLatch){
                        private final /* synthetic */ CountDownLatch $drawLatch;
                        {
                            this.$drawLatch = $drawLatch;
                        }

                        public final void run() {
                            this.$drawLatch.countDown();
                        }
                    });
                } else {
                    this.$decorView.getViewTreeObserver().addOnDrawListener(new ViewTreeObserver.OnDrawListener(this.$handler, this.$drawLatch, this.$decorView){
                        private boolean handled;
                        private final /* synthetic */ Handler $handler;
                        private final /* synthetic */ CountDownLatch $drawLatch;
                        private final /* synthetic */ View $decorView;
                        {
                            this.$handler = $handler;
                            this.$drawLatch = $drawLatch;
                            this.$decorView = $decorView;
                        }

                        public final boolean getHandled() {
                            return this.handled;
                        }

                        public final void setHandled(boolean bl) {
                            this.handled = bl;
                        }

                        public void onDraw() {
                            if (!this.handled) {
                                this.handled = true;
                                this.$handler.post(new Runnable(this.$drawLatch, this.$decorView, this){
                                    private final /* synthetic */ CountDownLatch $drawLatch;
                                    private final /* synthetic */ View $decorView;
                                    private final /* synthetic */ captureRegionToBitmap.2 $this;
                                    {
                                        this.$drawLatch = $drawLatch;
                                        this.$decorView = $decorView;
                                        this.$this = $receiver;
                                    }

                                    public final void run() {
                                        this.$drawLatch.countDown();
                                        this.$decorView.getViewTreeObserver().removeOnDrawListener((ViewTreeObserver.OnDrawListener)this.$this);
                                    }
                                });
                            }
                        }
                    });
                }
                this.$decorView.invalidate();
            }
        });
        if (!drawLatch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for DecorView redraw!");
        }
        Bitmap destBitmap = Bitmap.createBitmap((int)captureRectInWindow.width(), (int)captureRectInWindow.height(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
        CountDownLatch latch = new CountDownLatch(1);
        Ref.IntRef copyResult = new Ref.IntRef();
        PixelCopy.OnPixelCopyFinishedListener onCopyFinished2 = new PixelCopy.OnPixelCopyFinishedListener(copyResult, latch){
            private final /* synthetic */ Ref.IntRef $copyResult;
            private final /* synthetic */ CountDownLatch $latch;
            {
                this.$copyResult = $copyResult;
                this.$latch = $latch;
            }

            public final void onPixelCopyFinished(int result) {
                this.$copyResult.element = result;
                this.$latch.countDown();
            }
        };
        PixelCopy.request((Window)windowToCapture, (Rect)captureRectInWindow, (Bitmap)destBitmap, (PixelCopy.OnPixelCopyFinishedListener)onCopyFinished2, (Handler)handler);
        if (!latch.await(1L, TimeUnit.SECONDS)) {
            throw new AssertionError((Object)"Failed waiting for PixelCopy!");
        }
        if (copyResult.element != 0) {
            throw new AssertionError((Object)"PixelCopy failed!");
        }
        Intrinsics.checkNotNullExpressionValue((Object)destBitmap, (String)"destBitmap");
        return destBitmap;
    }

    public static /* synthetic */ Bitmap captureRegionToBitmap$default(Rect rect, View view, Window window, int n, Object object) {
        if ((n & 4) != 0) {
            window = null;
        }
        return WindowCaptureKt.captureRegionToBitmap(rect, view, window);
    }

    private static final Activity captureRegionToBitmap$getActivity(Context $this$captureRegionToBitmap_u24getActivity) {
        Activity activity;
        Context context = $this$captureRegionToBitmap_u24getActivity;
        if (context instanceof Activity) {
            activity = (Activity)$this$captureRegionToBitmap_u24getActivity;
        } else if (context instanceof ContextWrapper) {
            Context context2 = ((ContextWrapper)$this$captureRegionToBitmap_u24getActivity).getBaseContext();
            Intrinsics.checkNotNullExpressionValue((Object)context2, (String)"this.baseContext");
            activity = WindowCaptureKt.captureRegionToBitmap$getActivity(context2);
        } else {
            activity = null;
        }
        return activity;
    }
}

