/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.compose.ui.geometry.Offset;
import androidx.compose.ui.geometry.Rect;
import androidx.compose.ui.geometry.RectKt;
import androidx.compose.ui.layout.LayoutCoordinates;
import androidx.compose.ui.layout.LayoutCoordinatesKt;
import androidx.compose.ui.semantics.AccessibilityAction;
import androidx.compose.ui.semantics.SemanticsActions;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.compose.ui.semantics.SemanticsPropertyKey;
import androidx.compose.ui.unit.IntSizeKt;
import androidx.ui.test.ActionsKt;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.GestureScope;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SynchronizationKt;
import androidx.ui.test.UtilsKt;
import kotlin.Function;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\n\u0010\u0000\u001a\u00020\u0001*\u00020\u0001\u001a#\u0010\u0002\u001a\u00020\u0001*\u00020\u00012\u0017\u0010\u0003\u001a\u0013\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004\u00a2\u0006\u0002\b\u0007\u001a\n\u0010\b\u001a\u00020\u0001*\u00020\u0001\u001a$\u0010\t\u001a\u00020\u0006*\u00020\u00012\u0018\u0010\n\u001a\u0014\u0012\u0010\u0012\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000e0\r0\f0\u000b\u001aB\u0010\t\u001a\u00020\u0006\"\u000e\b\u0000\u0010\u000f*\b\u0012\u0004\u0012\u00020\u000e0\u0010*\u00020\u00012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u000f0\f0\u000b2\u0012\u0010\u0011\u001a\u000e\u0012\u0004\u0012\u0002H\u000f\u0012\u0004\u0012\u00020\u00060\u0004\u00a8\u0006\u0012"}, d2={"performClick", "Landroidx/ui/test/SemanticsNodeInteraction;", "performGesture", "block", "Lkotlin/Function1;", "Landroidx/ui/test/GestureScope;", "", "Lkotlin/ExtensionFunctionType;", "performScrollTo", "performSemanticsAction", "key", "Landroidx/compose/ui/semantics/SemanticsPropertyKey;", "Landroidx/compose/ui/semantics/AccessibilityAction;", "Lkotlin/Function0;", "", "T", "Lkotlin/Function;", "invocation", "ui-test_release"})
public final class ActionsKt {
    @NotNull
    public static final SemanticsNodeInteraction performClick(@NotNull SemanticsNodeInteraction $this$performClick) {
        Intrinsics.checkNotNullParameter((Object)$this$performClick, (String)"<this>");
        return ActionsKt.performGesture($this$performClick, (Function1<? super GestureScope, Unit>)((Function1)performClick.1.INSTANCE));
    }

    @NotNull
    public static final SemanticsNodeInteraction performScrollTo(@NotNull SemanticsNodeInteraction $this$performScrollTo) {
        float f;
        boolean bl;
        float dx;
        float f2;
        boolean bl2;
        float f3;
        float f4;
        boolean mustScrollRight;
        Offset offset;
        Intrinsics.checkNotNullParameter((Object)$this$performScrollTo, (String)"<this>");
        String errorMessageOnFail = "Action performScrollTo() failed.";
        SemanticsNode node = $this$performScrollTo.fetchSemanticsNode(errorMessageOnFail);
        SemanticsNode semanticsNode = UtilsKt.findClosestParentNode$default(node, false, performScrollTo.scrollableNode.1.INSTANCE, 1, null);
        if (semanticsNode == null) {
            throw new AssertionError((Object)"Semantic Node has no parent layout with a Scroll SemanticsAction");
        }
        SemanticsNode scrollableNode2 = semanticsNode;
        Rect viewPortInParent = LayoutCoordinatesKt.getBoundsInParent((LayoutCoordinates)scrollableNode2.getComponentNode().getCoordinates());
        LayoutCoordinates layoutCoordinates = scrollableNode2.getComponentNode().getCoordinates().getParentCoordinates();
        if (layoutCoordinates == null) {
            offset = null;
        } else {
            LayoutCoordinates $this$positionInRoot$iv = layoutCoordinates;
            boolean $i$f$getPositionInRoot = false;
            offset = Offset.box-impl((long)$this$positionInRoot$iv.localToRoot-k-4lQ0M(Offset.Companion.getZero-F1C5BW0()));
        }
        Offset offset2 = offset;
        long parentInRoot = offset2 == null ? Offset.Companion.getZero-F1C5BW0() : offset2.unbox-impl();
        Rect viewPort = viewPortInParent.translate-k-4lQ0M(parentInRoot);
        Rect target = RectKt.Rect-MrV732k((long)node.getPositionInRoot-F1C5BW0(), (long)IntSizeKt.toSize-ozmzZPI((long)node.getSize-YbymL2g()));
        boolean mustScrollUp = target.getBottom() > viewPort.getBottom();
        boolean mustScrollDown = target.getTop() < viewPort.getTop();
        boolean mustScrollLeft = target.getRight() > viewPort.getRight();
        boolean bl3 = mustScrollRight = target.getLeft() < viewPort.getLeft();
        if (mustScrollLeft && !mustScrollRight) {
            f4 = target.getLeft() - viewPort.getLeft();
            f3 = target.getRight() - viewPort.getRight();
            bl2 = false;
            f2 = Math.min(f4, f3);
        } else if (mustScrollRight && !mustScrollLeft) {
            f4 = target.getLeft() - viewPort.getLeft();
            f3 = target.getRight() - viewPort.getRight();
            bl2 = false;
            f2 = Math.max(f4, f3);
        } else {
            f2 = dx = 0.0f;
        }
        if (mustScrollUp && !mustScrollDown) {
            f3 = target.getTop() - viewPort.getTop();
            float f5 = target.getBottom() - viewPort.getBottom();
            bl = false;
            f = Math.min(f3, f5);
        } else if (mustScrollDown && !mustScrollUp) {
            f3 = target.getTop() - viewPort.getTop();
            float f6 = target.getBottom() - viewPort.getBottom();
            bl = false;
            f = Math.max(f3, f6);
        } else {
            f = 0.0f;
        }
        float dy = f;
        SynchronizationKt.runOnUiThread((Function0)new Function0<Boolean>(scrollableNode2, dx, dy){
            private final /* synthetic */ SemanticsNode $scrollableNode;
            private final /* synthetic */ float $dx;
            private final /* synthetic */ float $dy;
            {
                this.$scrollableNode = $scrollableNode;
                this.$dx = $dx;
                this.$dy = $dy;
                super(0);
            }

            public final boolean invoke() {
                return (Boolean)((Function2)((AccessibilityAction)this.$scrollableNode.getConfig().get(SemanticsActions.INSTANCE.getScrollBy())).getAction()).invoke((Object)Float.valueOf(this.$dx), (Object)Float.valueOf(this.$dy));
            }
        });
        return $this$performScrollTo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @NotNull
    public static final SemanticsNodeInteraction performGesture(@NotNull SemanticsNodeInteraction $this$performGesture, @NotNull Function1<? super GestureScope, Unit> block) {
        Intrinsics.checkNotNullParameter((Object)$this$performGesture, (String)"<this>");
        Intrinsics.checkNotNullParameter(block, (String)"block");
        SemanticsNode node = $this$performGesture.fetchSemanticsNode("Failed to perform a gesture.");
        GestureScope gestureScope = new GestureScope(node);
        boolean bl = false;
        boolean bl2 = false;
        GestureScope $this$performGesture_u24lambda_u2d0 = gestureScope;
        boolean bl3 = false;
        try {
            block.invoke((Object)$this$performGesture_u24lambda_u2d0);
        }
        finally {
            try {
                $this$performGesture_u24lambda_u2d0.getInputDispatcher$ui_test_release().sendAllSynchronous();
            }
            finally {
                $this$performGesture_u24lambda_u2d0.dispose$ui_test_release();
            }
        }
        return $this$performGesture;
    }

    public static final <T extends Function<? extends Boolean>> void performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<T>> key, @NotNull Function1<? super T, Unit> invocation) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        Intrinsics.checkNotNullParameter(invocation, (String)"invocation");
        SemanticsNode node = $this$performSemanticsAction.fetchSemanticsNode("Failed to perform " + key.getName() + " action.");
        if (!node.getConfig().contains(key)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage("Failed to perform " + key.getName() + " action as it is not defined on the node.", $this$performSemanticsAction.getSelector$ui_test_release(), node));
        }
        SynchronizationKt.runOnUiThread((Function0)new Function0<Unit>(invocation, node, key){
            private final /* synthetic */ Function1<T, Unit> $invocation;
            private final /* synthetic */ SemanticsNode $node;
            private final /* synthetic */ SemanticsPropertyKey<AccessibilityAction<T>> $key;
            {
                this.$invocation = $invocation;
                this.$node = $node;
                this.$key = $key;
                super(0);
            }

            public final void invoke() {
                this.$invocation.invoke((Object)((AccessibilityAction)this.$node.getConfig().get(this.$key)).getAction());
            }
        });
    }

    public static final void performSemanticsAction(@NotNull SemanticsNodeInteraction $this$performSemanticsAction, @NotNull SemanticsPropertyKey<AccessibilityAction<Function0<Boolean>>> key) {
        Intrinsics.checkNotNullParameter((Object)$this$performSemanticsAction, (String)"<this>");
        Intrinsics.checkNotNullParameter(key, (String)"key");
        ActionsKt.performSemanticsAction($this$performSemanticsAction, key, performSemanticsAction.2.INSTANCE);
    }
}

