/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.test;

import androidx.compose.ui.semantics.AccessibilityRangeInfo;
import androidx.compose.ui.semantics.SemanticsNode;
import androidx.ui.test.AndroidAssertionsKt;
import androidx.ui.test.ErrorMessagesKt;
import androidx.ui.test.FiltersKt;
import androidx.ui.test.SemanticsMatcher;
import androidx.ui.test.SemanticsNodeInteraction;
import androidx.ui.test.SemanticsNodeInteractionCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 4, 0}, bv={1, 0, 3}, k=2, xi=16, d1={"\u00000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0002\b\u0012\n\u0002\u0018\u0002\n\u0002\b\u0003\u001a$\u0010\u0000\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0010\b\u0002\u0010\u0004\u001a\n\u0012\u0004\u0012\u00020\u0006\u0018\u00010\u0005\u001a\u0012\u0010\u0007\u001a\u00020\b*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\t\u001a\u00020\b*\u00020\b2\u0006\u0010\u0002\u001a\u00020\u0003\u001a\u0012\u0010\n\u001a\u00020\b*\u00020\b2\u0006\u0010\u000b\u001a\u00020\f\u001a\n\u0010\r\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000e\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u000f\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0010\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0011\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0012\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0013\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0014\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0015\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0016\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0017\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0018\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u0019\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001a\u001a\u00020\u0001*\u00020\u0001\u001a\n\u0010\u001b\u001a\u00020\u0001*\u00020\u0001\u001a\u0012\u0010\u001c\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0012\u0010\u001e\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u001f\u001a\u0012\u0010 \u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u001a\u0012\u0010!\u001a\u00020\u0001*\u00020\u00012\u0006\u0010\u001d\u001a\u00020\u0006\u00a8\u0006\""}, d2={"assert", "Landroidx/ui/test/SemanticsNodeInteraction;", "matcher", "Landroidx/ui/test/SemanticsMatcher;", "messagePrefixOnError", "Lkotlin/Function0;", "", "assertAll", "Landroidx/ui/test/SemanticsNodeInteractionCollection;", "assertAny", "assertCountEquals", "expectedSize", "", "assertHasClickAction", "assertHasNoClickAction", "assertIsDisplayed", "assertIsEnabled", "assertIsHidden", "assertIsInMutuallyExclusiveGroup", "assertIsNotDisplayed", "assertIsNotEnabled", "assertIsNotHidden", "assertIsNotSelected", "assertIsOff", "assertIsOn", "assertIsSelectable", "assertIsSelected", "assertIsToggleable", "assertLabelEquals", "value", "assertRangeInfoEquals", "Landroidx/compose/ui/semantics/AccessibilityRangeInfo;", "assertTextEquals", "assertValueEquals", "ui-test_release"})
public final class AssertionsKt {
    @NotNull
    public static final SemanticsNodeInteraction assertIsHidden(@NotNull SemanticsNodeInteraction $this$assertIsHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsHidden, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsHidden, FiltersKt.isHidden(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotHidden(@NotNull SemanticsNodeInteraction $this$assertIsNotHidden) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotHidden, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsNotHidden, FiltersKt.isNotHidden(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsDisplayed, (String)"<this>");
        if (!AndroidAssertionsKt.checkIsDisplayed($this$assertIsDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is not displayed!");
        }
        return $this$assertIsDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotDisplayed(@NotNull SemanticsNodeInteraction $this$assertIsNotDisplayed) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotDisplayed, (String)"<this>");
        if (AndroidAssertionsKt.checkIsDisplayed($this$assertIsNotDisplayed)) {
            throw new AssertionError((Object)"Assert failed: The component is displayed!");
        }
        return $this$assertIsNotDisplayed;
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsEnabled(@NotNull SemanticsNodeInteraction $this$assertIsEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsEnabled, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsEnabled, FiltersKt.isEnabled(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotEnabled(@NotNull SemanticsNodeInteraction $this$assertIsNotEnabled) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotEnabled, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsNotEnabled, FiltersKt.isNotEnabled(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOn(@NotNull SemanticsNodeInteraction $this$assertIsOn) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOn, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsOn, FiltersKt.isOn(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsOff(@NotNull SemanticsNodeInteraction $this$assertIsOff) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsOff, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsOff, FiltersKt.isOff(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelected(@NotNull SemanticsNodeInteraction $this$assertIsSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelected, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsSelected, FiltersKt.isSelected(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsNotSelected(@NotNull SemanticsNodeInteraction $this$assertIsNotSelected) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsNotSelected, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsNotSelected, FiltersKt.isNotSelected(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsToggleable(@NotNull SemanticsNodeInteraction $this$assertIsToggleable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsToggleable, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsToggleable, FiltersKt.isToggleable(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsSelectable(@NotNull SemanticsNodeInteraction $this$assertIsSelectable) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsSelectable, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsSelectable, FiltersKt.isSelectable(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertIsInMutuallyExclusiveGroup(@NotNull SemanticsNodeInteraction $this$assertIsInMutuallyExclusiveGroup) {
        Intrinsics.checkNotNullParameter((Object)$this$assertIsInMutuallyExclusiveGroup, (String)"<this>");
        return AssertionsKt.assert$default($this$assertIsInMutuallyExclusiveGroup, FiltersKt.isInMutuallyExclusiveGroup(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertLabelEquals(@NotNull SemanticsNodeInteraction $this$assertLabelEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertLabelEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertLabelEquals, FiltersKt.hasLabel$default(value, false, 2, null), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertTextEquals(@NotNull SemanticsNodeInteraction $this$assertTextEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertTextEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertTextEquals, FiltersKt.hasText$default(value, false, 2, null), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertValueEquals(@NotNull SemanticsNodeInteraction $this$assertValueEquals, @NotNull String value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertValueEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertValueEquals, FiltersKt.hasValue(value), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertRangeInfoEquals(@NotNull SemanticsNodeInteraction $this$assertRangeInfoEquals, @NotNull AccessibilityRangeInfo value) {
        Intrinsics.checkNotNullParameter((Object)$this$assertRangeInfoEquals, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)value, (String)"value");
        return AssertionsKt.assert$default($this$assertRangeInfoEquals, FiltersKt.hasRangeInfo(value), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasClickAction(@NotNull SemanticsNodeInteraction $this$assertHasClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasClickAction, (String)"<this>");
        return AssertionsKt.assert$default($this$assertHasClickAction, FiltersKt.hasClickAction(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assertHasNoClickAction(@NotNull SemanticsNodeInteraction $this$assertHasNoClickAction) {
        Intrinsics.checkNotNullParameter((Object)$this$assertHasNoClickAction, (String)"<this>");
        return AssertionsKt.assert$default($this$assertHasNoClickAction, FiltersKt.hasNoClickAction(), null, 2, null);
    }

    @NotNull
    public static final SemanticsNodeInteraction assert(@NotNull SemanticsNodeInteraction $this$assert, @NotNull SemanticsMatcher matcher, @Nullable Function0<String> messagePrefixOnError) {
        SemanticsNode node;
        Intrinsics.checkNotNullParameter((Object)$this$assert, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorMessageOnFail = "Failed to assert the following: (" + matcher.getDescription() + ')';
        if (messagePrefixOnError != null) {
            errorMessageOnFail = (String)messagePrefixOnError.invoke() + '\n' + errorMessageOnFail;
        }
        if (!matcher.matches(node = $this$assert.fetchSemanticsNode(errorMessageOnFail))) {
            throw new AssertionError((Object)ErrorMessagesKt.buildGeneralErrorMessage(errorMessageOnFail, $this$assert.getSelector$ui_test_release(), node));
        }
        return $this$assert;
    }

    public static /* synthetic */ SemanticsNodeInteraction assert$default(SemanticsNodeInteraction semanticsNodeInteraction, SemanticsMatcher semanticsMatcher, Function0 function0, int n, Object object) {
        if ((n & 2) != 0) {
            function0 = null;
        }
        return AssertionsKt.assert(semanticsNodeInteraction, semanticsMatcher, (Function0<String>)function0);
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertCountEquals(@NotNull SemanticsNodeInteractionCollection $this$assertCountEquals, int expectedSize) {
        Intrinsics.checkNotNullParameter((Object)$this$assertCountEquals, (String)"<this>");
        String errorOnFail = "Failed to assert count of nodes.";
        List<SemanticsNode> matchedNodes = $this$assertCountEquals.fetchSemanticsNodes(errorOnFail);
        if (matchedNodes.size() != expectedSize) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForCountMismatch(errorOnFail, $this$assertCountEquals.getSelector$ui_test_release(), matchedNodes, expectedSize));
        }
        return $this$assertCountEquals;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAny(@NotNull SemanticsNodeInteractionCollection $this$assertAny, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAny, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAny(" + matcher.getDescription() + ')';
        List<SemanticsNode> nodes = $this$assertAny.fetchSemanticsNodes(errorOnFail);
        if (nodes.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAtLeastOneNodeExpected(errorOnFail, $this$assertAny.getSelector$ui_test_release()));
        }
        if (!matcher.matchesAny((Iterable<SemanticsNode>)nodes)) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAnyFail($this$assertAny.getSelector$ui_test_release(), nodes, matcher));
        }
        return $this$assertAny;
    }

    @NotNull
    public static final SemanticsNodeInteractionCollection assertAll(@NotNull SemanticsNodeInteractionCollection $this$assertAll, @NotNull SemanticsMatcher matcher) {
        Intrinsics.checkNotNullParameter((Object)$this$assertAll, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)matcher, (String)"matcher");
        String errorOnFail = "Failed to assertAll(" + matcher.getDescription() + ')';
        List<SemanticsNode> nodes = $this$assertAll.fetchSemanticsNodes(errorOnFail);
        boolean bl = false;
        List violations = new ArrayList();
        Iterable $this$forEach$iv = nodes;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            SemanticsNode it = (SemanticsNode)element$iv;
            boolean bl2 = false;
            if (matcher.matches(it)) continue;
            violations.add(it);
        }
        Collection collection = violations;
        boolean bl3 = false;
        if (!collection.isEmpty()) {
            throw new AssertionError((Object)ErrorMessagesKt.buildErrorMessageForAssertAllFail($this$assertAll.getSelector$ui_test_release(), violations, matcher));
        }
        return $this$assertAll;
    }
}

