/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import java.text.CharacterIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 17}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\f\n\u0002\b\n\b\u0000\u0018\u00002\u00020\u0001B\u001d\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\b\u0010\t\u001a\u00020\nH\u0016J\b\u0010\u000b\u001a\u00020\fH\u0016J\b\u0010\r\u001a\u00020\fH\u0016J\b\u0010\u000e\u001a\u00020\u0005H\u0016J\b\u0010\u000f\u001a\u00020\u0005H\u0016J\b\u0010\u0010\u001a\u00020\u0005H\u0016J\b\u0010\u0011\u001a\u00020\fH\u0016J\t\u0010\u0012\u001a\u00020\fH\u0096\u0002J\b\u0010\u0013\u001a\u00020\fH\u0016J\u0010\u0010\u0014\u001a\u00020\f2\u0006\u0010\u0015\u001a\u00020\u0005H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Landroidx/ui/text/platform/CharSequenceCharacterIterator;", "Ljava/text/CharacterIterator;", "charSequence", "", "start", "", "end", "(Ljava/lang/CharSequence;II)V", "index", "clone", "", "current", "", "first", "getBeginIndex", "getEndIndex", "getIndex", "last", "next", "previous", "setIndex", "position", "ui-text-android_release"})
public final class CharSequenceCharacterIterator
implements CharacterIterator {
    private int index;
    private final CharSequence charSequence;
    private final int start;
    private final int end;

    @Override
    public char first() {
        this.index = this.start;
        return this.current();
    }

    @Override
    public char last() {
        char c;
        if (this.start == this.end) {
            this.index = this.end;
            c = '\uffff';
        } else {
            this.index = this.end - 1;
            c = this.charSequence.charAt(this.index);
        }
        return c;
    }

    @Override
    public char current() {
        return this.index == this.end ? (char)'\uffff' : this.charSequence.charAt(this.index);
    }

    @Override
    public char next() {
        char c;
        int n = this.index;
        this.index = n + 1;
        if (this.index >= this.end) {
            this.index = this.end;
            c = '\uffff';
        } else {
            c = this.charSequence.charAt(this.index);
        }
        return c;
    }

    @Override
    public char previous() {
        char c;
        if (this.index <= this.start) {
            c = '\uffff';
        } else {
            int n = this.index;
            this.index = n + -1;
            c = this.charSequence.charAt(this.index);
        }
        return c;
    }

    @Override
    public char setIndex(int position) {
        int n = position;
        if (this.start > n || this.end < n) {
            throw (Throwable)new IllegalArgumentException("invalid position");
        }
        this.index = position;
        return this.current();
    }

    @Override
    public int getBeginIndex() {
        return this.start;
    }

    @Override
    public int getEndIndex() {
        return this.end;
    }

    @Override
    public int getIndex() {
        return this.index;
    }

    @Override
    @NotNull
    public Object clone() {
        Object object;
        try {
            Object object2 = CharacterIterator.super.clone();
            Intrinsics.checkNotNullExpressionValue((Object)object2, (String)"super.clone()");
            object = object2;
        }
        catch (CloneNotSupportedException e) {
            throw (Throwable)new InternalError();
        }
        return object;
    }

    public CharSequenceCharacterIterator(@NotNull CharSequence charSequence, int start, int end) {
        Intrinsics.checkNotNullParameter((Object)charSequence, (String)"charSequence");
        this.charSequence = charSequence;
        this.start = start;
        this.end = end;
        this.index = this.start;
    }
}

