/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.ui.input.PartialGapBuffer;
import androidx.ui.text.TextRange;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 22\u00020\u0001:\u00012B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\r\u0010\u001a\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001cJ\r\u0010\u001d\u001a\u00020\u001bH\u0000\u00a2\u0006\u0002\b\u001eJ\u001d\u0010\u001f\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b\"J\u0016\u0010#\u001a\u00020$2\u0006\u0010%\u001a\u00020\bH\u0080\u0002\u00a2\u0006\u0002\b&J\r\u0010'\u001a\u00020(H\u0000\u00a2\u0006\u0002\b)J%\u0010*\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\b2\u0006\u0010+\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b,J\u001d\u0010-\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b.J\u001d\u0010/\u001a\u00020\u001b2\u0006\u0010 \u001a\u00020\b2\u0006\u0010!\u001a\u00020\bH\u0000\u00a2\u0006\u0002\b0J\b\u00101\u001a\u00020\u0003H\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0014\u001a\u00020\b8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000b\u00a8\u00063"}, d2={"Landroidx/ui/input/EditingBuffer;", "", "initialText", "", "initialSelection", "Landroidx/ui/text/TextRange;", "(Ljava/lang/String;Landroidx/ui/text/TextRange;)V", "<set-?>", "", "compositionEnd", "getCompositionEnd$ui_text_core_release", "()I", "compositionStart", "getCompositionStart$ui_text_core_release", "cursor", "getCursor$ui_text_core_release", "setCursor$ui_text_core_release", "(I)V", "gapBuffer", "Landroidx/ui/input/PartialGapBuffer;", "length", "getLength$ui_text_core_release", "selectionEnd", "getSelectionEnd$ui_text_core_release", "selectionStart", "getSelectionStart$ui_text_core_release", "cancelComposition", "", "cancelComposition$ui_text_core_release", "commitComposition", "commitComposition$ui_text_core_release", "delete", "start", "end", "delete$ui_text_core_release", "get", "", "index", "get$ui_text_core_release", "hasComposition", "", "hasComposition$ui_text_core_release", "replace", "text", "replace$ui_text_core_release", "setComposition", "setComposition$ui_text_core_release", "setSelection", "setSelection$ui_text_core_release", "toString", "Companion", "ui-text-core_release"})
public final class EditingBuffer {
    private final PartialGapBuffer gapBuffer;
    private int selectionStart;
    private int selectionEnd;
    private int compositionStart;
    private int compositionEnd;
    public static final int NOWHERE = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public EditingBuffer(@NotNull String initialText, @NotNull TextRange initialSelection) {
        Intrinsics.checkParameterIsNotNull((Object)initialText, (String)"initialText");
        Intrinsics.checkParameterIsNotNull((Object)initialSelection, (String)"initialSelection");
        this.gapBuffer = new PartialGapBuffer(initialText);
        this.selectionStart = initialSelection.getMin();
        this.selectionEnd = initialSelection.getMax();
        this.compositionStart = -1;
        this.compositionEnd = -1;
        int start = initialSelection.getMin();
        int end = initialSelection.getMax();
        if (start < 0 || start > initialText.length()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + initialText.length());
        }
        if (end < 0 || end > initialText.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + initialText.length());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
    }

    public final int getSelectionStart$ui_text_core_release() {
        return this.selectionStart;
    }

    public final int getSelectionEnd$ui_text_core_release() {
        return this.selectionEnd;
    }

    public final int getCompositionStart$ui_text_core_release() {
        return this.compositionStart;
    }

    public final int getCompositionEnd$ui_text_core_release() {
        return this.compositionEnd;
    }

    public final boolean hasComposition$ui_text_core_release() {
        return this.getCompositionStart$ui_text_core_release() != -1;
    }

    public final int getCursor$ui_text_core_release() {
        return this.getSelectionStart$ui_text_core_release() == this.getSelectionEnd$ui_text_core_release() ? this.getSelectionEnd$ui_text_core_release() : -1;
    }

    public final void setCursor$ui_text_core_release(int cursor) {
        this.setSelection$ui_text_core_release(cursor, cursor);
    }

    public final char get$ui_text_core_release(int index) {
        return this.gapBuffer.get(index);
    }

    public final int getLength$ui_text_core_release() {
        return this.gapBuffer.getLength();
    }

    public final void replace$ui_text_core_release(int start, int end, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.gapBuffer.replace(start, end, text);
        this.selectionStart = start + text.length();
        this.selectionEnd = start + text.length();
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void delete$ui_text_core_release(int start, int end) {
        TextRange deleteRange = new TextRange(start, end);
        if (deleteRange.intersects(new TextRange(this.getSelectionStart$ui_text_core_release(), this.getSelectionEnd$ui_text_core_release()))) {
            String string = "support deletion within selection range.";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        this.gapBuffer.replace(start, end, "");
        if (end <= this.getSelectionStart$ui_text_core_release()) {
            EditingBuffer editingBuffer = this;
            editingBuffer.selectionStart = editingBuffer.getSelectionStart$ui_text_core_release() - deleteRange.getLength();
            editingBuffer = this;
            editingBuffer.selectionEnd = editingBuffer.getSelectionEnd$ui_text_core_release() - deleteRange.getLength();
        }
        if (!this.hasComposition$ui_text_core_release()) {
            return;
        }
        TextRange compositionRange = new TextRange(this.getCompositionStart$ui_text_core_release(), this.getCompositionEnd$ui_text_core_release());
        if (deleteRange.intersects(compositionRange)) {
            if (deleteRange.contains(compositionRange)) {
                this.compositionStart = -1;
                this.compositionEnd = -1;
            } else if (compositionRange.contains(deleteRange)) {
                EditingBuffer editingBuffer = this;
                editingBuffer.compositionEnd = editingBuffer.getCompositionEnd$ui_text_core_release() - deleteRange.getLength();
            } else if (deleteRange.contains(this.getCompositionStart$ui_text_core_release())) {
                this.compositionStart = deleteRange.getMin();
                EditingBuffer editingBuffer = this;
                editingBuffer.compositionEnd = editingBuffer.getCompositionEnd$ui_text_core_release() - deleteRange.getLength();
            } else {
                this.compositionEnd = deleteRange.getMin();
            }
        } else if (this.getCompositionStart$ui_text_core_release() > deleteRange.getMin()) {
            EditingBuffer editingBuffer = this;
            editingBuffer.compositionStart = editingBuffer.getCompositionStart$ui_text_core_release() - deleteRange.getLength();
            editingBuffer = this;
            editingBuffer.compositionEnd = editingBuffer.getCompositionEnd$ui_text_core_release() - deleteRange.getLength();
        }
    }

    public final void setSelection$ui_text_core_release(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.selectionStart = start;
        this.selectionEnd = end;
    }

    public final void setComposition$ui_text_core_release(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start + " > " + end);
        }
        this.compositionStart = start;
        this.compositionEnd = end;
    }

    public final void cancelComposition$ui_text_core_release() {
        this.replace$ui_text_core_release(this.getCompositionStart$ui_text_core_release(), this.getCompositionEnd$ui_text_core_release(), "");
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void commitComposition$ui_text_core_release() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    @NotNull
    public String toString() {
        return this.gapBuffer.toString();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/ui/input/EditingBuffer$Companion;", "", "()V", "NOWHERE", "", "ui-text-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

