/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.annotation.RestrictTo;
import androidx.ui.input.GapBuffer;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0005\b\u0007\u0018\u0000 \u00182\u00020\u0001:\u0001\u0018B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0006H\u0086\u0002J\u001e\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00062\u0006\u0010\u0016\u001a\u00020\u00062\u0006\u0010\u0002\u001a\u00020\u0003J\b\u0010\u0017\u001a\u00020\u0003H\u0016R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\b\u001a\u0004\u0018\u00010\tX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010\n\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\u0002\u001a\u00020\u0003X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0004\u00a8\u0006\u0019"}, d2={"Landroidx/ui/input/PartialGapBuffer;", "", "text", "", "(Ljava/lang/String;)V", "bufEnd", "", "bufStart", "buffer", "Landroidx/ui/input/GapBuffer;", "length", "getLength", "()I", "getText", "()Ljava/lang/String;", "setText", "get", "", "index", "replace", "", "start", "end", "toString", "Companion", "ui-text-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class PartialGapBuffer {
    private String text;
    private GapBuffer buffer;
    private int bufStart;
    private int bufEnd;
    public static final int BUF_SIZE = 255;
    public static final int SURROUNDING_SIZE = 64;
    public static final int NOWHERE = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public PartialGapBuffer(@NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.bufStart = -1;
        this.bufEnd = -1;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String string) {
        Intrinsics.checkParameterIsNotNull((Object)string, (String)"<set-?>");
        this.text = string;
    }

    public final int getLength() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.getText().length();
        }
        GapBuffer buffer = gapBuffer;
        return this.getText().length() - (this.bufEnd - this.bufStart) + buffer.length();
    }

    public final void replace(int start, int end, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        GapBuffer buffer = this.buffer;
        if (buffer == null) {
            int n = 255;
            int n2 = text.length() + 128;
            int n3 = 0;
            char[] charArray = new char[Math.max(n, n2)];
            n2 = 64;
            n3 = 0;
            int leftCopyCount = Math.min(start, n2);
            n3 = this.getText().length() - end;
            int n4 = 64;
            int n5 = 0;
            int rightCopyCount = Math.min(n3, n4);
            String string = this.getText();
            n4 = 0;
            n5 = start - leftCopyCount;
            int n6 = 0;
            String string2 = string;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            string2.getChars(n5, start, charArray, n4);
            string = this.getText();
            n4 = charArray.length - rightCopyCount;
            n5 = end + rightCopyCount;
            n6 = 0;
            String string3 = string;
            if (string3 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            string3.getChars(end, n5, charArray, n4);
            string = text;
            n4 = 0;
            n5 = 0;
            n6 = 12;
            Object var12_15 = null;
            if ((n6 & 2) != 0) {
                leftCopyCount = 0;
            }
            if ((n6 & 4) != 0) {
                n4 = 0;
            }
            if ((n6 & 8) != 0) {
                n5 = string.length();
            }
            n6 = 0;
            string.getChars(n4, n5, charArray, leftCopyCount);
            this.buffer = new GapBuffer(charArray, leftCopyCount + text.length(), charArray.length - rightCopyCount);
            this.bufStart = start - leftCopyCount;
            this.bufEnd = end + rightCopyCount;
            return;
        }
        int bufferStart = start - this.bufStart;
        int bufferEnd = end - this.bufStart;
        if (bufferStart < 0 || bufferEnd > buffer.length()) {
            this.setText(this.toString());
            this.buffer = null;
            this.bufStart = -1;
            this.bufEnd = -1;
            this.replace(start, end, text);
            return;
        }
        buffer.replace(bufferStart, bufferEnd, text);
    }

    public final char get(int index) {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.getText().charAt(index);
        }
        GapBuffer buffer = gapBuffer;
        if (index < this.bufStart) {
            return this.getText().charAt(index);
        }
        int gapBufLength = buffer.length();
        if (index < gapBufLength + this.bufStart) {
            return buffer.get(index - this.bufStart);
        }
        return this.getText().charAt(index - (gapBufLength - this.bufEnd + this.bufStart));
    }

    @NotNull
    public String toString() {
        GapBuffer gapBuffer = this.buffer;
        if (gapBuffer == null) {
            return this.getText();
        }
        GapBuffer b = gapBuffer;
        StringBuilder sb = new StringBuilder();
        sb.append(this.getText(), 0, this.bufStart);
        b.append$ui_text_core_release(sb);
        sb.append(this.getText(), this.bufEnd, this.getText().length());
        return sb.toString();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0007"}, d2={"Landroidx/ui/input/PartialGapBuffer$Companion;", "", "()V", "BUF_SIZE", "", "NOWHERE", "SURROUNDING_SIZE", "ui-text-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

