/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.ui.geometry.Rect;
import androidx.ui.input.EditOperation;
import androidx.ui.input.EditorValue;
import androidx.ui.input.ImeAction;
import androidx.ui.input.KeyboardType;
import androidx.ui.input.PlatformTextInputService;
import java.util.List;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000Z\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0016\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0014\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007H\u0016J#\u0010\f\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\f\u0010\r\u001a\b\u0012\u0004\u0012\u00020\n0\u000eH\u0082\bJ\u001c\u0010\u000f\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\u001c\u0010\u0012\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\u0014\u0010\u0015\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007H\u0016JR\u0010\u0016\u001a\u00060\u0006j\u0002`\u00072\u0006\u0010\u0017\u001a\u00020\u00142\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0018\u0010\u001c\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u001f0\u001e\u0012\u0004\u0012\u00020\n0\u001d2\u0012\u0010 \u001a\u000e\u0012\u0004\u0012\u00020\u001b\u0012\u0004\u0012\u00020\n0\u001dH\u0016J\u0014\u0010!\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\u0006j\u0002`\u0007H\u0016R\u0012\u0010\u0005\u001a\u00060\u0006j\u0002`\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Landroidx/ui/input/TextInputService;", "", "platformTextInputService", "Landroidx/ui/input/PlatformTextInputService;", "(Landroidx/ui/input/PlatformTextInputService;)V", "currentSessionToken", "", "Landroidx/ui/input/InputSessionToken;", "nextSessionToken", "hideSoftwareKeyboard", "", "token", "ignoreIfExpired", "block", "Lkotlin/Function0;", "notifyFocusedRect", "rect", "Landroidx/ui/geometry/Rect;", "onStateUpdated", "model", "Landroidx/ui/input/EditorValue;", "showSoftwareKeyboard", "startInput", "initModel", "keyboardType", "Landroidx/ui/input/KeyboardType;", "imeAction", "Landroidx/ui/input/ImeAction;", "onEditCommand", "Lkotlin/Function1;", "", "Landroidx/ui/input/EditOperation;", "onImeActionPerformed", "stopInput", "ui-text-core_release"})
public class TextInputService {
    private final PlatformTextInputService platformTextInputService;
    private int nextSessionToken;
    private int currentSessionToken;

    public TextInputService(@NotNull PlatformTextInputService platformTextInputService) {
        Intrinsics.checkParameterIsNotNull((Object)platformTextInputService, (String)"platformTextInputService");
        this.platformTextInputService = platformTextInputService;
        this.nextSessionToken = 1;
    }

    private final void ignoreIfExpired(int token, Function0<Unit> block) {
        block0: {
            if (token <= 0 || token != this.currentSessionToken) break block0;
            block.invoke();
        }
    }

    public int startInput(@NotNull EditorValue initModel, @NotNull KeyboardType keyboardType, @NotNull ImeAction imeAction, @NotNull Function1<? super List<? extends EditOperation>, Unit> onEditCommand, @NotNull Function1<? super ImeAction, Unit> onImeActionPerformed) {
        Intrinsics.checkParameterIsNotNull((Object)initModel, (String)"initModel");
        Intrinsics.checkParameterIsNotNull((Object)((Object)keyboardType), (String)"keyboardType");
        Intrinsics.checkParameterIsNotNull((Object)((Object)imeAction), (String)"imeAction");
        Intrinsics.checkParameterIsNotNull(onEditCommand, (String)"onEditCommand");
        Intrinsics.checkParameterIsNotNull(onImeActionPerformed, (String)"onImeActionPerformed");
        this.platformTextInputService.startInput(initModel, keyboardType, imeAction, onEditCommand, onImeActionPerformed);
        TextInputService textInputService = this;
        int n = textInputService.nextSessionToken;
        textInputService.nextSessionToken = n + 1;
        this.currentSessionToken = n;
        return this.currentSessionToken;
    }

    public void stopInput(int token) {
        TextInputService this_$iv = this;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            this.platformTextInputService.stopInput();
        }
    }

    public void showSoftwareKeyboard(int token) {
        TextInputService this_$iv = this;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            this.platformTextInputService.showSoftwareKeyboard();
        }
    }

    public void hideSoftwareKeyboard(int token) {
        TextInputService this_$iv = this;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            this.platformTextInputService.hideSoftwareKeyboard();
        }
    }

    public void onStateUpdated(int token, @NotNull EditorValue model) {
        Intrinsics.checkParameterIsNotNull((Object)model, (String)"model");
        TextInputService this_$iv = this;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            this.platformTextInputService.onStateUpdated(model);
        }
    }

    public void notifyFocusedRect(int token, @NotNull Rect rect) {
        Intrinsics.checkParameterIsNotNull((Object)rect, (String)"rect");
        TextInputService this_$iv = this;
        if (token > 0 && token == this_$iv.currentSessionToken) {
            this.platformTextInputService.notifyFocusedRect(rect);
        }
    }
}

