/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.LayoutDirection;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.MultiParagraph;
import androidx.ui.text.MultiParagraphIntrinsics;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.Placeholder;
import androidx.ui.text.TextLayoutHelperKt;
import androidx.ui.text.TextLayoutInput;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextPainter;
import androidx.ui.text.TextStyle;
import androidx.ui.text.TextStyleKt;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextOverflow;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0086\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0013\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\b\u0007\u0018\u0000 K2\u00020\u0001:\u0001KBY\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0014\b\u0002\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011\u00a2\u0006\u0002\u0010\u0014J(\u00109\u001a\u0002H:\"\u0004\b\u0000\u0010:2\u0012\u0010;\u001a\u000e\u0012\u0004\u0012\u00020(\u0012\u0004\u0012\u0002H:0<H\u0082\b\u00a2\u0006\u0002\u0010=J\"\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020\u00182\n\b\u0002\u0010C\u001a\u0004\u0018\u00010?J\u000e\u0010D\u001a\u00020E2\u0006\u0010B\u001a\u00020\u0018J \u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u0010J\u001a\u00020I2\u0006\u0010B\u001a\u00020\u0018H\u0002R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u001c\u0010\u0017\u001a\u0004\u0018\u00010\u0018X\u0080\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0019\u0010\u001a\"\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010 R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u001e8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010 R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010&R&\u0010'\u001a\u0004\u0018\u00010(8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b)\u0010*\u001a\u0004\b+\u0010,\"\u0004\b-\u0010.R\u001d\u0010\u0010\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00130\u00120\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u00104R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b5\u00106R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b7\u00108\u00a8\u0006L"}, d2={"Landroidx/ui/text/TextDelegate;", "", "text", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "maxLines", "", "softWrap", "", "overflow", "Landroidx/ui/text/style/TextOverflow;", "density", "Landroidx/ui/unit/Density;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "placeholders", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/Placeholder;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/text/TextStyle;IZLandroidx/ui/text/style/TextOverflow;Landroidx/ui/unit/Density;Landroidx/ui/text/font/Font$ResourceLoader;Ljava/util/List;)V", "getDensity", "()Landroidx/ui/unit/Density;", "intrinsicsLayoutDirection", "Landroidx/ui/core/LayoutDirection;", "getIntrinsicsLayoutDirection$ui_text_core_release", "()Landroidx/ui/core/LayoutDirection;", "setIntrinsicsLayoutDirection$ui_text_core_release", "(Landroidx/ui/core/LayoutDirection;)V", "maxIntrinsicWidth", "Landroidx/ui/unit/IntPx;", "getMaxIntrinsicWidth", "()Landroidx/ui/unit/IntPx;", "getMaxLines", "()I", "minIntrinsicWidth", "getMinIntrinsicWidth", "getOverflow", "()Landroidx/ui/text/style/TextOverflow;", "paragraphIntrinsics", "Landroidx/ui/text/MultiParagraphIntrinsics;", "paragraphIntrinsics$annotations$ui_text_core_release", "()V", "getParagraphIntrinsics$ui_text_core_release", "()Landroidx/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$ui_text_core_release", "(Landroidx/ui/text/MultiParagraphIntrinsics;)V", "getPlaceholders", "()Ljava/util/List;", "getResourceLoader", "()Landroidx/ui/text/font/Font$ResourceLoader;", "getSoftWrap", "()Z", "getStyle", "()Landroidx/ui/text/TextStyle;", "getText", "()Landroidx/ui/text/AnnotatedString;", "assumeIntrinsics", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "layout", "Landroidx/ui/text/TextLayoutResult;", "constraints", "Landroidx/ui/core/Constraints;", "layoutDirection", "prevResult", "layoutIntrinsics", "", "layoutText", "Landroidx/ui/text/MultiParagraph;", "minWidth", "", "maxWidth", "Companion", "ui-text-core_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY_GROUP})
public final class TextDelegate {
    private final AnnotatedString text;
    private final TextStyle style;
    private final int maxLines;
    private final boolean softWrap;
    private final TextOverflow overflow;
    private final Density density;
    private final Font.ResourceLoader resourceLoader;
    private final List<AnnotatedString.Item<Placeholder>> placeholders;
    private MultiParagraphIntrinsics paragraphIntrinsics;
    private LayoutDirection intrinsicsLayoutDirection;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public TextDelegate(@NotNull AnnotatedString text, @NotNull TextStyle style, int maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader, @NotNull List<AnnotatedString.Item<Placeholder>> placeholders) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        Intrinsics.checkParameterIsNotNull(placeholders, (String)"placeholders");
        this.text = text;
        this.style = style;
        this.maxLines = maxLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.resourceLoader = resourceLoader;
        this.placeholders = placeholders;
        boolean bl = this.getMaxLines() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string = "Check failed.";
            throw (Throwable)new IllegalStateException(string.toString());
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString text, TextStyle style, int maxLines, boolean softWrap, TextOverflow overflow, Density density, Font.ResourceLoader resourceLoader, List placeholders, int $mask0, DefaultConstructorMarker $marker) {
        List list;
        TextOverflow textOverflow;
        int n = ($mask0 & 4) != 0 ? Integer.MAX_VALUE : maxLines;
        boolean bl = ($mask0 & 8) != 0 ? true : softWrap;
        TextOverflow textOverflow2 = textOverflow = ($mask0 & 0x10) != 0 ? TextOverflow.Clip : overflow;
        if (($mask0 & 0x80) != 0) {
            boolean bl2 = false;
            list = CollectionsKt.emptyList();
        } else {
            list = placeholders;
        }
        List list2 = list;
        this(text, style, n, bl, textOverflow, density, resourceLoader, list2);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    @NotNull
    public final TextOverflow getOverflow() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final List<AnnotatedString.Item<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @Nullable
    public final MultiParagraphIntrinsics getParagraphIntrinsics$ui_text_core_release() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$ui_text_core_release(@Nullable MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    @VisibleForTesting
    public static /* synthetic */ void paragraphIntrinsics$annotations$ui_text_core_release() {
    }

    @Nullable
    public final LayoutDirection getIntrinsicsLayoutDirection$ui_text_core_release() {
        return this.intrinsicsLayoutDirection;
    }

    public final void setIntrinsicsLayoutDirection$ui_text_core_release(@Nullable LayoutDirection layoutDirection) {
        this.intrinsicsLayoutDirection = layoutDirection;
    }

    private final <T> T assumeIntrinsics(Function1<? super MultiParagraphIntrinsics, ? extends T> block) {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_core_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        return (T)block.invoke((Object)multiParagraphIntrinsics);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntPx getMinIntrinsicWidth() {
        IntPx intPx;
        void $this$ceil$iv;
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_core_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        float $this$px$iv22 = it.getMinIntrinsicWidth();
        Px $this$px$iv22 = new Px($this$px$iv22);
        float f = $this$ceil$iv.getValue();
        boolean bl = false;
        if (Float.isInfinite(f)) {
            intPx = IntPx.Companion.getInfinity();
        } else {
            f = $this$ceil$iv.getValue();
            bl = false;
            float f2 = (float)Math.ceil(f);
            int n = (int)f2;
            intPx = new IntPx(n);
        }
        return intPx;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntPx getMaxIntrinsicWidth() {
        IntPx intPx;
        void $this$ceil$iv;
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_core_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        float $this$px$iv22 = it.getMaxIntrinsicWidth();
        Px $this$px$iv22 = new Px($this$px$iv22);
        float f = $this$ceil$iv.getValue();
        boolean bl = false;
        if (Float.isInfinite(f)) {
            intPx = IntPx.Companion.getInfinity();
        } else {
            f = $this$ceil$iv.getValue();
            bl = false;
            float f2 = (float)Math.ceil(f);
            int n = (int)f2;
            intPx = new IntPx(n);
        }
        return intPx;
    }

    public final void layoutIntrinsics(@NotNull LayoutDirection layoutDirection) {
        MultiParagraphIntrinsics multiParagraphIntrinsics;
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        if (this.getParagraphIntrinsics$ui_text_core_release() == null || !Intrinsics.areEqual((Object)layoutDirection, (Object)this.getIntrinsicsLayoutDirection$ui_text_core_release())) {
            this.setIntrinsicsLayoutDirection$ui_text_core_release(layoutDirection);
            AnnotatedString annotatedString = this.getText();
            TextStyle textStyle = TextStyleKt.resolveDefaults(this.getStyle(), layoutDirection);
            Density density = this.getDensity();
            Font.ResourceLoader resourceLoader = this.getResourceLoader();
            List<AnnotatedString.Item<Placeholder>> list = this.getPlaceholders();
            multiParagraphIntrinsics = new MultiParagraphIntrinsics(annotatedString, textStyle, list, density, resourceLoader);
        } else {
            multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_core_release();
        }
        MultiParagraphIntrinsics intrinsics = multiParagraphIntrinsics;
        this.setParagraphIntrinsics$ui_text_core_release(intrinsics);
    }

    private final MultiParagraph layoutText(float minWidth, float maxWidth, LayoutDirection layoutDirection) {
        this.layoutIntrinsics(layoutDirection);
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_core_release();
        if (multiParagraphIntrinsics == null) {
            throw new IllegalStateException("layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics paragraphIntrinsics = multiParagraphIntrinsics;
        float width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((float)paragraphIntrinsics.getMaxIntrinsicWidth(), (float)minWidth, (float)maxWidth);
        return new MultiParagraph(paragraphIntrinsics, this.getMaxLines(), Intrinsics.areEqual((Object)((Object)this.getOverflow()), (Object)((Object)TextOverflow.Ellipsis)), new ParagraphConstraints(width));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextLayoutResult layout(@NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResult) {
        void val1$iv$iv;
        long l;
        void height$iv;
        void width$iv;
        IntPx intPx;
        Px $this$ceil$iv;
        void $this$px$iv52;
        IntPx intPx2;
        Px $this$ceil$iv2;
        void $this$px$iv42;
        Px px;
        IntPx maxWidth;
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        IntPx minWidth = constraints.getMinWidth();
        boolean widthMatters = this.getSoftWrap() || Intrinsics.areEqual((Object)((Object)this.getOverflow()), (Object)((Object)TextOverflow.Ellipsis));
        IntPx intPx3 = maxWidth = widthMatters ? constraints.getMaxWidth() : IntPx.Companion.getInfinity();
        if (prevResult != null && TextLayoutHelperKt.canReuse(prevResult, this.getText(), this.getStyle(), this.getMaxLines(), this.getSoftWrap(), this.getOverflow(), this.getDensity(), layoutDirection, this.getResourceLoader(), constraints)) {
            void val1$iv$iv2;
            long l2;
            void height$iv2;
            void width$iv2;
            IntPx intPx4;
            Px $this$ceil$iv3;
            void $this$px$iv32;
            IntPx intPx5;
            Px $this$ceil$iv4;
            void $this$px$iv22;
            Px px2;
            boolean bl = false;
            boolean bl2 = false;
            TextLayoutResult $this$layout_u24lambda_u2d3 = prevResult;
            float f = $this$layout_u24lambda_u2d3.getMultiParagraph$ui_text_core_release().getWidth();
            Constraints constraints2 = constraints;
            MultiParagraph multiParagraph = null;
            TextLayoutInput textLayoutInput = TextLayoutInput.copy$default($this$layout_u24lambda_u2d3.getLayoutInput(), null, null, null, 0, false, null, null, null, null, constraints, 511, null);
            TextLayoutResult textLayoutResult = $this$layout_u24lambda_u2d3;
            Px $this$px$iv22 = px2 = new Px((float)$this$px$iv22);
            float f2 = $this$ceil$iv4.getValue();
            boolean bl3 = false;
            if (Float.isInfinite(f2)) {
                intPx5 = IntPx.Companion.getInfinity();
            } else {
                f2 = $this$ceil$iv4.getValue();
                bl3 = false;
                float f3 = (float)Math.ceil(f2);
                int n = (int)f3;
                intPx5 = new IntPx(n);
            }
            $this$ceil$iv4 = px2 = intPx5;
            f2 = $this$layout_u24lambda_u2d3.getMultiParagraph$ui_text_core_release().getHeight();
            Px $this$px$iv32 = px2 = new Px((float)$this$px$iv32);
            float f4 = $this$ceil$iv3.getValue();
            boolean bl4 = false;
            if (Float.isInfinite(f4)) {
                intPx4 = IntPx.Companion.getInfinity();
            } else {
                f4 = $this$ceil$iv3.getValue();
                bl4 = false;
                float f5 = (float)Math.ceil(f4);
                int n = (int)f5;
                intPx4 = new IntPx(n);
            }
            $this$ceil$iv3 = px2 = intPx4;
            int n = width$iv2.getValue();
            int val2$iv$iv = height$iv2.getValue();
            boolean $i$f$packInts = false;
            long l3 = l2 = (long)val1$iv$iv2 << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
            px2 = new IntPxSize(l3);
            return TextLayoutResult.copy$default(textLayoutResult, textLayoutInput, multiParagraph, ConstraintsKt.constrain((Constraints)constraints2, (IntPxSize)px2), 2, null);
        }
        MultiParagraph multiParagraph = this.layoutText(minWidth.getValue(), maxWidth.getValue(), layoutDirection);
        float $this$layout_u24lambda_u2d3 = multiParagraph.getWidth();
        Constraints constraints3 = constraints;
        Px $this$px$iv42 = px = new Px((float)$this$px$iv42);
        float width$iv2 = $this$ceil$iv2.getValue();
        boolean bl = false;
        if (Float.isInfinite(width$iv2)) {
            intPx2 = IntPx.Companion.getInfinity();
        } else {
            width$iv2 = $this$ceil$iv2.getValue();
            bl = false;
            float f = (float)Math.ceil(width$iv2);
            int n = (int)f;
            intPx2 = new IntPx(n);
        }
        $this$ceil$iv2 = px = intPx2;
        width$iv2 = multiParagraph.getHeight();
        Px $this$px$iv52 = px = new Px((float)$this$px$iv52);
        float f = $this$ceil$iv.getValue();
        boolean bl5 = false;
        if (Float.isInfinite(f)) {
            intPx = IntPx.Companion.getInfinity();
        } else {
            f = $this$ceil$iv.getValue();
            bl5 = false;
            float f6 = (float)Math.ceil(f);
            int n = (int)f6;
            intPx = new IntPx(n);
        }
        $this$ceil$iv = px = intPx;
        int n = width$iv.getValue();
        int val2$iv$iv = height$iv.getValue();
        boolean $i$f$packInts = false;
        long l4 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
        px = new IntPxSize(l4);
        IntPxSize size = ConstraintsKt.constrain((Constraints)constraints3, (IntPxSize)px);
        return new TextLayoutResult(new TextLayoutInput(this.getText(), this.getStyle(), this.getPlaceholders(), this.getMaxLines(), this.getSoftWrap(), this.getOverflow(), this.getDensity(), layoutDirection, this.getResourceLoader(), constraints), multiParagraph, size);
    }

    public static /* synthetic */ TextLayoutResult layout$default(@NotNull TextDelegate this_, @NotNull Constraints constraints, @NotNull LayoutDirection layoutDirection, @Nullable TextLayoutResult prevResult, int $mask0, @Nullable Object $handler) {
        TextLayoutResult textLayoutResult = ($mask0 & 4) != 0 ? (TextLayoutResult)null : prevResult;
        return this_.layout(constraints, layoutDirection, textLayoutResult);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bJ.\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\u000f"}, d2={"Landroidx/ui/text/TextDelegate$Companion;", "", "()V", "paint", "", "canvas", "Landroidx/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/ui/text/TextLayoutResult;", "paintBackground", "start", "", "end", "color", "Landroidx/ui/graphics/Color;", "ui-text-core_release"})
    public static final class Companion {
        private Companion() {
        }

        public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
            TextPainter.INSTANCE.paint(canvas, textLayoutResult);
        }

        public final void paintBackground(int start, int end, @NotNull Color color, @NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
            Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
            if (start == end) {
                return;
            }
            Path selectionPath = textLayoutResult.getMultiParagraph$ui_text_core_release().getPathForRange(start, end);
            Paint paint = new Paint();
            Path path = selectionPath;
            Canvas canvas2 = canvas;
            boolean bl = false;
            boolean bl2 = false;
            Paint $this$paintBackground_u24lambda_u2d0 = paint;
            $this$paintBackground_u24lambda_u2d0.setColor(color);
            Paint paint2 = paint;
            canvas2.drawPath(path, paint2);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

