/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Path;
import androidx.ui.text.MultiParagraph;
import androidx.ui.text.TextLayoutInput;
import androidx.ui.text.TextRange;
import androidx.ui.text.style.TextDirection;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000f\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B\u001f\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\bJ\t\u0010\"\u001a\u00020\u0003H\u00c6\u0003J\u000e\u0010#\u001a\u00020\u0005H\u00c0\u0003\u00a2\u0006\u0002\b$J\t\u0010%\u001a\u00020\u0007H\u00c6\u0003J'\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010'\u001a\u00020\n2\b\u0010(\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u000e\u0010)\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u000e\u0010-\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,J\u000e\u0010.\u001a\u00020\u001d2\u0006\u0010+\u001a\u00020,J\u0016\u0010/\u001a\u00020\u00102\u0006\u0010+\u001a\u00020,2\u0006\u00100\u001a\u00020\nJ\u000e\u00101\u001a\u00020\u00102\u0006\u00102\u001a\u00020,J\u000e\u00103\u001a\u00020,2\u0006\u0010+\u001a\u00020,J\u000e\u00104\u001a\u00020,2\u0006\u00105\u001a\u000206J\u000e\u00107\u001a\u00020*2\u0006\u0010+\u001a\u00020,J\u0016\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020,2\u0006\u0010;\u001a\u00020,J\u000e\u0010<\u001a\u00020=2\u0006\u0010+\u001a\u00020,J\t\u0010>\u001a\u00020,H\u00d6\u0001J\t\u0010?\u001a\u00020@H\u00d6\u0001R\u0011\u0010\t\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\fR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u0011\u0010\u0013\u001a\u00020\n8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\fR\u0011\u0010\u0015\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0004\u001a\u00020\u0005X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0017\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u001d0\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!\u00a8\u0006A"}, d2={"Landroidx/ui/text/TextLayoutResult;", "", "layoutInput", "Landroidx/ui/text/TextLayoutInput;", "multiParagraph", "Landroidx/ui/text/MultiParagraph;", "size", "Landroidx/ui/unit/IntPxSize;", "(Landroidx/ui/text/TextLayoutInput;Landroidx/ui/text/MultiParagraph;Landroidx/ui/unit/IntPxSize;)V", "didOverflowHeight", "", "getDidOverflowHeight", "()Z", "didOverflowWidth", "getDidOverflowWidth", "firstBaseline", "Landroidx/ui/unit/Px;", "getFirstBaseline", "()Landroidx/ui/unit/Px;", "hasVisualOverflow", "getHasVisualOverflow", "lastBaseline", "getLastBaseline", "getLayoutInput", "()Landroidx/ui/text/TextLayoutInput;", "getMultiParagraph$ui_text_core_release", "()Landroidx/ui/text/MultiParagraph;", "placeholderRects", "", "Landroidx/ui/geometry/Rect;", "getPlaceholderRects", "()Ljava/util/List;", "getSize", "()Landroidx/ui/unit/IntPxSize;", "component1", "component2", "component2$ui_text_core_release", "component3", "copy", "equals", "other", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "", "getBoundingBox", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineForOffset", "getOffsetForPosition", "position", "Landroidx/ui/unit/PxPosition;", "getParagraphDirection", "getPathForRange", "Landroidx/ui/graphics/Path;", "start", "end", "getWordBoundary", "Landroidx/ui/text/TextRange;", "hashCode", "toString", "", "ui-text-core_release"})
public final class TextLayoutResult {
    private final TextLayoutInput layoutInput;
    private final MultiParagraph multiParagraph;
    private final IntPxSize size;
    private final Px firstBaseline;
    private final Px lastBaseline;
    private final List<Rect> placeholderRects;

    public TextLayoutResult(@NotNull TextLayoutInput layoutInput, @NotNull MultiParagraph multiParagraph, @NotNull IntPxSize size) {
        float $this$px$iv;
        Px px;
        Intrinsics.checkParameterIsNotNull((Object)layoutInput, (String)"layoutInput");
        Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        this.layoutInput = layoutInput;
        this.multiParagraph = multiParagraph;
        this.size = size;
        float f = this.getMultiParagraph$ui_text_core_release().getFirstBaseline();
        TextLayoutResult textLayoutResult = this;
        textLayoutResult.firstBaseline = px = new Px($this$px$iv);
        $this$px$iv = this.getMultiParagraph$ui_text_core_release().getLastBaseline();
        textLayoutResult = this;
        textLayoutResult.lastBaseline = px = new Px($this$px$iv);
        this.placeholderRects = this.getMultiParagraph$ui_text_core_release().getPlaceholderRects();
    }

    @NotNull
    public final TextLayoutInput getLayoutInput() {
        return this.layoutInput;
    }

    @NotNull
    public final MultiParagraph getMultiParagraph$ui_text_core_release() {
        return this.multiParagraph;
    }

    @NotNull
    public final IntPxSize getSize() {
        return this.size;
    }

    @NotNull
    public final Px getFirstBaseline() {
        return this.firstBaseline;
    }

    @NotNull
    public final Px getLastBaseline() {
        return this.lastBaseline;
    }

    public final boolean getDidOverflowHeight() {
        return this.getMultiParagraph$ui_text_core_release().getDidExceedMaxLines();
    }

    public final boolean getDidOverflowWidth() {
        IntPxSize this_$iv = this.getSize();
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackInt1 = false;
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        return (float)new IntPx($this$ipx$iv$iv).getValue() < this.getMultiParagraph$ui_text_core_release().getWidth();
    }

    public final boolean getHasVisualOverflow() {
        return this.getDidOverflowWidth() || this.getDidOverflowHeight();
    }

    @NotNull
    public final List<Rect> getPlaceholderRects() {
        return this.placeholderRects;
    }

    @NotNull
    public final Px getLineBottom(int lineIndex) {
        float $this$px$iv = this.getMultiParagraph$ui_text_core_release().getLineBottom(lineIndex);
        return new Px($this$px$iv);
    }

    public final int getLineForOffset(int offset) {
        return this.getMultiParagraph$ui_text_core_release().getLineForOffset(offset);
    }

    @NotNull
    public final Px getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        float $this$px$iv = this.getMultiParagraph$ui_text_core_release().getHorizontalPosition(offset, usePrimaryDirection);
        return new Px($this$px$iv);
    }

    @NotNull
    public final TextDirection getParagraphDirection(int offset) {
        return this.getMultiParagraph$ui_text_core_release().getParagraphDirection(offset);
    }

    @NotNull
    public final TextDirection getBidiRunDirection(int offset) {
        return this.getMultiParagraph$ui_text_core_release().getBidiRunDirection(offset);
    }

    public final int getOffsetForPosition(@NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        return this.getMultiParagraph$ui_text_core_release().getOffsetForPosition(position);
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        return this.getMultiParagraph$ui_text_core_release().getBoundingBox(offset);
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        return this.getMultiParagraph$ui_text_core_release().getWordBoundary(offset);
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        return this.getMultiParagraph$ui_text_core_release().getCursorRect(offset);
    }

    @NotNull
    public final Path getPathForRange(int start, int end) {
        return this.getMultiParagraph$ui_text_core_release().getPathForRange(start, end);
    }

    @NotNull
    public final TextLayoutInput component1() {
        return this.layoutInput;
    }

    @NotNull
    public final MultiParagraph component2$ui_text_core_release() {
        return this.multiParagraph;
    }

    @NotNull
    public final IntPxSize component3() {
        return this.size;
    }

    @NotNull
    public final TextLayoutResult copy(@NotNull TextLayoutInput layoutInput, @NotNull MultiParagraph multiParagraph, @NotNull IntPxSize size) {
        Intrinsics.checkParameterIsNotNull((Object)layoutInput, (String)"layoutInput");
        Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
        Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
        return new TextLayoutResult(layoutInput, multiParagraph, size);
    }

    public static /* synthetic */ TextLayoutResult copy$default(@NotNull TextLayoutResult this_, @Nullable TextLayoutInput layoutInput, @Nullable MultiParagraph multiParagraph, @Nullable IntPxSize size, int $mask0, @Nullable Object $handler) {
        TextLayoutInput textLayoutInput = ($mask0 & 1) != 0 ? this_.layoutInput : layoutInput;
        MultiParagraph multiParagraph2 = ($mask0 & 2) != 0 ? this_.multiParagraph : multiParagraph;
        IntPxSize intPxSize = ($mask0 & 4) != 0 ? this_.size : size;
        return this_.copy(textLayoutInput, multiParagraph2, intPxSize);
    }

    @NotNull
    public String toString() {
        return "TextLayoutResult(layoutInput=" + this.layoutInput + ", multiParagraph=" + this.multiParagraph + ", size=" + this.size + ")";
    }

    public int hashCode() {
        return (this.layoutInput.hashCode() * 31 + this.multiParagraph.hashCode()) * 31 + this.size.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextLayoutResult)) {
            return false;
        }
        Object object = other;
        TextLayoutResult textLayoutResult = (TextLayoutResult)object;
        if (!Intrinsics.areEqual((Object)this.layoutInput, (Object)textLayoutResult.layoutInput)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.multiParagraph, (Object)textLayoutResult.multiParagraph)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.size, (Object)textLayoutResult.size);
    }
}

