/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ClipOp;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.style.TextOverflow;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0016\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b\u00a8\u0006\t"}, d2={"Landroidx/ui/text/TextPainter;", "", "()V", "paint", "", "canvas", "Landroidx/ui/graphics/Canvas;", "textLayoutResult", "Landroidx/ui/text/TextLayoutResult;", "ui-text-core_release"})
public final class TextPainter {
    @NotNull
    public static final TextPainter INSTANCE = new TextPainter();

    private TextPainter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        boolean needClipping;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
        boolean bl = needClipping = textLayoutResult.getHasVisualOverflow() && Intrinsics.areEqual((Object)((Object)textLayoutResult.getLayoutInput().getOverflow()), (Object)((Object)TextOverflow.Clip));
        if (needClipping) {
            IntPxSize this_$iv = textLayoutResult.getSize();
            long value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackInt1 = false;
            int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
            float width = new IntPx($this$ipx$iv$iv).getValue();
            IntPxSize this_$iv2 = textLayoutResult.getSize();
            long value$iv$iv2 = this_$iv2.getValue();
            boolean $i$f$unpackInt2 = false;
            int $this$ipx$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            float height = new IntPx($this$ipx$iv$iv2).getValue();
            Rect bounds = Rect.Companion.fromLTWH(0.0f, 0.0f, width, height);
            canvas.save();
            Canvas.DefaultImpls.clipRect$default((Canvas)canvas, (Rect)bounds, (ClipOp)null, (int)2, null);
        }
        try {
            textLayoutResult.getMultiParagraph$ui_text_core_release().paint(canvas);
            Unit unit = Unit.INSTANCE;
        }
        finally {
            if (needClipping) {
                canvas.restore();
            }
        }
    }
}

