/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.content.Context;
import android.graphics.Typeface;
import androidx.ui.text.font.Font;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontListFontFamily;
import androidx.ui.text.font.FontMatcher;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.platform.AndroidTypeface;
import androidx.ui.text.platform.AndroidTypefaceCache;
import androidx.ui.text.platform.TypefaceAdapter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010$\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0000\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB=\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u001c\b\u0002\u0010\u0006\u001a\u0016\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\t\u0012\u0004\u0012\u00020\n0\b\u0018\u00010\u0007\u0012\b\b\u0002\u0010\u000b\u001a\u00020\f\u00a2\u0006\u0002\u0010\rJ \u0010\u0018\u001a\u00020\u00172\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\n2\u0006\u0010\u001b\u001a\u00020\u001cH\u0016R\u0014\u0010\u0002\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0013\u0010\u000b\u001a\u00020\f\u00a2\u0006\n\n\u0002\b\u0013\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\u0014\u001a\u000e\u0012\u0004\u0012\u00020\u0016\u0012\u0004\u0012\u00020\u00170\u0015X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Landroidx/ui/text/platform/AndroidFontListTypeface;", "Landroidx/ui/text/platform/AndroidTypeface;", "fontFamily", "Landroidx/ui/text/font/FontListFontFamily;", "context", "Landroid/content/Context;", "necessaryStyles", "", "Lkotlin/Pair;", "Landroidx/ui/text/font/FontWeight;", "Landroidx/ui/text/font/FontStyle;", "fontMatcher", "Landroidx/ui/text/font/FontMatcher;", "(Landroidx/ui/text/font/FontListFontFamily;Landroid/content/Context;Ljava/util/List;Landroidx/ui/text/font/FontMatcher;)V", "Landroidx/ui/text/font/FontFamily;", "getFontFamily", "()Landroidx/ui/text/font/FontFamily;", "getFontMatcher", "()Landroidx/ui/text/font/FontMatcher;", "fontMatcher$1", "loadedTypefaces", "", "Landroidx/ui/text/font/Font;", "Landroid/graphics/Typeface;", "getNativeTypeface", "fontWeight", "fontStyle", "synthesis", "Landroidx/ui/text/font/FontSynthesis;", "Companion", "ui-text-core_release"})
public final class AndroidFontListTypeface
implements AndroidTypeface {
    private final FontMatcher fontMatcher$1;
    private final Map<Font, Typeface> loadedTypefaces;
    private final FontFamily fontFamily;
    private static final FontMatcher fontMatcher;
    @NotNull
    public static final Companion Companion;

    /*
     * WARNING - void declaration
     */
    public AndroidFontListTypeface(@NotNull FontListFontFamily fontFamily, @NotNull Context context, @Nullable List<? extends Pair<FontWeight, ? extends FontStyle>> necessaryStyles, @NotNull FontMatcher fontMatcher) {
        Typeface typeface;
        boolean $i$f$map;
        List list;
        Intrinsics.checkParameterIsNotNull((Object)fontFamily, (String)"fontFamily");
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)fontMatcher, (String)"fontMatcher");
        this.fontMatcher$1 = fontMatcher;
        if (necessaryStyles == null) {
            list = fontFamily.getFonts();
        } else {
            void $this$mapTo$iv$iv;
            Iterable $this$map$iv = necessaryStyles;
            $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                Pair pair = (Pair)item$iv$iv;
                Collection collection = destination$iv$iv;
                FontWeight weight = (FontWeight)typeface.component1();
                FontStyle style = (FontStyle)((Object)typeface.component2());
                Font font = this.getFontMatcher().matchFont(fontFamily, weight, style);
                collection.add(font);
            }
            list = CollectionsKt.distinct((Iterable)((List)destination$iv$iv));
        }
        List targetFonts = list;
        $i$f$map = false;
        Map typefaces = new LinkedHashMap();
        Iterable $this$forEach$iv = targetFonts;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            Font it = (Font)element$iv;
            try {
                Map map = typefaces;
                typeface = AndroidTypefaceCache.INSTANCE.getOrCreate(context, it);
                boolean bl = false;
                map.put(it, typeface);
                map = Unit.INSTANCE;
            }
            catch (Exception e) {
                throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot create Typeface from ", (Object)it));
            }
        }
        this.loadedTypefaces = typefaces;
        this.fontFamily = fontFamily;
    }

    public /* synthetic */ AndroidFontListTypeface(FontListFontFamily fontFamily, Context context, List necessaryStyles, FontMatcher fontMatcher, int $mask0, DefaultConstructorMarker $marker) {
        List list = ($mask0 & 4) != 0 ? (List)null : necessaryStyles;
        FontMatcher fontMatcher2 = ($mask0 & 8) != 0 ? Companion.getFontMatcher() : fontMatcher;
        this(fontFamily, context, list, fontMatcher2);
    }

    @NotNull
    public final FontMatcher getFontMatcher() {
        return this.fontMatcher$1;
    }

    @Override
    @NotNull
    public FontFamily getFontFamily() {
        return this.fontFamily;
    }

    @Override
    @NotNull
    public Typeface getNativeTypeface(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis synthesis) {
        Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
        Intrinsics.checkParameterIsNotNull((Object)((Object)synthesis), (String)"synthesis");
        Font font = this.getFontMatcher().matchFont((Iterable<? extends Font>)this.loadedTypefaces.keySet(), fontWeight, fontStyle);
        Typeface typeface = this.loadedTypefaces.get(font);
        boolean bl = false;
        boolean bl2 = false;
        bl2 = false;
        boolean bl3 = false;
        if (typeface == null) {
            boolean bl4 = false;
            String string = "Required value was null.";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (Intrinsics.areEqual((Object)font.getWeight(), (Object)fontWeight) && Intrinsics.areEqual((Object)((Object)font.getStyle()), (Object)((Object)fontStyle)) || Intrinsics.areEqual((Object)((Object)synthesis), (Object)((Object)FontSynthesis.None))) {
            return typeface;
        }
        return TypefaceAdapter.Companion.synthesize(typeface, font, fontWeight, fontStyle, synthesis);
    }

    static {
        Companion = new Companion(null);
        fontMatcher = new FontMatcher();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0082\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Landroidx/ui/text/platform/AndroidFontListTypeface$Companion;", "", "()V", "fontMatcher", "Landroidx/ui/text/font/FontMatcher;", "getFontMatcher", "()Landroidx/ui/text/font/FontMatcher;", "ui-text-core_release"})
    private static final class Companion {
        private Companion() {
        }

        @NotNull
        public final FontMatcher getFontMatcher() {
            return fontMatcher;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

