/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LocaleSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.RequiresApi;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.Locale;
import androidx.ui.text.LocaleList;
import androidx.ui.text.Placeholder;
import androidx.ui.text.PlaceholderVerticalAlign;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.platform.AndroidLocale;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.platform.style.BaselineShiftSpan;
import androidx.ui.text.platform.style.FontFeatureSpan;
import androidx.ui.text.platform.style.LetterSpacingSpanEm;
import androidx.ui.text.platform.style.LetterSpacingSpanPx;
import androidx.ui.text.platform.style.LineHeightSpan;
import androidx.ui.text.platform.style.PlaceholderSpan;
import androidx.ui.text.platform.style.ShadowSpan;
import androidx.ui.text.platform.style.SkewXSpan;
import androidx.ui.text.platform.style.TypefaceSpan;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextIndent;
import androidx.ui.unit.Density;
import androidx.ui.unit.TextUnit;
import androidx.ui.unit.TextUnitKt;
import androidx.ui.unit.TextUnitType;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Triple;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000~\n\u0000\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001ab\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00022\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u00140\u00132\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00170\u00140\u00132\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001a\u0018\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0010\u0010\u001f\u001a\u00020\u00012\u0006\u0010 \u001a\u00020!H\u0000\u001a$\u0010\"\u001a\u00020\u0015*\u00020#2\u0006\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0000\u001a\f\u0010$\u001a\u00020%*\u00020\u0015H\u0002\u001a\f\u0010&\u001a\u00020'*\u00020(H\u0003\u001a\f\u0010)\u001a\u00020**\u00020+H\u0002\"\u0018\u0010\u0000\u001a\u00020\u0001*\u00020\u00028@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0003\u0010\u0004\"\u0018\u0010\u0005\u001a\u00020\u0001*\u00020\u00068@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\b\u00a8\u0006,"}, d2={"spanUnit", "", "Landroidx/ui/unit/TextUnit;", "getSpanUnit", "(Landroidx/ui/unit/TextUnit;)I", "spanVerticalAlign", "Landroidx/ui/text/PlaceholderVerticalAlign;", "getSpanVerticalAlign", "(Landroidx/ui/text/PlaceholderVerticalAlign;)I", "createStyledText", "", "text", "", "contextFontSize", "", "lineHeight", "textIndent", "Landroidx/ui/text/style/TextIndent;", "spanStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/SpanStyle;", "placeholders", "Landroidx/ui/text/Placeholder;", "density", "Landroidx/ui/unit/Density;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "createTypeface", "Landroid/graphics/Typeface;", "style", "resolveTextDirectionHeuristics", "textDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "applySpanStyle", "Landroid/text/TextPaint;", "hasFontAttributes", "", "toAndroidLocaleList", "Landroid/os/LocaleList;", "Landroidx/ui/text/LocaleList;", "toJavaLocale", "Ljava/util/Locale;", "Landroidx/ui/text/Locale;", "ui-text-core_release"})
public final class AndroidParagraphHelperKt {
    @NotNull
    public static final SpanStyle applySpanStyle(@NotNull TextPaint $this$applySpanStyle, @NotNull SpanStyle style, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        TextPaint textPaint;
        Object it;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)$this$applySpanStyle, (String)"<this>");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Object object = style.getFontSize().getType();
        int n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 1: {
                bl2 = false;
                bl = false;
                Density $this$applySpanStyle_u24lambda_u2d0 = density;
                $this$applySpanStyle.setTextSize($this$applySpanStyle_u24lambda_u2d0.toPx(style.getFontSize()).getValue());
                break;
            }
            case 2: {
                TextPaint textPaint2 = $this$applySpanStyle;
                textPaint2.setTextSize(textPaint2.getTextSize() * style.getFontSize().getValue());
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
            $this$applySpanStyle.setTypeface(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter));
        }
        if ((object = style.getLocaleList()) != null) {
            Object object2 = object;
            bl2 = false;
            bl = false;
            it = object2;
            if (Build.VERSION.SDK_INT >= 24) {
                $this$applySpanStyle.setTextLocales(AndroidParagraphHelperKt.toAndroidLocaleList((LocaleList)it));
            } else {
                Locale locale = ((LocaleList)it).isEmpty() ? Locale.Companion.getCurrent() : ((LocaleList)it).get(0);
                $this$applySpanStyle.setTextLocale(AndroidParagraphHelperKt.toJavaLocale(locale));
            }
        }
        object = style.getColor();
        if (object != null) {
            Object object3 = object;
            bl2 = false;
            bl = false;
            it = object3;
            $this$applySpanStyle.setColor(ColorKt.toArgb((Color)it));
        }
        object = style.getLetterSpacing().getType();
        n = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n) {
            case 2: {
                $this$applySpanStyle.setLetterSpacing(style.getLetterSpacing().getValue());
                break;
            }
            case 1: {
                break;
            }
            case 3: {
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        object = style.getFontFeatureSettings();
        if (object != null) {
            Object object4 = object;
            bl2 = false;
            bl = false;
            it = object4;
            $this$applySpanStyle.setFontFeatureSettings((String)it);
        }
        object = style.getTextGeometricTransform();
        if (object != null) {
            Object object5 = object;
            bl2 = false;
            bl = false;
            it = object5;
            textPaint = $this$applySpanStyle;
            textPaint.setTextScaleX(textPaint.getTextScaleX() * ((TextGeometricTransform)it).getScaleX());
        }
        object = style.getTextGeometricTransform();
        if (object != null) {
            Object object6 = object;
            bl2 = false;
            bl = false;
            it = object6;
            textPaint = $this$applySpanStyle;
            textPaint.setTextSkewX(textPaint.getTextSkewX() + ((TextGeometricTransform)it).getSkewX());
        }
        object = style.getShadow();
        if (object != null) {
            Object object7 = object;
            bl2 = false;
            bl = false;
            it = object7;
            $this$applySpanStyle.setShadowLayer(it.getBlurRadius().getValue(), it.getOffset().getDx(), it.getOffset().getDy(), ColorKt.toArgb((Color)it.getColor()));
        }
        object = style.getTextDecoration();
        if (object != null) {
            Object object8 = object;
            bl2 = false;
            bl = false;
            it = object8;
            if (((TextDecoration)it).contains(TextDecoration.Companion.getUnderline())) {
                $this$applySpanStyle.setUnderlineText(true);
            }
            if (((TextDecoration)it).contains(TextDecoration.Companion.getLineThrough())) {
                $this$applySpanStyle.setStrikeThruText(true);
            }
        }
        object = Intrinsics.areEqual((Object)style.getLetterSpacing().getType(), (Object)TextUnitType.Sp) && !(style.getLetterSpacing().getValue() == 0.0f) ? style.getLetterSpacing() : TextUnit.Companion.getInherit();
        Color color = Intrinsics.areEqual((Object)style.getBackground(), (Object)Color.Companion.getTransparent()) ? (Color)null : style.getBackground();
        BaselineShift baselineShift = Intrinsics.areEqual((Object)style.getBaselineShift(), (Object)BaselineShift.Companion.getNone()) ? (BaselineShift)null : style.getBaselineShift();
        return new SpanStyle(null, null, null, null, null, null, null, (TextUnit)object, baselineShift, null, null, color, null, null, 13951, null);
    }

    @NotNull
    public static final CharSequence createStyledText(@NotNull String text, float contextFontSize, @NotNull TextUnit lineHeight, @Nullable TextIndent textIndent, @NotNull List<AnnotatedString.Item<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Item<Placeholder>> placeholders, @NotNull Density density, @NotNull TypefaceAdapter typefaceAdapter) {
        int start;
        int n;
        Unit unit;
        int n2;
        SpannableString spannableString;
        boolean bl;
        boolean bl2;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)lineHeight, (String)"lineHeight");
        Intrinsics.checkParameterIsNotNull(spanStyles, (String)"spanStyles");
        Intrinsics.checkParameterIsNotNull(placeholders, (String)"placeholders");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        if (spanStyles.isEmpty() && textIndent == null) {
            return text;
        }
        SpannableString spannableString2 = new SpannableString((CharSequence)text);
        boolean bl3 = false;
        List deferredSpans = new ArrayList();
        Object object = lineHeight.getType();
        int n3 = WhenMappings.$EnumSwitchMapping$0[object.ordinal()];
        switch (n3) {
            case 1: {
                bl2 = false;
                bl = false;
                Density $this$createStyledText_u24lambda_u2d8 = density;
                float f = $this$createStyledText_u24lambda_u2d8.toPx(lineHeight).getValue();
                spannableString = spannableString2;
                n2 = 0;
                float f2 = (float)Math.ceil(f);
                int n4 = (int)f2;
                spannableString.setSpan((Object)new LineHeightSpan(n4), 0, text.length(), 33);
                Unit unit2 = Unit.INSTANCE;
                break;
            }
            case 2: {
                float f = lineHeight.getValue() * contextFontSize;
                SpannableString spannableString3 = spannableString2;
                bl = false;
                float f3 = (float)Math.ceil(f);
                int n5 = (int)f3;
                spannableString3.setSpan((Object)new LineHeightSpan(n5), 0, text.length(), 33);
                Unit unit2 = Unit.INSTANCE;
                break;
            }
            case 3: {
                Unit unit2 = Unit.INSTANCE;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        object = textIndent;
        if (object == null) {
            unit = null;
        } else {
            Object object2 = object;
            bl2 = false;
            bl = false;
            Object indent = object2;
            if (!Intrinsics.areEqual((Object)((TextIndent)indent).getFirstLine(), (Object)TextUnitKt.getSp((int)0)) || !Intrinsics.areEqual((Object)((TextIndent)indent).getRestLine(), (Object)TextUnitKt.getSp((int)0))) {
                if (!((TextIndent)indent).getFirstLine().isInherit() && !((TextIndent)indent).getRestLine().isInherit()) {
                    float f;
                    float f2;
                    boolean bl4 = false;
                    n = 0;
                    Density $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = density;
                    spannableString = ((TextIndent)indent).getFirstLine().getType();
                    n2 = WhenMappings.$EnumSwitchMapping$0[spannableString.ordinal()];
                    switch (n2) {
                        case 1: {
                            f2 = $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9.toPx(((TextIndent)indent).getFirstLine()).getValue();
                            break;
                        }
                        case 2: {
                            f2 = ((TextIndent)indent).getFirstLine().getValue() * contextFontSize;
                            break;
                        }
                        case 3: {
                            f2 = 0.0f;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    float firstLine = f2;
                    TextUnitType textUnitType = ((TextIndent)indent).getRestLine().getType();
                    int n6 = WhenMappings.$EnumSwitchMapping$0[textUnitType.ordinal()];
                    switch (n6) {
                        case 1: {
                            f = $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9.toPx(((TextIndent)indent).getRestLine()).getValue();
                            break;
                        }
                        case 2: {
                            f = ((TextIndent)indent).getRestLine().getValue() * contextFontSize;
                            break;
                        }
                        case 3: {
                            f = 0.0f;
                            break;
                        }
                        default: {
                            throw new NoWhenBranchMatchedException();
                        }
                    }
                    float restLine = f;
                    SpannableString spannableString4 = spannableString2;
                    n2 = 0;
                    float f5 = (float)Math.ceil(firstLine);
                    int n7 = (int)f5;
                    n2 = 0;
                    float f6 = (float)Math.ceil(restLine);
                    int n8 = (int)f6;
                    int n9 = n7;
                    spannableString4.setSpan((Object)new LeadingMarginSpan.Standard(n9, n8), 0, text.length(), 33);
                }
            }
            unit = Unit.INSTANCE;
        }
        for (AnnotatedString.Item item : spanStyles) {
            Unit unit3;
            Unit unit4;
            Unit unit5;
            Unit unit6;
            Unit unit7;
            Unit unit8;
            Unit unit9;
            Unit unit10;
            Unit unit11;
            Unit unit12;
            int start2 = item.getStart();
            int end = item.getEnd();
            SpanStyle style = (SpanStyle)item.getItem();
            if (start2 < 0 || start2 >= text.length() || end <= start2 || end > text.length()) continue;
            Object object3 = style.getBaselineShift();
            if (object3 == null) {
                unit12 = null;
            } else {
                BaselineShift baselineShift = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl5 = false;
                BaselineShift it = baselineShift;
                spannableString2.setSpan((Object)new BaselineShiftSpan(it.getMultiplier()), start2, end, 33);
                unit12 = Unit.INSTANCE;
            }
            object3 = style.getColor();
            if (object3 == null) {
                unit11 = null;
            } else {
                BaselineShift baselineShift = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl6 = false;
                BaselineShift it = baselineShift;
                spannableString2.setSpan((Object)new ForegroundColorSpan(ColorKt.toArgb((Color)it)), start2, end, 33);
                unit11 = Unit.INSTANCE;
            }
            object3 = style.getTextDecoration();
            if (object3 == null) {
                unit10 = null;
            } else {
                Unit unit13;
                Unit unit14;
                Object object4 = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl7 = false;
                Object it = object4;
                if (((TextDecoration)it).contains(TextDecoration.Companion.getUnderline())) {
                    spannableString2.setSpan((Object)new UnderlineSpan(), start2, end, 33);
                    unit14 = Unit.INSTANCE;
                } else {
                    unit14 = Unit.INSTANCE;
                }
                if (((TextDecoration)it).contains(TextDecoration.Companion.getLineThrough())) {
                    spannableString2.setSpan((Object)new StrikethroughSpan(), start2, end, 33);
                    unit13 = Unit.INSTANCE;
                } else {
                    unit13 = Unit.INSTANCE;
                }
                unit10 = Unit.INSTANCE;
            }
            object3 = style.getFontSize().getType();
            n = WhenMappings.$EnumSwitchMapping$0[object3.ordinal()];
            switch (n) {
                case 1: {
                    boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                    boolean bl8 = false;
                    Density $this$createStyledText_u24lambda_u2d14 = density;
                    spannableString2.setSpan((Object)new AbsoluteSizeSpan(MathKt.roundToInt((float)$this$createStyledText_u24lambda_u2d14.toPx(style.getFontSize()).getValue()), true), start2, end, 33);
                    Unit unit15 = Unit.INSTANCE;
                    break;
                }
                case 2: {
                    spannableString2.setSpan((Object)new RelativeSizeSpan(style.getFontSize().getValue()), start2, end, 33);
                    Unit unit15 = Unit.INSTANCE;
                    break;
                }
                case 3: {
                    Unit unit15 = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object3 = style.getFontFeatureSettings();
            if (object3 == null) {
                unit9 = null;
            } else {
                Object object5 = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl9 = false;
                Object it = object5;
                spannableString2.setSpan((Object)new FontFeatureSpan((String)it), start2, end, 33);
                unit9 = Unit.INSTANCE;
            }
            if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
                spannableString2.setSpan((Object)new TypefaceSpan(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter)), start2, end, 33);
                unit8 = Unit.INSTANCE;
            } else {
                unit8 = Unit.INSTANCE;
            }
            object3 = style.getTextGeometricTransform();
            if (object3 == null) {
                unit7 = null;
            } else {
                Unit unit16;
                Object object6 = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl10 = false;
                Object it = object6;
                if (!(((TextGeometricTransform)it).getScaleX() == 1.0f)) {
                    spannableString2.setSpan((Object)new ScaleXSpan(((TextGeometricTransform)it).getScaleX()), start2, end, 33);
                    unit16 = Unit.INSTANCE;
                } else {
                    unit16 = Unit.INSTANCE;
                }
                unit7 = Unit.INSTANCE;
            }
            object3 = style.getTextGeometricTransform();
            if (object3 == null) {
                unit6 = null;
            } else {
                Unit unit17;
                Object object7 = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl11 = false;
                Object it = object7;
                if (!(((TextGeometricTransform)it).getSkewX() == 0.0f)) {
                    spannableString2.setSpan((Object)new SkewXSpan(((TextGeometricTransform)it).getSkewX()), start2, end, 33);
                    unit17 = Unit.INSTANCE;
                } else {
                    unit17 = Unit.INSTANCE;
                }
                unit6 = Unit.INSTANCE;
            }
            object3 = style.getLetterSpacing().getType();
            int n10 = WhenMappings.$EnumSwitchMapping$0[object3.ordinal()];
            switch (n10) {
                case 1: {
                    boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                    boolean bl12 = false;
                    Density $this$createStyledText_u24lambda_u2d18 = density;
                    Object object2 = deferredSpans.add(new Triple((Object)new LetterSpacingSpanPx($this$createStyledText_u24lambda_u2d18.toPx(style.getLetterSpacing()).getValue()), (Object)start2, (Object)end));
                    break;
                }
                case 2: {
                    Object object2 = deferredSpans.add(new Triple((Object)new LetterSpacingSpanEm(style.getLetterSpacing().getValue()), (Object)start2, (Object)end));
                    break;
                }
                case 3: {
                    Object object2 = Unit.INSTANCE;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
            object3 = style.getLocaleList();
            if (object3 == null) {
                unit5 = null;
            } else {
                LocaleSpan localeSpan;
                Object object9 = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl13 = false;
                Object it = object9;
                if (Build.VERSION.SDK_INT >= 24) {
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toAndroidLocaleList((LocaleList)it));
                } else {
                    Locale locale = ((LocaleList)it).isEmpty() ? Locale.Companion.getCurrent() : ((LocaleList)it).get(0);
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toJavaLocale(locale));
                }
                spannableString2.setSpan((Object)localeSpan, start2, end, 33);
                unit5 = Unit.INSTANCE;
            }
            object3 = style.getBackground();
            if (object3 == null) {
                unit4 = null;
            } else {
                Object object10 = object3;
                boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
                boolean bl14 = false;
                Object it = object10;
                spannableString2.setSpan((Object)new BackgroundColorSpan(ColorKt.toArgb((Color)it)), start2, end, 33);
                unit4 = Unit.INSTANCE;
            }
            object3 = style.getShadow();
            if (object3 == null) {
                unit3 = null;
                continue;
            }
            Object object11 = object3;
            boolean $this$createStyledText_u24lambda_u2d10_u24lambda_u2d9 = false;
            boolean bl15 = false;
            Object it = object11;
            spannableString2.setSpan((Object)new ShadowSpan(ColorKt.toArgb((Color)it.getColor()), it.getOffset().getDx(), it.getOffset().getDy(), it.getBlurRadius().getValue()), start2, end, 33);
            unit3 = Unit.INSTANCE;
        }
        for (Triple triple : deferredSpans) {
            Object span = triple.component1();
            start = ((Number)triple.component2()).intValue();
            int end = ((Number)triple.component3()).intValue();
            spannableString2.setSpan(span, start, end, 33);
        }
        for (AnnotatedString.Item item : placeholders) {
            Placeholder placeholder = (Placeholder)item.component1();
            start = item.component2();
            int end = item.component3();
            boolean bl16 = false;
            n = 0;
            Placeholder $this$createStyledText_u24lambda_u2d22 = placeholder;
            spannableString2.setSpan((Object)new PlaceholderSpan($this$createStyledText_u24lambda_u2d22.getWidth().getValue(), AndroidParagraphHelperKt.getSpanUnit($this$createStyledText_u24lambda_u2d22.getWidth()), $this$createStyledText_u24lambda_u2d22.getHeight().getValue(), AndroidParagraphHelperKt.getSpanUnit($this$createStyledText_u24lambda_u2d22.getHeight()), density.getFontScale() * density.getDensity(), AndroidParagraphHelperKt.getSpanVerticalAlign($this$createStyledText_u24lambda_u2d22.getPlaceholderVerticalAlign())), start, end, 33);
        }
        return (CharSequence)spannableString2;
    }

    private static final boolean hasFontAttributes(SpanStyle $this$hasFontAttributes) {
        return $this$hasFontAttributes.getFontFamily() != null || $this$hasFontAttributes.getFontStyle() != null || $this$hasFontAttributes.getFontWeight() != null;
    }

    private static final Typeface createTypeface(SpanStyle style, TypefaceAdapter typefaceAdapter) {
        Object object = style.getFontWeight();
        FontWeight fontWeight = object == null ? FontWeight.Companion.getNormal() : object;
        object = style.getFontStyle();
        Object object2 = object == null ? FontStyle.Normal : object;
        object = style.getFontSynthesis();
        return typefaceAdapter.create(style.getFontFamily(), fontWeight, (FontStyle)((Object)object2), (FontSynthesis)((Object)(object == null ? FontSynthesis.All : object)));
    }

    public static final int resolveTextDirectionHeuristics(@NotNull TextDirectionAlgorithm textDirectionAlgorithm) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textDirectionAlgorithm), (String)"textDirectionAlgorithm");
        TextDirectionAlgorithm textDirectionAlgorithm2 = textDirectionAlgorithm;
        int n2 = WhenMappings.$EnumSwitchMapping$1[textDirectionAlgorithm2.ordinal()];
        switch (n2) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final java.util.Locale toJavaLocale(Locale $this$toJavaLocale) {
        return ((AndroidLocale)$this$toJavaLocale.getPlatformLocale$ui_text_core_release()).getJavaLocale();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=24)
    private static final android.os.LocaleList toAndroidLocaleList(LocaleList $this$toAndroidLocaleList) {
        Collection<java.util.Locale> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toAndroidLocaleList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Locale locale = (Locale)item$iv$iv;
            collection = destination$iv$iv;
            java.util.Locale locale2 = AndroidParagraphHelperKt.toJavaLocale((Locale)it);
            collection.add(locale2);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        java.util.Locale[] localeArray = thisCollection$iv.toArray(new java.util.Locale[0]);
        if (localeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = localeArray;
        java.util.Locale[] localeArray2 = (java.util.Locale[])collection;
        java.util.Locale[] localeArray3 = new java.util.Locale[localeArray2.length];
        System.arraycopy(localeArray2, 0, localeArray3, 0, localeArray2.length);
        java.util.Locale[] localeArray4 = localeArray3;
        return new android.os.LocaleList(localeArray4);
    }

    public static final int getSpanUnit(@NotNull TextUnit $this$spanUnit) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$this$spanUnit, (String)"<this>");
        TextUnitType textUnitType = $this$spanUnit.getType();
        int n2 = WhenMappings.$EnumSwitchMapping$0[textUnitType.ordinal()];
        switch (n2) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    public static final int getSpanVerticalAlign(@NotNull PlaceholderVerticalAlign $this$spanVerticalAlign) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)$this$spanVerticalAlign), (String)"<this>");
        PlaceholderVerticalAlign placeholderVerticalAlign = $this$spanVerticalAlign;
        int n2 = WhenMappings.$EnumSwitchMapping$2[placeholderVerticalAlign.ordinal()];
        switch (n2) {
            case 1: {
                n = 0;
                break;
            }
            case 2: {
                n = 1;
                break;
            }
            case 3: {
                n = 2;
                break;
            }
            case 4: {
                n = 3;
                break;
            }
            case 5: {
                n = 4;
                break;
            }
            case 6: {
                n = 5;
                break;
            }
            case 7: {
                n = 6;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$2;

        static {
            int[] nArray = new int[TextUnitType.values().length];
            nArray[TextUnitType.Sp.ordinal()] = 1;
            nArray[TextUnitType.Em.ordinal()] = 2;
            nArray[TextUnitType.Inherit.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[TextDirectionAlgorithm.values().length];
            nArray[TextDirectionAlgorithm.ContentOrLtr.ordinal()] = 1;
            nArray[TextDirectionAlgorithm.ContentOrRtl.ordinal()] = 2;
            nArray[TextDirectionAlgorithm.ForceLtr.ordinal()] = 3;
            nArray[TextDirectionAlgorithm.ForceRtl.ordinal()] = 4;
            $EnumSwitchMapping$1 = nArray;
            nArray = new int[PlaceholderVerticalAlign.values().length];
            nArray[PlaceholderVerticalAlign.AboveBaseline.ordinal()] = 1;
            nArray[PlaceholderVerticalAlign.Top.ordinal()] = 2;
            nArray[PlaceholderVerticalAlign.Bottom.ordinal()] = 3;
            nArray[PlaceholderVerticalAlign.Center.ordinal()] = 4;
            nArray[PlaceholderVerticalAlign.TextTop.ordinal()] = 5;
            nArray[PlaceholderVerticalAlign.TextBottom.ordinal()] = 6;
            nArray[PlaceholderVerticalAlign.TextCenter.ordinal()] = 7;
            $EnumSwitchMapping$2 = nArray;
        }
    }
}

