/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.text.TextPaint;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.ParagraphIntrinsics;
import androidx.ui.text.Placeholder;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.TextStyle;
import androidx.ui.text.platform.AndroidParagraphHelperKt;
import androidx.ui.text.platform.LayoutIntrinsics;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.unit.Density;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000`\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\f\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0000\u0018\u00002\u00020\u0001BM\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0012\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u0012\u0012\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\u0002\u0010\u0010R\u0014\u0010\u0011\u001a\u00020\u0012X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0014\u0010\u0017\u001a\u00020\u0018X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0014\u0010\u001b\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0014\u0010\u001f\u001a\u00020\u001c8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b \u0010\u001eR\u001d\u0010\n\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u001d\u0010\u0006\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\b0\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\"R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0014\u0010(\u001a\u00020)X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0014\u0010,\u001a\u00020-X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Landroidx/ui/text/platform/AndroidParagraphIntrinsics;", "Landroidx/ui/text/ParagraphIntrinsics;", "text", "", "style", "Landroidx/ui/text/TextStyle;", "spanStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/SpanStyle;", "placeholders", "Landroidx/ui/text/Placeholder;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "density", "Landroidx/ui/unit/Density;", "(Ljava/lang/String;Landroidx/ui/text/TextStyle;Ljava/util/List;Ljava/util/List;Landroidx/ui/text/platform/TypefaceAdapter;Landroidx/ui/unit/Density;)V", "charSequence", "", "getCharSequence$ui_text_core_release", "()Ljava/lang/CharSequence;", "getDensity", "()Landroidx/ui/unit/Density;", "layoutIntrinsics", "Landroidx/ui/text/platform/LayoutIntrinsics;", "getLayoutIntrinsics$ui_text_core_release", "()Landroidx/ui/text/platform/LayoutIntrinsics;", "maxIntrinsicWidth", "", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "getPlaceholders", "()Ljava/util/List;", "getSpanStyles", "getStyle", "()Landroidx/ui/text/TextStyle;", "getText", "()Ljava/lang/String;", "textDirectionHeuristic", "", "getTextDirectionHeuristic$ui_text_core_release", "()I", "textPaint", "Landroid/text/TextPaint;", "getTextPaint$ui_text_core_release", "()Landroid/text/TextPaint;", "getTypefaceAdapter", "()Landroidx/ui/text/platform/TypefaceAdapter;", "ui-text-core_release"})
public final class AndroidParagraphIntrinsics
implements ParagraphIntrinsics {
    private final String text;
    private final TextStyle style;
    private final List<AnnotatedString.Item<SpanStyle>> spanStyles;
    private final List<AnnotatedString.Item<Placeholder>> placeholders;
    private final TypefaceAdapter typefaceAdapter;
    private final Density density;
    private final TextPaint textPaint;
    private final CharSequence charSequence;
    private final LayoutIntrinsics layoutIntrinsics;
    private final int textDirectionHeuristic;

    public AndroidParagraphIntrinsics(@NotNull String text, @NotNull TextStyle style, @NotNull List<AnnotatedString.Item<SpanStyle>> spanStyles, @NotNull List<AnnotatedString.Item<Placeholder>> placeholders, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Integer n;
        Integer n2;
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull(spanStyles, (String)"spanStyles");
        Intrinsics.checkParameterIsNotNull(placeholders, (String)"placeholders");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        this.text = text;
        this.style = style;
        this.spanStyles = spanStyles;
        this.placeholders = placeholders;
        this.typefaceAdapter = typefaceAdapter;
        this.density = density;
        this.textPaint = new TextPaint(1);
        AndroidParagraphIntrinsics androidParagraphIntrinsics = this;
        TextDirectionAlgorithm textDirectionAlgorithm = this.getStyle().getTextDirectionAlgorithm();
        if (textDirectionAlgorithm == null) {
            n2 = null;
        } else {
            TextDirectionAlgorithm textDirectionAlgorithm2 = textDirectionAlgorithm;
            AndroidParagraphIntrinsics androidParagraphIntrinsics2 = androidParagraphIntrinsics;
            boolean bl = false;
            boolean bl2 = false;
            TextDirectionAlgorithm it = textDirectionAlgorithm2;
            int n3 = AndroidParagraphHelperKt.resolveTextDirectionHeuristics(this.getStyle().getTextDirectionAlgorithm());
            androidParagraphIntrinsics = androidParagraphIntrinsics2;
            n2 = n = Integer.valueOf(n3);
        }
        if (n == null) {
            throw new IllegalArgumentException("TextStyle.textDirectionAlgorithm should not be null");
        }
        androidParagraphIntrinsics.textDirectionHeuristic = n;
        SpanStyle notAppliedStyle = AndroidParagraphHelperKt.applySpanStyle(this.getTextPaint$ui_text_core_release(), this.getStyle().toSpanStyle(), this.getTypefaceAdapter(), this.getDensity());
        this.charSequence = AndroidParagraphHelperKt.createStyledText(this.getText(), this.getTextPaint$ui_text_core_release().getTextSize(), this.getStyle().getLineHeight(), this.getStyle().getTextIndent(), CollectionsKt.plus((Collection)CollectionsKt.listOf(new AnnotatedString.Item<SpanStyle>(notAppliedStyle, 0, this.getText().length())), (Iterable)this.getSpanStyles()), this.getPlaceholders(), this.getDensity(), this.getTypefaceAdapter());
        this.layoutIntrinsics = new LayoutIntrinsics(this.getCharSequence$ui_text_core_release(), this.getTextPaint$ui_text_core_release(), this.getTextDirectionHeuristic$ui_text_core_release());
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final List<AnnotatedString.Item<SpanStyle>> getSpanStyles() {
        return this.spanStyles;
    }

    @NotNull
    public final List<AnnotatedString.Item<Placeholder>> getPlaceholders() {
        return this.placeholders;
    }

    @NotNull
    public final TypefaceAdapter getTypefaceAdapter() {
        return this.typefaceAdapter;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final TextPaint getTextPaint$ui_text_core_release() {
        return this.textPaint;
    }

    @NotNull
    public final CharSequence getCharSequence$ui_text_core_release() {
        return this.charSequence;
    }

    @NotNull
    public final LayoutIntrinsics getLayoutIntrinsics$ui_text_core_release() {
        return this.layoutIntrinsics;
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.getLayoutIntrinsics$ui_text_core_release().getMaxIntrinsicWidth();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.getLayoutIntrinsics$ui_text_core_release().getMinIntrinsicWidth();
    }

    public final int getTextDirectionHeuristic$ui_text_core_release() {
        return this.textDirectionHeuristic;
    }
}

