/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.annotation.RestrictTo;
import androidx.ui.input.EditOperation;
import androidx.ui.input.EditingBuffer;
import java.text.BreakIterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\t\u0010\u0007\u001a\u00020\u0003H\u00c6\u0003J\u0013\u0010\b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\fH\u00d6\u0003J\t\u0010\r\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0016J\t\u0010\u0012\u001a\u00020\u0013H\u00d6\u0001R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0014"}, d2={"Landroidx/ui/input/MoveCursorEditOp;", "Landroidx/ui/input/EditOperation;", "amount", "", "(I)V", "getAmount", "()I", "component1", "copy", "equals", "", "other", "", "hashCode", "process", "", "buffer", "Landroidx/ui/input/EditingBuffer;", "toString", "", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class MoveCursorEditOp
implements EditOperation {
    private final int amount;

    /*
     * WARNING - void declaration
     */
    @Override
    public void process(@NotNull EditingBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        BreakIterator it = BreakIterator.getCharacterInstance();
        it.setText(buffer.toString());
        if (buffer.getCursor() == -1) {
            buffer.setCursor(buffer.getSelectionStart());
        }
        int newCursor = buffer.getSelectionStart();
        if (this.amount > 0) {
            int next;
            int n = 0;
            int n2 = this.amount;
            while (n < n2 && (next = it.following(newCursor)) != -1) {
                void i;
                newCursor = next;
                ++i;
            }
        } else {
            int prev;
            int n = -this.amount;
            for (int i = 0; i < n && (prev = it.preceding(newCursor)) != -1; ++i) {
                newCursor = prev;
            }
        }
        buffer.setCursor(newCursor);
    }

    public final int getAmount() {
        return this.amount;
    }

    public MoveCursorEditOp(int amount) {
        this.amount = amount;
    }

    public final int component1() {
        return this.amount;
    }

    @NotNull
    public final MoveCursorEditOp copy(int amount) {
        return new MoveCursorEditOp(amount);
    }

    public static /* synthetic */ MoveCursorEditOp copy$default(MoveCursorEditOp moveCursorEditOp, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = moveCursorEditOp.amount;
        }
        return moveCursorEditOp.copy(n);
    }

    @NotNull
    public String toString() {
        return "MoveCursorEditOp(amount=" + this.amount + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.amount);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof MoveCursorEditOp)) break block3;
                MoveCursorEditOp moveCursorEditOp = (MoveCursorEditOp)object;
                if (!(this.amount == moveCursorEditOp.amount)) break block3;
            }
            return true;
        }
        return false;
    }
}

