/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.text.LocaleList;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.StringKt;
import androidx.ui.text.TextStyle;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.functions.Function3;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001:\u0001(B9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nJ\u0010\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u0012J0\u0010\u0013\u001a\u00020\u0014\"\u0004\b\u0000\u0010\u00152\u0012\u0010\u0016\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u0002H\u00150\u00060\u00052\f\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u0018H\u0002J\t\u0010\u001a\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u001b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u00c6\u0003J\u0015\u0010\u001c\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005H\u00c6\u0003J?\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005H\u00c6\u0001J\u0010\u0010\u001e\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\u0013\u0010\u001f\u001a\u00020 2\b\u0010!\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\"\u001a\u00020\u0019H\u00d6\u0001J\u0010\u0010#\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u0012J\t\u0010$\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010%\u001a\u00020\u00002\b\b\u0002\u0010\u0011\u001a\u00020\u0012J(\u0010&\u001a\u00020\u00002\u001e\u0010&\u001a\u001a\u0012\u0004\u0012\u00020\u0003\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u0019\u0012\u0004\u0012\u00020\u00030'H\u0002R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006)"}, d2={"Landroidx/ui/text/AnnotatedString;", "", "text", "", "textStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/TextStyle;", "paragraphStyles", "Landroidx/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getParagraphStyles", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "getTextStyles", "capitalize", "localeList", "Landroidx/ui/text/LocaleList;", "collectItemTransitions", "", "T", "items", "target", "Ljava/util/SortedSet;", "", "component1", "component2", "component3", "copy", "decapitalize", "equals", "", "other", "hashCode", "toLowerCase", "toString", "toUpperCase", "transform", "Lkotlin/Function3;", "Item", "ui-text_release"})
public final class AnnotatedString {
    @NotNull
    private final String text;
    @NotNull
    private final List<Item<TextStyle>> textStyles;
    @NotNull
    private final List<Item<ParagraphStyle>> paragraphStyles;

    @NotNull
    public final AnnotatedString toUpperCase(@NotNull LocaleList localeList) {
        Intrinsics.checkParameterIsNotNull((Object)localeList, (String)"localeList");
        return this.transform((Function3<? super String, ? super Integer, ? super Integer, String>)((Function3)new Function3<String, Integer, Integer, String>(localeList){
            final /* synthetic */ LocaleList $localeList;

            @NotNull
            public final String invoke(@NotNull String str, int start, int end) {
                Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
                String string = str;
                boolean bl = false;
                String string2 = string.substring(start, end);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return StringKt.toUpperCase(string2, this.$localeList);
            }
            {
                this.$localeList = localeList;
                super(3);
            }
        }));
    }

    public static /* synthetic */ AnnotatedString toUpperCase$default(AnnotatedString annotatedString, LocaleList localeList, int n, Object object) {
        if ((n & 1) != 0) {
            localeList = LocaleList.Companion.getCurrent();
        }
        return annotatedString.toUpperCase(localeList);
    }

    @NotNull
    public final AnnotatedString toLowerCase(@NotNull LocaleList localeList) {
        Intrinsics.checkParameterIsNotNull((Object)localeList, (String)"localeList");
        return this.transform((Function3<? super String, ? super Integer, ? super Integer, String>)((Function3)new Function3<String, Integer, Integer, String>(localeList){
            final /* synthetic */ LocaleList $localeList;

            @NotNull
            public final String invoke(@NotNull String str, int start, int end) {
                Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
                String string = str;
                boolean bl = false;
                String string2 = string.substring(start, end);
                Intrinsics.checkExpressionValueIsNotNull((Object)string2, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                return StringKt.toLowerCase(string2, this.$localeList);
            }
            {
                this.$localeList = localeList;
                super(3);
            }
        }));
    }

    public static /* synthetic */ AnnotatedString toLowerCase$default(AnnotatedString annotatedString, LocaleList localeList, int n, Object object) {
        if ((n & 1) != 0) {
            localeList = LocaleList.Companion.getCurrent();
        }
        return annotatedString.toLowerCase(localeList);
    }

    @NotNull
    public final AnnotatedString capitalize(@NotNull LocaleList localeList) {
        Intrinsics.checkParameterIsNotNull((Object)localeList, (String)"localeList");
        return this.transform((Function3<? super String, ? super Integer, ? super Integer, String>)((Function3)new Function3<String, Integer, Integer, String>(localeList){
            final /* synthetic */ LocaleList $localeList;

            @NotNull
            public final String invoke(@NotNull String str, int start, int end) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
                if (start == 0) {
                    String string2 = str;
                    boolean bl = false;
                    String string3 = string2.substring(start, end);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = StringKt.capitalize(string3, this.$localeList);
                } else {
                    String string4 = str;
                    boolean bl = false;
                    String string5 = string4.substring(start, end);
                    string = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                }
                return string;
            }
            {
                this.$localeList = localeList;
                super(3);
            }
        }));
    }

    public static /* synthetic */ AnnotatedString capitalize$default(AnnotatedString annotatedString, LocaleList localeList, int n, Object object) {
        if ((n & 1) != 0) {
            localeList = LocaleList.Companion.getCurrent();
        }
        return annotatedString.capitalize(localeList);
    }

    @NotNull
    public final AnnotatedString decapitalize(@NotNull LocaleList localeList) {
        Intrinsics.checkParameterIsNotNull((Object)localeList, (String)"localeList");
        return this.transform((Function3<? super String, ? super Integer, ? super Integer, String>)((Function3)new Function3<String, Integer, Integer, String>(localeList){
            final /* synthetic */ LocaleList $localeList;

            @NotNull
            public final String invoke(@NotNull String str, int start, int end) {
                String string;
                Intrinsics.checkParameterIsNotNull((Object)str, (String)"str");
                if (start == 0) {
                    String string2 = str;
                    boolean bl = false;
                    String string3 = string2.substring(start, end);
                    Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                    string = StringKt.decapitalize(string3, this.$localeList);
                } else {
                    String string4 = str;
                    boolean bl = false;
                    String string5 = string4.substring(start, end);
                    string = string5;
                    Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
                }
                return string;
            }
            {
                this.$localeList = localeList;
                super(3);
            }
        }));
    }

    public static /* synthetic */ AnnotatedString decapitalize$default(AnnotatedString annotatedString, LocaleList localeList, int n, Object object) {
        if ((n & 1) != 0) {
            localeList = LocaleList.Companion.getCurrent();
        }
        return annotatedString.decapitalize(localeList);
    }

    /*
     * WARNING - void declaration
     */
    private final AnnotatedString transform(Function3<? super String, ? super Integer, ? super Integer, String> transform2) {
        void resultStr;
        TreeSet transitions = SetsKt.sortedSetOf((Object[])new Integer[0]);
        this.collectItemTransitions(this.textStyles, transitions);
        this.collectItemTransitions(this.paragraphStyles, transitions);
        Ref.ObjectRef objectRef = new Ref.ObjectRef();
        objectRef.element = "";
        Map offsetMap = MapsKt.mutableMapOf((Pair[])new Pair[]{TuplesKt.to((Object)0, (Object)0)});
        CollectionsKt.windowed$default((Iterable)transitions, (int)2, (int)0, (boolean)false, (Function1)((Function1)new Function1<List<? extends Integer>, Integer>(this, (Ref.ObjectRef)resultStr, transform2, offsetMap){
            final /* synthetic */ AnnotatedString this$0;
            final /* synthetic */ Ref.ObjectRef $resultStr;
            final /* synthetic */ Function3 $transform;
            final /* synthetic */ Map $offsetMap;

            @Nullable
            public final Integer invoke(@NotNull List<Integer> $dstr$start$end) {
                Intrinsics.checkParameterIsNotNull($dstr$start$end, (String)"<name for destructuring parameter 0>");
                List<Integer> list = $dstr$start$end;
                boolean bl = false;
                int start = ((Number)list.get(0)).intValue();
                list = $dstr$start$end;
                bl = false;
                int end = ((Number)list.get(1)).intValue();
                this.$resultStr.element = (String)this.$resultStr.element + (String)this.$transform.invoke((Object)this.this$0.getText(), (Object)start, (Object)end);
                return this.$offsetMap.put(end, ((String)this.$resultStr.element).length());
            }
            {
                this.this$0 = annotatedString;
                this.$resultStr = objectRef;
                this.$transform = function3;
                this.$offsetMap = map;
                super(1);
            }
        }), (int)6, null);
        boolean bl = false;
        List newTextStyles = new ArrayList();
        boolean bl2 = false;
        List newParaStyles = new ArrayList();
        for (Item<TextStyle> item : this.textStyles) {
            TextStyle textStyle = item.getStyle();
            Object v = offsetMap.get(item.getStart());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            int n = ((Number)v).intValue();
            Object v2 = offsetMap.get(item.getEnd());
            if (v2 == null) {
                Intrinsics.throwNpe();
            }
            newTextStyles.add(new Item<TextStyle>(textStyle, n, ((Number)v2).intValue()));
        }
        for (Item<Object> item : this.paragraphStyles) {
            Object object = item.getStyle();
            Object v = offsetMap.get(item.getStart());
            if (v == null) {
                Intrinsics.throwNpe();
            }
            int n = ((Number)v).intValue();
            Object v3 = offsetMap.get(item.getEnd());
            if (v3 == null) {
                Intrinsics.throwNpe();
            }
            newParaStyles.add(new Item<Object>(object, n, ((Number)v3).intValue()));
        }
        return new AnnotatedString((String)resultStr.element, newTextStyles, newParaStyles);
    }

    /*
     * WARNING - void declaration
     */
    private final <T> void collectItemTransitions(List<Item<T>> items, SortedSet<Integer> target) {
        Iterable $this$fold$iv = items;
        boolean $i$f$fold = false;
        SortedSet<Integer> accumulator$iv = target;
        for (Object element$iv : $this$fold$iv) {
            void item;
            Item item2 = (Item)element$iv;
            SortedSet<Integer> acc = accumulator$iv;
            boolean bl = false;
            SortedSet<Integer> sortedSet = acc;
            boolean bl2 = false;
            boolean bl3 = false;
            SortedSet<Integer> $this$apply = sortedSet;
            boolean bl4 = false;
            $this$apply.add(item.getStart());
            $this$apply.add(item.getEnd());
            accumulator$iv = sortedSet;
        }
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<Item<TextStyle>> getTextStyles() {
        return this.textStyles;
    }

    @NotNull
    public final List<Item<ParagraphStyle>> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public AnnotatedString(@NotNull String text, @NotNull List<Item<TextStyle>> textStyles, @NotNull List<Item<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
        Intrinsics.checkParameterIsNotNull(paragraphStyles, (String)"paragraphStyles");
        this.text = text;
        this.textStyles = textStyles;
        this.paragraphStyles = paragraphStyles;
        int lastStyleEnd = -1;
        for (Item<ParagraphStyle> paragraphStyle : this.paragraphStyles) {
            if (paragraphStyle.getStart() < lastStyleEnd) {
                throw (Throwable)new IllegalArgumentException("ParagraphStyle should not overlap");
            }
            if (paragraphStyle.getEnd() > this.text.length()) {
                throw (Throwable)new IllegalArgumentException("ParagraphStyle range " + '[' + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ") is out of boundary");
            }
            lastStyleEnd = paragraphStyle.getEnd();
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 2) != 0) {
            bl = false;
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
            list2 = CollectionsKt.emptyList();
        }
        this(string, list, list2);
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final List<Item<TextStyle>> component2() {
        return this.textStyles;
    }

    @NotNull
    public final List<Item<ParagraphStyle>> component3() {
        return this.paragraphStyles;
    }

    @NotNull
    public final AnnotatedString copy(@NotNull String text, @NotNull List<Item<TextStyle>> textStyles, @NotNull List<Item<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
        Intrinsics.checkParameterIsNotNull(paragraphStyles, (String)"paragraphStyles");
        return new AnnotatedString(text, textStyles, paragraphStyles);
    }

    public static /* synthetic */ AnnotatedString copy$default(AnnotatedString annotatedString, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = annotatedString.text;
        }
        if ((n & 2) != 0) {
            list = annotatedString.textStyles;
        }
        if ((n & 4) != 0) {
            list2 = annotatedString.paragraphStyles;
        }
        return annotatedString.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "AnnotatedString(text=" + this.text + ", textStyles=" + this.textStyles + ", paragraphStyles=" + this.paragraphStyles + ")";
    }

    public int hashCode() {
        String string = this.text;
        List<Item<TextStyle>> list = this.textStyles;
        List<Item<ParagraphStyle>> list2 = this.paragraphStyles;
        return ((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AnnotatedString)) break block3;
                AnnotatedString annotatedString = (AnnotatedString)object;
                if (!Intrinsics.areEqual((Object)this.text, (Object)annotatedString.text) || !Intrinsics.areEqual(this.textStyles, annotatedString.textStyles) || !Intrinsics.areEqual(this.paragraphStyles, annotatedString.paragraphStyles)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Landroidx/ui/text/AnnotatedString$Item;", "T", "", "style", "start", "", "end", "(Ljava/lang/Object;II)V", "getEnd", "()I", "getStart", "getStyle", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;II)Landroidx/ui/text/AnnotatedString$Item;", "equals", "", "other", "hashCode", "toString", "", "ui-text_release"})
    public static final class Item<T> {
        private final T style;
        private final int start;
        private final int end;

        public final T getStyle() {
            return this.style;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public Item(T style, int start, int end) {
            this.style = style;
            this.start = start;
            this.end = end;
            if (this.start > this.end) {
                throw (Throwable)new IllegalArgumentException("Reversed range is not supported");
            }
        }

        public final T component1() {
            return this.style;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final Item<T> copy(T style, int start, int end) {
            return new Item<T>(style, start, end);
        }

        public static /* synthetic */ Item copy$default(Item item, Object object, int n, int n2, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = item.style;
            }
            if ((n3 & 2) != 0) {
                n = item.start;
            }
            if ((n3 & 4) != 0) {
                n2 = item.end;
            }
            return item.copy(object, n, n2);
        }

        @NotNull
        public String toString() {
            return "Item(style=" + this.style + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            T t = this.style;
            return ((t != null ? t.hashCode() : 0) * 31 + Integer.hashCode(this.start)) * 31 + Integer.hashCode(this.end);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Item)) break block3;
                    Item item = (Item)object;
                    if (!Intrinsics.areEqual(this.style, item.style) || !(this.start == item.start) || !(this.end == item.end)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

