/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.text.AnnotatedString;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u001a(\u0010\u0000\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00030\u00020\u0001*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u001aa\u0010\b\u001a\b\u0012\u0004\u0012\u0002H\t0\u0001\"\u0004\b\u0000\u0010\t*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2>\b\u0004\u0010\f\u001a8\u0012\u0013\u0012\u00110\u0004\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0010\u0012\u0019\u0012\u0017\u0012\u0004\u0012\u00020\u000b0\u0002\u00a2\u0006\f\b\u000e\u0012\b\b\u000f\u0012\u0004\b\b(\u0011\u0012\u0004\u0012\u0002H\t0\rH\u0080\b\u001a \u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\u00020\u0001*\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0000\u001a\u001c\u0010\u0013\u001a\u00020\u0004*\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a8\u0006\u0014"}, d2={"getLocalStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/TextStyle;", "Landroidx/ui/text/AnnotatedString;", "start", "", "end", "mapEachParagraphStyle", "T", "defaultParagraphStyle", "Landroidx/ui/text/ParagraphStyle;", "block", "Lkotlin/Function2;", "Lkotlin/ParameterName;", "name", "annotatedString", "paragraphStyle", "normalizedParagraphStyles", "substringWithoutParagraphStyles", "ui-text_release"})
public final class AnnotatedStringKt {
    @NotNull
    public static final List<AnnotatedString.Item<ParagraphStyle>> normalizedParagraphStyles(@NotNull AnnotatedString $this$normalizedParagraphStyles, @NotNull ParagraphStyle defaultParagraphStyle) {
        Intrinsics.checkParameterIsNotNull((Object)$this$normalizedParagraphStyles, (String)"$this$normalizedParagraphStyles");
        Intrinsics.checkParameterIsNotNull((Object)defaultParagraphStyle, (String)"defaultParagraphStyle");
        int length = $this$normalizedParagraphStyles.getText().length();
        List<AnnotatedString.Item<ParagraphStyle>> paragraphStyles = $this$normalizedParagraphStyles.getParagraphStyles();
        int lastOffset = 0;
        boolean bl = false;
        List result = new ArrayList();
        for (AnnotatedString.Item<ParagraphStyle> item : paragraphStyles) {
            ParagraphStyle style = item.component1();
            int start = item.component2();
            int end = item.component3();
            if (start != lastOffset) {
                result.add(new AnnotatedString.Item<ParagraphStyle>(defaultParagraphStyle, lastOffset, start));
            }
            result.add(new AnnotatedString.Item<ParagraphStyle>(defaultParagraphStyle.merge(style), start, end));
            lastOffset = end;
        }
        if (lastOffset != length) {
            result.add(new AnnotatedString.Item<ParagraphStyle>(defaultParagraphStyle, lastOffset, length));
        }
        if (result.isEmpty()) {
            result.add(new AnnotatedString.Item<ParagraphStyle>(defaultParagraphStyle, 0, 0));
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private static final List<AnnotatedString.Item<TextStyle>> getLocalStyles(@NotNull AnnotatedString $this$getLocalStyles, int start, int end) {
        void $this$mapTo$iv$iv;
        AnnotatedString.Item it;
        Iterable $this$filterTo$iv$iv;
        if (start == end) {
            boolean bl = false;
            return CollectionsKt.emptyList();
        }
        if (start == 0 && end >= $this$getLocalStyles.getText().length()) {
            return $this$getLocalStyles.getTextStyles();
        }
        Iterable $this$filter$iv = $this$getLocalStyles.getTextStyles();
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (AnnotatedString.Item)element$iv$iv;
            boolean bl = false;
            if (!(it.getStart() < end && it.getEnd() > start)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (AnnotatedString.Item)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotatedString.Item item = new AnnotatedString.Item(it.getStyle(), RangesKt.coerceIn((int)it.getStart(), (int)start, (int)end) - start, RangesKt.coerceIn((int)it.getEnd(), (int)start, (int)end) - start);
            collection.add(item);
        }
        return (List)destination$iv$iv;
    }

    private static final AnnotatedString substringWithoutParagraphStyles(@NotNull AnnotatedString $this$substringWithoutParagraphStyles, int start, int end) {
        String string;
        if (start != end) {
            String string2;
            String string3 = $this$substringWithoutParagraphStyles.getText();
            boolean bl = false;
            String string4 = string3;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(start, end);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
            string = string2 = string5;
        } else {
            string = "";
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 4;
        List list = null;
        List<AnnotatedString.Item<TextStyle>> list2 = AnnotatedStringKt.getLocalStyles($this$substringWithoutParagraphStyles, start, end);
        String string6 = string;
        return new AnnotatedString(string6, list2, list, n, defaultConstructorMarker);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final <T> List<T> mapEachParagraphStyle(@NotNull AnnotatedString $this$mapEachParagraphStyle, @NotNull ParagraphStyle defaultParagraphStyle, @NotNull Function2<? super AnnotatedString, ? super AnnotatedString.Item<ParagraphStyle>, ? extends T> block) {
        void $this$mapTo$iv$iv;
        int $i$f$mapEachParagraphStyle = 0;
        Intrinsics.checkParameterIsNotNull((Object)$this$mapEachParagraphStyle, (String)"$this$mapEachParagraphStyle");
        Intrinsics.checkParameterIsNotNull((Object)defaultParagraphStyle, (String)"defaultParagraphStyle");
        Intrinsics.checkParameterIsNotNull(block, (String)"block");
        Iterable $this$map$iv = AnnotatedStringKt.normalizedParagraphStyles($this$mapEachParagraphStyle, defaultParagraphStyle);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void paragraphStyleItem;
            AnnotatedString.Item item = (AnnotatedString.Item)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            AnnotatedString annotatedString = AnnotatedStringKt.substringWithoutParagraphStyles($this$mapEachParagraphStyle, paragraphStyleItem.getStart(), paragraphStyleItem.getEnd());
            Object object = block.invoke((Object)annotatedString, (Object)paragraphStyleItem);
            collection.add(object);
        }
        return (List)destination$iv$iv;
    }
}

