/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.MathHelpersKt;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.text.style.TextDirection;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0080\b\u0018\u0000 \"2\u00020\u0001:\u0001\"B-\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\u0006\u0010\u0006\u001a\u00020\u0003\u0012\u0006\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0011\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0013\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J;\u0010\u0016\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00032\b\b\u0002\u0010\u0005\u001a\u00020\u00032\b\b\u0002\u0010\u0006\u001a\u00020\u00032\b\b\u0002\u0010\u0007\u001a\u00020\bH\u00c6\u0001J\u0006\u0010\u0017\u001a\u00020\u0003J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\u0006\u0010\u001d\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u001fJ\b\u0010 \u001a\u00020!H\u0016R\u0011\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0011\u0010\u0007\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u000b\u00a8\u0006#"}, d2={"Landroidx/ui/text/TextBox;", "", "left", "", "top", "right", "bottom", "direction", "Landroidx/ui/text/style/TextDirection;", "(FFFFLandroidx/ui/text/style/TextDirection;)V", "getBottom", "()F", "getDirection", "()Landroidx/ui/text/style/TextDirection;", "getLeft", "getRight", "getTop", "component1", "component2", "component3", "component4", "component5", "copy", "end", "equals", "", "other", "hashCode", "", "start", "toRect", "Landroidx/ui/engine/geometry/Rect;", "toString", "", "Companion", "ui-text_release"})
public final class TextBox {
    private final float left;
    private final float top;
    private final float right;
    private final float bottom;
    @NotNull
    private final TextDirection direction;
    public static final Companion Companion = new Companion(null);

    @NotNull
    public final Rect toRect() {
        return Rect.Companion.fromLTRB(this.left, this.top, this.right, this.bottom);
    }

    public final float start() {
        return this.direction == TextDirection.Ltr ? this.left : this.right;
    }

    public final float end() {
        return this.direction == TextDirection.Ltr ? this.right : this.left;
    }

    @NotNull
    public String toString() {
        return "TextBox.fromLTRBD(" + MathHelpersKt.toStringAsFixed((float)this.left, (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.top, (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.right, (int)1) + ", " + MathHelpersKt.toStringAsFixed((float)this.bottom, (int)1) + ", " + this.direction + ')';
    }

    public final float getLeft() {
        return this.left;
    }

    public final float getTop() {
        return this.top;
    }

    public final float getRight() {
        return this.right;
    }

    public final float getBottom() {
        return this.bottom;
    }

    @NotNull
    public final TextDirection getDirection() {
        return this.direction;
    }

    public TextBox(float left, float top, float right, float bottom, @NotNull TextDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        this.left = left;
        this.top = top;
        this.right = right;
        this.bottom = bottom;
        this.direction = direction;
    }

    public final float component1() {
        return this.left;
    }

    public final float component2() {
        return this.top;
    }

    public final float component3() {
        return this.right;
    }

    public final float component4() {
        return this.bottom;
    }

    @NotNull
    public final TextDirection component5() {
        return this.direction;
    }

    @NotNull
    public final TextBox copy(float left, float top, float right, float bottom, @NotNull TextDirection direction) {
        Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
        return new TextBox(left, top, right, bottom, direction);
    }

    public static /* synthetic */ TextBox copy$default(TextBox textBox, float f, float f2, float f3, float f4, TextDirection textDirection, int n, Object object) {
        if ((n & 1) != 0) {
            f = textBox.left;
        }
        if ((n & 2) != 0) {
            f2 = textBox.top;
        }
        if ((n & 4) != 0) {
            f3 = textBox.right;
        }
        if ((n & 8) != 0) {
            f4 = textBox.bottom;
        }
        if ((n & 0x10) != 0) {
            textDirection = textBox.direction;
        }
        return textBox.copy(f, f2, f3, f4, textDirection);
    }

    public int hashCode() {
        TextDirection textDirection = this.direction;
        return (((Float.hashCode(this.left) * 31 + Float.hashCode(this.top)) * 31 + Float.hashCode(this.right)) * 31 + Float.hashCode(this.bottom)) * 31 + (textDirection != null ? textDirection.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof TextBox)) break block3;
                TextBox textBox = (TextBox)object;
                if (Float.compare(this.left, textBox.left) != 0 || Float.compare(this.top, textBox.top) != 0 || Float.compare(this.right, textBox.right) != 0 || Float.compare(this.bottom, textBox.bottom) != 0 || !Intrinsics.areEqual((Object)this.direction, (Object)textBox.direction)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J.\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\b\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\u00062\u0006\u0010\n\u001a\u00020\u000b\u00a8\u0006\f"}, d2={"Landroidx/ui/text/TextBox$Companion;", "", "()V", "fromLTRBD", "Landroidx/ui/text/TextBox;", "left", "", "top", "right", "bottom", "direction", "Landroidx/ui/text/style/TextDirection;", "ui-text_release"})
    public static final class Companion {
        @NotNull
        public final TextBox fromLTRBD(float left, float top, float right, float bottom, @NotNull TextDirection direction) {
            Intrinsics.checkParameterIsNotNull((Object)direction, (String)"direction");
            return new TextBox(left, top, right, bottom, direction);
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

