/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.VisibleForTesting;
import androidx.ui.core.Density;
import androidx.ui.core.LayoutDirection;
import androidx.ui.core.Sp;
import androidx.ui.engine.geometry.Offset;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Shader;
import androidx.ui.graphics.ShaderKt;
import androidx.ui.text.Paragraph;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.ParagraphKt;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextDelegate;
import androidx.ui.text.TextDelegateKt$WhenMappings;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextOverflow;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=2, d1={"\u0000.\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u0012\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\bH\u0002\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"DefaultFontSize", "Landroidx/ui/core/Sp;", "resolveTextDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "textDirectionAlgorithm", "resolveTextStyle", "Landroidx/ui/text/TextStyle;", "style", "createOverflowShader", "Landroidx/ui/graphics/Shader;", "Landroidx/ui/text/TextDelegate;", "layoutResult", "Landroidx/ui/text/TextDelegate$LayoutResult;", "ui-text_release"})
public final class TextDelegateKt {
    private static final Sp DefaultFontSize;

    private static final TextStyle resolveTextStyle(TextStyle style) {
        return style == null ? new TextStyle(null, DefaultFontSize, null, null, null, null, null, null, null, null, null, null, null, null, null, 32765, null) : (style.getFontSize() == null ? TextStyle.copy$default(style, null, DefaultFontSize, null, null, null, null, null, null, null, null, null, null, null, null, null, 32765, null) : style);
    }

    /*
     * WARNING - void declaration
     */
    private static final Shader createOverflowShader(@NotNull TextDelegate $this$createOverflowShader, TextDelegate.LayoutResult layoutResult) {
        Shader shader;
        if (layoutResult.getHasVisualOverflow() && $this$createOverflowShader.getOverflow() == TextOverflow.Fade) {
            ParagraphStyle paragraphStyle = $this$createOverflowShader.getParagraphStyle();
            TextStyle textStyle = $this$createOverflowShader.getTextStyle();
            String string = "\u2026";
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            ParagraphConstraints paragraphConstraints = new ParagraphConstraints(FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
            Font.ResourceLoader resourceLoader = $this$createOverflowShader.getResourceLoader();
            Density density = $this$createOverflowShader.getDensity();
            Paragraph paragraph = ParagraphKt.Paragraph$default(string, textStyle, paragraphStyle, list, null, null, paragraphConstraints, density, resourceLoader, 48, null);
            float fadeWidth = paragraph.getMaxIntrinsicWidth();
            float fadeHeight = paragraph.getHeight();
            if (layoutResult.getDidOverflowWidth()) {
                void fadeStart;
                Pair pair = $this$createOverflowShader.getLayoutDirection() == LayoutDirection.Rtl ? new Pair((Object)Float.valueOf(fadeWidth), (Object)Float.valueOf(0.0f)) : new Pair((Object)Float.valueOf(layoutResult.getSize().getWidth() - fadeWidth), (Object)Float.valueOf(layoutResult.getSize().getWidth()));
                float f = ((Number)pair.component1()).floatValue();
                float fadeEnd = ((Number)pair.component2()).floatValue();
                shader = ShaderKt.LinearGradientShader$default((Offset)new Offset((float)fadeStart, 0.0f), (Offset)new Offset(fadeEnd, 0.0f), (List)CollectionsKt.listOf((Object[])new Color[]{ColorKt.Color((long)0xFFFFFFFFL), ColorKt.Color((int)0xFFFFFF)}), null, null, (int)24, null);
            } else {
                float fadeEnd = layoutResult.getSize().getHeight();
                float fadeStart = fadeEnd - fadeHeight;
                shader = ShaderKt.LinearGradientShader$default((Offset)new Offset(0.0f, fadeStart), (Offset)new Offset(0.0f, fadeEnd), (List)CollectionsKt.listOf((Object[])new Color[]{ColorKt.Color((long)0xFFFFFFFFL), ColorKt.Color((int)0xFFFFFF)}), null, null, (int)24, null);
            }
        } else {
            shader = null;
        }
        return shader;
    }

    @VisibleForTesting
    @NotNull
    public static final TextDirectionAlgorithm resolveTextDirectionAlgorithm(@NotNull LayoutDirection layoutDirection, @Nullable TextDirectionAlgorithm textDirectionAlgorithm) {
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        TextDirectionAlgorithm textDirectionAlgorithm2 = textDirectionAlgorithm;
        if (textDirectionAlgorithm2 == null) {
            switch (TextDelegateKt$WhenMappings.$EnumSwitchMapping$0[layoutDirection.ordinal()]) {
                case 1: {
                    textDirectionAlgorithm2 = TextDirectionAlgorithm.ContentOrLtr;
                    break;
                }
                case 2: {
                    textDirectionAlgorithm2 = TextDirectionAlgorithm.ContentOrRtl;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        }
        return textDirectionAlgorithm2;
    }

    static {
        int $this$sp$iv = 14;
        DefaultFontSize = new Sp((float)$this$sp$iv);
    }

    public static final /* synthetic */ Shader access$createOverflowShader(TextDelegate $this$access_u24createOverflowShader, TextDelegate.LayoutResult layoutResult) {
        return TextDelegateKt.createOverflowShader($this$access_u24createOverflowShader, layoutResult);
    }

    public static final /* synthetic */ TextStyle access$resolveTextStyle(TextStyle style) {
        return TextDelegateKt.resolveTextStyle(style);
    }
}

