/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.font;

import androidx.ui.text.font.Font;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.function.UnaryOperator;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin._Assertions;
import kotlin.collections.ArraysKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.CollectionToArray;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.markers.KMappedMarker;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0005\n\u0002\u0010\u0011\n\u0002\b\u0007\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0006\n\u0002\u0010(\n\u0002\b\u0002\n\u0002\u0010*\n\u0002\b\u0005\b\u0086\b\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u000f\b\u0016\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0005B\u000f\b\u0016\u0012\u0006\u0010\u0006\u001a\u00020\u0002\u00a2\u0006\u0002\u0010\u0007B\u0015\b\u0016\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\tB\u001b\b\u0016\u0012\u0012\u0010\b\u001a\n\u0012\u0006\b\u0001\u0012\u00020\u00020\n\"\u00020\u0002\u00a2\u0006\u0002\u0010\u000bB\u001f\b\u0002\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\u0002\u0010\fJ\u000b\u0010\u0015\u001a\u0004\u0018\u00010\u0004H\u00c6\u0003J\u000f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u00c6\u0003J\u0011\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0003J\u0017\u0010\u001a\u001a\u00020\u00182\f\u0010\u001b\u001a\b\u0012\u0004\u0012\u00020\u00020\u001cH\u0096\u0001J%\u0010\u001d\u001a\u00020\u00002\n\b\u0002\u0010\u0003\u001a\u0004\u0018\u00010\u00042\u000e\b\u0002\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u00182\b\u0010\u001f\u001a\u0004\u0018\u00010 H\u00d6\u0003J\u0011\u0010!\u001a\u00020\u00022\u0006\u0010\"\u001a\u00020\u0012H\u0096\u0003J\t\u0010#\u001a\u00020\u0012H\u00d6\u0001J\u0011\u0010$\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0001J\t\u0010%\u001a\u00020\u0018H\u0096\u0001J\u000f\u0010&\u001a\b\u0012\u0004\u0012\u00020\u00020'H\u0096\u0003J\u0011\u0010(\u001a\u00020\u00122\u0006\u0010\u0019\u001a\u00020\u0002H\u0096\u0001J\u000f\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*H\u0096\u0001J\u0017\u0010)\u001a\b\u0012\u0004\u0012\u00020\u00020*2\u0006\u0010\"\u001a\u00020\u0012H\u0096\u0001J\u001f\u0010+\u001a\b\u0012\u0004\u0012\u00020\u00020\u00012\u0006\u0010,\u001a\u00020\u00122\u0006\u0010-\u001a\u00020\u0012H\u0096\u0001J\t\u0010.\u001a\u00020\u0004H\u00d6\u0001R\u0017\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0013\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0012\u0010\u0011\u001a\u00020\u0012X\u0096\u0005\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u00a8\u0006/"}, d2={"Landroidx/ui/text/font/FontFamily;", "", "Landroidx/ui/text/font/Font;", "genericFamily", "", "(Ljava/lang/String;)V", "font", "(Landroidx/ui/text/font/Font;)V", "fonts", "(Ljava/util/List;)V", "", "([Landroidx/ui/text/font/Font;)V", "(Ljava/lang/String;Ljava/util/List;)V", "getFonts", "()Ljava/util/List;", "getGenericFamily", "()Ljava/lang/String;", "size", "", "getSize", "()I", "component1", "component2", "contains", "", "element", "containsAll", "elements", "", "copy", "equals", "other", "", "get", "index", "hashCode", "indexOf", "isEmpty", "iterator", "", "lastIndexOf", "listIterator", "", "subList", "fromIndex", "toIndex", "toString", "ui-text_release"})
public final class FontFamily
implements List<Font>,
KMappedMarker {
    @Nullable
    private final String genericFamily;
    @NotNull
    private final List<Font> fonts;

    @Nullable
    public final String getGenericFamily() {
        return this.genericFamily;
    }

    @NotNull
    public final List<Font> getFonts() {
        return this.fonts;
    }

    private FontFamily(String genericFamily, List<Font> fonts) {
        this.genericFamily = genericFamily;
        this.fonts = fonts;
        boolean bl = this.genericFamily != null || this.fonts.size() > 0;
        boolean bl2 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean $i$a$-assert-FontFamily$22 = false;
            String $i$a$-assert-FontFamily$22 = "Either genericFamily or at least one font should be passed to FontFamily";
            throw (Throwable)((Object)new AssertionError((Object)$i$a$-assert-FontFamily$22));
        }
        Iterable $this$distinctBy$iv = this.fonts;
        boolean $i$f$distinctBy = false;
        HashSet<Pair> set$iv = new HashSet<Pair>();
        ArrayList list$iv = new ArrayList();
        for (Object e$iv : $this$distinctBy$iv) {
            Font it = (Font)e$iv;
            boolean bl3 = false;
            Pair key$iv = new Pair((Object)it.getWeight(), (Object)it.getStyle());
            if (!set$iv.add(key$iv)) continue;
            list$iv.add(e$iv);
        }
        boolean bl4 = ((List)list$iv).size() == this.fonts.size();
        bl2 = false;
        if (_Assertions.ENABLED && !bl4) {
            boolean bl5 = false;
            String string = "There cannot be two fonts with the same FontWeight and FontStyle in the same FontFamily";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public FontFamily(@NotNull String genericFamily) {
        Intrinsics.checkParameterIsNotNull((Object)genericFamily, (String)"genericFamily");
        String string = genericFamily;
        FontFamily fontFamily = this;
        boolean bl = false;
        List list = CollectionsKt.emptyList();
        fontFamily(string, list);
    }

    public FontFamily(@NotNull Font font) {
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        this(null, CollectionsKt.listOf((Object)font));
    }

    public FontFamily(@NotNull List<Font> fonts) {
        Intrinsics.checkParameterIsNotNull(fonts, (String)"fonts");
        this(null, fonts);
    }

    public FontFamily(Font ... fonts) {
        Intrinsics.checkParameterIsNotNull((Object)fonts, (String)"fonts");
        this(null, ArraysKt.asList((Object[])fonts));
    }

    public int getSize() {
        return this.fonts.size();
    }

    public boolean contains(@NotNull Font element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.fonts.contains(element);
    }

    @Override
    public boolean containsAll(@NotNull Collection<? extends Object> elements) {
        Intrinsics.checkParameterIsNotNull(elements, (String)"elements");
        return this.fonts.containsAll(elements);
    }

    @Override
    @NotNull
    public Font get(int index) {
        Font font = this.fonts.get(index);
        Intrinsics.checkExpressionValueIsNotNull((Object)font, (String)"get(...)");
        return font;
    }

    public int indexOf(@NotNull Font element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.fonts.indexOf(element);
    }

    @Override
    public boolean isEmpty() {
        return this.fonts.isEmpty();
    }

    @Override
    @NotNull
    public Iterator<Font> iterator() {
        return this.fonts.iterator();
    }

    public int lastIndexOf(@NotNull Font element) {
        Intrinsics.checkParameterIsNotNull((Object)element, (String)"element");
        return this.fonts.lastIndexOf(element);
    }

    @Override
    @NotNull
    public ListIterator<Font> listIterator() {
        return this.fonts.listIterator();
    }

    @Override
    @NotNull
    public ListIterator<Font> listIterator(int index) {
        return this.fonts.listIterator(index);
    }

    @Override
    @NotNull
    public List<Font> subList(int fromIndex, int toIndex) {
        return this.fonts.subList(fromIndex, toIndex);
    }

    @Nullable
    public final String component1() {
        return this.genericFamily;
    }

    @NotNull
    public final List<Font> component2() {
        return this.fonts;
    }

    @NotNull
    public final FontFamily copy(@Nullable String genericFamily, @NotNull List<Font> fonts) {
        Intrinsics.checkParameterIsNotNull(fonts, (String)"fonts");
        return new FontFamily(genericFamily, fonts);
    }

    public static /* synthetic */ FontFamily copy$default(FontFamily fontFamily, String string, List list, int n, Object object) {
        if ((n & 1) != 0) {
            string = fontFamily.genericFamily;
        }
        if ((n & 2) != 0) {
            list = fontFamily.fonts;
        }
        return fontFamily.copy(string, list);
    }

    @NotNull
    public String toString() {
        return "FontFamily(genericFamily=" + this.genericFamily + ", fonts=" + this.fonts + ")";
    }

    @Override
    public int hashCode() {
        String string = this.genericFamily;
        List<Font> list = this.fonts;
        return (string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0);
    }

    @Override
    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FontFamily)) break block3;
                FontFamily fontFamily = (FontFamily)object;
                if (!Intrinsics.areEqual((Object)this.genericFamily, (Object)fontFamily.genericFamily) || !Intrinsics.areEqual(this.fonts, fontFamily.fonts)) break block3;
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean add(Font font) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void add(int n, Font font) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(int n, Collection<? extends Font> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean addAll(Collection<? extends Font> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean remove(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean removeAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Font remove(int n) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void replaceAll(UnaryOperator<Font> unaryOperator) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public boolean retainAll(Collection<? extends Object> collection) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Font set(int n, Font font) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public void sort(Comparator<? super Font> comparator) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ boolean add(Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ void add(int n, Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object remove(int n) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public /* synthetic */ Object set(int n, Object object) {
        throw new UnsupportedOperationException("Operation is not supported for read-only collection");
    }

    @Override
    public Object[] toArray() {
        return CollectionToArray.toArray((Collection)this);
    }

    @Override
    public <T> T[] toArray(T[] TArray) {
        return CollectionToArray.toArray((Collection)this, (Object[])TArray);
    }
}

