/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.font;

import androidx.ui.MathHelpersKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u000f\n\u0000\n\u0002\u0010\b\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0002\b\u0086\b\u0018\u0000 \u00142\b\u0012\u0004\u0012\u00020\u00000\u0001:\u0001\u0014B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u0011\u0010\t\u001a\u00020\u00032\u0006\u0010\n\u001a\u00020\u0000H\u0096\u0002J\u000e\u0010\u000b\u001a\u00020\u0003H\u00c0\u0003\u00a2\u0006\u0002\b\fJ\u0013\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\n\u001a\u0004\u0018\u00010\u0010H\u00d6\u0003J\t\u0010\u0011\u001a\u00020\u0003H\u00d6\u0001J\b\u0010\u0012\u001a\u00020\u0013H\u0016R\u0014\u0010\u0005\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\u0002\u001a\u00020\u0003X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0015"}, d2={"Landroidx/ui/text/font/FontWeight;", "", "weight", "", "(I)V", "index", "getIndex", "()I", "getWeight$ui_text_release", "compareTo", "other", "component1", "component1$ui_text_release", "copy", "equals", "", "", "hashCode", "toString", "", "Companion", "ui-text_release"})
public final class FontWeight
implements Comparable<FontWeight> {
    private final int weight;
    @NotNull
    private static final FontWeight w100;
    @NotNull
    private static final FontWeight w200;
    @NotNull
    private static final FontWeight w300;
    @NotNull
    private static final FontWeight w400;
    @NotNull
    private static final FontWeight w500;
    @NotNull
    private static final FontWeight w600;
    @NotNull
    private static final FontWeight w700;
    @NotNull
    private static final FontWeight w800;
    @NotNull
    private static final FontWeight w900;
    @NotNull
    private static final FontWeight normal;
    @NotNull
    private static final FontWeight bold;
    @NotNull
    private static final List<FontWeight> values;
    public static final Companion Companion;

    private final int getIndex() {
        return this.weight / 100 - 1;
    }

    @Override
    public int compareTo(@NotNull FontWeight other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return Intrinsics.compare((int)this.weight, (int)other.weight);
    }

    @NotNull
    public String toString() {
        String string;
        switch (this.getIndex()) {
            case 0: {
                string = "FontWeight.w100";
                break;
            }
            case 1: {
                string = "FontWeight.w200";
                break;
            }
            case 2: {
                string = "FontWeight.w300";
                break;
            }
            case 3: {
                string = "FontWeight.w400";
                break;
            }
            case 4: {
                string = "FontWeight.w500";
                break;
            }
            case 5: {
                string = "FontWeight.w600";
                break;
            }
            case 6: {
                string = "FontWeight.w700";
                break;
            }
            case 7: {
                string = "FontWeight.w800";
                break;
            }
            case 8: {
                string = "FontWeight.w900";
                break;
            }
            default: {
                string = "FontWeight.unknown";
            }
        }
        return string;
    }

    public final int getWeight$ui_text_release() {
        return this.weight;
    }

    private FontWeight(int weight) {
        this.weight = weight;
    }

    static {
        Companion = new Companion(null);
        w100 = new FontWeight(100);
        w200 = new FontWeight(200);
        w300 = new FontWeight(300);
        w400 = new FontWeight(400);
        w500 = new FontWeight(500);
        w600 = new FontWeight(600);
        w700 = new FontWeight(700);
        w800 = new FontWeight(800);
        w900 = new FontWeight(900);
        normal = w400;
        bold = w700;
        values = CollectionsKt.listOf((Object[])new FontWeight[]{w100, w200, w300, w400, w500, w600, w700, w800, w900});
    }

    public final int component1$ui_text_release() {
        return this.weight;
    }

    @NotNull
    public final FontWeight copy(int weight) {
        return new FontWeight(weight);
    }

    public static /* synthetic */ FontWeight copy$default(FontWeight fontWeight, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            n = fontWeight.weight;
        }
        return fontWeight.copy(n);
    }

    public int hashCode() {
        return Integer.hashCode(this.weight);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof FontWeight)) break block3;
                FontWeight fontWeight = (FontWeight)object;
                if (!(this.weight == fontWeight.weight)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\b\u0018\n\u0002\u0010\u0007\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\"\u0010\u001f\u001a\u00020\u00042\b\u0010 \u001a\u0004\u0018\u00010\u00042\b\u0010!\u001a\u0004\u0018\u00010\u00042\u0006\u0010\"\u001a\u00020#R\u0011\u0010\u0003\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006R\u0011\u0010\u0007\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0006R\u0017\u0010\t\u001a\b\u0012\u0004\u0012\u00020\u00040\n\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u0006R\u0011\u0010\u000f\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0006R\u0011\u0010\u0011\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0006R\u0011\u0010\u0013\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0006R\u0011\u0010\u0015\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\u0006R\u0011\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0006R\u0011\u0010\u0019\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0006R\u0011\u0010\u001b\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u0006R\u0011\u0010\u001d\u001a\u00020\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u0006\u00a8\u0006$"}, d2={"Landroidx/ui/text/font/FontWeight$Companion;", "", "()V", "bold", "Landroidx/ui/text/font/FontWeight;", "getBold", "()Landroidx/ui/text/font/FontWeight;", "normal", "getNormal", "values", "", "getValues", "()Ljava/util/List;", "w100", "getW100", "w200", "getW200", "w300", "getW300", "w400", "getW400", "w500", "getW500", "w600", "getW600", "w700", "getW700", "w800", "getW800", "w900", "getW900", "lerp", "a", "b", "t", "", "ui-text_release"})
    public static final class Companion {
        @NotNull
        public final FontWeight getW100() {
            return w100;
        }

        @NotNull
        public final FontWeight getW200() {
            return w200;
        }

        @NotNull
        public final FontWeight getW300() {
            return w300;
        }

        @NotNull
        public final FontWeight getW400() {
            return w400;
        }

        @NotNull
        public final FontWeight getW500() {
            return w500;
        }

        @NotNull
        public final FontWeight getW600() {
            return w600;
        }

        @NotNull
        public final FontWeight getW700() {
            return w700;
        }

        @NotNull
        public final FontWeight getW800() {
            return w800;
        }

        @NotNull
        public final FontWeight getW900() {
            return w900;
        }

        @NotNull
        public final FontWeight getNormal() {
            return normal;
        }

        @NotNull
        public final FontWeight getBold() {
            return bold;
        }

        @NotNull
        public final List<FontWeight> getValues() {
            return values;
        }

        @NotNull
        public final FontWeight lerp(@Nullable FontWeight a, @Nullable FontWeight b, float t) {
            FontWeight fontWeight = a;
            FontWeight fontWeight2 = b;
            return this.getValues().get(RangesKt.coerceIn((int)MathKt.roundToInt((float)MathHelpersKt.lerp((int)(fontWeight != null ? fontWeight.getIndex() : this.getNormal().getIndex()), (int)(fontWeight2 != null ? fontWeight2.getIndex() : this.getNormal().getIndex()), (float)t)), (int)0, (int)8));
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

