/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.annotation.RestrictTo;
import androidx.ui.input.PartialGapBuffer;
import androidx.ui.text.TextRange;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0007\b\u0007\u0018\u0000 *2\u00020\u0001:\u0001*B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\u0006\u0010\u001a\u001a\u00020\u001bJ\u0006\u0010\u001c\u001a\u00020\u001bJ\u0016\u0010\u001d\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bJ\u0011\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020\bH\u0086\u0002J\u0006\u0010#\u001a\u00020$J\u001e\u0010%\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010&\u001a\u00020\u0003J\u0016\u0010'\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bJ\u0016\u0010(\u001a\u00020\u001b2\u0006\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\bJ\b\u0010)\u001a\u00020\u0003H\u0016R\u001e\u0010\t\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u001e\u0010\f\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR$\u0010\u000e\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\b8F@FX\u0086\u000e\u00a2\u0006\f\u001a\u0004\b\u000f\u0010\u000b\"\u0004\b\u0010\u0010\u0011R\u000e\u0010\u0012\u001a\u00020\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0014\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0015\u0010\u000bR\u001e\u0010\u0016\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u000bR\u001e\u0010\u0018\u001a\u00020\b2\u0006\u0010\u0007\u001a\u00020\b@BX\u0086\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u000b\u00a8\u0006+"}, d2={"Landroidx/ui/input/EditingBuffer;", "", "initialText", "", "initialSelection", "Landroidx/ui/text/TextRange;", "(Ljava/lang/String;Landroidx/ui/text/TextRange;)V", "<set-?>", "", "compositionEnd", "getCompositionEnd", "()I", "compositionStart", "getCompositionStart", "cursor", "getCursor", "setCursor", "(I)V", "gapBuffer", "Landroidx/ui/input/PartialGapBuffer;", "length", "getLength", "selectionEnd", "getSelectionEnd", "selectionStart", "getSelectionStart", "cancelComposition", "", "commitComposition", "delete", "start", "end", "get", "", "index", "hasComposition", "", "replace", "text", "setComposition", "setSelection", "toString", "Companion", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class EditingBuffer {
    private final PartialGapBuffer gapBuffer;
    private int selectionStart;
    private int selectionEnd;
    private int compositionStart;
    private int compositionEnd;
    public static final int NOWHERE = -1;
    public static final Companion Companion = new Companion(null);

    public final int getSelectionStart() {
        return this.selectionStart;
    }

    public final int getSelectionEnd() {
        return this.selectionEnd;
    }

    public final int getCompositionStart() {
        return this.compositionStart;
    }

    public final int getCompositionEnd() {
        return this.compositionEnd;
    }

    public final boolean hasComposition() {
        return this.compositionStart != -1;
    }

    public final int getCursor() {
        return this.selectionStart == this.selectionEnd ? this.selectionEnd : -1;
    }

    public final void setCursor(int cursor) {
        this.setSelection(cursor, cursor);
    }

    public final char get(int index) {
        return this.gapBuffer.get(index);
    }

    public final int getLength() {
        return this.gapBuffer.getLength();
    }

    public final void replace(int start, int end, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw (Throwable)new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw (Throwable)new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw (Throwable)new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.gapBuffer.replace(start, end, text);
        this.selectionStart = start + text.length();
        this.selectionEnd = start + text.length();
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void delete(int start, int end) {
        TextRange deleteRange = new TextRange(start, end);
        if (deleteRange.intersects(new TextRange(this.selectionStart, this.selectionEnd))) {
            String string = "support deletion within selection range.";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        this.gapBuffer.replace(start, end, "");
        if (end <= this.selectionStart) {
            this.selectionStart -= deleteRange.getLength();
            this.selectionEnd -= deleteRange.getLength();
        }
        if (!this.hasComposition()) {
            return;
        }
        TextRange compositionRange = new TextRange(this.compositionStart, this.compositionEnd);
        if (deleteRange.intersects(compositionRange)) {
            if (deleteRange.contains(compositionRange)) {
                this.compositionStart = -1;
                this.compositionEnd = -1;
            } else if (compositionRange.contains(deleteRange)) {
                this.compositionEnd -= deleteRange.getLength();
            } else if (deleteRange.contains(this.compositionStart)) {
                this.compositionStart = deleteRange.getMin();
                this.compositionEnd -= deleteRange.getLength();
            } else {
                this.compositionEnd = deleteRange.getMin();
            }
        } else if (this.compositionStart > deleteRange.getMin()) {
            this.compositionStart -= deleteRange.getLength();
            this.compositionEnd -= deleteRange.getLength();
        }
    }

    public final void setSelection(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw (Throwable)new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw (Throwable)new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw (Throwable)new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.selectionStart = start;
        this.selectionEnd = end;
    }

    public final void setComposition(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw (Throwable)new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw (Throwable)new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start >= end) {
            throw (Throwable)new IllegalArgumentException("Do not set reversed or empty range: " + start + " > " + end);
        }
        this.compositionStart = start;
        this.compositionEnd = end;
    }

    public final void cancelComposition() {
        this.replace(this.compositionStart, this.compositionEnd, "");
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void commitComposition() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    @NotNull
    public String toString() {
        return this.gapBuffer.toString();
    }

    public EditingBuffer(@NotNull String initialText, @NotNull TextRange initialSelection) {
        Intrinsics.checkParameterIsNotNull((Object)initialText, (String)"initialText");
        Intrinsics.checkParameterIsNotNull((Object)initialSelection, (String)"initialSelection");
        this.gapBuffer = new PartialGapBuffer(initialText);
        this.selectionStart = initialSelection.getMin();
        this.selectionEnd = initialSelection.getMax();
        this.compositionStart = -1;
        this.compositionEnd = -1;
        int start = initialSelection.getMin();
        int end = initialSelection.getMax();
        if (start < 0 || start > initialText.length()) {
            throw (Throwable)new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + initialText.length());
        }
        if (end < 0 || end > initialText.length()) {
            throw (Throwable)new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + initialText.length());
        }
        if (start > end) {
            throw (Throwable)new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0012\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0005"}, d2={"Landroidx/ui/input/EditingBuffer$Companion;", "", "()V", "NOWHERE", "", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

