/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.annotation.RestrictTo;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0087\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0019\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Landroidx/ui/input/InputState;", "", "text", "", "selection", "Landroidx/ui/text/TextRange;", "composition", "(Ljava/lang/String;Landroidx/ui/text/TextRange;Landroidx/ui/text/TextRange;)V", "getComposition", "()Landroidx/ui/text/TextRange;", "getSelection", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "getSelectedText", "getTextAfterSelection", "maxChars", "", "getTextBeforeSelection", "hashCode", "toString", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class InputState {
    @NotNull
    private final String text;
    @NotNull
    private final TextRange selection;
    @Nullable
    private final TextRange composition;

    @NotNull
    public final String getTextBeforeSelection(int maxChars) {
        String string = this.text;
        int n = Math.max(0, this.selection.getMin() - maxChars);
        int n2 = this.selection.getMin();
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String getTextAfterSelection(int maxChars) {
        String string = this.text;
        int n = this.selection.getMax();
        int n2 = Math.min(this.selection.getMax() + maxChars, this.text.length());
        boolean bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String getSelectedText() {
        return TextRangeKt.substring((CharSequence)this.text, (TextRange)this.selection);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextRange getSelection() {
        return this.selection;
    }

    @Nullable
    public final TextRange getComposition() {
        return this.composition;
    }

    public InputState(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        this.text = text;
        this.selection = selection;
        this.composition = composition;
    }

    public /* synthetic */ InputState(String string, TextRange textRange, TextRange textRange2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            string = "";
        }
        if ((n & 2) != 0) {
            textRange = new TextRange(0, 0);
        }
        if ((n & 4) != 0) {
            textRange2 = null;
        }
        this(string, textRange, textRange2);
    }

    public InputState() {
        this(null, null, null, 7, null);
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final TextRange component2() {
        return this.selection;
    }

    @Nullable
    public final TextRange component3() {
        return this.composition;
    }

    @NotNull
    public final InputState copy(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        return new InputState(text, selection, composition);
    }

    public static /* synthetic */ InputState copy$default(InputState inputState, String string, TextRange textRange, TextRange textRange2, int n, Object object) {
        if ((n & 1) != 0) {
            string = inputState.text;
        }
        if ((n & 2) != 0) {
            textRange = inputState.selection;
        }
        if ((n & 4) != 0) {
            textRange2 = inputState.composition;
        }
        return inputState.copy(string, textRange, textRange2);
    }

    @NotNull
    public String toString() {
        return "InputState(text=" + this.text + ", selection=" + this.selection + ", composition=" + this.composition + ")";
    }

    public int hashCode() {
        String string = this.text;
        TextRange textRange = this.selection;
        TextRange textRange2 = this.composition;
        return ((string != null ? string.hashCode() : 0) * 31 + (textRange != null ? textRange.hashCode() : 0)) * 31 + (textRange2 != null ? textRange2.hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof InputState)) break block3;
                InputState inputState = (InputState)object;
                if (!Intrinsics.areEqual((Object)this.text, (Object)inputState.text) || !Intrinsics.areEqual((Object)this.selection, (Object)inputState.selection) || !Intrinsics.areEqual((Object)this.composition, (Object)inputState.composition)) break block3;
            }
            return true;
        }
        return false;
    }
}

