/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.annotation.RestrictTo;
import androidx.ui.input.EditOperation;
import androidx.ui.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0005J\t\u0010\t\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\n\u001a\u00020\u0003H\u00c6\u0003J\u001d\u0010\u000b\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0003H\u00c6\u0001J\u0013\u0010\f\u001a\u00020\r2\b\u0010\u000e\u001a\u0004\u0018\u00010\u000fH\u00d6\u0003J\t\u0010\u0010\u001a\u00020\u0003H\u00d6\u0001J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0016J\t\u0010\u0015\u001a\u00020\u0016H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\u0007\u00a8\u0006\u0017"}, d2={"Landroidx/ui/input/SetSelectionEditOp;", "Landroidx/ui/input/EditOperation;", "start", "", "end", "(II)V", "getEnd", "()I", "getStart", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "process", "", "buffer", "Landroidx/ui/input/EditingBuffer;", "toString", "", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class SetSelectionEditOp
implements EditOperation {
    private final int start;
    private final int end;

    @Override
    public void process(@NotNull EditingBuffer buffer) {
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        int clampedStart = RangesKt.coerceIn((int)this.start, (int)0, (int)buffer.getLength());
        int clampedEnd = RangesKt.coerceIn((int)this.end, (int)0, (int)buffer.getLength());
        if (clampedStart < clampedEnd) {
            buffer.setSelection(clampedStart, clampedEnd);
        } else {
            buffer.setSelection(clampedEnd, clampedStart);
        }
    }

    public final int getStart() {
        return this.start;
    }

    public final int getEnd() {
        return this.end;
    }

    public SetSelectionEditOp(int start, int end) {
        this.start = start;
        this.end = end;
    }

    public final int component1() {
        return this.start;
    }

    public final int component2() {
        return this.end;
    }

    @NotNull
    public final SetSelectionEditOp copy(int start, int end) {
        return new SetSelectionEditOp(start, end);
    }

    public static /* synthetic */ SetSelectionEditOp copy$default(SetSelectionEditOp setSelectionEditOp, int n, int n2, int n3, Object object) {
        if ((n3 & 1) != 0) {
            n = setSelectionEditOp.start;
        }
        if ((n3 & 2) != 0) {
            n2 = setSelectionEditOp.end;
        }
        return setSelectionEditOp.copy(n, n2);
    }

    @NotNull
    public String toString() {
        return "SetSelectionEditOp(start=" + this.start + ", end=" + this.end + ")";
    }

    public int hashCode() {
        return Integer.hashCode(this.start) * 31 + Integer.hashCode(this.end);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SetSelectionEditOp)) break block3;
                SetSelectionEditOp setSelectionEditOp = (SetSelectionEditOp)object;
                if (this.start != setSelectionEditOp.start || this.end != setSelectionEditOp.end) break block3;
            }
            return true;
        }
        return false;
    }
}

