/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextStyle;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0086\b\u0018\u00002\u00020\u0001:\u0002\u001b\u001cB9\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u0012\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\u0002\u0010\nJ\t\u0010\u0010\u001a\u00020\u0003H\u00c6\u0003J\u0015\u0010\u0011\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005H\u00c6\u0003J\u0015\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005H\u00c6\u0003J?\u0010\u0013\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\u0014\b\u0002\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u00052\u0014\b\u0002\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005H\u00c6\u0001J\u0013\u0010\u0014\u001a\u00020\u00152\b\u0010\u0016\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001J\u0011\u0010\u0019\u001a\u00020\u00002\u0006\u0010\u0016\u001a\u00020\u0000H\u0086\u0002J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\t0\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u001d\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\f\u00a8\u0006\u001d"}, d2={"Landroidx/ui/text/AnnotatedString;", "", "text", "", "textStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/TextStyle;", "paragraphStyles", "Landroidx/ui/text/ParagraphStyle;", "(Ljava/lang/String;Ljava/util/List;Ljava/util/List;)V", "getParagraphStyles", "()Ljava/util/List;", "getText", "()Ljava/lang/String;", "getTextStyles", "component1", "component2", "component3", "copy", "equals", "", "other", "hashCode", "", "plus", "toString", "Builder", "Item", "ui-text_release"})
public final class AnnotatedString {
    @NotNull
    private final String text;
    @NotNull
    private final List<Item<TextStyle>> textStyles;
    @NotNull
    private final List<Item<ParagraphStyle>> paragraphStyles;

    @NotNull
    public final AnnotatedString plus(@NotNull AnnotatedString other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        Builder builder = new Builder(this);
        boolean bl = false;
        boolean bl2 = false;
        Builder $this$with = builder;
        boolean bl3 = false;
        $this$with.append(other);
        return $this$with.toAnnotatedString();
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final List<Item<TextStyle>> getTextStyles() {
        return this.textStyles;
    }

    @NotNull
    public final List<Item<ParagraphStyle>> getParagraphStyles() {
        return this.paragraphStyles;
    }

    public AnnotatedString(@NotNull String text, @NotNull List<Item<TextStyle>> textStyles, @NotNull List<Item<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
        Intrinsics.checkParameterIsNotNull(paragraphStyles, (String)"paragraphStyles");
        this.text = text;
        this.textStyles = textStyles;
        this.paragraphStyles = paragraphStyles;
        int lastStyleEnd = -1;
        for (Item<ParagraphStyle> paragraphStyle : this.paragraphStyles) {
            boolean bl = paragraphStyle.getStart() >= lastStyleEnd;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "ParagraphStyle should not overlap";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            bl = paragraphStyle.getEnd() <= this.text.length();
            bl2 = false;
            bl3 = false;
            if (!bl) {
                boolean bl5 = false;
                String string = "ParagraphStyle range [" + paragraphStyle.getStart() + ", " + paragraphStyle.getEnd() + ')' + " is out of boundary";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
            lastStyleEnd = paragraphStyle.getEnd();
        }
    }

    public /* synthetic */ AnnotatedString(String string, List list, List list2, int n, DefaultConstructorMarker defaultConstructorMarker) {
        boolean bl;
        if ((n & 2) != 0) {
            bl = false;
            list = CollectionsKt.emptyList();
        }
        if ((n & 4) != 0) {
            bl = false;
            list2 = CollectionsKt.emptyList();
        }
        this(string, list, list2);
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final List<Item<TextStyle>> component2() {
        return this.textStyles;
    }

    @NotNull
    public final List<Item<ParagraphStyle>> component3() {
        return this.paragraphStyles;
    }

    @NotNull
    public final AnnotatedString copy(@NotNull String text, @NotNull List<Item<TextStyle>> textStyles, @NotNull List<Item<ParagraphStyle>> paragraphStyles) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
        Intrinsics.checkParameterIsNotNull(paragraphStyles, (String)"paragraphStyles");
        return new AnnotatedString(text, textStyles, paragraphStyles);
    }

    public static /* synthetic */ AnnotatedString copy$default(AnnotatedString annotatedString, String string, List list, List list2, int n, Object object) {
        if ((n & 1) != 0) {
            string = annotatedString.text;
        }
        if ((n & 2) != 0) {
            list = annotatedString.textStyles;
        }
        if ((n & 4) != 0) {
            list2 = annotatedString.paragraphStyles;
        }
        return annotatedString.copy(string, list, list2);
    }

    @NotNull
    public String toString() {
        return "AnnotatedString(text=" + this.text + ", textStyles=" + this.textStyles + ", paragraphStyles=" + this.paragraphStyles + ")";
    }

    public int hashCode() {
        String string = this.text;
        List<Item<TextStyle>> list = this.textStyles;
        List<Item<ParagraphStyle>> list2 = this.paragraphStyles;
        return ((string != null ? string.hashCode() : 0) * 31 + (list != null ? ((Object)list).hashCode() : 0)) * 31 + (list2 != null ? ((Object)list2).hashCode() : 0);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof AnnotatedString)) break block3;
                AnnotatedString annotatedString = (AnnotatedString)object;
                if (!Intrinsics.areEqual((Object)this.text, (Object)annotatedString.text) || !Intrinsics.areEqual(this.textStyles, annotatedString.textStyles) || !Intrinsics.areEqual(this.paragraphStyles, annotatedString.paragraphStyles)) break block3;
            }
            return true;
        }
        return false;
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000$\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001d\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u000e\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\fJ\t\u0010\u000f\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0010\u001a\u00020\u0005H\u00c6\u0003J2\u0010\u0011\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0012J\u0013\u0010\u0013\u001a\u00020\u00142\b\u0010\u0015\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0016\u001a\u00020\u0005H\u00d6\u0001J\t\u0010\u0017\u001a\u00020\u0018H\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\r\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0019"}, d2={"Landroidx/ui/text/AnnotatedString$Item;", "T", "", "style", "start", "", "end", "(Ljava/lang/Object;II)V", "getEnd", "()I", "getStart", "getStyle", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;II)Landroidx/ui/text/AnnotatedString$Item;", "equals", "", "other", "hashCode", "toString", "", "ui-text_release"})
    public static final class Item<T> {
        private final T style;
        private final int start;
        private final int end;

        public final T getStyle() {
            return this.style;
        }

        public final int getStart() {
            return this.start;
        }

        public final int getEnd() {
            return this.end;
        }

        public Item(T style, int start, int end) {
            this.style = style;
            this.start = start;
            this.end = end;
            boolean bl = this.start <= this.end;
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = "Reversed range is not supported";
                throw (Throwable)new IllegalArgumentException(string.toString());
            }
        }

        public final T component1() {
            return this.style;
        }

        public final int component2() {
            return this.start;
        }

        public final int component3() {
            return this.end;
        }

        @NotNull
        public final Item<T> copy(T style, int start, int end) {
            return new Item<T>(style, start, end);
        }

        public static /* synthetic */ Item copy$default(Item item, Object object, int n, int n2, int n3, Object object2) {
            if ((n3 & 1) != 0) {
                object = item.style;
            }
            if ((n3 & 2) != 0) {
                n = item.start;
            }
            if ((n3 & 4) != 0) {
                n2 = item.end;
            }
            return item.copy(object, n, n2);
        }

        @NotNull
        public String toString() {
            return "Item(style=" + this.style + ", start=" + this.start + ", end=" + this.end + ")";
        }

        public int hashCode() {
            T t = this.style;
            return ((t != null ? t.hashCode() : 0) * 31 + Integer.hashCode(this.start)) * 31 + Integer.hashCode(this.end);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof Item)) break block3;
                    Item item = (Item)object;
                    if (!Intrinsics.areEqual(this.style, item.style) || this.start != item.start || this.end != item.end) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\f\n\u0002\b\u0007\u0018\u00002\u00020\u0001:\u0001#B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004B\u000f\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u000f\u0012\b\b\u0002\u0010\u0007\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00102\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u001e\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00152\u0006\u0010\u0019\u001a\u00020\b2\u0006\u0010\u001a\u001a\u00020\bJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0005J\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u001c\u001a\u00020\u001dJ\u000e\u0010\u001b\u001a\u00020\u00172\u0006\u0010\u0002\u001a\u00020\u0003J\u0006\u0010\u001e\u001a\u00020\u0017J\u000e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\bJ\u000e\u0010 \u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0010J\u000e\u0010 \u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0015J\u0006\u0010!\u001a\u00020\u0005J\b\u0010\"\u001a\u00020\u0003H\u0016R\u0011\u0010\n\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00100\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u0011\u001a\u0010\u0012\f\u0012\n\u0012\u0006\b\u0001\u0012\u00020\u00010\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0012\u0010\u0002\u001a\u00060\u0012j\u0002`\u0013X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0014\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00150\u000f0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Landroidx/ui/text/AnnotatedString$Builder;", "", "text", "", "(Ljava/lang/String;)V", "Landroidx/ui/text/AnnotatedString;", "(Landroidx/ui/text/AnnotatedString;)V", "capacity", "", "(I)V", "length", "getLength", "()I", "paragraphStyles", "", "Landroidx/ui/text/AnnotatedString$Builder$MutableItem;", "Landroidx/ui/text/ParagraphStyle;", "styleStack", "Ljava/lang/StringBuilder;", "Lkotlin/text/StringBuilder;", "textStyles", "Landroidx/ui/text/TextStyle;", "addStyle", "", "style", "start", "end", "append", "char", "", "popStyle", "index", "pushStyle", "toAnnotatedString", "toString", "MutableItem", "ui-text_release"})
    public static final class Builder {
        private final StringBuilder text;
        private final List<MutableItem<TextStyle>> textStyles;
        private final List<MutableItem<ParagraphStyle>> paragraphStyles;
        private final List<MutableItem<? extends Object>> styleStack;

        public final int getLength() {
            return this.text.length();
        }

        @NotNull
        public String toString() {
            String string = this.text.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text.toString()");
            return string;
        }

        public final void append(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this.text.append(text);
        }

        public final void append(char c) {
            this.text.append(c);
        }

        public final void append(@NotNull AnnotatedString text) {
            Item it;
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            int start = this.text.length();
            this.text.append(text.getText());
            Iterable $this$forEach$iv = text.getTextStyles();
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Item)element$iv;
                boolean bl = false;
                this.addStyle((TextStyle)it.getStyle(), start + it.getStart(), start + it.getEnd());
            }
            $this$forEach$iv = text.getParagraphStyles();
            $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                it = (Item)element$iv;
                boolean bl = false;
                this.addStyle((ParagraphStyle)it.getStyle(), start + it.getStart(), start + it.getEnd());
            }
        }

        public final void addStyle(@NotNull TextStyle style, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            this.textStyles.add(new MutableItem<TextStyle>(style, start, end));
        }

        public final void addStyle(@NotNull ParagraphStyle style, int start, int end) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            this.paragraphStyles.add(new MutableItem<ParagraphStyle>(style, start, end));
        }

        public final int pushStyle(@NotNull TextStyle style) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            MutableItem mutableItem = new MutableItem(style, this.text.length(), 0, 4, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableItem it = mutableItem;
            boolean bl3 = false;
            this.styleStack.add(it);
            this.textStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final int pushStyle(@NotNull ParagraphStyle style) {
            Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
            MutableItem mutableItem = new MutableItem(style, this.text.length(), 0, 4, null);
            boolean bl = false;
            boolean bl2 = false;
            MutableItem it = mutableItem;
            boolean bl3 = false;
            this.styleStack.add(it);
            this.paragraphStyles.add(it);
            return this.styleStack.size() - 1;
        }

        public final void popStyle() {
            Collection collection = this.styleStack;
            boolean bl = false;
            boolean bl2 = !collection.isEmpty();
            bl = false;
            boolean bl3 = false;
            if (!bl2) {
                boolean bl4 = false;
                String string = "Nothing to pop.";
                throw (Throwable)new IllegalStateException(string.toString());
            }
            MutableItem<? extends Object> item = this.styleStack.remove(this.styleStack.size() - 1);
            item.setEnd(this.text.length());
        }

        public final void popStyle(int index) {
            boolean bl = index < this.styleStack.size();
            boolean bl2 = false;
            boolean bl3 = false;
            if (!bl) {
                boolean bl4 = false;
                String string = index + " should be less than " + this.styleStack.size();
                throw (Throwable)new IllegalStateException(string.toString());
            }
            while (this.styleStack.size() - 1 >= index) {
                this.popStyle();
            }
        }

        @NotNull
        public final AnnotatedString toAnnotatedString() {
            Object object;
            MutableItem it;
            Collection collection;
            Iterable $this$mapTo$iv$iv;
            Iterable $this$map$iv;
            String string = this.text.toString();
            Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"text.toString()");
            Iterable iterable = this.textStyles;
            String string2 = string;
            boolean $i$f$map = false;
            void var3_4 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                MutableItem mutableItem = (MutableItem)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                object = it.toItem(this.text.length());
                collection.add(object);
            }
            collection = (List)destination$iv$iv;
            $this$map$iv = this.paragraphStyles;
            collection = CollectionsKt.toList((Iterable)collection);
            $i$f$map = false;
            $this$mapTo$iv$iv = $this$map$iv;
            destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                it = (MutableItem)item$iv$iv;
                object = destination$iv$iv;
                boolean bl = false;
                Item item = it.toItem(this.text.length());
                object.add(item);
            }
            object = (List)destination$iv$iv;
            List list = CollectionsKt.toList((Iterable)((Iterable)object));
            Collection collection2 = collection;
            String string3 = string2;
            return new AnnotatedString(string3, (List<Item<TextStyle>>)collection2, list);
        }

        public Builder(int capacity) {
            List list;
            this.text = new StringBuilder(capacity);
            Builder builder = this;
            boolean bl = false;
            builder.textStyles = list = (List)new ArrayList();
            builder = this;
            bl = false;
            builder.paragraphStyles = list = (List)new ArrayList();
            builder = this;
            bl = false;
            builder.styleStack = list = (List)new ArrayList();
        }

        public /* synthetic */ Builder(int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n2 & 1) != 0) {
                n = 16;
            }
            this(n);
        }

        public Builder() {
            this(0, 1, null);
        }

        public Builder(@NotNull String text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        public Builder(@NotNull AnnotatedString text) {
            Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
            this(0, 1, null);
            this.append(text);
        }

        @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000,\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0010\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0082\b\u0018\u0000*\u0004\b\u0000\u0010\u00012\u00020\u0002B\u001f\u0012\u0006\u0010\u0003\u001a\u00028\u0000\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0007J\u000e\u0010\u0010\u001a\u00028\u0000H\u00c6\u0003\u00a2\u0006\u0002\u0010\u000eJ\t\u0010\u0011\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00c6\u0003J2\u0010\u0013\u001a\b\u0012\u0004\u0012\u00028\u00000\u00002\b\b\u0002\u0010\u0003\u001a\u00028\u00002\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u0005H\u00c6\u0001\u00a2\u0006\u0002\u0010\u0014J\u0013\u0010\u0015\u001a\u00020\u00162\b\u0010\u0017\u001a\u0004\u0018\u00010\u0002H\u00d6\u0003J\t\u0010\u0018\u001a\u00020\u0005H\u00d6\u0001J\u0016\u0010\u0019\u001a\b\u0012\u0004\u0012\u00028\u00000\u001a2\b\b\u0002\u0010\u001b\u001a\u00020\u0005J\t\u0010\u001c\u001a\u00020\u001dH\u00d6\u0001R\u001a\u0010\u0006\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\b\u0010\t\"\u0004\b\n\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\tR\u0013\u0010\u0003\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\u000f\u001a\u0004\b\r\u0010\u000e\u00a8\u0006\u001e"}, d2={"Landroidx/ui/text/AnnotatedString$Builder$MutableItem;", "T", "", "style", "start", "", "end", "(Ljava/lang/Object;II)V", "getEnd", "()I", "setEnd", "(I)V", "getStart", "getStyle", "()Ljava/lang/Object;", "Ljava/lang/Object;", "component1", "component2", "component3", "copy", "(Ljava/lang/Object;II)Landroidx/ui/text/AnnotatedString$Builder$MutableItem;", "equals", "", "other", "hashCode", "toItem", "Landroidx/ui/text/AnnotatedString$Item;", "defaultEnd", "toString", "", "ui-text_release"})
        private static final class MutableItem<T> {
            private final T style;
            private final int start;
            private int end;

            @NotNull
            public final Item<T> toItem(int defaultEnd) {
                int end = this.end == Integer.MIN_VALUE ? defaultEnd : this.end;
                boolean bl = end != Integer.MIN_VALUE;
                boolean bl2 = false;
                boolean bl3 = false;
                if (!bl) {
                    boolean bl4 = false;
                    String string = "Item.end should be set first";
                    throw (Throwable)new IllegalStateException(string.toString());
                }
                return new Item<T>(this.style, this.start, end);
            }

            public static /* synthetic */ Item toItem$default(MutableItem mutableItem, int n, int n2, Object object) {
                if ((n2 & 1) != 0) {
                    n = Integer.MIN_VALUE;
                }
                return mutableItem.toItem(n);
            }

            public final T getStyle() {
                return this.style;
            }

            public final int getStart() {
                return this.start;
            }

            public final int getEnd() {
                return this.end;
            }

            public final void setEnd(int n) {
                this.end = n;
            }

            public MutableItem(T style, int start, int end) {
                this.style = style;
                this.start = start;
                this.end = end;
            }

            public /* synthetic */ MutableItem(Object object, int n, int n2, int n3, DefaultConstructorMarker defaultConstructorMarker) {
                if ((n3 & 4) != 0) {
                    n2 = Integer.MIN_VALUE;
                }
                this(object, n, n2);
            }

            public final T component1() {
                return this.style;
            }

            public final int component2() {
                return this.start;
            }

            public final int component3() {
                return this.end;
            }

            @NotNull
            public final MutableItem<T> copy(T style, int start, int end) {
                return new MutableItem<T>(style, start, end);
            }

            public static /* synthetic */ MutableItem copy$default(MutableItem mutableItem, Object object, int n, int n2, int n3, Object object2) {
                if ((n3 & 1) != 0) {
                    object = mutableItem.style;
                }
                if ((n3 & 2) != 0) {
                    n = mutableItem.start;
                }
                if ((n3 & 4) != 0) {
                    n2 = mutableItem.end;
                }
                return mutableItem.copy(object, n, n2);
            }

            @NotNull
            public String toString() {
                return "MutableItem(style=" + this.style + ", start=" + this.start + ", end=" + this.end + ")";
            }

            public int hashCode() {
                T t = this.style;
                return ((t != null ? t.hashCode() : 0) * 31 + Integer.hashCode(this.start)) * 31 + Integer.hashCode(this.end);
            }

            public boolean equals(@Nullable Object object) {
                block3: {
                    block2: {
                        if (this == object) break block2;
                        if (!(object instanceof MutableItem)) break block3;
                        MutableItem mutableItem = (MutableItem)object;
                        if (!Intrinsics.areEqual(this.style, mutableItem.style) || this.start != mutableItem.start || this.end != mutableItem.end) break block3;
                    }
                    return true;
                }
                return false;
            }
        }
    }
}

