/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.Density;
import androidx.ui.core.IntPx;
import androidx.ui.core.IntPxSize;
import androidx.ui.core.LayoutDirection;
import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.engine.geometry.Size;
import androidx.ui.graphics.BlendMode;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.Shader;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.MultiParagraph;
import androidx.ui.text.MultiParagraphIntrinsics;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextDelegateKt;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextDirection;
import androidx.ui.text.style.TextOverflow;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00ac\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001pB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J(\u0010H\u001a\u0002HI\"\u0004\b\u0000\u0010I2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002HI0KH\u0082\b\u00a2\u0006\u0002\u0010LJ(\u0010M\u001a\u0002HI\"\u0004\b\u0000\u0010I2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002HI0KH\u0082\b\u00a2\u0006\u0002\u0010LJ\u000e\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010Q\u001a\u00020R2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010S\u001a\u00020\u00182\u0006\u0010T\u001a\u00020\tJ\u000e\u0010U\u001a\u00020\t2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010V\u001a\u00020\t2\u0006\u0010W\u001a\u00020XJ\u000e\u0010Y\u001a\u00020O2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010Z\u001a\u00020\u00182\u0006\u0010P\u001a\u00020\tJ\u000e\u0010[\u001a\u00020\u00182\u0006\u0010P\u001a\u00020\tJ\u000e\u0010\\\u001a\u00020]2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010^\u001a\u00020_2\u0006\u0010`\u001a\u00020aJ\u0006\u0010b\u001a\u000205J\u0018\u0010c\u001a\u00020d2\u0006\u0010e\u001a\u00020\u00182\u0006\u0010f\u001a\u00020\u0018H\u0002J\u000e\u0010g\u001a\u00020_2\u0006\u0010h\u001a\u00020iJ&\u0010j\u001a\u00020_2\u0006\u0010k\u001a\u00020\t2\u0006\u0010l\u001a\u00020\t2\u0006\u0010m\u001a\u00020n2\u0006\u0010h\u001a\u00020iJ\u0016\u0010o\u001a\u00020_2\u0006\u0010P\u001a\u00020\t2\u0006\u0010h\u001a\u00020iR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R&\u0010!\u001a\u0004\u0018\u00010\"8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001aR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b+\u0010,R\u0011\u0010.\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00104\u001a\u0004\u0018\u0001058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b6\u0010$\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u001a\u00a8\u0006q"}, d2={"Landroidx/ui/text/TextDelegate;", "", "text", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "paragraphStyle", "Landroidx/ui/text/ParagraphStyle;", "maxLines", "", "softWrap", "", "overflow", "Landroidx/ui/text/style/TextOverflow;", "density", "Landroidx/ui/core/Density;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/text/TextStyle;Landroidx/ui/text/ParagraphStyle;Ljava/lang/Integer;ZLandroidx/ui/text/style/TextOverflow;Landroidx/ui/core/Density;Landroidx/ui/core/LayoutDirection;Landroidx/ui/text/font/Font$ResourceLoader;)V", "getDensity", "()Landroidx/ui/core/Density;", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "getLayoutDirection", "()Landroidx/ui/core/LayoutDirection;", "layoutResult", "Landroidx/ui/text/TextDelegate$LayoutResult;", "layoutResult$annotations", "()V", "getLayoutResult$ui_text_release", "()Landroidx/ui/text/TextDelegate$LayoutResult;", "setLayoutResult$ui_text_release", "(Landroidx/ui/text/TextDelegate$LayoutResult;)V", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "minIntrinsicWidth", "getMinIntrinsicWidth", "getOverflow", "()Landroidx/ui/text/style/TextOverflow;", "overflowShader", "Landroidx/ui/graphics/Shader;", "paragraphIntrinsics", "Landroidx/ui/text/MultiParagraphIntrinsics;", "paragraphIntrinsics$annotations", "getParagraphIntrinsics$ui_text_release", "()Landroidx/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$ui_text_release", "(Landroidx/ui/text/MultiParagraphIntrinsics;)V", "getParagraphStyle", "()Landroidx/ui/text/ParagraphStyle;", "getResourceLoader", "()Landroidx/ui/text/font/Font$ResourceLoader;", "getSoftWrap", "()Z", "getText", "()Landroidx/ui/text/AnnotatedString;", "textStyle", "getTextStyle", "()Landroidx/ui/text/TextStyle;", "width", "getWidth", "assumeIntrinsics", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "assumeLayout", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "getBoundingBox", "Landroidx/ui/engine/geometry/Rect;", "getLineBottom", "lineIndex", "getLineForOffset", "getOffsetForPosition", "position", "Landroidx/ui/core/PxPosition;", "getParagraphDirection", "getPrimaryHorizontal", "getSecondaryHorizontal", "getWordBoundary", "Landroidx/ui/text/TextRange;", "layout", "", "constraints", "Landroidx/ui/core/Constraints;", "layoutIntrinsics", "layoutText", "Landroidx/ui/text/MultiParagraph;", "minWidth", "maxWidth", "paint", "canvas", "Landroidx/ui/graphics/Canvas;", "paintBackground", "start", "end", "color", "Landroidx/ui/graphics/Color;", "paintCursor", "LayoutResult", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TextDelegate {
    @NotNull
    private final TextStyle textStyle;
    @NotNull
    private final ParagraphStyle paragraphStyle;
    @Nullable
    private LayoutResult layoutResult;
    private Shader overflowShader;
    @Nullable
    private MultiParagraphIntrinsics paragraphIntrinsics;
    @NotNull
    private final AnnotatedString text;
    @Nullable
    private final Integer maxLines;
    private final boolean softWrap;
    @NotNull
    private final TextOverflow overflow;
    @NotNull
    private final Density density;
    @NotNull
    private final LayoutDirection layoutDirection;
    @NotNull
    private final Font.ResourceLoader resourceLoader;

    @NotNull
    public final TextStyle getTextStyle() {
        return this.textStyle;
    }

    @NotNull
    public final ParagraphStyle getParagraphStyle() {
        return this.paragraphStyle;
    }

    @VisibleForTesting
    public static /* synthetic */ void layoutResult$annotations() {
    }

    @Nullable
    public final LayoutResult getLayoutResult$ui_text_release() {
        return this.layoutResult;
    }

    public final void setLayoutResult$ui_text_release(@Nullable LayoutResult layoutResult) {
        this.layoutResult = layoutResult;
    }

    private final <T> T assumeLayout(Function1<? super LayoutResult, ? extends T> block) {
        int $i$f$assumeLayout = 0;
        LayoutResult layoutResult = this.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        return (T)block.invoke((Object)layoutResult);
    }

    private final <T> T assumeIntrinsics(Function1<? super MultiParagraphIntrinsics, ? extends T> block) {
        int $i$f$assumeIntrinsics = 0;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layoutForIntrinsics must be called first"));
        }
        return (T)block.invoke((Object)multiParagraphIntrinsics);
    }

    public final float getMinIntrinsicWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layoutForIntrinsics must be called first"));
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        boolean bl = false;
        return it.getMinIntrinsicWidth();
    }

    public final float getMaxIntrinsicWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layoutForIntrinsics must be called first"));
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        boolean bl = false;
        return it.getMaxIntrinsicWidth();
    }

    @VisibleForTesting
    public static /* synthetic */ void paragraphIntrinsics$annotations() {
    }

    @Nullable
    public final MultiParagraphIntrinsics getParagraphIntrinsics$ui_text_release() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$ui_text_release(@Nullable MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    public final float getWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        return it.getSize().getWidth();
    }

    public final float getFirstBaseline() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        return it.getMultiParagraph().getFirstBaseline();
    }

    public final float getLastBaseline() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        return it.getMultiParagraph().getLastBaseline();
    }

    public final float getHeight() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        return it.getSize().getHeight();
    }

    @NotNull
    public final MultiParagraphIntrinsics layoutIntrinsics() {
        MultiParagraphIntrinsics intrinsics;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.paragraphIntrinsics;
        if (multiParagraphIntrinsics == null) {
            multiParagraphIntrinsics = new MultiParagraphIntrinsics(this.text, this.textStyle, this.paragraphStyle, this.density, this.resourceLoader);
        }
        this.paragraphIntrinsics = intrinsics = multiParagraphIntrinsics;
        return intrinsics;
    }

    private final MultiParagraph layoutText(float minWidth, float maxWidth) {
        MultiParagraphIntrinsics paragraphIntrinsics = this.layoutIntrinsics();
        float width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((float)paragraphIntrinsics.getMaxIntrinsicWidth(), (float)minWidth, (float)maxWidth);
        return new MultiParagraph(paragraphIntrinsics, this.maxLines, this.overflow == TextOverflow.Ellipsis, new ParagraphConstraints(width));
    }

    /*
     * WARNING - void declaration
     */
    public final void layout(@NotNull Constraints constraints) {
        void val1$iv$iv;
        long l;
        void height$iv;
        void width$iv;
        Px $this$round$iv;
        void $this$px$iv32;
        Px $this$round$iv2;
        void $this$px$iv22;
        Px px;
        boolean $i$a$-let-TextDelegate$layout$322;
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        float minWidth = constraints.getMinWidth().getValue();
        boolean widthMatters = this.softWrap || this.overflow == TextOverflow.Ellipsis;
        float maxWidth = widthMatters ? (float)constraints.getMaxWidth().getValue() : FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY();
        LayoutResult layoutResult = this.layoutResult;
        if (layoutResult != null) {
            LayoutResult layoutResult2 = layoutResult;
            boolean bl = false;
            boolean bl2 = false;
            LayoutResult it = layoutResult2;
            $i$a$-let-TextDelegate$layout$322 = false;
            if (it.getMinWidth() == minWidth && it.getMaxWidth() == maxWidth) {
                return;
            }
        }
        MultiParagraph multiParagraph = this.layoutText(minWidth, maxWidth);
        float f = multiParagraph.getWidth();
        Object object = constraints;
        Px $this$px$iv22 = px = new Px((float)$this$px$iv22);
        float it = $this$round$iv2.getValue();
        $i$a$-let-TextDelegate$layout$322 = false;
        $this$round$iv2 = px = Float.isInfinite(it) ? IntPx.Companion.getInfinity() : new IntPx(MathKt.roundToInt((float)$this$round$iv2.getValue()));
        it = multiParagraph.getHeight();
        Px $this$px$iv32 = px = new Px((float)$this$px$iv32);
        float $i$a$-let-TextDelegate$layout$322 = $this$round$iv.getValue();
        boolean bl = false;
        $this$round$iv = px = Float.isInfinite($i$a$-let-TextDelegate$layout$322) ? IntPx.Companion.getInfinity() : new IntPx(MathKt.roundToInt((float)$this$round$iv.getValue()));
        int $i$a$-let-TextDelegate$layout$322 = width$iv.getValue();
        int val2$iv$iv = height$iv.getValue();
        long l2 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
        px = new IntPxSize(l2);
        Object object2 = ConstraintsKt.constrain((Constraints)object, (IntPxSize)px);
        boolean bl3 = false;
        boolean bl4 = false;
        IntPxSize it2 = object2;
        boolean bl5 = false;
        IntPxSize this_$iv = it2;
        long value$iv$iv = this_$iv.getValue();
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        IntPx intPx = new IntPx($this$ipx$iv$iv);
        this_$iv = it2;
        float f2 = intPx.getValue();
        value$iv$iv = this_$iv.getValue();
        $this$ipx$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        IntPx intPx2 = new IntPx($this$ipx$iv$iv);
        float f3 = intPx2.getValue();
        float f4 = f2;
        Size size = new Size(f4, f3);
        object2 = new LayoutResult(multiParagraph, size, minWidth, maxWidth);
        object = this;
        bl3 = false;
        bl4 = false;
        it2 = object2;
        boolean bl6 = false;
        this.overflowShader = TextDelegateKt.access$createOverflowShader(this, (LayoutResult)it2);
        px = object2;
        object.layoutResult = px;
    }

    public final void paint(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        if (layoutResult2.getHasVisualOverflow()) {
            Rect bounds = Rect.Companion.fromLTWH(0.0f, 0.0f, layoutResult2.getSize().getWidth(), layoutResult2.getSize().getHeight());
            if (this.overflowShader != null) {
                canvas.saveLayer(bounds, new Paint());
            } else {
                canvas.save();
            }
            Canvas.DefaultImpls.clipRect$default((Canvas)canvas, (Rect)bounds, null, (int)2, null);
        }
        layoutResult2.getMultiParagraph().paint(canvas);
        Size size = layoutResult2.getSize();
        if (layoutResult2.getHasVisualOverflow()) {
            if (this.overflowShader != null) {
                Rect bounds = Rect.Companion.fromLTWH(0.0f, 0.0f, size.getWidth(), size.getHeight());
                Paint paint = new Paint();
                paint.setBlendMode(BlendMode.multiply);
                paint.setShader(this.overflowShader);
                canvas.drawRect(bounds, paint);
            }
            canvas.restore();
        }
    }

    public final void paintBackground(int start, int end, @NotNull Color color, @NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        if (start == end) {
            return;
        }
        Path selectionPath = layoutResult2.getMultiParagraph().getPathForRange(start, end);
        Paint paint = new Paint();
        Path path = selectionPath;
        Canvas canvas2 = canvas;
        boolean bl2 = false;
        boolean bl3 = false;
        Paint $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setColor(color);
        Paint paint2 = paint;
        canvas2.drawPath(path, paint2);
    }

    public final void paintCursor(int offset, @NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        Rect cursorRect = layoutResult2.getMultiParagraph().getCursorRect(offset);
        Paint paint = new Paint();
        Rect rect = cursorRect;
        Canvas canvas2 = canvas;
        boolean bl2 = false;
        boolean bl3 = false;
        Paint $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setColor(Color.Companion.getBlack());
        Paint paint2 = paint;
        canvas2.drawRect(rect, paint2);
    }

    public final float getLineBottom(int lineIndex) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getLineBottom(lineIndex);
    }

    public final int getLineForOffset(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getLineForOffset(offset);
    }

    public final float getPrimaryHorizontal(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getPrimaryHorizontal(offset);
    }

    public final float getSecondaryHorizontal(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getSecondaryHorizontal(offset);
    }

    @NotNull
    public final TextDirection getParagraphDirection(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getParagraphDirection(offset);
    }

    @NotNull
    public final TextDirection getBidiRunDirection(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getBidiRunDirection(offset);
    }

    public final int getOffsetForPosition(@NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getOffsetForPosition(position);
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getBoundingBox(offset);
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getWordBoundary(offset);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    @Nullable
    public final Integer getMaxLines() {
        return this.maxLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    @NotNull
    public final TextOverflow getOverflow() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public TextDelegate(@NotNull AnnotatedString text, @Nullable TextStyle style, @Nullable ParagraphStyle paragraphStyle, @Nullable Integer maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this.text = text;
        this.maxLines = maxLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.layoutDirection = layoutDirection;
        this.resourceLoader = resourceLoader;
        this.textStyle = TextDelegateKt.access$resolveTextStyle(style);
        this.paragraphStyle = paragraphStyle == null ? new ParagraphStyle(null, TextDelegateKt.resolveTextDirectionAlgorithm(this.layoutDirection, null), null, null, 13, null) : (paragraphStyle.getTextDirectionAlgorithm() == null ? ParagraphStyle.copy$default(paragraphStyle, null, TextDelegateKt.resolveTextDirectionAlgorithm(this.layoutDirection, null), null, null, 13, null) : paragraphStyle);
        boolean bl = this.maxLines == null || this.maxLines > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, ParagraphStyle paragraphStyle, Integer n, boolean bl, TextOverflow textOverflow, Density density, LayoutDirection layoutDirection, Font.ResourceLoader resourceLoader, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            textStyle = null;
        }
        if ((n2 & 4) != 0) {
            paragraphStyle = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            textOverflow = TextOverflow.Clip;
        }
        this(annotatedString, textStyle, paragraphStyle, n, bl, textOverflow, density, layoutDirection, resourceLoader);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Landroidx/ui/text/TextDelegate$LayoutResult;", "", "multiParagraph", "Landroidx/ui/text/MultiParagraph;", "size", "Landroidx/ui/engine/geometry/Size;", "minWidth", "", "maxWidth", "(Landroidx/ui/text/MultiParagraph;Landroidx/ui/engine/geometry/Size;FF)V", "didOverflowHeight", "", "getDidOverflowHeight", "()Z", "didOverflowWidth", "getDidOverflowWidth", "hasVisualOverflow", "getHasVisualOverflow", "getMaxWidth", "()F", "getMinWidth", "getMultiParagraph", "()Landroidx/ui/text/MultiParagraph;", "getSize", "()Landroidx/ui/engine/geometry/Size;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "ui-text_release"})
    @VisibleForTesting
    public static final class LayoutResult {
        @NotNull
        private final MultiParagraph multiParagraph;
        @NotNull
        private final Size size;
        private final float minWidth;
        private final float maxWidth;

        private final boolean getDidOverflowHeight() {
            return this.multiParagraph.getDidExceedMaxLines();
        }

        public final boolean getDidOverflowWidth() {
            return this.size.getWidth() < this.multiParagraph.getWidth();
        }

        public final boolean getHasVisualOverflow() {
            return this.getDidOverflowWidth() || this.getDidOverflowHeight();
        }

        @NotNull
        public final MultiParagraph getMultiParagraph() {
            return this.multiParagraph;
        }

        @NotNull
        public final Size getSize() {
            return this.size;
        }

        public final float getMinWidth() {
            return this.minWidth;
        }

        public final float getMaxWidth() {
            return this.maxWidth;
        }

        public LayoutResult(@NotNull MultiParagraph multiParagraph, @NotNull Size size, float minWidth, float maxWidth) {
            Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            this.multiParagraph = multiParagraph;
            this.size = size;
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
        }

        @NotNull
        public final MultiParagraph component1() {
            return this.multiParagraph;
        }

        @NotNull
        public final Size component2() {
            return this.size;
        }

        public final float component3() {
            return this.minWidth;
        }

        public final float component4() {
            return this.maxWidth;
        }

        @NotNull
        public final LayoutResult copy(@NotNull MultiParagraph multiParagraph, @NotNull Size size, float minWidth, float maxWidth) {
            Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            return new LayoutResult(multiParagraph, size, minWidth, maxWidth);
        }

        public static /* synthetic */ LayoutResult copy$default(LayoutResult layoutResult, MultiParagraph multiParagraph, Size size, float f, float f2, int n, Object object) {
            if ((n & 1) != 0) {
                multiParagraph = layoutResult.multiParagraph;
            }
            if ((n & 2) != 0) {
                size = layoutResult.size;
            }
            if ((n & 4) != 0) {
                f = layoutResult.minWidth;
            }
            if ((n & 8) != 0) {
                f2 = layoutResult.maxWidth;
            }
            return layoutResult.copy(multiParagraph, size, f, f2);
        }

        @NotNull
        public String toString() {
            return "LayoutResult(multiParagraph=" + this.multiParagraph + ", size=" + this.size + ", minWidth=" + this.minWidth + ", maxWidth=" + this.maxWidth + ")";
        }

        public int hashCode() {
            MultiParagraph multiParagraph = this.multiParagraph;
            Size size = this.size;
            return (((multiParagraph != null ? multiParagraph.hashCode() : 0) * 31 + (size != null ? size.hashCode() : 0)) * 31 + Float.hashCode(this.minWidth)) * 31 + Float.hashCode(this.maxWidth);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LayoutResult)) break block3;
                    LayoutResult layoutResult = (LayoutResult)object;
                    if (!Intrinsics.areEqual((Object)this.multiParagraph, (Object)layoutResult.multiParagraph) || !Intrinsics.areEqual((Object)this.size, (Object)layoutResult.size) || Float.compare(this.minWidth, layoutResult.minWidth) != 0 || Float.compare(this.maxWidth, layoutResult.maxWidth) != 0) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

