/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Path;
import android.text.TextPaint;
import android.text.TextUtils;
import androidx.annotation.VisibleForTesting;
import androidx.text.TextLayout;
import androidx.text.selection.WordBoundary;
import androidx.ui.core.Density;
import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.graphics.Canvas;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.Paragraph;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextStyle;
import androidx.ui.text.platform.AndroidParagraph$WhenMappings;
import androidx.ui.text.platform.AndroidParagraphIntrinsics;
import androidx.ui.text.platform.AndroidParagraphKt;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.style.TextDirection;
import java.util.List;
import java.util.Locale;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\r\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B_\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u0012\u0006\u0010\u0011\u001a\u00020\u0012\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\u0002\u0010\u0015B)\u0012\u0006\u0010\u0016\u001a\u00020\u0017\u0012\b\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\b\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\u0006\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010O\u001a\u00020P2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0010\u0010R\u001a\u00020S2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0010\u0010T\u001a\u00020S2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0010\u0010U\u001a\u00020(2\u0006\u0010V\u001a\u00020\fH\u0016J\u0010\u0010W\u001a\u00020\f2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0010\u0010X\u001a\u00020(2\u0006\u0010V\u001a\u00020\fH\u0016J\u0010\u0010Y\u001a\u00020(2\u0006\u0010V\u001a\u00020\fH\u0016J\u0010\u0010Z\u001a\u00020(2\u0006\u0010V\u001a\u00020\fH\u0016J\u0010\u0010[\u001a\u00020(2\u0006\u0010V\u001a\u00020\fH\u0016J\u0010\u0010\\\u001a\u00020\f2\u0006\u0010]\u001a\u00020^H\u0016J\u0010\u0010_\u001a\u00020P2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0018\u0010`\u001a\u00020a2\u0006\u0010b\u001a\u00020\f2\u0006\u0010c\u001a\u00020\fH\u0016J\u0010\u0010d\u001a\u00020(2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0010\u0010e\u001a\u00020(2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0010\u0010K\u001a\u00020f2\u0006\u0010Q\u001a\u00020\fH\u0016J\u0015\u0010g\u001a\u00020\u000e2\u0006\u0010V\u001a\u00020\fH\u0000\u00a2\u0006\u0002\bhJ\u0010\u0010i\u001a\u00020j2\u0006\u0010k\u001a\u00020lH\u0016R\u001a\u0010\u0019\u001a\u00020\u001a8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b\u001b\u0010\u001c\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u000f\u001a\u00020\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0014\u0010!\u001a\u00020\u000e8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\"\u0010#R\u0015\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\n\n\u0002\u0010&\u001a\u0004\b$\u0010%R\u0014\u0010'\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b)\u0010*R\u0014\u0010+\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b,\u0010*R\u0014\u0010-\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b.\u0010*R\u000e\u0010/\u001a\u000200X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u00101\u001a\u00020\f8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b2\u00103R\u0014\u00104\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b5\u0010*R\u0015\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\n\n\u0002\u00108\u001a\u0004\b6\u00107R\u0014\u00109\u001a\u00020(8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b:\u0010*R\u0011\u0010\u0016\u001a\u00020\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u001a\u0010=\u001a\u00020>8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\b?\u0010\u001c\u001a\u0004\b@\u0010AR\u001a\u0010B\u001a\u00020C8@X\u0081\u0004\u00a2\u0006\f\u0012\u0004\bD\u0010\u001c\u001a\u0004\bE\u0010FR\u0014\u0010G\u001a\u00020(X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010*R\u001b\u0010I\u001a\u00020J8BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\bM\u0010N\u001a\u0004\bK\u0010L\u00a8\u0006m"}, d2={"Landroidx/ui/text/platform/AndroidParagraph;", "Landroidx/ui/text/Paragraph;", "text", "", "style", "Landroidx/ui/text/TextStyle;", "paragraphStyle", "Landroidx/ui/text/ParagraphStyle;", "textStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/ui/text/ParagraphConstraints;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "density", "Landroidx/ui/core/Density;", "(Ljava/lang/String;Landroidx/ui/text/TextStyle;Landroidx/ui/text/ParagraphStyle;Ljava/util/List;Ljava/lang/Integer;Ljava/lang/Boolean;Landroidx/ui/text/ParagraphConstraints;Landroidx/ui/text/platform/TypefaceAdapter;Landroidx/ui/core/Density;)V", "paragraphIntrinsics", "Landroidx/ui/text/platform/AndroidParagraphIntrinsics;", "(Landroidx/ui/text/platform/AndroidParagraphIntrinsics;Ljava/lang/Integer;Ljava/lang/Boolean;Landroidx/ui/text/ParagraphConstraints;)V", "charSequence", "", "charSequence$annotations", "()V", "getCharSequence$ui_text_release", "()Ljava/lang/CharSequence;", "getConstraints", "()Landroidx/ui/text/ParagraphConstraints;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "getEllipsis", "()Ljava/lang/Boolean;", "Ljava/lang/Boolean;", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "lastBaseline", "getLastBaseline", "layout", "Landroidx/text/TextLayout;", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "minIntrinsicWidth", "getMinIntrinsicWidth", "getParagraphIntrinsics", "()Landroidx/ui/text/platform/AndroidParagraphIntrinsics;", "textLocale", "Ljava/util/Locale;", "textLocale$annotations", "getTextLocale$ui_text_release", "()Ljava/util/Locale;", "textPaint", "Landroid/text/TextPaint;", "textPaint$annotations", "getTextPaint$ui_text_release", "()Landroid/text/TextPaint;", "width", "getWidth", "wordBoundary", "Landroidx/text/selection/WordBoundary;", "getWordBoundary", "()Landroidx/text/selection/WordBoundary;", "wordBoundary$delegate", "Lkotlin/Lazy;", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "getBoundingBox", "Landroidx/ui/engine/geometry/Rect;", "getCursorRect", "getLineBottom", "lineIndex", "getLineForOffset", "getLineHeight", "getLineLeft", "getLineRight", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/ui/core/PxPosition;", "getParagraphDirection", "getPathForRange", "Landroidx/ui/graphics/Path;", "start", "end", "getPrimaryHorizontal", "getSecondaryHorizontal", "Landroidx/ui/text/TextRange;", "isEllipsisApplied", "isEllipsisApplied$ui_text_release", "paint", "", "canvas", "Landroidx/ui/graphics/Canvas;", "ui-text_release"})
public final class AndroidParagraph
implements Paragraph {
    private final TextLayout layout;
    private final float width;
    private final Lazy wordBoundary$delegate;
    @NotNull
    private final AndroidParagraphIntrinsics paragraphIntrinsics;
    @Nullable
    private final Integer maxLines;
    @Nullable
    private final Boolean ellipsis;
    @NotNull
    private final ParagraphConstraints constraints;

    @Override
    public float getWidth() {
        return this.width;
    }

    @Override
    public float getHeight() {
        TextLayout textLayout = this.layout;
        boolean bl = false;
        boolean bl2 = false;
        TextLayout it = textLayout;
        boolean bl3 = false;
        int lineCount = it.getLineCount();
        return this.maxLines != null && this.maxLines >= 0 && this.maxLines < lineCount ? it.getLineBottom(this.maxLines - 1) : (float)it.getHeight();
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.paragraphIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.paragraphIntrinsics.getMinIntrinsicWidth();
    }

    @Override
    public float getFirstBaseline() {
        return this.layout.getLineBaseline(0);
    }

    @Override
    public float getLastBaseline() {
        int n;
        return this.maxLines != null && 0 <= (n = this.maxLines.intValue()) && this.getLineCount() > n ? this.layout.getLineBaseline(this.maxLines - 1) : this.layout.getLineBaseline(this.getLineCount() - 1);
    }

    @Override
    public boolean getDidExceedMaxLines() {
        return this.layout.getDidExceedMaxLines();
    }

    @VisibleForTesting
    public static /* synthetic */ void textLocale$annotations() {
    }

    @NotNull
    public final Locale getTextLocale$ui_text_release() {
        Locale locale = this.paragraphIntrinsics.getTextPaint$ui_text_release().getTextLocale();
        Intrinsics.checkExpressionValueIsNotNull((Object)locale, (String)"paragraphIntrinsics.textPaint.textLocale");
        return locale;
    }

    @Override
    public int getLineCount() {
        return this.layout.getLineCount();
    }

    @VisibleForTesting
    public static /* synthetic */ void charSequence$annotations() {
    }

    @NotNull
    public final CharSequence getCharSequence$ui_text_release() {
        return this.paragraphIntrinsics.getCharSequence$ui_text_release();
    }

    @VisibleForTesting
    public static /* synthetic */ void textPaint$annotations() {
    }

    @NotNull
    public final TextPaint getTextPaint$ui_text_release() {
        return this.paragraphIntrinsics.getTextPaint$ui_text_release();
    }

    @Override
    public int getOffsetForPosition(@NotNull PxPosition position) {
        PxPosition this_$iv;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        PxPosition pxPosition = position;
        TextLayout textLayout = this.layout;
        long value$iv$iv = this_$iv.getValue();
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv & 0xFFFFFFFFL);
        boolean bl = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n);
        Px px = new Px($this$px$iv$iv);
        int line = textLayout.getLineForVertical((int)px.getValue());
        this_$iv = position;
        int n2 = line;
        textLayout = this.layout;
        value$iv$iv = this_$iv.getValue();
        floatCompanionObject = FloatCompanionObject.INSTANCE;
        n = (int)(value$iv$iv >> 32);
        bl = false;
        $this$px$iv$iv = Float.intBitsToFloat(n);
        Px px2 = new Px($this$px$iv$iv);
        return textLayout.getOffsetForHorizontal(n2, px2.getValue());
    }

    @Override
    @NotNull
    public Rect getBoundingBox(int offset) {
        float left = this.layout.getPrimaryHorizontal(offset);
        float right = this.layout.getPrimaryHorizontal(offset + 1);
        int line = this.layout.getLineForOffset(offset);
        float top = this.layout.getLineTop(line);
        float bottom = this.layout.getLineBottom(line);
        float f = right;
        float f2 = left;
        float f3 = bottom;
        float f4 = top;
        return new Rect(f2, f4, f, f3);
    }

    @Override
    @NotNull
    public androidx.ui.graphics.Path getPathForRange(int start, int end) {
        int n = start;
        if (0 > n || end < n || end > this.getCharSequence$ui_text_release().length()) {
            throw (Throwable)((Object)new AssertionError((Object)("Start(" + start + ") or End(" + end + ") is out of Range(0.." + this.getCharSequence$ui_text_release().length() + ")," + " or start > end!")));
        }
        Path path = new Path();
        this.layout.getSelectionPath(start, end, path);
        return new androidx.ui.graphics.Path(path);
    }

    @Override
    @NotNull
    public Rect getCursorRect(int offset) {
        int n = offset;
        if (0 > n || this.getCharSequence$ui_text_release().length() < n) {
            throw (Throwable)((Object)new AssertionError((Object)("offset(" + offset + ") is out of bounds (0," + this.getCharSequence$ui_text_release().length())));
        }
        float cursorWidth = 4.0f;
        float horizontal = this.layout.getPrimaryHorizontal(offset);
        int line = this.layout.getLineForOffset(offset);
        return new Rect(horizontal - 0.5f * cursorWidth, this.layout.getLineTop(line), horizontal + 0.5f * cursorWidth, this.layout.getLineBottom(line));
    }

    private final WordBoundary getWordBoundary() {
        Lazy lazy = this.wordBoundary$delegate;
        AndroidParagraph androidParagraph = this;
        Object var3_3 = null;
        boolean bl = false;
        return (WordBoundary)lazy.getValue();
    }

    @Override
    @NotNull
    public TextRange getWordBoundary(int offset) {
        return new TextRange(this.getWordBoundary().getWordStart(offset), this.getWordBoundary().getWordEnd(offset));
    }

    @Override
    public float getLineLeft(int lineIndex) {
        return this.layout.getLineLeft(lineIndex);
    }

    @Override
    public float getLineRight(int lineIndex) {
        return this.layout.getLineRight(lineIndex);
    }

    @Override
    public float getLineBottom(int lineIndex) {
        return this.layout.getLineBottom(lineIndex);
    }

    @Override
    public float getLineHeight(int lineIndex) {
        return this.layout.getLineHeight(lineIndex);
    }

    @Override
    public float getLineWidth(int lineIndex) {
        return this.layout.getLineWidth(lineIndex);
    }

    @Override
    public int getLineForOffset(int offset) {
        return this.layout.getLineForOffset(offset);
    }

    @Override
    public float getPrimaryHorizontal(int offset) {
        return this.layout.getPrimaryHorizontal(offset);
    }

    @Override
    public float getSecondaryHorizontal(int offset) {
        return this.layout.getSecondaryHorizontal(offset);
    }

    @Override
    @NotNull
    public TextDirection getParagraphDirection(int offset) {
        int lineIndex = this.layout.getLineForOffset(offset);
        int direction = this.layout.getParagraphDirection(lineIndex);
        return direction == 1 ? TextDirection.Ltr : TextDirection.Rtl;
    }

    @Override
    @NotNull
    public TextDirection getBidiRunDirection(int offset) {
        return this.layout.isRtlCharAt(offset) ? TextDirection.Rtl : TextDirection.Ltr;
    }

    public final boolean isEllipsisApplied$ui_text_release(int lineIndex) {
        return this.layout.isEllipsisApplied(lineIndex);
    }

    @Override
    public void paint(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        android.graphics.Canvas nativeCanvas = canvas.getNativeCanvas();
        if (this.getDidExceedMaxLines()) {
            nativeCanvas.save();
            nativeCanvas.clipRect(0.0f, 0.0f, this.getWidth(), this.getHeight());
        }
        this.layout.paint(nativeCanvas);
        if (this.getDidExceedMaxLines()) {
            nativeCanvas.restore();
        }
    }

    @NotNull
    public final AndroidParagraphIntrinsics getParagraphIntrinsics() {
        return this.paragraphIntrinsics;
    }

    @Nullable
    public final Integer getMaxLines() {
        return this.maxLines;
    }

    @Nullable
    public final Boolean getEllipsis() {
        return this.ellipsis;
    }

    @NotNull
    public final ParagraphConstraints getConstraints() {
        return this.constraints;
    }

    /*
     * Unable to fully structure code
     */
    public AndroidParagraph(@NotNull AndroidParagraphIntrinsics paragraphIntrinsics, @Nullable Integer maxLines, @Nullable Boolean ellipsis, @NotNull ParagraphConstraints constraints) {
        Intrinsics.checkParameterIsNotNull((Object)paragraphIntrinsics, (String)"paragraphIntrinsics");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        super();
        this.paragraphIntrinsics = paragraphIntrinsics;
        this.maxLines = maxLines;
        this.ellipsis = ellipsis;
        this.constraints = constraints;
        v0 = this.maxLines;
        if (v0 != null) {
            var5_5 = v0;
            var6_6 = false;
            var7_7 = false;
            it = ((Number)var5_5).intValue();
            $i$a$-let-AndroidParagraph$1 = false;
            var10_11 = it >= 1;
            var11_13 = false;
            var12_15 = false;
            if (!var10_11) {
                $i$a$-require-AndroidParagraph$1$1 = false;
                var12_16 = "maxLines should be greater than 0";
                throw (Throwable)new IllegalArgumentException(var12_16.toString());
            }
        }
        paragraphStyle = this.paragraphIntrinsics.getParagraphStyle();
        alignment = AndroidParagraphKt.access$toLayoutAlign(paragraphStyle.getTextAlign());
        v1 = this.maxLines;
        maxLines = v1 != null ? v1 : 0x7FFFFFFF;
        v2 = paragraphStyle.getTextAlign();
        if (v2 == null) ** GOTO lbl-1000
        switch (AndroidParagraph$WhenMappings.$EnumSwitchMapping$0[v2.ordinal()]) {
            case 1: {
                v3 = 1;
                break;
            }
            default: lbl-1000:
            // 2 sources

            {
                v3 = 0;
            }
        }
        justificationMode = v3;
        ellipsize = Intrinsics.areEqual((Object)this.ellipsis, (Object)true) != false ? TextUtils.TruncateAt.END : null;
        this.width = this.constraints.getWidth();
        var10_12 = this.paragraphIntrinsics.getLayoutIntrinsics$ui_text_release();
        var11_14 = null;
        var12_17 = null;
        var13_19 = justificationMode;
        var14_20 = 0;
        var15_21 = 0;
        var16_22 = maxLines;
        var17_23 = false;
        var18_24 = 0.0f;
        var19_25 = 1.0f;
        var20_26 = this.paragraphIntrinsics.getTextDirectionHeuristic$ui_text_release();
        var21_27 = alignment;
        var22_28 = ellipsize;
        this.layout = new TextLayout(this.paragraphIntrinsics.getCharSequence$ui_text_release(), this.constraints.getWidth(), this.getTextPaint$ui_text_release(), var21_27, var22_28, var20_26, var19_25, var18_24, var17_23, var16_22, var15_21, var14_20, var13_19, var12_17, var11_14, var10_12, 28032, null);
        this.wordBoundary$delegate = LazyKt.lazy((Function0)((Function0)new Function0<WordBoundary>(this){
            final /* synthetic */ AndroidParagraph this$0;

            @NotNull
            public final WordBoundary invoke() {
                return new WordBoundary(this.this$0.getTextLocale$ui_text_release(), AndroidParagraph.access$getLayout$p(this.this$0).getText());
            }
            {
                this.this$0 = androidParagraph;
                super(0);
            }
        }));
    }

    public AndroidParagraph(@NotNull String text, @NotNull TextStyle style, @NotNull ParagraphStyle paragraphStyle, @NotNull List<AnnotatedString.Item<TextStyle>> textStyles, @Nullable Integer maxLines, @Nullable Boolean ellipsis, @NotNull ParagraphConstraints constraints, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)paragraphStyle, (String)"paragraphStyle");
        Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        this(new AndroidParagraphIntrinsics(text, style, paragraphStyle, textStyles, typefaceAdapter, density), maxLines, ellipsis, constraints);
    }

    public static final /* synthetic */ TextLayout access$getLayout$p(AndroidParagraph $this) {
        return $this.layout;
    }
}

