/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LocaleSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.RequiresApi;
import androidx.text.style.BaselineShiftSpan;
import androidx.text.style.FontFeatureSpan;
import androidx.text.style.LetterSpacingSpan;
import androidx.text.style.LineHeightSpan;
import androidx.text.style.ShadowSpan;
import androidx.text.style.SkewXSpan;
import androidx.text.style.TypefaceSpan;
import androidx.ui.core.Density;
import androidx.ui.core.DensityKt;
import androidx.ui.core.DensityScope;
import androidx.ui.core.Em;
import androidx.ui.core.Sp;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Shadow;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.Locale;
import androidx.ui.text.LocaleList;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.platform.AndroidLocale;
import androidx.ui.text.platform.AndroidParagraphHelperKt$WhenMappings;
import androidx.ui.text.platform.PlatformLocale;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextIndent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aH\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\b\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a$\u0010\u0017\u001a\u00020\u000b*\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u000bH\u0002\u001a\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0003\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002\u00a8\u0006!"}, d2={"createStyledText", "", "text", "", "lineHeight", "Landroidx/ui/core/Sp;", "textIndent", "Landroidx/ui/text/style/TextIndent;", "textStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/TextStyle;", "density", "Landroidx/ui/core/Density;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "createTypeface", "Landroid/graphics/Typeface;", "style", "resolveTextDirectionHeuristics", "", "textDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "applyTextStyle", "Landroid/text/TextPaint;", "hasFontAttributes", "", "toAndroidLocaleList", "Landroid/os/LocaleList;", "Landroidx/ui/text/LocaleList;", "toJavaLocale", "Ljava/util/Locale;", "Landroidx/ui/text/Locale;", "ui-text_release"})
public final class AndroidParagraphHelperKt {
    @NotNull
    public static final TextStyle applyTextStyle(@NotNull TextPaint $this$applyTextStyle, @NotNull TextStyle style, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Object object;
        Object object2;
        boolean bl;
        boolean bl2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)$this$applyTextStyle, (String)"$this$applyTextStyle");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Sp sp = style.getFontSize();
        if (sp != null) {
            object3 = sp;
            bl2 = false;
            bl = false;
            Sp it = object3;
            boolean bl3 = false;
            DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>(it, $this$applyTextStyle, density){
                final /* synthetic */ Sp $it;
                final /* synthetic */ TextPaint $this_applyTextStyle$inlined;
                final /* synthetic */ Density $density$inlined;
                {
                    this.$it = sp;
                    this.$this_applyTextStyle$inlined = textPaint;
                    this.$density$inlined = density;
                    super(1);
                }

                public final void invoke(@NotNull DensityScope $this$withDensity) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                    this.$this_applyTextStyle$inlined.setTextSize($this$withDensity.toPx(this.$it).getValue());
                }
            }));
        }
        Float f = style.getFontSizeScale();
        if (f != null) {
            object3 = f;
            bl2 = false;
            bl = false;
            float it = ((Number)object3).floatValue();
            boolean bl4 = false;
            TextPaint textPaint = $this$applyTextStyle;
            textPaint.setTextSize(textPaint.getTextSize() * it);
        }
        if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
            $this$applyTextStyle.setTypeface(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter));
        }
        LocaleList localeList = style.getLocaleList();
        if (localeList != null) {
            object3 = localeList;
            bl2 = false;
            bl = false;
            Object it = object3;
            boolean bl5 = false;
            if (Build.VERSION.SDK_INT >= 24) {
                $this$applyTextStyle.setTextLocales(AndroidParagraphHelperKt.toAndroidLocaleList((LocaleList)it));
            } else {
                Locale locale = ((LocaleList)it).isEmpty() ? Locale.Companion.getCurrent() : ((LocaleList)it).get(0);
                $this$applyTextStyle.setTextLocale(AndroidParagraphHelperKt.toJavaLocale(locale));
            }
        }
        Color color = style.getColor();
        if (color != null) {
            object3 = color;
            bl2 = false;
            bl = false;
            Object it = object3;
            boolean bl6 = false;
            $this$applyTextStyle.setColor(ColorKt.toArgb((Color)it));
        }
        Em em = style.getLetterSpacing();
        if (em != null) {
            object3 = em;
            bl2 = false;
            bl = false;
            Object it = object3;
            boolean bl7 = false;
            $this$applyTextStyle.setLetterSpacing(it.getValue());
        }
        String string = style.getFontFeatureSettings();
        if (string != null) {
            object3 = string;
            bl2 = false;
            bl = false;
            Object it = object3;
            boolean bl8 = false;
            $this$applyTextStyle.setFontFeatureSettings((String)it);
        }
        if ((object2 = style.getTextGeometricTransform()) != null && (object2 = ((TextGeometricTransform)object2).getScaleX()) != null) {
            object3 = object2;
            bl2 = false;
            bl = false;
            float it = ((Number)object3).floatValue();
            boolean bl9 = false;
            TextPaint textPaint = $this$applyTextStyle;
            textPaint.setTextScaleX(textPaint.getTextScaleX() * it);
        }
        if ((object = style.getTextGeometricTransform()) != null && (object = ((TextGeometricTransform)object).getSkewX()) != null) {
            object3 = object;
            bl2 = false;
            bl = false;
            float it = ((Number)object3).floatValue();
            boolean bl10 = false;
            TextPaint textPaint = $this$applyTextStyle;
            textPaint.setTextSkewX(textPaint.getTextSkewX() + it);
        }
        Shadow shadow = style.getShadow();
        if (shadow != null) {
            object3 = shadow;
            bl2 = false;
            bl = false;
            Object it = object3;
            boolean bl11 = false;
            $this$applyTextStyle.setShadowLayer(it.getBlurRadius().getValue(), it.getOffset().getDx(), it.getOffset().getDy(), ColorKt.toArgb((Color)it.getColor()));
        }
        TextDecoration textDecoration = style.getDecoration();
        if (textDecoration != null) {
            object3 = textDecoration;
            bl2 = false;
            bl = false;
            Object it = object3;
            boolean bl12 = false;
            if (((TextDecoration)it).contains(TextDecoration.Companion.getUnderline())) {
                $this$applyTextStyle.setUnderlineText(true);
            }
            if (((TextDecoration)it).contains(TextDecoration.Companion.getLineThrough())) {
                $this$applyTextStyle.setStrikeThruText(true);
            }
        }
        object3 = null;
        TextDecoration textDecoration2 = null;
        BaselineShift baselineShift = style.getBaselineShift();
        LocaleList localeList2 = null;
        TextGeometricTransform textGeometricTransform = null;
        Color color2 = style.getBackground();
        return new TextStyle(null, null, null, null, null, null, null, null, null, baselineShift, textGeometricTransform, localeList2, color2, textDecoration2, (Shadow)object3, 28159, null);
    }

    @NotNull
    public static final CharSequence createStyledText(@NotNull String text, @Nullable Sp lineHeight, @Nullable TextIndent textIndent, @NotNull List<AnnotatedString.Item<TextStyle>> textStyles, @NotNull Density density, @NotNull TypefaceAdapter typefaceAdapter) {
        SpannableString spannableString;
        block22: {
            Object indent;
            block23: {
                boolean $this$sp$iv;
                Sp sp;
                boolean bl;
                boolean bl2;
                Object object;
                Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
                Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
                Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
                Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
                if (textStyles.isEmpty() && textIndent == null) {
                    return text;
                }
                spannableString = new SpannableString((CharSequence)text);
                Sp sp2 = lineHeight;
                if (sp2 != null) {
                    object = sp2;
                    bl2 = false;
                    bl = false;
                    Object it = object;
                    boolean bl3 = false;
                    DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>((Sp)it, density, spannableString, text){
                        final /* synthetic */ Sp $it;
                        final /* synthetic */ Density $density$inlined;
                        final /* synthetic */ SpannableString $spannableString$inlined;
                        final /* synthetic */ String $text$inlined;
                        {
                            this.$it = sp;
                            this.$density$inlined = density;
                            this.$spannableString$inlined = spannableString;
                            this.$text$inlined = string;
                            super(1);
                        }

                        public final void invoke(@NotNull DensityScope $this$withDensity) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                            float f = $this$withDensity.toPx(this.$it).getValue();
                            SpannableString spannableString = this.$spannableString$inlined;
                            boolean bl = false;
                            float f2 = (float)Math.ceil(f);
                            int n = (int)f2;
                            spannableString.setSpan((Object)new LineHeightSpan(n), 0, this.$text$inlined.length(), 33);
                        }
                    }));
                }
                TextIndent textIndent2 = textIndent;
                if (textIndent2 == null) break block22;
                object = textIndent2;
                bl2 = false;
                bl = false;
                indent = object;
                boolean bl4 = false;
                boolean bl5 = false;
                Sp sp3 = ((TextIndent)indent).getFirstLine();
                if (!Intrinsics.areEqual((Object)sp3, (Object)(sp = new Sp((float)$this$sp$iv)))) break block23;
                $this$sp$iv = false;
                sp3 = ((TextIndent)indent).getRestLine();
                if (Intrinsics.areEqual((Object)sp3, (Object)(sp = new Sp((float)$this$sp$iv)))) break block22;
            }
            DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>((TextIndent)indent, density, spannableString, text){
                final /* synthetic */ TextIndent $indent;
                final /* synthetic */ Density $density$inlined;
                final /* synthetic */ SpannableString $spannableString$inlined;
                final /* synthetic */ String $text$inlined;
                {
                    this.$indent = textIndent;
                    this.$density$inlined = density;
                    this.$spannableString$inlined = spannableString;
                    this.$text$inlined = string;
                    super(1);
                }

                public final void invoke(@NotNull DensityScope $this$withDensity) {
                    Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                    this.$spannableString$inlined.setSpan((Object)new LeadingMarginSpan.Standard((int)$this$withDensity.toPx(this.$indent.getFirstLine()).getValue(), (int)$this$withDensity.toPx(this.$indent.getRestLine()).getValue()), 0, this.$text$inlined.length(), 33);
                }
            }));
        }
        for (AnnotatedString.Item<TextStyle> textStyle : textStyles) {
            Shadow shadow;
            Object object;
            Object object2;
            Object it;
            int start = textStyle.getStart();
            int end = textStyle.getEnd();
            TextStyle style = textStyle.getStyle();
            if (start < 0 || start >= text.length() || end <= start || end > text.length()) continue;
            if (style.getBaselineShift() != null) {
                BaselineShift baselineShift;
                boolean bl = false;
                boolean bl6 = false;
                it = baselineShift;
                boolean bl7 = false;
                spannableString.setSpan((Object)new BaselineShiftSpan(((BaselineShift)it).getMultiplier()), start, end, 33);
            }
            if (style.getColor() != null) {
                Color color;
                boolean bl = false;
                boolean bl8 = false;
                it = color;
                boolean bl9 = false;
                spannableString.setSpan((Object)new ForegroundColorSpan(ColorKt.toArgb((Color)it)), start, end, 33);
            }
            if (style.getDecoration() != null) {
                TextDecoration textDecoration;
                boolean bl = false;
                boolean bl10 = false;
                it = textDecoration;
                boolean bl11 = false;
                if (((TextDecoration)it).contains(TextDecoration.Companion.getUnderline())) {
                    spannableString.setSpan((Object)new UnderlineSpan(), start, end, 33);
                }
                if (((TextDecoration)it).contains(TextDecoration.Companion.getLineThrough())) {
                    spannableString.setSpan((Object)new StrikethroughSpan(), start, end, 33);
                }
            }
            if (style.getFontSize() != null) {
                Sp sp;
                boolean bl = false;
                boolean bl12 = false;
                it = sp;
                boolean bl13 = false;
                DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>((Sp)it, density, spannableString, start, end){
                    final /* synthetic */ Sp $it;
                    final /* synthetic */ Density $density$inlined;
                    final /* synthetic */ SpannableString $spannableString$inlined;
                    final /* synthetic */ int $start$inlined;
                    final /* synthetic */ int $end$inlined;
                    {
                        this.$it = sp;
                        this.$density$inlined = density;
                        this.$spannableString$inlined = spannableString;
                        this.$start$inlined = n;
                        this.$end$inlined = n2;
                        super(1);
                    }

                    public final void invoke(@NotNull DensityScope $this$withDensity) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                        this.$spannableString$inlined.setSpan((Object)new AbsoluteSizeSpan(MathKt.roundToInt((float)$this$withDensity.toPx(this.$it).getValue()), true), this.$start$inlined, this.$end$inlined, 33);
                    }
                }));
            }
            if (style.getFontSizeScale() != null) {
                Float f;
                boolean bl = false;
                boolean bl14 = false;
                float it2 = ((Number)f).floatValue();
                boolean bl15 = false;
                spannableString.setSpan((Object)new RelativeSizeSpan(it2), start, end, 33);
            }
            if (style.getFontFeatureSettings() != null) {
                String string;
                boolean bl = false;
                boolean bl16 = false;
                String it3 = string;
                boolean bl17 = false;
                spannableString.setSpan((Object)new FontFeatureSpan(it3), start, end, 33);
            }
            if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
                spannableString.setSpan((Object)new TypefaceSpan(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter)), start, end, 33);
            }
            if ((object2 = style.getTextGeometricTransform()) != null && (object2 = ((TextGeometricTransform)object2).getScaleX()) != null) {
                Object object3 = object2;
                boolean bl = false;
                boolean bl18 = false;
                float it4 = ((Number)object3).floatValue();
                boolean bl19 = false;
                spannableString.setSpan((Object)new ScaleXSpan(it4), start, end, 33);
            }
            if ((object = style.getTextGeometricTransform()) != null && (object = ((TextGeometricTransform)object).getSkewX()) != null) {
                Object object4 = object;
                boolean bl = false;
                boolean bl20 = false;
                float it5 = ((Number)object4).floatValue();
                boolean bl21 = false;
                spannableString.setSpan((Object)new SkewXSpan(it5), start, end, 33);
            }
            if (style.getLetterSpacing() != null) {
                Em em;
                boolean bl = false;
                boolean bl22 = false;
                Em it6 = em;
                boolean bl23 = false;
                spannableString.setSpan((Object)new LetterSpacingSpan(it6.getValue()), start, end, 33);
            }
            if (style.getLocaleList() != null) {
                LocaleSpan localeSpan;
                LocaleList localeList;
                boolean bl = false;
                boolean bl24 = false;
                LocaleList it7 = localeList;
                boolean bl25 = false;
                if (Build.VERSION.SDK_INT >= 24) {
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toAndroidLocaleList(it7));
                } else {
                    Locale locale = it7.isEmpty() ? Locale.Companion.getCurrent() : it7.get(0);
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toJavaLocale(locale));
                }
                spannableString.setSpan((Object)localeSpan, start, end, 33);
            }
            if (style.getBackground() != null) {
                Color color;
                boolean bl = false;
                boolean bl26 = false;
                Color it8 = color;
                boolean bl27 = false;
                spannableString.setSpan((Object)new BackgroundColorSpan(ColorKt.toArgb((Color)it8)), start, end, 33);
            }
            if (style.getShadow() == null) continue;
            boolean bl = false;
            boolean bl28 = false;
            Shadow it9 = shadow;
            boolean bl29 = false;
            spannableString.setSpan((Object)new ShadowSpan(ColorKt.toArgb((Color)it9.getColor()), it9.getOffset().getDx(), it9.getOffset().getDy(), it9.getBlurRadius().getValue()), start, end, 33);
        }
        return (CharSequence)spannableString;
    }

    private static final boolean hasFontAttributes(@NotNull TextStyle $this$hasFontAttributes) {
        return $this$hasFontAttributes.getFontFamily() != null || $this$hasFontAttributes.getFontStyle() != null || $this$hasFontAttributes.getFontWeight() != null;
    }

    private static final Typeface createTypeface(TextStyle style, TypefaceAdapter typefaceAdapter) {
        FontSynthesis fontSynthesis;
        FontStyle fontStyle;
        FontFamily fontFamily = style.getFontFamily();
        FontWeight fontWeight = style.getFontWeight();
        if (fontWeight == null) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((fontStyle = style.getFontStyle()) == null) {
            fontStyle = FontStyle.Normal;
        }
        if ((fontSynthesis = style.getFontSynthesis()) == null) {
            fontSynthesis = FontSynthesis.All;
        }
        return typefaceAdapter.create(fontFamily, fontWeight, fontStyle, fontSynthesis);
    }

    public static final int resolveTextDirectionHeuristics(@NotNull TextDirectionAlgorithm textDirectionAlgorithm) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textDirectionAlgorithm), (String)"textDirectionAlgorithm");
        switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$0[textDirectionAlgorithm.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final java.util.Locale toJavaLocale(@NotNull Locale $this$toJavaLocale) {
        PlatformLocale platformLocale = $this$toJavaLocale.getPlatformLocale$ui_text_release();
        if (platformLocale == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.ui.text.platform.AndroidLocale");
        }
        return ((AndroidLocale)platformLocale).getJavaLocale();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=24)
    private static final android.os.LocaleList toAndroidLocaleList(@NotNull LocaleList $this$toAndroidLocaleList) {
        Collection<java.util.Locale> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toAndroidLocaleList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Locale locale = (Locale)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            java.util.Locale locale2 = AndroidParagraphHelperKt.toJavaLocale((Locale)it);
            collection.add(locale2);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        java.util.Locale[] localeArray = thisCollection$iv.toArray(new java.util.Locale[0]);
        if (localeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = localeArray;
        java.util.Locale[] localeArray2 = (java.util.Locale[])collection;
        java.util.Locale[] localeArray3 = Arrays.copyOf(localeArray2, localeArray2.length);
        return new android.os.LocaleList(localeArray3);
    }
}

