/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.text.TextPaint;
import androidx.text.LayoutIntrinsics;
import androidx.ui.core.Density;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.ParagraphIntrinsics;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextStyle;
import androidx.ui.text.platform.AndroidParagraphHelperKt;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.style.TextDirectionAlgorithm;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\r\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u000b\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0007\b\u0000\u0018\u00002\u00020\u0001BA\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t\u0012\u0006\u0010\u000b\u001a\u00020\f\u0012\u0006\u0010\r\u001a\u00020\u000e\u00a2\u0006\u0002\u0010\u000fR\u0014\u0010\u0010\u001a\u00020\u0011X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\r\u001a\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0017X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001dR\u0014\u0010\u001e\u001a\u00020\u001b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u001f\u0010\u001dR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010!R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010#R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020+X\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u001d\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00050\n0\t\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0011\u0010\u000b\u001a\u00020\f\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101\u00a8\u00062"}, d2={"Landroidx/ui/text/platform/AndroidParagraphIntrinsics;", "Landroidx/ui/text/ParagraphIntrinsics;", "text", "", "style", "Landroidx/ui/text/TextStyle;", "paragraphStyle", "Landroidx/ui/text/ParagraphStyle;", "textStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "density", "Landroidx/ui/core/Density;", "(Ljava/lang/String;Landroidx/ui/text/TextStyle;Landroidx/ui/text/ParagraphStyle;Ljava/util/List;Landroidx/ui/text/platform/TypefaceAdapter;Landroidx/ui/core/Density;)V", "charSequence", "", "getCharSequence$ui_text_release", "()Ljava/lang/CharSequence;", "getDensity", "()Landroidx/ui/core/Density;", "layoutIntrinsics", "Landroidx/text/LayoutIntrinsics;", "getLayoutIntrinsics$ui_text_release", "()Landroidx/text/LayoutIntrinsics;", "maxIntrinsicWidth", "", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "getParagraphStyle", "()Landroidx/ui/text/ParagraphStyle;", "getStyle", "()Landroidx/ui/text/TextStyle;", "getText", "()Ljava/lang/String;", "textDirectionHeuristic", "", "getTextDirectionHeuristic$ui_text_release", "()I", "textPaint", "Landroid/text/TextPaint;", "getTextPaint$ui_text_release", "()Landroid/text/TextPaint;", "getTextStyles", "()Ljava/util/List;", "getTypefaceAdapter", "()Landroidx/ui/text/platform/TypefaceAdapter;", "ui-text_release"})
public final class AndroidParagraphIntrinsics
implements ParagraphIntrinsics {
    @NotNull
    private final TextPaint textPaint;
    @NotNull
    private final CharSequence charSequence;
    @NotNull
    private final LayoutIntrinsics layoutIntrinsics;
    private final int textDirectionHeuristic;
    @NotNull
    private final String text;
    @NotNull
    private final TextStyle style;
    @NotNull
    private final ParagraphStyle paragraphStyle;
    @NotNull
    private final List<AnnotatedString.Item<TextStyle>> textStyles;
    @NotNull
    private final TypefaceAdapter typefaceAdapter;
    @NotNull
    private final Density density;

    @NotNull
    public final TextPaint getTextPaint$ui_text_release() {
        return this.textPaint;
    }

    @NotNull
    public final CharSequence getCharSequence$ui_text_release() {
        return this.charSequence;
    }

    @NotNull
    public final LayoutIntrinsics getLayoutIntrinsics$ui_text_release() {
        return this.layoutIntrinsics;
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.layoutIntrinsics.getMaxIntrinsicWidth();
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.layoutIntrinsics.getMinIntrinsicWidth();
    }

    public final int getTextDirectionHeuristic$ui_text_release() {
        return this.textDirectionHeuristic;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    @NotNull
    public final ParagraphStyle getParagraphStyle() {
        return this.paragraphStyle;
    }

    @NotNull
    public final List<AnnotatedString.Item<TextStyle>> getTextStyles() {
        return this.textStyles;
    }

    @NotNull
    public final TypefaceAdapter getTypefaceAdapter() {
        return this.typefaceAdapter;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    public AndroidParagraphIntrinsics(@NotNull String text, @NotNull TextStyle style, @NotNull ParagraphStyle paragraphStyle, @NotNull List<AnnotatedString.Item<TextStyle>> textStyles, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)paragraphStyle, (String)"paragraphStyle");
        Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        this.text = text;
        this.style = style;
        this.paragraphStyle = paragraphStyle;
        this.textStyles = textStyles;
        this.typefaceAdapter = typefaceAdapter;
        this.density = density;
        this.textPaint = new TextPaint(1);
        TextDirectionAlgorithm textDirectionAlgorithm = this.paragraphStyle.getTextDirectionAlgorithm();
        if (textDirectionAlgorithm == null) {
            throw (Throwable)new IllegalArgumentException("ParagraphStyle.textDirectionAlgorithm should not be null");
        }
        TextDirectionAlgorithm textDirectionAlgorithm2 = textDirectionAlgorithm;
        AndroidParagraphIntrinsics androidParagraphIntrinsics = this;
        boolean bl = false;
        boolean bl2 = false;
        TextDirectionAlgorithm it = textDirectionAlgorithm2;
        boolean bl3 = false;
        int n = AndroidParagraphHelperKt.resolveTextDirectionHeuristics(this.paragraphStyle.getTextDirectionAlgorithm());
        androidParagraphIntrinsics.textDirectionHeuristic = n;
        TextStyle notAppliedStyle = AndroidParagraphHelperKt.applyTextStyle(this.textPaint, this.style, this.typefaceAdapter, this.density);
        this.charSequence = AndroidParagraphHelperKt.createStyledText(this.text, this.paragraphStyle.getLineHeight(), this.paragraphStyle.getTextIndent(), CollectionsKt.plus((Collection)CollectionsKt.listOf(new AnnotatedString.Item<TextStyle>(notAppliedStyle, 0, this.text.length())), (Iterable)this.textStyles), this.density, this.typefaceAdapter);
        this.layoutIntrinsics = new LayoutIntrinsics(this.charSequence, this.textPaint, this.textDirectionHeuristic);
    }
}

