/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import androidx.collection.LruCache;
import androidx.ui.text.font.Font;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontMatcher;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000R\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 !2\u00020\u0001:\u0002 !B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u000e2\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0015\u001a\u0004\u0018\u00010\u00162\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0016\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\u001a2\u0006\u0010\u001b\u001a\u00020\u001aJ.\u0010\u001c\u001a\u00020\f2\u0006\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\""}, d2={"Landroidx/ui/text/platform/TypefaceAdapter;", "", "fontMatcher", "Landroidx/ui/text/font/FontMatcher;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/font/FontMatcher;Landroidx/ui/text/font/Font$ResourceLoader;)V", "getFontMatcher", "()Landroidx/ui/text/font/FontMatcher;", "getResourceLoader", "()Landroidx/ui/text/font/Font$ResourceLoader;", "create", "Landroid/graphics/Typeface;", "fontFamily", "Landroidx/ui/text/font/FontFamily;", "fontWeight", "Landroidx/ui/text/font/FontWeight;", "fontStyle", "Landroidx/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/ui/text/font/FontSynthesis;", "genericFontFamily", "", "getTypefaceStyle", "", "isBold", "", "isItalic", "synthesize", "typeface", "font", "Landroidx/ui/text/font/Font;", "CacheKey", "Companion", "ui-text_release"})
public class TypefaceAdapter {
    @NotNull
    private final FontMatcher fontMatcher;
    @NotNull
    private final Font.ResourceLoader resourceLoader;
    private static final FontWeight ANDROID_BOLD;
    @NotNull
    private static final LruCache<CacheKey, Typeface> typefaceCache;
    public static final Companion Companion;

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    @NotNull
    public Typeface create(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
        Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkParameterIsNotNull((Object)fontStyle, (String)"fontStyle");
        Intrinsics.checkParameterIsNotNull((Object)fontSynthesis, (String)"fontSynthesis");
        cacheKey = new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis);
        cachedTypeface = (Typeface)TypefaceAdapter.typefaceCache.get((Object)cacheKey);
        if (cachedTypeface != null) {
            return cachedTypeface;
        }
        if (fontFamily == null) ** GOTO lbl-1000
        var8_7 /* !! */  = fontFamily;
        var9_8 = false;
        if (var8_7 /* !! */ .isEmpty() == false) {
            var8_7 /* !! */  = fontSynthesis;
            var9_9 = fontStyle;
            var10_10 = fontWeight;
            var11_11 = fontFamily;
            v0 = this.create(var9_9, var10_10, var11_11, (FontSynthesis)var8_7 /* !! */ );
        } else lbl-1000:
        // 2 sources

        {
            v1 = fontFamily;
            v0 = this.create(v1 != null ? v1.getGenericFamily() : null, fontWeight, fontStyle);
        }
        typeface = v0;
        TypefaceAdapter.typefaceCache.put((Object)cacheKey, (Object)typeface);
        return typeface;
    }

    public static /* synthetic */ Typeface create$default(TypefaceAdapter typefaceAdapter, FontFamily fontFamily, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            fontFamily = null;
        }
        if ((n & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n & 4) != 0) {
            fontStyle = FontStyle.Normal;
        }
        if ((n & 8) != 0) {
            fontSynthesis = FontSynthesis.All;
        }
        return typefaceAdapter.create(fontFamily, fontWeight, fontStyle, fontSynthesis);
    }

    private final Typeface create(String genericFontFamily, FontWeight fontWeight, FontStyle fontStyle) {
        Typeface result;
        Typeface typeface;
        if (fontStyle == FontStyle.Normal && Intrinsics.areEqual((Object)fontWeight, (Object)FontWeight.Companion.getNormal())) {
            CharSequence charSequence = genericFontFamily;
            boolean bl = false;
            boolean bl2 = false;
            if (charSequence == null || charSequence.length() == 0) {
                Typeface typeface2 = Typeface.DEFAULT;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeface2, (String)"Typeface.DEFAULT");
                return typeface2;
            }
        }
        if (Build.VERSION.SDK_INT < 28) {
            int targetStyle = this.getTypefaceStyle(fontWeight, fontStyle);
            CharSequence charSequence = genericFontFamily;
            boolean bl = false;
            boolean bl3 = false;
            typeface = charSequence == null || charSequence.length() == 0 ? Typeface.defaultFromStyle((int)targetStyle) : Typeface.create((String)genericFontFamily, (int)targetStyle);
        } else {
            Typeface familyTypeface = null;
            if (genericFontFamily == null) {
                Typeface typeface3 = Typeface.DEFAULT;
                Intrinsics.checkExpressionValueIsNotNull((Object)typeface3, (String)"Typeface.DEFAULT");
                familyTypeface = typeface3;
            } else {
                Typeface typeface4 = Typeface.create((String)genericFontFamily, (int)0);
                Intrinsics.checkExpressionValueIsNotNull((Object)typeface4, (String)"Typeface.create(genericF\u2026tFamily, Typeface.NORMAL)");
                familyTypeface = typeface4;
            }
            typeface = Typeface.create((Typeface)familyTypeface, (int)fontWeight.getWeight$ui_text_release(), (fontStyle == FontStyle.Italic ? 1 : 0) != 0);
        }
        Typeface typeface5 = result = typeface;
        Intrinsics.checkExpressionValueIsNotNull((Object)typeface5, (String)"result");
        return typeface5;
    }

    static /* synthetic */ Typeface create$default(TypefaceAdapter typefaceAdapter, String string, FontWeight fontWeight, FontStyle fontStyle, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            string = null;
        }
        if ((n & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n & 4) != 0) {
            fontStyle = FontStyle.Normal;
        }
        return typefaceAdapter.create(string, fontWeight, fontStyle);
    }

    private final Typeface create(FontStyle fontStyle, FontWeight fontWeight, FontFamily fontFamily, FontSynthesis fontSynthesis) {
        boolean loadedFontIsSameAsRequest;
        Typeface typeface;
        Font font = this.fontMatcher.matchFont(fontFamily, fontWeight, fontStyle);
        try {
            Object object = this.resourceLoader.load(font);
            if (object == null) {
                throw new TypeCastException("null cannot be cast to non-null type android.graphics.Typeface");
            }
            typeface = (Typeface)object;
        }
        catch (Exception e) {
            throw (Throwable)new IllegalStateException("Cannot create Typeface from " + font);
        }
        Typeface typeface2 = typeface;
        boolean bl = loadedFontIsSameAsRequest = Intrinsics.areEqual((Object)fontWeight, (Object)font.getWeight()) && fontStyle == font.getStyle();
        if (fontSynthesis == FontSynthesis.None || loadedFontIsSameAsRequest) {
            return typeface2;
        }
        return this.synthesize(typeface2, font, fontWeight, fontStyle, fontSynthesis);
    }

    static /* synthetic */ Typeface create$default(TypefaceAdapter typefaceAdapter, FontStyle fontStyle, FontWeight fontWeight, FontFamily fontFamily, FontSynthesis fontSynthesis, int n, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: create");
        }
        if ((n & 1) != 0) {
            fontStyle = FontStyle.Normal;
        }
        if ((n & 2) != 0) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((n & 8) != 0) {
            fontSynthesis = FontSynthesis.All;
        }
        return typefaceAdapter.create(fontStyle, fontWeight, fontFamily, fontSynthesis);
    }

    @NotNull
    public final Typeface synthesize(@NotNull Typeface typeface, @NotNull Font font, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
        Typeface typeface2;
        boolean synthesizeStyle;
        Intrinsics.checkParameterIsNotNull((Object)typeface, (String)"typeface");
        Intrinsics.checkParameterIsNotNull((Object)font, (String)"font");
        Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fontSynthesis), (String)"fontSynthesis");
        boolean synthesizeWeight = fontSynthesis.isWeightOn$ui_text_release() && fontWeight.compareTo(ANDROID_BOLD) >= 0 && font.getWeight().compareTo(ANDROID_BOLD) < 0;
        boolean bl = synthesizeStyle = fontSynthesis.isStyleOn$ui_text_release() && fontStyle != font.getStyle();
        if (!synthesizeStyle && !synthesizeWeight) {
            return typeface;
        }
        if (Build.VERSION.SDK_INT < 28) {
            int targetStyle = this.getTypefaceStyle(synthesizeWeight, synthesizeStyle && fontStyle == FontStyle.Italic);
            Typeface typeface3 = Typeface.create((Typeface)typeface, (int)targetStyle);
            typeface2 = typeface3;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeface3, (String)"Typeface.create(typeface, targetStyle)");
        } else {
            int finalFontWeight;
            int n = finalFontWeight = synthesizeWeight ? fontWeight.getWeight$ui_text_release() : font.getWeight().getWeight$ui_text_release();
            boolean finalFontStyle = synthesizeStyle ? fontStyle == FontStyle.Italic : font.getStyle() == FontStyle.Italic;
            Typeface typeface4 = Typeface.create((Typeface)typeface, (int)finalFontWeight, (boolean)finalFontStyle);
            typeface2 = typeface4;
            Intrinsics.checkExpressionValueIsNotNull((Object)typeface4, (String)"Typeface.create(typeface\u2026ntWeight, finalFontStyle)");
        }
        return typeface2;
    }

    public final int getTypefaceStyle(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle) {
        Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
        return this.getTypefaceStyle(fontWeight.compareTo(ANDROID_BOLD) >= 0, fontStyle == FontStyle.Italic);
    }

    public final int getTypefaceStyle(boolean isBold, boolean isItalic) {
        return isItalic && isBold ? 3 : (isBold ? 1 : (isItalic ? 2 : 0));
    }

    @NotNull
    public final FontMatcher getFontMatcher() {
        return this.fontMatcher;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public TypefaceAdapter(@NotNull FontMatcher fontMatcher, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)fontMatcher, (String)"fontMatcher");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this.fontMatcher = fontMatcher;
        this.resourceLoader = resourceLoader;
    }

    public /* synthetic */ TypefaceAdapter(FontMatcher fontMatcher, Font.ResourceLoader resourceLoader, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            fontMatcher = new FontMatcher();
        }
        this(fontMatcher, resourceLoader);
    }

    static {
        Companion = new Companion(null);
        ANDROID_BOLD = FontWeight.Companion.getW600();
        typefaceCache = new LruCache(16);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Landroidx/ui/text/platform/TypefaceAdapter$CacheKey;", "", "fontFamily", "Landroidx/ui/text/font/FontFamily;", "fontWeight", "Landroidx/ui/text/font/FontWeight;", "fontStyle", "Landroidx/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/ui/text/font/FontSynthesis;", "(Landroidx/ui/text/font/FontFamily;Landroidx/ui/text/font/FontWeight;Landroidx/ui/text/font/FontStyle;Landroidx/ui/text/font/FontSynthesis;)V", "getFontFamily", "()Landroidx/ui/text/font/FontFamily;", "getFontStyle", "()Landroidx/ui/text/font/FontStyle;", "getFontSynthesis", "()Landroidx/ui/text/font/FontSynthesis;", "getFontWeight", "()Landroidx/ui/text/font/FontWeight;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-text_release"})
    public static final class CacheKey {
        @Nullable
        private final FontFamily fontFamily;
        @NotNull
        private final FontWeight fontWeight;
        @NotNull
        private final FontStyle fontStyle;
        @NotNull
        private final FontSynthesis fontSynthesis;

        @Nullable
        public final FontFamily getFontFamily() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight getFontWeight() {
            return this.fontWeight;
        }

        @NotNull
        public final FontStyle getFontStyle() {
            return this.fontStyle;
        }

        @NotNull
        public final FontSynthesis getFontSynthesis() {
            return this.fontSynthesis;
        }

        public CacheKey(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
            Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontSynthesis), (String)"fontSynthesis");
            this.fontFamily = fontFamily;
            this.fontWeight = fontWeight;
            this.fontStyle = fontStyle;
            this.fontSynthesis = fontSynthesis;
        }

        public /* synthetic */ CacheKey(FontFamily fontFamily, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, int n, DefaultConstructorMarker defaultConstructorMarker) {
            if ((n & 1) != 0) {
                fontFamily = null;
            }
            this(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }

        @Nullable
        public final FontFamily component1() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight component2() {
            return this.fontWeight;
        }

        @NotNull
        public final FontStyle component3() {
            return this.fontStyle;
        }

        @NotNull
        public final FontSynthesis component4() {
            return this.fontSynthesis;
        }

        @NotNull
        public final CacheKey copy(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
            Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontSynthesis), (String)"fontSynthesis");
            return new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }

        public static /* synthetic */ CacheKey copy$default(CacheKey cacheKey, FontFamily fontFamily, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, int n, Object object) {
            if ((n & 1) != 0) {
                fontFamily = cacheKey.fontFamily;
            }
            if ((n & 2) != 0) {
                fontWeight = cacheKey.fontWeight;
            }
            if ((n & 4) != 0) {
                fontStyle = cacheKey.fontStyle;
            }
            if ((n & 8) != 0) {
                fontSynthesis = cacheKey.fontSynthesis;
            }
            return cacheKey.copy(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }

        @NotNull
        public String toString() {
            return "CacheKey(fontFamily=" + this.fontFamily + ", fontWeight=" + this.fontWeight + ", fontStyle=" + (Object)((Object)this.fontStyle) + ", fontSynthesis=" + (Object)((Object)this.fontSynthesis) + ")";
        }

        public int hashCode() {
            FontFamily fontFamily = this.fontFamily;
            FontWeight fontWeight = this.fontWeight;
            FontStyle fontStyle = this.fontStyle;
            FontSynthesis fontSynthesis = this.fontSynthesis;
            return (((fontFamily != null ? ((Object)fontFamily).hashCode() : 0) * 31 + (fontWeight != null ? ((Object)fontWeight).hashCode() : 0)) * 31 + (fontStyle != null ? ((Object)((Object)fontStyle)).hashCode() : 0)) * 31 + (fontSynthesis != null ? ((Object)((Object)fontSynthesis)).hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof CacheKey)) break block3;
                    CacheKey cacheKey = (CacheKey)object;
                    if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)cacheKey.fontFamily) || !Intrinsics.areEqual((Object)this.fontWeight, (Object)cacheKey.fontWeight) || !Intrinsics.areEqual((Object)((Object)this.fontStyle), (Object)((Object)cacheKey.fontStyle)) || !Intrinsics.areEqual((Object)((Object)this.fontSynthesis), (Object)((Object)cacheKey.fontSynthesis))) break block3;
                }
                return true;
            }
            return false;
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/ui/text/platform/TypefaceAdapter$Companion;", "", "()V", "ANDROID_BOLD", "Landroidx/ui/text/font/FontWeight;", "typefaceCache", "Landroidx/collection/LruCache;", "Landroidx/ui/text/platform/TypefaceAdapter$CacheKey;", "Landroid/graphics/Typeface;", "getTypefaceCache", "()Landroidx/collection/LruCache;", "ui-text_release"})
    public static final class Companion {
        @NotNull
        public final LruCache<CacheKey, Typeface> getTypefaceCache() {
            return typefaceCache;
        }

        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

