/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.ui.input.EditOperation;
import androidx.ui.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Landroidx/ui/input/SetComposingTextEditOp;", "Landroidx/ui/input/EditOperation;", "text", "", "newCursorPosition", "", "(Ljava/lang/String;I)V", "getNewCursorPosition", "()I", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "process", "", "buffer", "Landroidx/ui/input/EditingBuffer;", "toString", "ui-text_release"})
public final class SetComposingTextEditOp
implements EditOperation {
    @NotNull
    private final String text;
    private final int newCursorPosition;

    @Override
    public void process(@NotNull EditingBuffer buffer) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        if (buffer.hasComposition$ui_text_release()) {
            int compositionStart = buffer.getCompositionStart$ui_text_release();
            buffer.replace$ui_text_release(buffer.getCompositionStart$ui_text_release(), buffer.getCompositionEnd$ui_text_release(), this.text);
            charSequence = this.text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                buffer.setComposition$ui_text_release(compositionStart, compositionStart + this.text.length());
            }
        } else {
            int selectionStart = buffer.getSelectionStart$ui_text_release();
            buffer.replace$ui_text_release(buffer.getSelectionStart$ui_text_release(), buffer.getSelectionEnd$ui_text_release(), this.text);
            charSequence = this.text;
            boolean bl = false;
            if (charSequence.length() > 0) {
                buffer.setComposition$ui_text_release(selectionStart, selectionStart + this.text.length());
            }
        }
        int newCursor = buffer.getCursor$ui_text_release();
        int newCursorInBuffer = this.newCursorPosition > 0 ? newCursor + this.newCursorPosition - 1 : newCursor + this.newCursorPosition - this.text.length();
        buffer.setCursor$ui_text_release(RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)buffer.getLength$ui_text_release()));
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    public SetComposingTextEditOp(@NotNull String text, int newCursorPosition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.newCursorPosition = newCursorPosition;
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    public final int component2() {
        return this.newCursorPosition;
    }

    @NotNull
    public final SetComposingTextEditOp copy(@NotNull String text, int newCursorPosition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return new SetComposingTextEditOp(text, newCursorPosition);
    }

    public static /* synthetic */ SetComposingTextEditOp copy$default(SetComposingTextEditOp setComposingTextEditOp, String string, int n, int n2, Object object) {
        if ((n2 & 1) != 0) {
            string = setComposingTextEditOp.text;
        }
        if ((n2 & 2) != 0) {
            n = setComposingTextEditOp.newCursorPosition;
        }
        return setComposingTextEditOp.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "SetComposingTextEditOp(text=" + this.text + ", newCursorPosition=" + this.newCursorPosition + ")";
    }

    public int hashCode() {
        String string = this.text;
        return (string != null ? string.hashCode() : 0) * 31 + Integer.hashCode(this.newCursorPosition);
    }

    public boolean equals(@Nullable Object object) {
        block3: {
            block2: {
                if (this == object) break block2;
                if (!(object instanceof SetComposingTextEditOp)) break block3;
                SetComposingTextEditOp setComposingTextEditOp = (SetComposingTextEditOp)object;
                if (!Intrinsics.areEqual((Object)this.text, (Object)setComposingTextEditOp.text) || this.newCursorPosition != setComposingTextEditOp.newCursorPosition) break block3;
            }
            return true;
        }
        return false;
    }
}

