/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.core.Density;
import androidx.ui.core.Px;
import androidx.ui.core.PxPosition;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Path;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.AnnotatedStringKt;
import androidx.ui.text.MultiParagraphIntrinsics;
import androidx.ui.text.MultiParagraphKt;
import androidx.ui.text.Paragraph;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.ParagraphInfo;
import androidx.ui.text.ParagraphIntrinsicInfo;
import androidx.ui.text.ParagraphKt;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextDirection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0007\n\u0002\b\u0013\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001BO\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012B-\u0012\u0006\u0010\u0013\u001a\u00020\u0014\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\n\b\u0002\u0010\n\u001a\u0004\u0018\u00010\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u00a2\u0006\u0002\u0010\u0015J\u000e\u00104\u001a\u0002052\u0006\u00106\u001a\u00020\tJ\u000e\u00107\u001a\u0002082\u0006\u00106\u001a\u00020\tJ\u000e\u00109\u001a\u0002082\u0006\u00106\u001a\u00020\tJ\u0016\u0010:\u001a\u00020\u001c2\u0006\u00106\u001a\u00020\t2\u0006\u0010;\u001a\u00020\u000bJ\u000e\u0010<\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\tJ\u000e\u0010>\u001a\u00020\t2\u0006\u00106\u001a\u00020\tJ\u000e\u0010?\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\tJ\u000e\u0010@\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\tJ\u000e\u0010A\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\tJ\u000e\u0010B\u001a\u00020\u001c2\u0006\u0010=\u001a\u00020\tJ\u000e\u0010C\u001a\u00020\t2\u0006\u0010D\u001a\u00020EJ\u000e\u0010F\u001a\u0002052\u0006\u00106\u001a\u00020\tJ\u0016\u0010G\u001a\u00020H2\u0006\u0010I\u001a\u00020\t2\u0006\u0010J\u001a\u00020\tJ\u000e\u0010K\u001a\u00020L2\u0006\u00106\u001a\u00020\tJ\u000e\u0010M\u001a\u00020N2\u0006\u0010O\u001a\u00020PJ\u0010\u0010Q\u001a\u00020N2\u0006\u00106\u001a\u00020\tH\u0002J\u0010\u0010R\u001a\u00020N2\u0006\u00106\u001a\u00020\tH\u0002J\u0010\u0010S\u001a\u00020N2\u0006\u0010=\u001a\u00020\tH\u0002R\u0014\u0010\u0002\u001a\u00020\u00038BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\u0017R\u0011\u0010\u0018\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u001eR\u0011\u0010\u001f\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001eR\u0011\u0010\u0013\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\"R\u0011\u0010#\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\u001eR\u0011\u0010%\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b&\u0010'R\u0011\u0010(\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b)\u0010\u001eR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010,\u001a\u0004\b*\u0010+R\u0011\u0010-\u001a\u00020\u001c8F\u00a2\u0006\u0006\u001a\u0004\b.\u0010\u001eR\u0014\u0010/\u001a\b\u0012\u0004\u0012\u00020100X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u00102\u001a\u00020\u001c\u00a2\u0006\b\n\u0000\u001a\u0004\b3\u0010\u001e\u00a8\u0006T"}, d2={"Landroidx/ui/text/MultiParagraph;", "", "annotatedString", "Landroidx/ui/text/AnnotatedString;", "textStyle", "Landroidx/ui/text/TextStyle;", "paragraphStyle", "Landroidx/ui/text/ParagraphStyle;", "maxLines", "", "ellipsis", "", "constraints", "Landroidx/ui/text/ParagraphConstraints;", "density", "Landroidx/ui/core/Density;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/text/TextStyle;Landroidx/ui/text/ParagraphStyle;Ljava/lang/Integer;Ljava/lang/Boolean;Landroidx/ui/text/ParagraphConstraints;Landroidx/ui/core/Density;Landroidx/ui/text/font/Font$ResourceLoader;)V", "intrinsics", "Landroidx/ui/text/MultiParagraphIntrinsics;", "(Landroidx/ui/text/MultiParagraphIntrinsics;Ljava/lang/Integer;Ljava/lang/Boolean;Landroidx/ui/text/ParagraphConstraints;)V", "getAnnotatedString", "()Landroidx/ui/text/AnnotatedString;", "didExceedMaxLines", "getDidExceedMaxLines", "()Z", "firstBaseline", "", "getFirstBaseline", "()F", "height", "getHeight", "getIntrinsics", "()Landroidx/ui/text/MultiParagraphIntrinsics;", "lastBaseline", "getLastBaseline", "lineCount", "getLineCount", "()I", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "minIntrinsicWidth", "getMinIntrinsicWidth", "paragraphInfoList", "", "Landroidx/ui/text/ParagraphInfo;", "width", "getWidth", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "getBoundingBox", "Landroidx/ui/engine/geometry/Rect;", "getCursorRect", "getHorizontalPosition", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineForOffset", "getLineHeight", "getLineLeft", "getLineRight", "getLineWidth", "getOffsetForPosition", "position", "Landroidx/ui/core/PxPosition;", "getParagraphDirection", "getPathForRange", "Landroidx/ui/graphics/Path;", "start", "end", "getWordBoundary", "Landroidx/ui/text/TextRange;", "paint", "", "canvas", "Landroidx/ui/graphics/Canvas;", "requireIndexInRange", "requireIndexInRangeInclusiveEnd", "requireLineIndexInRange", "ui-text_release"})
public final class MultiParagraph {
    private final boolean didExceedMaxLines;
    private final float width;
    private final float height;
    private final int lineCount;
    private final List<ParagraphInfo> paragraphInfoList;
    @NotNull
    private final MultiParagraphIntrinsics intrinsics;
    @Nullable
    private final Integer maxLines;

    private final AnnotatedString getAnnotatedString() {
        return this.intrinsics.getAnnotatedString();
    }

    public final float getMinIntrinsicWidth() {
        return this.intrinsics.getMaxIntrinsicWidth();
    }

    public final float getMaxIntrinsicWidth() {
        return this.intrinsics.getMaxIntrinsicWidth();
    }

    public final boolean getDidExceedMaxLines() {
        return this.didExceedMaxLines;
    }

    public final float getWidth() {
        return this.width;
    }

    public final float getHeight() {
        return this.height;
    }

    public final float getFirstBaseline() {
        return this.paragraphInfoList.isEmpty() ? 0.0f : this.paragraphInfoList.get(0).getParagraph().getFirstBaseline();
    }

    public final float getLastBaseline() {
        return this.paragraphInfoList.isEmpty() ? 0.0f : ((ParagraphInfo)CollectionsKt.last(this.paragraphInfoList)).getParagraph().getLastBaseline();
    }

    public final int getLineCount() {
        return this.lineCount;
    }

    public final void paint(@NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        canvas.save();
        Iterable $this$forEach$iv = this.paragraphInfoList;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParagraphInfo it = (ParagraphInfo)element$iv;
            boolean bl = false;
            it.getParagraph().paint(canvas);
            canvas.translate(0.0f, it.getParagraph().getHeight());
        }
        canvas.restore();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final Path getPathForRange(int start, int end) {
        void $this$filterNotTo$iv$iv;
        int n = start;
        n = 0 <= n && end >= n && end <= this.getAnnotatedString().getText().length() ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "Start(" + start + ") or End(" + end + ") is out of range [0.." + this.getAnnotatedString().getText().length() + ")," + " or start > end!";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        if (start == end) {
            return new Path(null, 1, null);
        }
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, start);
        Path path = new Path(null, 1, null);
        Iterable $this$takeWhile$iv = CollectionsKt.drop((Iterable)this.paragraphInfoList, (int)paragraphIndex);
        boolean $i$f$takeWhile = false;
        Iterable list$iv = new ArrayList();
        for (Object item$iv : $this$takeWhile$iv) {
            ParagraphInfo it = (ParagraphInfo)item$iv;
            boolean bl4 = false;
            if (!(it.getStartIndex() < end)) break;
            ((ArrayList)list$iv).add(item$iv);
        }
        Iterable $this$filterNot$iv = (List)list$iv;
        boolean $i$f$filterNot = false;
        list$iv = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            ParagraphInfo it = (ParagraphInfo)element$iv$iv;
            boolean bl5 = false;
            if (it.getStartIndex() == it.getEndIndex()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$forEach$iv = (List)destination$iv$iv;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            ParagraphInfo it = (ParagraphInfo)element$iv;
            boolean bl6 = false;
            boolean bl7 = false;
            boolean bl8 = false;
            ParagraphInfo $this$with = it;
            boolean bl9 = false;
            Path.addPath$default((Path)path, (Path)$this$with.toGlobal($this$with.getParagraph().getPathForRange($this$with.toLocalIndex(start), $this$with.toLocalIndex(end))), null, null, (int)6, null);
        }
        return path;
    }

    public final int getOffsetForPosition(@NotNull PxPosition position) {
        int n;
        int n2;
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        PxPosition this_$iv = position;
        long value$iv$iv = this_$iv.getValue();
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
        int n4 = 0;
        float $this$px$iv$iv = Float.intBitsToFloat(n3);
        Px px = new Px($this$px$iv$iv);
        if (px.getValue() <= 0.0f) {
            n2 = 0;
        } else {
            this_$iv = position;
            value$iv$iv = this_$iv.getValue();
            floatCompanionObject = FloatCompanionObject.INSTANCE;
            n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
            n4 = 0;
            $this$px$iv$iv = Float.intBitsToFloat(n3);
            Px px2 = new Px($this$px$iv$iv);
            if (px2.getValue() >= this.height) {
                n2 = CollectionsKt.getLastIndex(this.paragraphInfoList);
            } else {
                this_$iv = position;
                List<ParagraphInfo> list = this.paragraphInfoList;
                value$iv$iv = this_$iv.getValue();
                floatCompanionObject = FloatCompanionObject.INSTANCE;
                n3 = (int)(value$iv$iv & 0xFFFFFFFFL);
                n4 = 0;
                $this$px$iv$iv = Float.intBitsToFloat(n3);
                Px px3 = new Px($this$px$iv$iv);
                n2 = MultiParagraphKt.findParagraphByY(list, px3);
            }
        }
        int paragraphIndex = n2;
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        if ($this$with.getLength() == 0) {
            n4 = 0;
            int n5 = $this$with.getStartIndex() - 1;
            boolean bl4 = false;
            n = Math.max(n4, n5);
        } else {
            n = $this$with.toGlobalIndex($this$with.getParagraph().getOffsetForPosition($this$with.toLocal(position)));
        }
        return n;
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.toGlobal($this$with.getParagraph().getBoundingBox($this$with.toLocalIndex(offset)));
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.getParagraph().getHorizontalPosition($this$with.toLocalIndex(offset), usePrimaryDirection);
    }

    @NotNull
    public final TextDirection getParagraphDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.getParagraph().getParagraphDirection($this$with.toLocalIndex(offset));
    }

    @NotNull
    public final TextDirection getBidiRunDirection(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.getParagraph().getBidiRunDirection($this$with.toLocalIndex(offset));
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        this.requireIndexInRange(offset);
        int paragraphIndex = MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.toGlobal($this$with.getParagraph().getWordBoundary($this$with.toLocalIndex(offset)));
    }

    @NotNull
    public final Rect getCursorRect(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.toGlobal($this$with.getParagraph().getCursorRect($this$with.toLocalIndex(offset)));
    }

    public final int getLineForOffset(int offset) {
        this.requireIndexInRangeInclusiveEnd(offset);
        int paragraphIndex = offset == AnnotatedStringKt.getLength(this.getAnnotatedString()) ? CollectionsKt.getLastIndex(this.paragraphInfoList) : MultiParagraphKt.findParagraphByIndex(this.paragraphInfoList, offset);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.toGlobalLineIndex($this$with.getParagraph().getLineForOffset($this$with.toLocalIndex(offset)));
    }

    public final float getLineLeft(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.getParagraph().getLineLeft($this$with.toLocalLineIndex(lineIndex));
    }

    public final float getLineRight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.getParagraph().getLineRight($this$with.toLocalLineIndex(lineIndex));
    }

    public final float getLineBottom(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.toGlobalYPosition($this$with.getParagraph().getLineBottom($this$with.toLocalLineIndex(lineIndex)));
    }

    public final float getLineHeight(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.getParagraph().getLineHeight($this$with.toLocalLineIndex(lineIndex));
    }

    public final float getLineWidth(int lineIndex) {
        this.requireLineIndexInRange(lineIndex);
        int paragraphIndex = MultiParagraphKt.findParagraphByLineIndex(this.paragraphInfoList, lineIndex);
        ParagraphInfo paragraphInfo = this.paragraphInfoList.get(paragraphIndex);
        boolean bl = false;
        boolean bl2 = false;
        ParagraphInfo $this$with = paragraphInfo;
        boolean bl3 = false;
        return $this$with.getParagraph().getLineWidth($this$with.toLocalLineIndex(lineIndex));
    }

    private final void requireIndexInRange(int offset) {
        int n = offset;
        n = 0 <= n && ((CharSequence)this.getAnnotatedString().getText()).length() > n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "offset(" + offset + ") is out of bounds [0, " + AnnotatedStringKt.getLength(this.getAnnotatedString()) + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void requireIndexInRangeInclusiveEnd(int offset) {
        int n = offset;
        n = 0 <= n && this.getAnnotatedString().getText().length() >= n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "offset(" + offset + ") is out of bounds [0, " + AnnotatedStringKt.getLength(this.getAnnotatedString()) + ']';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    private final void requireLineIndexInRange(int lineIndex) {
        int n = lineIndex;
        n = 0 <= n && this.lineCount > n ? 1 : 0;
        boolean bl = false;
        boolean bl2 = false;
        if (n == 0) {
            boolean bl3 = false;
            String string = "lineIndex(" + lineIndex + ") is out of bounds [0, " + lineIndex + ')';
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
    }

    @NotNull
    public final MultiParagraphIntrinsics getIntrinsics() {
        return this.intrinsics;
    }

    @Nullable
    public final Integer getMaxLines() {
        return this.maxLines;
    }

    /*
     * WARNING - void declaration
     */
    public MultiParagraph(@NotNull MultiParagraphIntrinsics intrinsics, @Nullable Integer maxLines, @Nullable Boolean ellipsis, @NotNull ParagraphConstraints constraints) {
        Collection<ParagraphInfo> collection;
        void $this$mapTo$iv$iv;
        void $this$map$iv;
        Intrinsics.checkParameterIsNotNull((Object)intrinsics, (String)"intrinsics");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        this.intrinsics = intrinsics;
        this.maxLines = maxLines;
        Iterable iterable = this.intrinsics.getInfoList$ui_text_release();
        Object object = this;
        boolean $i$f$map = false;
        void var7_9 = $this$map$iv;
        Collection destination$iv$iv22 = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            ParagraphIntrinsicInfo paragraphIntrinsicInfo = (ParagraphIntrinsicInfo)item$iv$iv;
            collection = destination$iv$iv22;
            boolean bl = false;
            ParagraphInfo paragraphInfo = new ParagraphInfo(ParagraphKt.Paragraph(it.getIntrinsics(), this.maxLines, ellipsis, constraints), it.getStartIndex(), it.getEndIndex(), 0, 0, null, null, 120, null);
            collection.add(paragraphInfo);
        }
        collection = (List)destination$iv$iv22;
        ((MultiParagraph)object).paragraphInfoList = collection;
        boolean didExceedMaxLines = false;
        int currentLineCount = 0;
        float currentHeight = 0.0f;
        boolean destination$iv$iv22 = false;
        for (ParagraphInfo paragraphInfo : (Iterable)this.paragraphInfoList) {
            void index;
            block5: {
                block4: {
                    float $this$px$iv;
                    Paragraph paragraph = paragraphInfo.getParagraph();
                    paragraphInfo.setStartLineIndex(currentLineCount);
                    paragraphInfo.setEndLineIndex(currentLineCount + paragraph.getLineCount());
                    currentLineCount = paragraphInfo.getEndLineIndex();
                    float it = currentHeight;
                    object = paragraphInfo;
                    collection = new Px($this$px$iv);
                    ((ParagraphInfo)object).setTop((Px)collection);
                    $this$px$iv = currentHeight + paragraph.getHeight();
                    object = paragraphInfo;
                    collection = new Px($this$px$iv);
                    ((ParagraphInfo)object).setBottom((Px)collection);
                    currentHeight += paragraph.getHeight();
                    if (paragraph.getDidExceedMaxLines()) break block4;
                    Integer n = this.maxLines;
                    if (n == null || currentLineCount != n || index == CollectionsKt.getLastIndex(this.paragraphInfoList)) break block5;
                }
                didExceedMaxLines = true;
                break;
            }
            ++index;
        }
        this.didExceedMaxLines = didExceedMaxLines;
        this.lineCount = currentLineCount;
        this.height = currentHeight;
        this.width = constraints.getWidth();
    }

    public /* synthetic */ MultiParagraph(MultiParagraphIntrinsics multiParagraphIntrinsics, Integer n, Boolean bl, ParagraphConstraints paragraphConstraints, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            n = null;
        }
        if ((n2 & 4) != 0) {
            bl = null;
        }
        this(multiParagraphIntrinsics, n, bl, paragraphConstraints);
    }

    public MultiParagraph(@NotNull AnnotatedString annotatedString, @NotNull TextStyle textStyle, @NotNull ParagraphStyle paragraphStyle, @Nullable Integer maxLines, @Nullable Boolean ellipsis, @NotNull ParagraphConstraints constraints, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkParameterIsNotNull((Object)textStyle, (String)"textStyle");
        Intrinsics.checkParameterIsNotNull((Object)paragraphStyle, (String)"paragraphStyle");
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this(new MultiParagraphIntrinsics(annotatedString, textStyle, paragraphStyle, density, resourceLoader), maxLines, ellipsis, constraints);
    }

    public /* synthetic */ MultiParagraph(AnnotatedString annotatedString, TextStyle textStyle, ParagraphStyle paragraphStyle, Integer n, Boolean bl, ParagraphConstraints paragraphConstraints, Density density, Font.ResourceLoader resourceLoader, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = null;
        }
        this(annotatedString, textStyle, paragraphStyle, n, bl, paragraphConstraints, density, resourceLoader);
    }
}

