/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.Density;
import androidx.ui.core.IntPx;
import androidx.ui.core.IntPxSize;
import androidx.ui.core.LayoutDirection;
import androidx.ui.core.PxPosition;
import androidx.ui.engine.geometry.Rect;
import androidx.ui.graphics.BlendMode;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.Shader;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.MultiParagraph;
import androidx.ui.text.MultiParagraphIntrinsics;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.TextDelegateKt;
import androidx.ui.text.TextRange;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextDirection;
import androidx.ui.text.style.TextOverflow;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u00b2\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0010\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0015\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001:\u0001qB]\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\b\b\u0002\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\u0002\u0010\u0014J(\u0010H\u001a\u0002HI\"\u0004\b\u0000\u0010I2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u000205\u0012\u0004\u0012\u0002HI0KH\u0082\b\u00a2\u0006\u0002\u0010LJ(\u0010M\u001a\u0002HI\"\u0004\b\u0000\u0010I2\u0012\u0010J\u001a\u000e\u0012\u0004\u0012\u00020\"\u0012\u0004\u0012\u0002HI0KH\u0082\b\u00a2\u0006\u0002\u0010LJ\u000e\u0010N\u001a\u00020O2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010Q\u001a\u00020R2\u0006\u0010P\u001a\u00020\tJ\u0016\u0010S\u001a\u00020T2\u0006\u0010P\u001a\u00020\t2\u0006\u0010U\u001a\u00020\u000bJ\u000e\u0010V\u001a\u00020T2\u0006\u0010W\u001a\u00020\tJ\u000e\u0010X\u001a\u00020\t2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010Y\u001a\u00020\t2\u0006\u0010Z\u001a\u00020[J\u000e\u0010\\\u001a\u00020O2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010]\u001a\u00020^2\u0006\u0010P\u001a\u00020\tJ\u000e\u0010_\u001a\u00020`2\u0006\u0010a\u001a\u00020bJ\u0006\u0010c\u001a\u00020`J\u0018\u0010d\u001a\u00020e2\u0006\u0010f\u001a\u00020T2\u0006\u0010g\u001a\u00020TH\u0002J\u000e\u0010h\u001a\u00020`2\u0006\u0010i\u001a\u00020jJ&\u0010k\u001a\u00020`2\u0006\u0010l\u001a\u00020\t2\u0006\u0010m\u001a\u00020\t2\u0006\u0010n\u001a\u00020o2\u0006\u0010i\u001a\u00020jJ\u0016\u0010p\u001a\u00020`2\u0006\u0010P\u001a\u00020\t2\u0006\u0010i\u001a\u00020jR\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u001b\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\u001aR\u0011\u0010\u001d\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R&\u0010!\u001a\u0004\u0018\u00010\"8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b#\u0010$\u001a\u0004\b%\u0010&\"\u0004\b'\u0010(R\u0011\u0010)\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\u001aR\u0015\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\n\n\u0002\u0010-\u001a\u0004\b+\u0010,R\u0011\u0010.\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b/\u0010\u001aR\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0010\u00102\u001a\u0004\u0018\u000103X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u00104\u001a\u0004\u0018\u0001058\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b6\u0010$\u001a\u0004\b7\u00108\"\u0004\b9\u0010:R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u0010<R\u0011\u0010\u0012\u001a\u00020\u0013\u00a2\u0006\b\n\u0000\u001a\u0004\b=\u0010>R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b?\u0010@R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\bA\u0010BR\u0011\u0010C\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0011\u0010F\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\bG\u0010\u001a\u00a8\u0006r"}, d2={"Landroidx/ui/text/TextDelegate;", "", "text", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "paragraphStyle", "Landroidx/ui/text/ParagraphStyle;", "maxLines", "", "softWrap", "", "overflow", "Landroidx/ui/text/style/TextOverflow;", "density", "Landroidx/ui/core/Density;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/text/TextStyle;Landroidx/ui/text/ParagraphStyle;Ljava/lang/Integer;ZLandroidx/ui/text/style/TextOverflow;Landroidx/ui/core/Density;Landroidx/ui/core/LayoutDirection;Landroidx/ui/text/font/Font$ResourceLoader;)V", "getDensity", "()Landroidx/ui/core/Density;", "firstBaseline", "Landroidx/ui/core/IntPx;", "getFirstBaseline", "()Landroidx/ui/core/IntPx;", "height", "getHeight", "lastBaseline", "getLastBaseline", "getLayoutDirection", "()Landroidx/ui/core/LayoutDirection;", "layoutResult", "Landroidx/ui/text/TextDelegate$LayoutResult;", "layoutResult$annotations", "()V", "getLayoutResult$ui_text_release", "()Landroidx/ui/text/TextDelegate$LayoutResult;", "setLayoutResult$ui_text_release", "(Landroidx/ui/text/TextDelegate$LayoutResult;)V", "maxIntrinsicWidth", "getMaxIntrinsicWidth", "getMaxLines", "()Ljava/lang/Integer;", "Ljava/lang/Integer;", "minIntrinsicWidth", "getMinIntrinsicWidth", "getOverflow", "()Landroidx/ui/text/style/TextOverflow;", "overflowShader", "Landroidx/ui/graphics/Shader;", "paragraphIntrinsics", "Landroidx/ui/text/MultiParagraphIntrinsics;", "paragraphIntrinsics$annotations", "getParagraphIntrinsics$ui_text_release", "()Landroidx/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$ui_text_release", "(Landroidx/ui/text/MultiParagraphIntrinsics;)V", "getParagraphStyle", "()Landroidx/ui/text/ParagraphStyle;", "getResourceLoader", "()Landroidx/ui/text/font/Font$ResourceLoader;", "getSoftWrap", "()Z", "getText", "()Landroidx/ui/text/AnnotatedString;", "textStyle", "getTextStyle", "()Landroidx/ui/text/TextStyle;", "width", "getWidth", "assumeIntrinsics", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "assumeLayout", "getBidiRunDirection", "Landroidx/ui/text/style/TextDirection;", "offset", "getBoundingBox", "Landroidx/ui/engine/geometry/Rect;", "getHorizontalPosition", "", "usePrimaryDirection", "getLineBottom", "lineIndex", "getLineForOffset", "getOffsetForPosition", "position", "Landroidx/ui/core/PxPosition;", "getParagraphDirection", "getWordBoundary", "Landroidx/ui/text/TextRange;", "layout", "", "constraints", "Landroidx/ui/core/Constraints;", "layoutIntrinsics", "layoutText", "Landroidx/ui/text/MultiParagraph;", "minWidth", "maxWidth", "paint", "canvas", "Landroidx/ui/graphics/Canvas;", "paintBackground", "start", "end", "color", "Landroidx/ui/graphics/Color;", "paintCursor", "LayoutResult", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TextDelegate {
    @NotNull
    private final TextStyle textStyle;
    @NotNull
    private final ParagraphStyle paragraphStyle;
    @Nullable
    private LayoutResult layoutResult;
    private Shader overflowShader;
    @Nullable
    private MultiParagraphIntrinsics paragraphIntrinsics;
    @NotNull
    private final AnnotatedString text;
    @Nullable
    private final Integer maxLines;
    private final boolean softWrap;
    @NotNull
    private final TextOverflow overflow;
    @NotNull
    private final Density density;
    @NotNull
    private final LayoutDirection layoutDirection;
    @NotNull
    private final Font.ResourceLoader resourceLoader;

    @NotNull
    public final TextStyle getTextStyle() {
        return this.textStyle;
    }

    @NotNull
    public final ParagraphStyle getParagraphStyle() {
        return this.paragraphStyle;
    }

    @VisibleForTesting
    public static /* synthetic */ void layoutResult$annotations() {
    }

    @Nullable
    public final LayoutResult getLayoutResult$ui_text_release() {
        return this.layoutResult;
    }

    public final void setLayoutResult$ui_text_release(@Nullable LayoutResult layoutResult) {
        this.layoutResult = layoutResult;
    }

    @VisibleForTesting
    public static /* synthetic */ void paragraphIntrinsics$annotations() {
    }

    @Nullable
    public final MultiParagraphIntrinsics getParagraphIntrinsics$ui_text_release() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$ui_text_release(@Nullable MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    private final <T> T assumeLayout(Function1<? super LayoutResult, ? extends T> block) {
        int $i$f$assumeLayout = 0;
        LayoutResult layoutResult = this.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        return (T)block.invoke((Object)layoutResult);
    }

    private final <T> T assumeIntrinsics(Function1<? super MultiParagraphIntrinsics, ? extends T> block) {
        int $i$f$assumeIntrinsics = 0;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layoutForIntrinsics must be called first"));
        }
        return (T)block.invoke((Object)multiParagraphIntrinsics);
    }

    @NotNull
    public final IntPx getMinIntrinsicWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layoutForIntrinsics must be called first"));
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        boolean bl = false;
        return TextDelegateKt.access$toIntPx(it.getMinIntrinsicWidth());
    }

    @NotNull
    public final IntPx getMaxIntrinsicWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layoutForIntrinsics must be called first"));
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        boolean bl = false;
        return TextDelegateKt.access$toIntPx(it.getMaxIntrinsicWidth());
    }

    @NotNull
    public final IntPx getWidth() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        IntPxSize this_$iv2 = it.getSize();
        long value$iv$iv = this_$iv2.getValue();
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        return new IntPx($this$ipx$iv$iv);
    }

    @NotNull
    public final IntPx getHeight() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        IntPxSize this_$iv2 = it.getSize();
        long value$iv$iv = this_$iv2.getValue();
        int $this$ipx$iv$iv = (int)(value$iv$iv & 0xFFFFFFFFL);
        return new IntPx($this$ipx$iv$iv);
    }

    @NotNull
    public final IntPx getFirstBaseline() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        return TextDelegateKt.access$toIntPx(it.getMultiParagraph().getFirstBaseline());
    }

    @NotNull
    public final IntPx getLastBaseline() {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult it = layoutResult;
        boolean bl = false;
        return TextDelegateKt.access$toIntPx(it.getMultiParagraph().getLastBaseline());
    }

    public final void layoutIntrinsics() {
        MultiParagraphIntrinsics intrinsics;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.paragraphIntrinsics;
        if (multiParagraphIntrinsics == null) {
            multiParagraphIntrinsics = new MultiParagraphIntrinsics(this.text, this.textStyle, this.paragraphStyle, this.density, this.resourceLoader);
        }
        this.paragraphIntrinsics = intrinsics = multiParagraphIntrinsics;
    }

    private final MultiParagraph layoutText(float minWidth, float maxWidth) {
        this.layoutIntrinsics();
        TextDelegate this_$iv = this;
        boolean $i$f$assumeIntrinsics = false;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layoutForIntrinsics must be called first"));
        }
        MultiParagraphIntrinsics paragraphIntrinsics = multiParagraphIntrinsics;
        boolean bl = false;
        float width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((float)paragraphIntrinsics.getMaxIntrinsicWidth(), (float)minWidth, (float)maxWidth);
        return new MultiParagraph(paragraphIntrinsics, this.maxLines, this.overflow == TextOverflow.Ellipsis, new ParagraphConstraints(width));
    }

    /*
     * WARNING - void declaration
     */
    public final void layout(@NotNull Constraints constraints) {
        void val1$iv$iv;
        long l;
        void height$iv;
        void width$iv;
        int n;
        LayoutResult it;
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        IntPx minWidth = constraints.getMinWidth();
        boolean widthMatters = this.softWrap || this.overflow == TextOverflow.Ellipsis;
        IntPx maxWidth = widthMatters ? constraints.getMaxWidth() : IntPx.Companion.getInfinity();
        LayoutResult layoutResult = this.layoutResult;
        if (layoutResult != null) {
            LayoutResult layoutResult2 = layoutResult;
            boolean bl = false;
            boolean bl2 = false;
            it = layoutResult2;
            n = 0;
            if (Intrinsics.areEqual((Object)it.getMinWidth(), (Object)minWidth) && Intrinsics.areEqual((Object)it.getMaxWidth(), (Object)maxWidth)) {
                return;
            }
        }
        MultiParagraph multiParagraph = this.layoutText(minWidth.getValue(), maxWidth.getValue());
        Object object = TextDelegateKt.access$toIntPx(multiParagraph.getWidth());
        it = TextDelegateKt.access$toIntPx(multiParagraph.getHeight());
        Object object2 = constraints;
        n = width$iv.getValue();
        int val2$iv$iv = height$iv.getValue();
        long l2 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
        IntPxSize intPxSize = new IntPxSize(l2);
        IntPxSize size = ConstraintsKt.constrain((Constraints)object2, (IntPxSize)intPxSize);
        object = new LayoutResult(multiParagraph, size, minWidth, maxWidth);
        object2 = this;
        boolean bl = false;
        boolean bl3 = false;
        Object it2 = object;
        boolean bl4 = false;
        this.overflowShader = TextDelegateKt.access$createOverflowShader(this, (LayoutResult)it2);
        intPxSize = object;
        object2.layoutResult = intPxSize;
    }

    public final void paint(@NotNull Canvas canvas) {
        Rect bounds;
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        IntPxSize this_$iv2 = layoutResult2.getSize();
        long value$iv$iv = this_$iv2.getValue();
        int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
        float width = new IntPx($this$ipx$iv$iv).getValue();
        IntPxSize this_$iv3 = layoutResult2.getSize();
        long value$iv$iv2 = this_$iv3.getValue();
        int $this$ipx$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        float height = new IntPx($this$ipx$iv$iv2).getValue();
        if (layoutResult2.getHasVisualOverflow()) {
            bounds = Rect.Companion.fromLTWH(0.0f, 0.0f, width, height);
            if (this.overflowShader != null) {
                canvas.saveLayer(bounds, new Paint());
            } else {
                canvas.save();
            }
            Canvas.DefaultImpls.clipRect$default((Canvas)canvas, (Rect)bounds, null, (int)2, null);
        }
        layoutResult2.getMultiParagraph().paint(canvas);
        if (layoutResult2.getHasVisualOverflow()) {
            if (this.overflowShader != null) {
                bounds = Rect.Companion.fromLTWH(0.0f, 0.0f, width, height);
                Paint paint = new Paint();
                paint.setBlendMode(BlendMode.multiply);
                paint.setShader(this.overflowShader);
                canvas.drawRect(bounds, paint);
            }
            canvas.restore();
        }
    }

    public final void paintBackground(int start, int end, @NotNull Color color, @NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        if (start == end) {
            return;
        }
        Path selectionPath = layoutResult2.getMultiParagraph().getPathForRange(start, end);
        Paint paint = new Paint();
        Path path = selectionPath;
        Canvas canvas2 = canvas;
        boolean bl2 = false;
        boolean bl3 = false;
        Paint $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setColor(color);
        Paint paint2 = paint;
        canvas2.drawPath(path, paint2);
    }

    public final void paintCursor(int offset, @NotNull Canvas canvas) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        Rect cursorRect = layoutResult2.getMultiParagraph().getCursorRect(offset);
        Paint paint = new Paint();
        Rect rect = cursorRect;
        Canvas canvas2 = canvas;
        boolean bl2 = false;
        boolean bl3 = false;
        Paint $this$apply = paint;
        boolean bl4 = false;
        $this$apply.setColor(Color.Companion.getBlack());
        Paint paint2 = paint;
        canvas2.drawRect(rect, paint2);
    }

    public final float getLineBottom(int lineIndex) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getLineBottom(lineIndex);
    }

    public final int getLineForOffset(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getLineForOffset(offset);
    }

    public final float getHorizontalPosition(int offset, boolean usePrimaryDirection) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getHorizontalPosition(offset, usePrimaryDirection);
    }

    @NotNull
    public final TextDirection getParagraphDirection(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getParagraphDirection(offset);
    }

    @NotNull
    public final TextDirection getBidiRunDirection(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getBidiRunDirection(offset);
    }

    public final int getOffsetForPosition(@NotNull PxPosition position) {
        Intrinsics.checkParameterIsNotNull((Object)position, (String)"position");
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getOffsetForPosition(position);
    }

    @NotNull
    public final Rect getBoundingBox(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getBoundingBox(offset);
    }

    @NotNull
    public final TextRange getWordBoundary(int offset) {
        TextDelegate this_$iv = this;
        boolean $i$f$assumeLayout = false;
        LayoutResult layoutResult = this_$iv.getLayoutResult$ui_text_release();
        if (layoutResult == null) {
            throw (Throwable)((Object)new AssertionError((Object)"layout must be called first"));
        }
        LayoutResult layoutResult2 = layoutResult;
        boolean bl = false;
        return layoutResult2.getMultiParagraph().getWordBoundary(offset);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    @Nullable
    public final Integer getMaxLines() {
        return this.maxLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    @NotNull
    public final TextOverflow getOverflow() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    public TextDelegate(@NotNull AnnotatedString text, @Nullable TextStyle style, @Nullable ParagraphStyle paragraphStyle, @Nullable Integer maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this.text = text;
        this.maxLines = maxLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.layoutDirection = layoutDirection;
        this.resourceLoader = resourceLoader;
        this.textStyle = TextDelegateKt.access$resolveTextStyle(style);
        this.paragraphStyle = paragraphStyle == null ? new ParagraphStyle(null, TextDelegateKt.resolveTextDirectionAlgorithm(this.layoutDirection, null), null, null, 13, null) : (paragraphStyle.getTextDirectionAlgorithm() == null ? ParagraphStyle.copy$default(paragraphStyle, null, TextDelegateKt.resolveTextDirectionAlgorithm(this.layoutDirection, null), null, null, 13, null) : paragraphStyle);
        boolean bl = this.maxLines == null || this.maxLines > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString annotatedString, TextStyle textStyle, ParagraphStyle paragraphStyle, Integer n, boolean bl, TextOverflow textOverflow, Density density, LayoutDirection layoutDirection, Font.ResourceLoader resourceLoader, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 2) != 0) {
            textStyle = null;
        }
        if ((n2 & 4) != 0) {
            paragraphStyle = null;
        }
        if ((n2 & 8) != 0) {
            n = null;
        }
        if ((n2 & 0x10) != 0) {
            bl = true;
        }
        if ((n2 & 0x20) != 0) {
            textOverflow = TextOverflow.Clip;
        }
        this(annotatedString, textStyle, paragraphStyle, n, bl, textOverflow, density, layoutDirection, resourceLoader);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0015\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0081\b\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\tJ\t\u0010\u0019\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u001a\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u001b\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u001c\u001a\u00020\u0007H\u00c6\u0003J1\u0010\u001d\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\u0007H\u00c6\u0001J\u0013\u0010\u001e\u001a\u00020\u000b2\b\u0010\u001f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010 \u001a\u00020!H\u00d6\u0001J\t\u0010\"\u001a\u00020#H\u00d6\u0001R\u0014\u0010\n\u001a\u00020\u000b8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\rR\u0011\u0010\u000e\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\rR\u0011\u0010\u0010\u001a\u00020\u000b8F\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\rR\u0011\u0010\b\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0013R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0018\u00a8\u0006$"}, d2={"Landroidx/ui/text/TextDelegate$LayoutResult;", "", "multiParagraph", "Landroidx/ui/text/MultiParagraph;", "size", "Landroidx/ui/core/IntPxSize;", "minWidth", "Landroidx/ui/core/IntPx;", "maxWidth", "(Landroidx/ui/text/MultiParagraph;Landroidx/ui/core/IntPxSize;Landroidx/ui/core/IntPx;Landroidx/ui/core/IntPx;)V", "didOverflowHeight", "", "getDidOverflowHeight", "()Z", "didOverflowWidth", "getDidOverflowWidth", "hasVisualOverflow", "getHasVisualOverflow", "getMaxWidth", "()Landroidx/ui/core/IntPx;", "getMinWidth", "getMultiParagraph", "()Landroidx/ui/text/MultiParagraph;", "getSize", "()Landroidx/ui/core/IntPxSize;", "component1", "component2", "component3", "component4", "copy", "equals", "other", "hashCode", "", "toString", "", "ui-text_release"})
    @VisibleForTesting
    public static final class LayoutResult {
        @NotNull
        private final MultiParagraph multiParagraph;
        @NotNull
        private final IntPxSize size;
        @NotNull
        private final IntPx minWidth;
        @NotNull
        private final IntPx maxWidth;

        private final boolean getDidOverflowHeight() {
            return this.multiParagraph.getDidExceedMaxLines();
        }

        public final boolean getDidOverflowWidth() {
            IntPxSize this_$iv = this.size;
            long value$iv$iv = this_$iv.getValue();
            int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
            return (float)new IntPx($this$ipx$iv$iv).getValue() < this.multiParagraph.getWidth();
        }

        public final boolean getHasVisualOverflow() {
            return this.getDidOverflowWidth() || this.getDidOverflowHeight();
        }

        @NotNull
        public final MultiParagraph getMultiParagraph() {
            return this.multiParagraph;
        }

        @NotNull
        public final IntPxSize getSize() {
            return this.size;
        }

        @NotNull
        public final IntPx getMinWidth() {
            return this.minWidth;
        }

        @NotNull
        public final IntPx getMaxWidth() {
            return this.maxWidth;
        }

        public LayoutResult(@NotNull MultiParagraph multiParagraph, @NotNull IntPxSize size, @NotNull IntPx minWidth, @NotNull IntPx maxWidth) {
            Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            Intrinsics.checkParameterIsNotNull((Object)minWidth, (String)"minWidth");
            Intrinsics.checkParameterIsNotNull((Object)maxWidth, (String)"maxWidth");
            this.multiParagraph = multiParagraph;
            this.size = size;
            this.minWidth = minWidth;
            this.maxWidth = maxWidth;
        }

        @NotNull
        public final MultiParagraph component1() {
            return this.multiParagraph;
        }

        @NotNull
        public final IntPxSize component2() {
            return this.size;
        }

        @NotNull
        public final IntPx component3() {
            return this.minWidth;
        }

        @NotNull
        public final IntPx component4() {
            return this.maxWidth;
        }

        @NotNull
        public final LayoutResult copy(@NotNull MultiParagraph multiParagraph, @NotNull IntPxSize size, @NotNull IntPx minWidth, @NotNull IntPx maxWidth) {
            Intrinsics.checkParameterIsNotNull((Object)multiParagraph, (String)"multiParagraph");
            Intrinsics.checkParameterIsNotNull((Object)size, (String)"size");
            Intrinsics.checkParameterIsNotNull((Object)minWidth, (String)"minWidth");
            Intrinsics.checkParameterIsNotNull((Object)maxWidth, (String)"maxWidth");
            return new LayoutResult(multiParagraph, size, minWidth, maxWidth);
        }

        public static /* synthetic */ LayoutResult copy$default(LayoutResult layoutResult, MultiParagraph multiParagraph, IntPxSize intPxSize, IntPx intPx, IntPx intPx2, int n, Object object) {
            if ((n & 1) != 0) {
                multiParagraph = layoutResult.multiParagraph;
            }
            if ((n & 2) != 0) {
                intPxSize = layoutResult.size;
            }
            if ((n & 4) != 0) {
                intPx = layoutResult.minWidth;
            }
            if ((n & 8) != 0) {
                intPx2 = layoutResult.maxWidth;
            }
            return layoutResult.copy(multiParagraph, intPxSize, intPx, intPx2);
        }

        @NotNull
        public String toString() {
            return "LayoutResult(multiParagraph=" + this.multiParagraph + ", size=" + this.size + ", minWidth=" + this.minWidth + ", maxWidth=" + this.maxWidth + ")";
        }

        public int hashCode() {
            MultiParagraph multiParagraph = this.multiParagraph;
            IntPxSize intPxSize = this.size;
            IntPx intPx = this.minWidth;
            IntPx intPx2 = this.maxWidth;
            return (((multiParagraph != null ? multiParagraph.hashCode() : 0) * 31 + (intPxSize != null ? intPxSize.hashCode() : 0)) * 31 + (intPx != null ? intPx.hashCode() : 0)) * 31 + (intPx2 != null ? intPx2.hashCode() : 0);
        }

        public boolean equals(@Nullable Object object) {
            block3: {
                block2: {
                    if (this == object) break block2;
                    if (!(object instanceof LayoutResult)) break block3;
                    LayoutResult layoutResult = (LayoutResult)object;
                    if (!Intrinsics.areEqual((Object)this.multiParagraph, (Object)layoutResult.multiParagraph) || !Intrinsics.areEqual((Object)this.size, (Object)layoutResult.size) || !Intrinsics.areEqual((Object)this.minWidth, (Object)layoutResult.minWidth) || !Intrinsics.areEqual((Object)this.maxWidth, (Object)layoutResult.maxWidth)) break block3;
                }
                return true;
            }
            return false;
        }
    }
}

