/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.core.TextUnit;
import androidx.ui.core.TextUnitKt;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Shadow;
import androidx.ui.graphics.ShadowKt;
import androidx.ui.text.LocaleList;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.font.FontWeightKt;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.BaselineShiftKt;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextGeometricTransformKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0000\u001a\u001e\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00012\u0006\u0010\u0003\u001a\u00020\u00012\u0006\u0010\u0004\u001a\u00020\u0005\u001a+\u0010\u0006\u001a\u0002H\u0007\"\u0004\b\u0000\u0010\u00072\u0006\u0010\b\u001a\u0002H\u00072\u0006\u0010\t\u001a\u0002H\u00072\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a2\u0006\u0002\u0010\u000b\u001a \u0010\f\u001a\u00020\r2\u0006\u0010\b\u001a\u00020\r2\u0006\u0010\t\u001a\u00020\r2\u0006\u0010\n\u001a\u00020\u0005H\u0002\u00a8\u0006\u000e"}, d2={"lerp", "Landroidx/ui/text/TextStyle;", "start", "stop", "fraction", "", "lerpDiscrete", "T", "a", "b", "t", "(Ljava/lang/Object;Ljava/lang/Object;F)Ljava/lang/Object;", "lerpTextUnitInheritable", "Landroidx/ui/core/TextUnit;", "ui-text_release"})
public final class TextStyleKt {
    private static final TextUnit lerpTextUnitInheritable(TextUnit a, TextUnit b, float t) {
        if (a.isInherit() && b.isInherit()) {
            return a;
        }
        return TextUnitKt.lerpTextUnit((TextUnit)a, (TextUnit)b, (float)t);
    }

    private static final <T> T lerpDiscrete(T a, T b, float t) {
        return (double)t < 0.5 ? a : b;
    }

    @NotNull
    public static final TextStyle lerp(@NotNull TextStyle start, @NotNull TextStyle stop, float fraction) {
        Shadow shadow;
        TextGeometricTransform textGeometricTransform;
        BaselineShift baselineShift;
        FontWeight fontWeight;
        Color color;
        Intrinsics.checkParameterIsNotNull((Object)start, (String)"start");
        Intrinsics.checkParameterIsNotNull((Object)stop, (String)"stop");
        Color color2 = start.getColor();
        if (color2 == null) {
            color2 = Color.Companion.getBlack();
        }
        if ((color = stop.getColor()) == null) {
            color = Color.Companion.getBlack();
        }
        Color color3 = ColorKt.lerp((Color)color2, (Color)color, (float)fraction);
        TextUnit textUnit = TextStyleKt.lerpTextUnitInheritable(start.getFontSize(), stop.getFontSize(), fraction);
        FontWeight fontWeight2 = start.getFontWeight();
        if (fontWeight2 == null) {
            fontWeight2 = FontWeight.Companion.getNormal();
        }
        if ((fontWeight = stop.getFontWeight()) == null) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        FontWeight fontWeight3 = FontWeightKt.lerp(fontWeight2, fontWeight, fraction);
        TextUnit textUnit2 = TextStyleKt.lerpTextUnitInheritable(start.getLetterSpacing(), stop.getLetterSpacing(), fraction);
        BaselineShift baselineShift2 = start.getBaselineShift();
        if (baselineShift2 == null) {
            baselineShift2 = new BaselineShift(0.0f);
        }
        if ((baselineShift = stop.getBaselineShift()) == null) {
            baselineShift = new BaselineShift(0.0f);
        }
        BaselineShift baselineShift3 = BaselineShiftKt.lerp(baselineShift2, baselineShift, fraction);
        TextGeometricTransform textGeometricTransform2 = start.getTextGeometricTransform();
        if (textGeometricTransform2 == null) {
            textGeometricTransform2 = TextGeometricTransform.Companion.getNone$ui_text_release();
        }
        if ((textGeometricTransform = stop.getTextGeometricTransform()) == null) {
            textGeometricTransform = TextGeometricTransform.Companion.getNone$ui_text_release();
        }
        TextGeometricTransform textGeometricTransform3 = TextGeometricTransformKt.lerp(textGeometricTransform2, textGeometricTransform, fraction);
        Shadow shadow2 = start.getShadow();
        if (shadow2 == null) {
            shadow2 = new Shadow(null, null, null, 7, null);
        }
        if ((shadow = stop.getShadow()) == null) {
            shadow = new Shadow(null, null, null, 7, null);
        }
        Shadow shadow3 = ShadowKt.lerp((Shadow)shadow2, (Shadow)shadow, (float)fraction);
        TextDecoration textDecoration = TextStyleKt.lerpDiscrete(start.getDecoration(), stop.getDecoration(), fraction);
        Color color4 = TextStyleKt.lerpDiscrete(start.getBackground(), stop.getBackground(), fraction);
        LocaleList localeList = TextStyleKt.lerpDiscrete(start.getLocaleList(), stop.getLocaleList(), fraction);
        TextGeometricTransform textGeometricTransform4 = textGeometricTransform3;
        BaselineShift baselineShift4 = baselineShift3;
        TextUnit textUnit3 = textUnit2;
        String string = TextStyleKt.lerpDiscrete(start.getFontFeatureSettings(), stop.getFontFeatureSettings(), fraction);
        FontSynthesis fontSynthesis = TextStyleKt.lerpDiscrete(start.getFontSynthesis(), stop.getFontSynthesis(), fraction);
        FontStyle fontStyle = TextStyleKt.lerpDiscrete(start.getFontStyle(), stop.getFontStyle(), fraction);
        FontWeight fontWeight4 = fontWeight3;
        TextUnit textUnit4 = textUnit;
        FontFamily fontFamily = TextStyleKt.lerpDiscrete(start.getFontFamily(), stop.getFontFamily(), fraction);
        return new TextStyle(color3, textUnit4, fontWeight4, fontStyle, fontSynthesis, fontFamily, string, textUnit3, baselineShift4, textGeometricTransform4, localeList, color4, textDecoration, shadow3);
    }
}

