/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import android.text.SpannableString;
import android.text.TextPaint;
import android.text.style.AbsoluteSizeSpan;
import android.text.style.BackgroundColorSpan;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LocaleSpan;
import android.text.style.RelativeSizeSpan;
import android.text.style.ScaleXSpan;
import android.text.style.StrikethroughSpan;
import android.text.style.UnderlineSpan;
import androidx.annotation.RequiresApi;
import androidx.text.style.BaselineShiftSpan;
import androidx.text.style.FontFeatureSpan;
import androidx.text.style.LetterSpacingSpan;
import androidx.text.style.LineHeightSpan;
import androidx.text.style.ShadowSpan;
import androidx.text.style.SkewXSpan;
import androidx.text.style.TypefaceSpan;
import androidx.ui.core.Density;
import androidx.ui.core.DensityKt;
import androidx.ui.core.DensityScope;
import androidx.ui.core.Px;
import androidx.ui.core.TextUnit;
import androidx.ui.core.TextUnitKt;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Shadow;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.Locale;
import androidx.ui.text.LocaleList;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.platform.AndroidLocale;
import androidx.ui.text.platform.AndroidParagraphHelperKt$WhenMappings;
import androidx.ui.text.platform.PlatformLocale;
import androidx.ui.text.platform.TypefaceAdapter;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextIndent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000h\n\u0000\n\u0002\u0010\r\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\u001aF\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u00072\u0012\u0010\b\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u000b0\n0\t2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0000\u001a\u0018\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002\u001a\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0000\u001a$\u0010\u0017\u001a\u00020\u000b*\u00020\u00182\u0006\u0010\u0012\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\f\u001a\u00020\rH\u0000\u001a\f\u0010\u0019\u001a\u00020\u001a*\u00020\u000bH\u0002\u001a\f\u0010\u001b\u001a\u00020\u001c*\u00020\u001dH\u0003\u001a\f\u0010\u001e\u001a\u00020\u001f*\u00020 H\u0002\u00a8\u0006!"}, d2={"createStyledText", "", "text", "", "lineHeight", "Landroidx/ui/core/TextUnit;", "textIndent", "Landroidx/ui/text/style/TextIndent;", "textStyles", "", "Landroidx/ui/text/AnnotatedString$Item;", "Landroidx/ui/text/TextStyle;", "density", "Landroidx/ui/core/Density;", "typefaceAdapter", "Landroidx/ui/text/platform/TypefaceAdapter;", "createTypeface", "Landroid/graphics/Typeface;", "style", "resolveTextDirectionHeuristics", "", "textDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "applyTextStyle", "Landroid/text/TextPaint;", "hasFontAttributes", "", "toAndroidLocaleList", "Landroid/os/LocaleList;", "Landroidx/ui/text/LocaleList;", "toJavaLocale", "Ljava/util/Locale;", "Landroidx/ui/text/Locale;", "ui-text_release"})
public final class AndroidParagraphHelperKt {
    @NotNull
    public static final TextStyle applyTextStyle(@NotNull TextPaint $this$applyTextStyle, @NotNull TextStyle style, @NotNull TypefaceAdapter typefaceAdapter, @NotNull Density density) {
        Object object;
        Object object2;
        Object it;
        boolean bl;
        boolean bl2;
        Object object3;
        Intrinsics.checkParameterIsNotNull((Object)$this$applyTextStyle, (String)"$this$applyTextStyle");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$0[style.getFontSize().getType().ordinal()]) {
            case 1: {
                DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>($this$applyTextStyle, style){
                    final /* synthetic */ TextPaint $this_applyTextStyle;
                    final /* synthetic */ TextStyle $style;

                    public final void invoke(@NotNull DensityScope $this$withDensity) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                        this.$this_applyTextStyle.setTextSize($this$withDensity.toPx(this.$style.getFontSize()).getValue());
                    }
                    {
                        this.$this_applyTextStyle = textPaint;
                        this.$style = textStyle;
                        super(1);
                    }
                }));
                break;
            }
            case 2: {
                TextPaint textPaint = $this$applyTextStyle;
                textPaint.setTextSize(textPaint.getTextSize() * style.getFontSize().getValue());
            }
        }
        if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
            $this$applyTextStyle.setTypeface(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter));
        }
        LocaleList localeList = style.getLocaleList();
        if (localeList != null) {
            object3 = localeList;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl3 = false;
            if (Build.VERSION.SDK_INT >= 24) {
                $this$applyTextStyle.setTextLocales(AndroidParagraphHelperKt.toAndroidLocaleList((LocaleList)it));
            } else {
                Locale locale = ((LocaleList)it).isEmpty() ? Locale.Companion.getCurrent() : ((LocaleList)it).get(0);
                $this$applyTextStyle.setTextLocale(AndroidParagraphHelperKt.toJavaLocale(locale));
            }
        }
        Color color = style.getColor();
        if (color != null) {
            object3 = color;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl4 = false;
            $this$applyTextStyle.setColor(ColorKt.toArgb((Color)it));
        }
        switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$1[style.getLetterSpacing().getType().ordinal()]) {
            case 1: {
                DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>($this$applyTextStyle, style){
                    final /* synthetic */ TextPaint $this_applyTextStyle;
                    final /* synthetic */ TextStyle $style;

                    public final void invoke(@NotNull DensityScope $this$withDensity) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                        this.$this_applyTextStyle.setLetterSpacing($this$withDensity.toPx(this.$style.getLetterSpacing()).getValue() / this.$this_applyTextStyle.getTextSize());
                    }
                    {
                        this.$this_applyTextStyle = textPaint;
                        this.$style = textStyle;
                        super(1);
                    }
                }));
                break;
            }
            case 2: {
                $this$applyTextStyle.setLetterSpacing(style.getLetterSpacing().getValue());
            }
        }
        String string = style.getFontFeatureSettings();
        if (string != null) {
            object3 = string;
            bl2 = false;
            bl = false;
            it = object3;
            boolean bl5 = false;
            $this$applyTextStyle.setFontFeatureSettings((String)it);
        }
        if ((object2 = style.getTextGeometricTransform()) != null && (object2 = ((TextGeometricTransform)object2).getScaleX()) != null) {
            object3 = object2;
            bl2 = false;
            bl = false;
            float it2 = ((Number)object3).floatValue();
            boolean bl6 = false;
            TextPaint textPaint = $this$applyTextStyle;
            textPaint.setTextScaleX(textPaint.getTextScaleX() * it2);
        }
        if ((object = style.getTextGeometricTransform()) != null && (object = ((TextGeometricTransform)object).getSkewX()) != null) {
            object3 = object;
            bl2 = false;
            bl = false;
            float it3 = ((Number)object3).floatValue();
            boolean bl7 = false;
            TextPaint textPaint = $this$applyTextStyle;
            textPaint.setTextSkewX(textPaint.getTextSkewX() + it3);
        }
        Shadow shadow = style.getShadow();
        if (shadow != null) {
            object3 = shadow;
            bl2 = false;
            bl = false;
            Object it4 = object3;
            boolean bl8 = false;
            $this$applyTextStyle.setShadowLayer(it4.getBlurRadius().getValue(), it4.getOffset().getDx(), it4.getOffset().getDy(), ColorKt.toArgb((Color)it4.getColor()));
        }
        TextDecoration textDecoration = style.getDecoration();
        if (textDecoration != null) {
            object3 = textDecoration;
            bl2 = false;
            bl = false;
            Object it5 = object3;
            boolean bl9 = false;
            if (((TextDecoration)it5).contains(TextDecoration.Companion.getUnderline())) {
                $this$applyTextStyle.setUnderlineText(true);
            }
            if (((TextDecoration)it5).contains(TextDecoration.Companion.getLineThrough())) {
                $this$applyTextStyle.setStrikeThruText(true);
            }
        }
        object3 = null;
        TextDecoration textDecoration2 = null;
        BaselineShift baselineShift = style.getBaselineShift();
        LocaleList localeList2 = null;
        TextGeometricTransform textGeometricTransform = null;
        Color color2 = style.getBackground();
        return new TextStyle(null, null, null, null, null, null, null, null, baselineShift, textGeometricTransform, localeList2, color2, textDecoration2, (Shadow)object3, 14079, null);
    }

    @NotNull
    public static final CharSequence createStyledText(@NotNull String text, @NotNull TextUnit lineHeight, @Nullable TextIndent textIndent, @NotNull List<AnnotatedString.Item<TextStyle>> textStyles, @NotNull Density density, @NotNull TypefaceAdapter typefaceAdapter) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)lineHeight, (String)"lineHeight");
        Intrinsics.checkParameterIsNotNull(textStyles, (String)"textStyles");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)typefaceAdapter, (String)"typefaceAdapter");
        if (textStyles.isEmpty() && textIndent == null) {
            return text;
        }
        SpannableString spannableString = new SpannableString((CharSequence)text);
        switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$2[lineHeight.getType().ordinal()]) {
            case 1: {
                DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>(spannableString, lineHeight, text){
                    final /* synthetic */ SpannableString $spannableString;
                    final /* synthetic */ TextUnit $lineHeight;
                    final /* synthetic */ String $text;

                    public final void invoke(@NotNull DensityScope $this$withDensity) {
                        Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                        float f = $this$withDensity.toPx(this.$lineHeight).getValue();
                        SpannableString spannableString = this.$spannableString;
                        boolean bl = false;
                        float f2 = (float)Math.ceil(f);
                        int n = (int)f2;
                        spannableString.setSpan((Object)new LineHeightSpan(n), 0, this.$text.length(), 33);
                    }
                    {
                        this.$spannableString = spannableString;
                        this.$lineHeight = textUnit;
                        this.$text = string;
                        super(1);
                    }
                }));
            }
        }
        TextIndent textIndent2 = textIndent;
        if (textIndent2 != null) {
            TextIndent textIndent3 = textIndent2;
            boolean bl = false;
            boolean bl2 = false;
            TextIndent indent = textIndent3;
            boolean bl3 = false;
            if (!(Intrinsics.areEqual((Object)indent.getFirstLine(), (Object)TextUnitKt.getSp((int)0)) && Intrinsics.areEqual((Object)indent.getRestLine(), (Object)TextUnitKt.getSp((int)0)) || indent.getFirstLine().isInherit() || indent.getRestLine().isInherit())) {
                DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>(indent, density, spannableString, text){
                    final /* synthetic */ TextIndent $indent;
                    final /* synthetic */ Density $density$inlined;
                    final /* synthetic */ SpannableString $spannableString$inlined;
                    final /* synthetic */ String $text$inlined;
                    {
                        this.$indent = textIndent;
                        this.$density$inlined = density;
                        this.$spannableString$inlined = spannableString;
                        this.$text$inlined = string;
                        super(1);
                    }

                    public final void invoke(@NotNull DensityScope $this$withDensity) {
                        Px px;
                        Px px2;
                        Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                        switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$3[this.$indent.getFirstLine().getType().ordinal()]) {
                            case 1: {
                                px2 = $this$withDensity.toPx(this.$indent.getFirstLine());
                                break;
                            }
                            case 2: {
                                boolean $this$px$iv = false;
                                px2 = new Px((float)$this$px$iv);
                                break;
                            }
                            case 3: {
                                boolean $this$px$iv = false;
                                px2 = new Px((float)$this$px$iv);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        Px firstLine = px2;
                        switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$4[this.$indent.getRestLine().getType().ordinal()]) {
                            case 1: {
                                px = $this$withDensity.toPx(this.$indent.getRestLine());
                                break;
                            }
                            case 2: {
                                boolean $this$px$iv = false;
                                px = new Px((float)$this$px$iv);
                                break;
                            }
                            case 3: {
                                boolean $this$px$iv = false;
                                px = new Px((float)$this$px$iv);
                                break;
                            }
                            default: {
                                throw new NoWhenBranchMatchedException();
                            }
                        }
                        Px restLine = px;
                        this.$spannableString$inlined.setSpan((Object)new LeadingMarginSpan.Standard((int)firstLine.getValue(), (int)restLine.getValue()), 0, this.$text$inlined.length(), 33);
                    }
                }));
            }
        }
        for (AnnotatedString.Item<TextStyle> textStyle : textStyles) {
            Object object;
            Object object2;
            Object it;
            Object object3;
            boolean bl;
            boolean bl4;
            int start = textStyle.getStart();
            int end = textStyle.getEnd();
            TextStyle style = textStyle.getStyle();
            if (start < 0 || start >= text.length() || end <= start || end > text.length()) continue;
            if (style.getBaselineShift() != null) {
                bl4 = false;
                bl = false;
                it = object3;
                boolean bl5 = false;
                spannableString.setSpan((Object)new BaselineShiftSpan(((BaselineShift)it).getMultiplier()), start, end, 33);
            }
            if (style.getColor() != null) {
                bl4 = false;
                bl = false;
                it = object3;
                boolean bl6 = false;
                spannableString.setSpan((Object)new ForegroundColorSpan(ColorKt.toArgb((Color)it)), start, end, 33);
            }
            if (style.getDecoration() != null) {
                bl4 = false;
                bl = false;
                it = object3;
                boolean bl7 = false;
                if (((TextDecoration)it).contains(TextDecoration.Companion.getUnderline())) {
                    spannableString.setSpan((Object)new UnderlineSpan(), start, end, 33);
                }
                if (((TextDecoration)it).contains(TextDecoration.Companion.getLineThrough())) {
                    spannableString.setSpan((Object)new StrikethroughSpan(), start, end, 33);
                }
            }
            switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$5[style.getFontSize().getType().ordinal()]) {
                case 1: {
                    DensityKt.withDensity((Density)density, (Function1)((Function1)new Function1<DensityScope, Unit>(spannableString, style, start, end){
                        final /* synthetic */ SpannableString $spannableString;
                        final /* synthetic */ TextStyle $style;
                        final /* synthetic */ int $start;
                        final /* synthetic */ int $end;

                        public final void invoke(@NotNull DensityScope $this$withDensity) {
                            Intrinsics.checkParameterIsNotNull((Object)$this$withDensity, (String)"$receiver");
                            this.$spannableString.setSpan((Object)new AbsoluteSizeSpan(MathKt.roundToInt((float)$this$withDensity.toPx(this.$style.getFontSize()).getValue()), true), this.$start, this.$end, 33);
                        }
                        {
                            this.$spannableString = spannableString;
                            this.$style = textStyle;
                            this.$start = n;
                            this.$end = n2;
                            super(1);
                        }
                    }));
                    break;
                }
                case 2: {
                    spannableString.setSpan((Object)new RelativeSizeSpan(style.getFontSize().getValue()), start, end, 33);
                }
            }
            if (style.getFontFeatureSettings() != null) {
                bl4 = false;
                bl = false;
                it = object3;
                boolean bl8 = false;
                spannableString.setSpan((Object)new FontFeatureSpan((String)it), start, end, 33);
            }
            if (AndroidParagraphHelperKt.hasFontAttributes(style)) {
                spannableString.setSpan((Object)new TypefaceSpan(AndroidParagraphHelperKt.createTypeface(style, typefaceAdapter)), start, end, 33);
            }
            if ((object2 = style.getTextGeometricTransform()) != null && (object2 = ((TextGeometricTransform)object2).getScaleX()) != null) {
                object3 = object2;
                bl4 = false;
                bl = false;
                float it2 = ((Number)object3).floatValue();
                boolean bl9 = false;
                spannableString.setSpan((Object)new ScaleXSpan(it2), start, end, 33);
            }
            if ((object = style.getTextGeometricTransform()) != null && (object = ((TextGeometricTransform)object).getSkewX()) != null) {
                object3 = object;
                bl4 = false;
                bl = false;
                float it3 = ((Number)object3).floatValue();
                boolean bl10 = false;
                spannableString.setSpan((Object)new SkewXSpan(it3), start, end, 33);
            }
            switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$6[style.getLetterSpacing().getType().ordinal()]) {
                case 1: {
                    break;
                }
                case 2: {
                    spannableString.setSpan((Object)new LetterSpacingSpan(style.getLetterSpacing().getValue()), start, end, 33);
                }
            }
            if (style.getLocaleList() != null) {
                LocaleSpan localeSpan;
                bl4 = false;
                bl = false;
                Object it4 = object3;
                boolean bl11 = false;
                if (Build.VERSION.SDK_INT >= 24) {
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toAndroidLocaleList((LocaleList)it4));
                } else {
                    Locale locale = ((LocaleList)it4).isEmpty() ? Locale.Companion.getCurrent() : ((LocaleList)it4).get(0);
                    localeSpan = new LocaleSpan(AndroidParagraphHelperKt.toJavaLocale(locale));
                }
                spannableString.setSpan((Object)localeSpan, start, end, 33);
            }
            if (style.getBackground() != null) {
                bl4 = false;
                bl = false;
                Object it5 = object3;
                boolean bl12 = false;
                spannableString.setSpan((Object)new BackgroundColorSpan(ColorKt.toArgb((Color)it5)), start, end, 33);
            }
            if (style.getShadow() == null) continue;
            bl4 = false;
            bl = false;
            Object it6 = object3;
            boolean bl13 = false;
            spannableString.setSpan((Object)new ShadowSpan(ColorKt.toArgb((Color)it6.getColor()), it6.getOffset().getDx(), it6.getOffset().getDy(), it6.getBlurRadius().getValue()), start, end, 33);
        }
        return (CharSequence)spannableString;
    }

    private static final boolean hasFontAttributes(@NotNull TextStyle $this$hasFontAttributes) {
        return $this$hasFontAttributes.getFontFamily() != null || $this$hasFontAttributes.getFontStyle() != null || $this$hasFontAttributes.getFontWeight() != null;
    }

    private static final Typeface createTypeface(TextStyle style, TypefaceAdapter typefaceAdapter) {
        FontSynthesis fontSynthesis;
        FontStyle fontStyle;
        FontFamily fontFamily = style.getFontFamily();
        FontWeight fontWeight = style.getFontWeight();
        if (fontWeight == null) {
            fontWeight = FontWeight.Companion.getNormal();
        }
        if ((fontStyle = style.getFontStyle()) == null) {
            fontStyle = FontStyle.Normal;
        }
        if ((fontSynthesis = style.getFontSynthesis()) == null) {
            fontSynthesis = FontSynthesis.All;
        }
        return typefaceAdapter.create(fontFamily, fontWeight, fontStyle, fontSynthesis);
    }

    public static final int resolveTextDirectionHeuristics(@NotNull TextDirectionAlgorithm textDirectionAlgorithm) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)((Object)textDirectionAlgorithm), (String)"textDirectionAlgorithm");
        switch (AndroidParagraphHelperKt$WhenMappings.$EnumSwitchMapping$7[textDirectionAlgorithm.ordinal()]) {
            case 1: {
                n = 2;
                break;
            }
            case 2: {
                n = 3;
                break;
            }
            case 3: {
                n = 0;
                break;
            }
            case 4: {
                n = 1;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        return n;
    }

    private static final java.util.Locale toJavaLocale(@NotNull Locale $this$toJavaLocale) {
        PlatformLocale platformLocale = $this$toJavaLocale.getPlatformLocale$ui_text_release();
        if (platformLocale == null) {
            throw new TypeCastException("null cannot be cast to non-null type androidx.ui.text.platform.AndroidLocale");
        }
        return ((AndroidLocale)platformLocale).getJavaLocale();
    }

    /*
     * WARNING - void declaration
     */
    @RequiresApi(api=24)
    private static final android.os.LocaleList toAndroidLocaleList(@NotNull LocaleList $this$toAndroidLocaleList) {
        Collection<java.util.Locale> collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv = $this$toAndroidLocaleList;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Locale locale = (Locale)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            java.util.Locale locale2 = AndroidParagraphHelperKt.toJavaLocale((Locale)it);
            collection.add(locale2);
        }
        collection = (List)destination$iv$iv;
        Collection $this$toTypedArray$iv = collection;
        boolean $i$f$toTypedArray = false;
        Collection thisCollection$iv = $this$toTypedArray$iv;
        java.util.Locale[] localeArray = thisCollection$iv.toArray(new java.util.Locale[0]);
        if (localeArray == null) {
            throw new TypeCastException("null cannot be cast to non-null type kotlin.Array<T>");
        }
        collection = localeArray;
        java.util.Locale[] localeArray2 = (java.util.Locale[])collection;
        java.util.Locale[] localeArray3 = Arrays.copyOf(localeArray2, localeArray2.length);
        return new android.os.LocaleList(localeArray3);
    }
}

