/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.ui.text.TextRange;
import androidx.ui.text.TextRangeKt;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000(\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0004\b\u0086\b\u0018\u00002\u00020\u0001B%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\u0002\u0010\u0007J\t\u0010\r\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\u000e\u001a\u00020\u0005H\u00c6\u0003J\u000b\u0010\u000f\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J)\u0010\u0010\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\n\b\u0002\u0010\u0006\u001a\u0004\u0018\u00010\u0005H\u00c6\u0001J\u0013\u0010\u0011\u001a\u00020\u00122\b\u0010\u0013\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\u0006\u0010\u0014\u001a\u00020\u0003J\u000e\u0010\u0015\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\u000e\u0010\u0018\u001a\u00020\u00032\u0006\u0010\u0016\u001a\u00020\u0017J\t\u0010\u0019\u001a\u00020\u0017H\u00d6\u0001J\t\u0010\u001a\u001a\u00020\u0003H\u00d6\u0001R\u0013\u0010\u0006\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\b\u0010\tR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\tR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u001b"}, d2={"Landroidx/ui/input/InputState;", "", "text", "", "selection", "Landroidx/ui/text/TextRange;", "composition", "(Ljava/lang/String;Landroidx/ui/text/TextRange;Landroidx/ui/text/TextRange;)V", "getComposition", "()Landroidx/ui/text/TextRange;", "getSelection", "getText", "()Ljava/lang/String;", "component1", "component2", "component3", "copy", "equals", "", "other", "getSelectedText", "getTextAfterSelection", "maxChars", "", "getTextBeforeSelection", "hashCode", "toString", "ui-text_release"})
public final class InputState {
    private final String text;
    private final TextRange selection;
    private final TextRange composition;

    public InputState(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        this.text = text;
        this.selection = selection;
        this.composition = composition;
    }

    public /* synthetic */ InputState(String text, TextRange selection, TextRange composition, int $mask0, DefaultConstructorMarker $marker) {
        String string = ($mask0 & 1) != 0 ? "" : text;
        TextRange textRange = ($mask0 & 2) != 0 ? new TextRange(0, 0) : selection;
        TextRange textRange2 = ($mask0 & 4) != 0 ? (TextRange)null : composition;
        this(string, textRange, textRange2);
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    @NotNull
    public final TextRange getSelection() {
        return this.selection;
    }

    @Nullable
    public final TextRange getComposition() {
        return this.composition;
    }

    @NotNull
    public final String getTextBeforeSelection(int maxChars) {
        String string = this.getText();
        int n = 0;
        int n2 = this.getSelection().getMin() - maxChars;
        boolean bl = false;
        n = Math.max(n, n2);
        n2 = this.getSelection().getMin();
        bl = false;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String getTextAfterSelection(int maxChars) {
        String string = this.getText();
        int n = this.getSelection().getMax();
        int n2 = this.getSelection().getMax() + maxChars;
        int n3 = this.getText().length();
        boolean bl = false;
        n2 = Math.min(n2, n3);
        n3 = 0;
        String string2 = string;
        if (string2 == null) {
            throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
        }
        String string3 = string2.substring(n, n2);
        Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.Strin\u2026ing(startIndex, endIndex)");
        return string3;
    }

    @NotNull
    public final String getSelectedText() {
        return TextRangeKt.substring(this.getText(), this.getSelection());
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    @NotNull
    public final TextRange component2() {
        return this.selection;
    }

    @Nullable
    public final TextRange component3() {
        return this.composition;
    }

    @NotNull
    public final InputState copy(@NotNull String text, @NotNull TextRange selection, @Nullable TextRange composition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)selection, (String)"selection");
        return new InputState(text, selection, composition);
    }

    public static /* synthetic */ InputState copy$default(@NotNull InputState this_, @Nullable String text, @Nullable TextRange selection, @Nullable TextRange composition, int $mask0, @Nullable Object $handler) {
        String string = ($mask0 & 1) != 0 ? this_.text : text;
        TextRange textRange = ($mask0 & 2) != 0 ? this_.selection : selection;
        TextRange textRange2 = ($mask0 & 4) != 0 ? this_.composition : composition;
        return this_.copy(string, textRange, textRange2);
    }

    @NotNull
    public String toString() {
        return "InputState(text=" + this.text + ", selection=" + this.selection + ", composition=" + this.composition + ")";
    }

    public int hashCode() {
        return (this.text.hashCode() * 31 + this.selection.hashCode()) * 31 + (this.composition == null ? 0 : this.composition.hashCode());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof InputState)) {
            return false;
        }
        Object object = other;
        InputState inputState = (InputState)object;
        if (!Intrinsics.areEqual((Object)this.text, (Object)inputState.text)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.selection, (Object)inputState.selection)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.composition, (Object)inputState.composition);
    }

    public InputState() {
        this(null, null, null, 7, null);
    }
}

