/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.text.AnnotatedString;
import androidx.ui.text.AnnotatedStringKt;
import androidx.ui.text.ParagraphIntrinsicInfo;
import androidx.ui.text.ParagraphIntrinsics;
import androidx.ui.text.ParagraphIntrinsicsKt;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.unit.Density;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000@\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0002\u0018\u00002\u00020\u0001B%\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u0004\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u0019H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u001a\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u000f0\u000eX\u0080\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u0014\u0010\u0012\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0016\u001a\u00020\u0013X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0015\u00a8\u0006\u001b"}, d2={"Landroidx/ui/text/MultiParagraphIntrinsics;", "Landroidx/ui/text/ParagraphIntrinsics;", "annotatedString", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "density", "Landroidx/ui/unit/Density;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/text/TextStyle;Landroidx/ui/unit/Density;Landroidx/ui/text/font/Font$ResourceLoader;)V", "getAnnotatedString", "()Landroidx/ui/text/AnnotatedString;", "infoList", "", "Landroidx/ui/text/ParagraphIntrinsicInfo;", "getInfoList$ui_text_release", "()Ljava/util/List;", "maxIntrinsicWidth", "", "getMaxIntrinsicWidth", "()F", "minIntrinsicWidth", "getMinIntrinsicWidth", "resolveTextDirection", "Landroidx/ui/text/ParagraphStyle;", "defaultStyle", "ui-text_release"})
public final class MultiParagraphIntrinsics
implements ParagraphIntrinsics {
    private final AnnotatedString annotatedString;
    private final float minIntrinsicWidth;
    private final float maxIntrinsicWidth;
    private final List<ParagraphIntrinsicInfo> infoList;

    /*
     * WARNING - void declaration
     */
    public MultiParagraphIntrinsics(@NotNull AnnotatedString annotatedString, @NotNull TextStyle style, @NotNull Density density, @NotNull Font.ResourceLoader resourceLoader) {
        Object v1;
        Object e$iv;
        Object maxElem$iv;
        Object v0;
        Iterable $this$maxBy$iv;
        List list;
        Iterable $this$mapTo$iv$iv$iv;
        void $this$mapEachParagraphStyle$iv;
        Intrinsics.checkParameterIsNotNull((Object)annotatedString, (String)"annotatedString");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this.annotatedString = annotatedString;
        TextDirectionAlgorithm textDirectionAlgorithm = style.getTextDirectionAlgorithm();
        boolean bl = false;
        boolean bl2 = false;
        if (textDirectionAlgorithm == null) {
            String string = "ParagraphStyle.textDirectionAlgorithm should not be null";
            throw (Throwable)new IllegalArgumentException(string.toString());
        }
        ParagraphStyle paragraphStyle = style.toParagraphStyle();
        Object object = this.getAnnotatedString();
        MultiParagraphIntrinsics multiParagraphIntrinsics = this;
        Iterable $this$map$iv$iv = AnnotatedStringKt.normalizedParagraphStyles((AnnotatedString)$this$mapEachParagraphStyle$iv, paragraphStyle);
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv$iv;
        Collection destination$iv$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv$iv : $this$mapTo$iv$iv$iv) {
            void paragraphStyleItem;
            void paragraphStyleItem$iv;
            AnnotatedString.Item item = (AnnotatedString.Item)item$iv$iv$iv;
            Collection collection = destination$iv$iv$iv;
            AnnotatedString annotatedString$iv = AnnotatedStringKt.access$substringWithoutParagraphStyles$0((AnnotatedString)$this$mapEachParagraphStyle$iv, paragraphStyleItem$iv.getStart(), paragraphStyleItem$iv.getEnd());
            void var17_31 = paragraphStyleItem$iv;
            AnnotatedString annotatedString2 = annotatedString$iv;
            ParagraphStyle currentParagraphStyle = this.resolveTextDirection((ParagraphStyle)paragraphStyleItem.getItem(), paragraphStyle);
            String string = annotatedString2.getText();
            List<AnnotatedString.Item<SpanStyle>> list2 = annotatedString2.getSpanStyles();
            TextStyle textStyle = style.merge(currentParagraphStyle);
            Density density2 = density;
            Font.ResourceLoader resourceLoader2 = resourceLoader;
            ParagraphIntrinsicInfo paragraphIntrinsicInfo = new ParagraphIntrinsicInfo(ParagraphIntrinsicsKt.ParagraphIntrinsics(string, textStyle, list2, density2, resourceLoader2), paragraphStyleItem.getStart(), paragraphStyleItem.getEnd());
            collection.add(paragraphIntrinsicInfo);
        }
        multiParagraphIntrinsics.infoList = list = (List)destination$iv$iv$iv;
        $this$mapTo$iv$iv$iv = this.getInfoList$ui_text_release();
        multiParagraphIntrinsics = this;
        boolean $i$f$maxBy = false;
        Iterator iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                ParagraphIntrinsicInfo it = (ParagraphIntrinsicInfo)maxElem$iv;
                float maxValue$iv = it.getIntrinsics().getMinIntrinsicWidth();
                do {
                    ParagraphIntrinsicInfo it2;
                    float v$iv;
                    if (Float.compare(maxValue$iv, v$iv = (it2 = (ParagraphIntrinsicInfo)(e$iv = iterator$iv.next())).getIntrinsics().getMinIntrinsicWidth()) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        list = v0;
        ParagraphIntrinsicInfo paragraphIntrinsicInfo = (ParagraphIntrinsicInfo)((Object)list);
        ParagraphIntrinsics paragraphIntrinsics = paragraphIntrinsicInfo == null ? (ParagraphIntrinsics)null : paragraphIntrinsicInfo.getIntrinsics();
        object = paragraphIntrinsics == null ? (Float)null : Float.valueOf(paragraphIntrinsics.getMinIntrinsicWidth());
        multiParagraphIntrinsics.minIntrinsicWidth = object == null ? 0.0f : ((Float)object).floatValue();
        $this$maxBy$iv = this.getInfoList$ui_text_release();
        multiParagraphIntrinsics = this;
        $i$f$maxBy = false;
        iterator$iv = $this$maxBy$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v1 = null;
        } else {
            maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v1 = maxElem$iv;
            } else {
                ParagraphIntrinsicInfo it = (ParagraphIntrinsicInfo)maxElem$iv;
                float maxValue$iv = it.getIntrinsics().getMaxIntrinsicWidth();
                do {
                    ParagraphIntrinsicInfo it3;
                    float v$iv;
                    if (Float.compare(maxValue$iv, v$iv = (it3 = (ParagraphIntrinsicInfo)(e$iv = iterator$iv.next())).getIntrinsics().getMaxIntrinsicWidth()) >= 0) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v1 = maxElem$iv;
            }
        }
        list = v1;
        paragraphIntrinsicInfo = (ParagraphIntrinsicInfo)((Object)list);
        paragraphIntrinsics = paragraphIntrinsicInfo == null ? (ParagraphIntrinsics)null : paragraphIntrinsicInfo.getIntrinsics();
        object = paragraphIntrinsics == null ? (Float)null : Float.valueOf(paragraphIntrinsics.getMaxIntrinsicWidth());
        multiParagraphIntrinsics.maxIntrinsicWidth = object == null ? 0.0f : ((Float)object).floatValue();
    }

    @NotNull
    public final AnnotatedString getAnnotatedString() {
        return this.annotatedString;
    }

    @Override
    public float getMinIntrinsicWidth() {
        return this.minIntrinsicWidth;
    }

    @Override
    public float getMaxIntrinsicWidth() {
        return this.maxIntrinsicWidth;
    }

    @NotNull
    public final List<ParagraphIntrinsicInfo> getInfoList$ui_text_release() {
        return this.infoList;
    }

    private final ParagraphStyle resolveTextDirection(ParagraphStyle style, ParagraphStyle defaultStyle) {
        ParagraphStyle paragraphStyle;
        TextDirectionAlgorithm textDirectionAlgorithm = style.getTextDirectionAlgorithm();
        if (textDirectionAlgorithm == null) {
            paragraphStyle = null;
        } else {
            TextDirectionAlgorithm textDirectionAlgorithm2 = textDirectionAlgorithm;
            boolean bl = false;
            boolean bl2 = false;
            TextDirectionAlgorithm it = textDirectionAlgorithm2;
            paragraphStyle = style;
        }
        ParagraphStyle paragraphStyle2 = paragraphStyle;
        return paragraphStyle2 == null ? ParagraphStyle.copy$default(style, null, defaultStyle.getTextDirectionAlgorithm(), null, null, 13, null) : paragraphStyle2;
    }
}

