/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.LayoutDirection;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.BlendMode;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.ClipOp;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.graphics.Shader;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.MultiParagraph;
import androidx.ui.text.MultiParagraphIntrinsics;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.TextDelegateKt;
import androidx.ui.text.TextLayoutHelperKt;
import androidx.ui.text.TextLayoutInput;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextOverflow;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001BO\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\u0002\u0010\u0012J(\u00103\u001a\u0002H4\"\u0004\b\u0000\u001042\u0012\u00105\u001a\u000e\u0012\u0004\u0012\u00020$\u0012\u0004\u0012\u0002H406H\u0082\b\u00a2\u0006\u0002\u00107J\u001a\u00108\u001a\u0002092\u0006\u0010:\u001a\u00020;2\n\b\u0002\u0010<\u001a\u0004\u0018\u000109J\u0006\u0010=\u001a\u00020>J\u0018\u0010?\u001a\u00020@2\u0006\u0010A\u001a\u00020B2\u0006\u0010C\u001a\u00020BH\u0002J\u0016\u0010D\u001a\u00020>2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000209J.\u0010H\u001a\u00020>2\u0006\u0010I\u001a\u00020\u00072\u0006\u0010J\u001a\u00020\u00072\u0006\u0010K\u001a\u00020L2\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000209J\u001e\u0010M\u001a\u00020>2\u0006\u0010N\u001a\u00020\u00072\u0006\u0010E\u001a\u00020F2\u0006\u0010G\u001a\u000209R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0013\u0010\u0014R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016R\u0011\u0010\u0017\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u0019\u0010\u001aR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0011\u0010\u001d\u001a\u00020\u00188F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\u001aR\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010 R\u0010\u0010!\u001a\u0004\u0018\u00010\"X\u0082\u000e\u00a2\u0006\u0002\n\u0000R&\u0010#\u001a\u0004\u0018\u00010$8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b%\u0010&\u001a\u0004\b'\u0010(\"\u0004\b)\u0010*R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010.R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b/\u00100R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b1\u00102\u00a8\u0006O"}, d2={"Landroidx/ui/text/TextDelegate;", "", "text", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "maxLines", "", "softWrap", "", "overflow", "Landroidx/ui/text/style/TextOverflow;", "density", "Landroidx/ui/unit/Density;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/AnnotatedString;Landroidx/ui/text/TextStyle;IZLandroidx/ui/text/style/TextOverflow;Landroidx/ui/unit/Density;Landroidx/ui/core/LayoutDirection;Landroidx/ui/text/font/Font$ResourceLoader;)V", "getDensity", "()Landroidx/ui/unit/Density;", "getLayoutDirection", "()Landroidx/ui/core/LayoutDirection;", "maxIntrinsicWidth", "Landroidx/ui/unit/IntPx;", "getMaxIntrinsicWidth", "()Landroidx/ui/unit/IntPx;", "getMaxLines", "()I", "minIntrinsicWidth", "getMinIntrinsicWidth", "getOverflow", "()Landroidx/ui/text/style/TextOverflow;", "overflowShader", "Landroidx/ui/graphics/Shader;", "paragraphIntrinsics", "Landroidx/ui/text/MultiParagraphIntrinsics;", "paragraphIntrinsics$annotations$ui_text_release", "()V", "getParagraphIntrinsics$ui_text_release", "()Landroidx/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$ui_text_release", "(Landroidx/ui/text/MultiParagraphIntrinsics;)V", "getResourceLoader", "()Landroidx/ui/text/font/Font$ResourceLoader;", "getSoftWrap", "()Z", "getStyle", "()Landroidx/ui/text/TextStyle;", "getText", "()Landroidx/ui/text/AnnotatedString;", "assumeIntrinsics", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "layout", "Landroidx/ui/text/TextLayoutResult;", "constraints", "Landroidx/ui/core/Constraints;", "prevResult", "layoutIntrinsics", "", "layoutText", "Landroidx/ui/text/MultiParagraph;", "minWidth", "", "maxWidth", "paint", "canvas", "Landroidx/ui/graphics/Canvas;", "textLayoutResult", "paintBackground", "start", "end", "color", "Landroidx/ui/graphics/Color;", "paintCursor", "offset", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TextDelegate {
    private final AnnotatedString text;
    private final int maxLines;
    private final boolean softWrap;
    private final TextOverflow overflow;
    private final Density density;
    private final LayoutDirection layoutDirection;
    private final Font.ResourceLoader resourceLoader;
    private final TextStyle style;
    private Shader overflowShader;
    private MultiParagraphIntrinsics paragraphIntrinsics;

    public TextDelegate(@NotNull AnnotatedString text, @Nullable TextStyle style, int maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this.text = text;
        this.maxLines = maxLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.layoutDirection = layoutDirection;
        this.resourceLoader = resourceLoader;
        this.style = TextDelegateKt.access$resolveTextStyle$0(style, this.getLayoutDirection());
        boolean bl = this.getMaxLines() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString text, TextStyle style, int maxLines, boolean softWrap, TextOverflow overflow, Density density, LayoutDirection layoutDirection, Font.ResourceLoader resourceLoader, int $mask0, DefaultConstructorMarker $marker) {
        TextStyle textStyle = ($mask0 & 2) != 0 ? (TextStyle)null : style;
        int n = ($mask0 & 4) != 0 ? Integer.MAX_VALUE : maxLines;
        boolean bl = ($mask0 & 8) != 0 ? true : softWrap;
        TextOverflow textOverflow = ($mask0 & 0x10) != 0 ? TextOverflow.Clip : overflow;
        this(text, textStyle, n, bl, textOverflow, density, layoutDirection, resourceLoader);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    @NotNull
    public final TextOverflow getOverflow() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    @Nullable
    public final MultiParagraphIntrinsics getParagraphIntrinsics$ui_text_release() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$ui_text_release(@Nullable MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    @VisibleForTesting
    public static /* synthetic */ void paragraphIntrinsics$annotations$ui_text_release() {
    }

    private final <T> T assumeIntrinsics(Function1<? super MultiParagraphIntrinsics, ? extends T> block) {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        return (T)block.invoke((Object)multiParagraphIntrinsics);
    }

    @NotNull
    public final IntPx getMinIntrinsicWidth() {
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        return TextDelegateKt.access$toIntPx$1(it.getMinIntrinsicWidth());
    }

    @NotNull
    public final IntPx getMaxIntrinsicWidth() {
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        return TextDelegateKt.access$toIntPx$1(it.getMaxIntrinsicWidth());
    }

    public final void layoutIntrinsics() {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_release();
        MultiParagraphIntrinsics intrinsics = multiParagraphIntrinsics == null ? new MultiParagraphIntrinsics(this.getText(), this.getStyle(), this.getDensity(), this.getResourceLoader()) : multiParagraphIntrinsics;
        this.setParagraphIntrinsics$ui_text_release(intrinsics);
    }

    private final MultiParagraph layoutText(float minWidth, float maxWidth) {
        this.layoutIntrinsics();
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics paragraphIntrinsics = multiParagraphIntrinsics;
        float width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((float)paragraphIntrinsics.getMaxIntrinsicWidth(), (float)minWidth, (float)maxWidth);
        return new MultiParagraph(paragraphIntrinsics, this.getMaxLines(), Intrinsics.areEqual((Object)((Object)this.getOverflow()), (Object)((Object)TextOverflow.Ellipsis)), new ParagraphConstraints(width));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextLayoutResult layout(@NotNull Constraints constraints, @Nullable TextLayoutResult prevResult) {
        void val1$iv$iv;
        long l;
        void height$iv;
        void width$iv;
        IntPx maxWidth;
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        IntPx minWidth = constraints.getMinWidth();
        boolean widthMatters = this.getSoftWrap() || Intrinsics.areEqual((Object)((Object)this.getOverflow()), (Object)((Object)TextOverflow.Ellipsis));
        IntPx intPx = maxWidth = widthMatters ? constraints.getMaxWidth() : IntPx.Companion.getInfinity();
        if (prevResult != null && TextLayoutHelperKt.canReuse(prevResult, this.getText(), this.getStyle(), this.getMaxLines(), this.getSoftWrap(), this.getOverflow(), this.getDensity(), this.getLayoutDirection(), this.getResourceLoader(), constraints)) {
            void val1$iv$iv2;
            long l2;
            void height$iv2;
            void width$iv2;
            boolean bl = false;
            boolean bl2 = false;
            TextLayoutResult $this$layout_u24lambda_u2d3 = prevResult;
            IntPx intPx2 = TextDelegateKt.access$toIntPx$1($this$layout_u24lambda_u2d3.getMultiParagraph$ui_text_release().getWidth());
            IntPx intPx3 = TextDelegateKt.access$toIntPx$1($this$layout_u24lambda_u2d3.getMultiParagraph$ui_text_release().getHeight());
            Constraints constraints2 = constraints;
            MultiParagraph multiParagraph = null;
            TextLayoutInput textLayoutInput = TextLayoutInput.copy$default($this$layout_u24lambda_u2d3.getLayoutInput(), null, null, 0, false, null, null, null, null, constraints, 255, null);
            TextLayoutResult textLayoutResult = $this$layout_u24lambda_u2d3;
            int n = width$iv2.getValue();
            int val2$iv$iv = height$iv2.getValue();
            boolean $i$f$packInts = false;
            long l3 = l2 = (long)val1$iv$iv2 << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
            IntPxSize intPxSize = new IntPxSize(l3);
            return TextLayoutResult.copy$default(textLayoutResult, textLayoutInput, multiParagraph, ConstraintsKt.constrain((Constraints)constraints2, (IntPxSize)intPxSize), 2, null);
        }
        MultiParagraph multiParagraph = this.layoutText(minWidth.getValue(), maxWidth.getValue());
        IntPx $this$layout_u24lambda_u2d3 = TextDelegateKt.access$toIntPx$1(multiParagraph.getWidth());
        IntPx width$iv2 = TextDelegateKt.access$toIntPx$1(multiParagraph.getHeight());
        Constraints constraints3 = constraints;
        int height$iv2 = width$iv.getValue();
        int val2$iv$iv = height$iv.getValue();
        boolean $i$f$packInts = false;
        long l4 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
        IntPxSize intPxSize = new IntPxSize(l4);
        IntPxSize size = ConstraintsKt.constrain((Constraints)constraints3, (IntPxSize)intPxSize);
        TextLayoutResult textLayoutResult = new TextLayoutResult(new TextLayoutInput(this.getText(), this.getStyle(), this.getMaxLines(), this.getSoftWrap(), this.getOverflow(), this.getDensity(), this.getLayoutDirection(), this.getResourceLoader(), constraints), multiParagraph, size);
        boolean bl = false;
        boolean bl3 = false;
        TextLayoutResult it = textLayoutResult;
        this.overflowShader = TextDelegateKt.access$createOverflowShader$2(this, it);
        return textLayoutResult;
    }

    public static /* synthetic */ TextLayoutResult layout$default(@NotNull TextDelegate this_, @NotNull Constraints constraints, @Nullable TextLayoutResult prevResult, int $mask0, @Nullable Object $handler) {
        TextLayoutResult textLayoutResult = ($mask0 & 2) != 0 ? (TextLayoutResult)null : prevResult;
        return this_.layout(constraints, textLayoutResult);
    }

    public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        block4: {
            Rect bounds;
            Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
            Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
            IntPxSize this_$iv = textLayoutResult.getSize();
            long value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackInt1 = false;
            int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
            float width = new IntPx($this$ipx$iv$iv).getValue();
            IntPxSize this_$iv2 = textLayoutResult.getSize();
            long value$iv$iv2 = this_$iv2.getValue();
            boolean $i$f$unpackInt2 = false;
            int $this$ipx$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
            float height = new IntPx($this$ipx$iv$iv2).getValue();
            if (textLayoutResult.getHasVisualOverflow()) {
                bounds = Rect.Companion.fromLTWH(0.0f, 0.0f, width, height);
                if (this.overflowShader != null) {
                    canvas.saveLayer(bounds, new Paint());
                } else {
                    canvas.save();
                }
                Canvas.DefaultImpls.clipRect$default((Canvas)canvas, (Rect)bounds, (ClipOp)null, (int)2, null);
            }
            textLayoutResult.getMultiParagraph$ui_text_release().paint(canvas);
            if (!textLayoutResult.getHasVisualOverflow()) break block4;
            if (this.overflowShader != null) {
                bounds = Rect.Companion.fromLTWH(0.0f, 0.0f, width, height);
                Paint paint = new Paint();
                paint.setBlendMode(BlendMode.multiply);
                paint.setShader(this.overflowShader);
                canvas.drawRect(bounds, paint);
            }
            canvas.restore();
        }
    }

    public final void paintBackground(int start, int end, @NotNull Color color, @NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
        if (start == end) {
            return;
        }
        Path selectionPath = textLayoutResult.getMultiParagraph$ui_text_release().getPathForRange(start, end);
        Paint paint = new Paint();
        Path path = selectionPath;
        Canvas canvas2 = canvas;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$paintBackground_u24lambda_u2d5 = paint;
        $this$paintBackground_u24lambda_u2d5.setColor(color);
        Paint paint2 = paint;
        canvas2.drawPath(path, paint2);
    }

    public final void paintCursor(int offset, @NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
        Rect cursorRect = textLayoutResult.getMultiParagraph$ui_text_release().getCursorRect(offset);
        Paint paint = new Paint();
        Rect rect = cursorRect;
        Canvas canvas2 = canvas;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$paintCursor_u24lambda_u2d6 = paint;
        $this$paintCursor_u24lambda_u2d6.setColor(Color.Companion.getBlack());
        Paint paint2 = paint;
        canvas2.drawRect(rect, paint2);
    }
}

