/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.VisibleForTesting;
import androidx.ui.core.LayoutDirection;
import androidx.ui.geometry.Offset;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.ColorKt;
import androidx.ui.graphics.Shader;
import androidx.ui.graphics.ShaderKt;
import androidx.ui.graphics.TileMode;
import androidx.ui.text.Paragraph;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.ParagraphKt;
import androidx.ui.text.TextDelegate;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextStyle;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextOverflow;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.TextUnit;
import androidx.ui.unit.TextUnitKt;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.math.MathKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u00008\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0007\n\u0000\u001a\u001a\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\b\u0010\u0006\u001a\u0004\u0018\u00010\u0003H\u0001\u001a\u001a\u0010\u0007\u001a\u00020\b2\b\u0010\t\u001a\u0004\u0018\u00010\b2\u0006\u0010\u0004\u001a\u00020\u0005H\u0002\u001a\u0016\u0010\n\u001a\u0004\u0018\u00010\u000b*\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0002\u001a\f\u0010\u000f\u001a\u00020\u0010*\u00020\u0011H\u0002\"\u000e\u0010\u0000\u001a\u00020\u0001X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"DefaultFontSize", "Landroidx/ui/unit/TextUnit;", "resolveTextDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "textDirectionAlgorithm", "resolveTextStyle", "Landroidx/ui/text/TextStyle;", "style", "createOverflowShader", "Landroidx/ui/graphics/Shader;", "Landroidx/ui/text/TextDelegate;", "textLayoutResult", "Landroidx/ui/text/TextLayoutResult;", "toIntPx", "Landroidx/ui/unit/IntPx;", "", "ui-text_release"})
public final class TextDelegateKt {
    private static final TextUnit DefaultFontSize = TextUnitKt.getSp((int)14);

    private static final TextStyle resolveTextStyle(TextStyle style, LayoutDirection layoutDirection) {
        TextUnit fontSize;
        TextStyle textStyle = style;
        TextDirectionAlgorithm textDirectionAlgorithm = textStyle == null ? (TextDirectionAlgorithm)null : textStyle.getTextDirectionAlgorithm();
        TextDirectionAlgorithm textDirectionAlgorithm2 = textDirectionAlgorithm == null ? TextDelegateKt.resolveTextDirectionAlgorithm(layoutDirection, null) : textDirectionAlgorithm;
        TextStyle textStyle2 = style;
        Object object = textStyle = textStyle2 == null ? (TextUnit)null : textStyle2.getFontSize();
        TextUnit textUnit = textStyle == null ? DefaultFontSize : (fontSize = Intrinsics.areEqual((Object)textStyle, (Object)TextUnit.Companion.getInherit()) ? DefaultFontSize : style.getFontSize());
        return style == null ? new TextStyle(null, fontSize, null, null, null, null, null, null, null, null, null, null, null, null, null, textDirectionAlgorithm2, null, null, 229373, null) : (!Intrinsics.areEqual((Object)((Object)style.getTextDirectionAlgorithm()), (Object)((Object)textDirectionAlgorithm2)) || !Intrinsics.areEqual((Object)style.getFontSize(), (Object)fontSize) ? TextStyle.copy$default(style, null, fontSize, null, null, null, null, null, null, null, null, null, null, null, null, null, textDirectionAlgorithm2, null, null, 229373, null) : style);
    }

    private static final Shader createOverflowShader(TextDelegate $this$createOverflowShader, TextLayoutResult textLayoutResult) {
        Shader shader;
        if (textLayoutResult.getHasVisualOverflow() && Intrinsics.areEqual((Object)((Object)$this$createOverflowShader.getOverflow()), (Object)((Object)TextOverflow.Fade))) {
            boolean bl = false;
            List list = CollectionsKt.emptyList();
            TextStyle textStyle = $this$createOverflowShader.getStyle();
            Density density = $this$createOverflowShader.getDensity();
            Font.ResourceLoader resourceLoader = $this$createOverflowShader.getResourceLoader();
            ParagraphConstraints paragraphConstraints = new ParagraphConstraints(FloatCompanionObject.INSTANCE.getPOSITIVE_INFINITY());
            Paragraph paragraph = ParagraphKt.Paragraph$default("\u2026", textStyle, list, 0, false, paragraphConstraints, density, resourceLoader, 24, null);
            float fadeWidth = paragraph.getMaxIntrinsicWidth();
            float fadeHeight = paragraph.getHeight();
            IntPxSize this_$iv = textLayoutResult.getSize();
            long value$iv$iv = this_$iv.getValue();
            boolean $i$f$unpackInt1 = false;
            int $this$ipx$iv$iv = (int)(value$iv$iv >> 32);
            float width = new IntPx($this$ipx$iv$iv).getValue();
            if (textLayoutResult.getDidOverflowWidth()) {
                this_$iv = Intrinsics.areEqual((Object)$this$createOverflowShader.getLayoutDirection(), (Object)LayoutDirection.Rtl) ? new Pair((Object)Float.valueOf(fadeWidth), (Object)Float.valueOf(0.0f)) : new Pair((Object)Float.valueOf(width - fadeWidth), (Object)Float.valueOf(width));
                float fadeStart = ((Number)this_$iv.component1()).floatValue();
                float fadeEnd = ((Number)this_$iv.component2()).floatValue();
                Object[] objectArray = new Color[]{ColorKt.Color((long)0xFFFFFFFFL), ColorKt.Color((int)0xFFFFFF)};
                shader = ShaderKt.LinearGradientShader$default((Offset)new Offset(fadeStart, 0.0f), (Offset)new Offset(fadeEnd, 0.0f), (List)CollectionsKt.listOf((Object[])objectArray), (List)null, (TileMode)null, (int)24, null);
            } else {
                IntPxSize this_$iv2 = textLayoutResult.getSize();
                long value$iv$iv2 = this_$iv2.getValue();
                boolean $i$f$unpackInt2 = false;
                int $this$ipx$iv$iv2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
                float fadeEnd = new IntPx($this$ipx$iv$iv2).getValue();
                float fadeStart = fadeEnd - fadeHeight;
                Object[] objectArray = new Color[]{ColorKt.Color((long)0xFFFFFFFFL), ColorKt.Color((int)0xFFFFFF)};
                shader = ShaderKt.LinearGradientShader$default((Offset)new Offset(0.0f, fadeStart), (Offset)new Offset(0.0f, fadeEnd), (List)CollectionsKt.listOf((Object[])objectArray), (List)null, (TileMode)null, (int)24, null);
            }
        } else {
            shader = null;
        }
        return shader;
    }

    @VisibleForTesting
    @NotNull
    public static final TextDirectionAlgorithm resolveTextDirectionAlgorithm(@NotNull LayoutDirection layoutDirection, @Nullable TextDirectionAlgorithm textDirectionAlgorithm) {
        TextDirectionAlgorithm textDirectionAlgorithm2;
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        TextDirectionAlgorithm textDirectionAlgorithm3 = textDirectionAlgorithm;
        if (textDirectionAlgorithm3 == null) {
            LayoutDirection layoutDirection2 = layoutDirection;
            int n = WhenMappings.$EnumSwitchMapping$0[layoutDirection2.ordinal()];
            switch (n) {
                case 1: {
                    textDirectionAlgorithm2 = TextDirectionAlgorithm.ContentOrLtr;
                    break;
                }
                case 2: {
                    textDirectionAlgorithm2 = TextDirectionAlgorithm.ContentOrRtl;
                    break;
                }
                default: {
                    throw new NoWhenBranchMatchedException();
                }
            }
        } else {
            textDirectionAlgorithm2 = textDirectionAlgorithm3;
        }
        return textDirectionAlgorithm2;
    }

    private static final IntPx toIntPx(float $this$toIntPx) {
        boolean bl = false;
        int $this$ipx$iv = MathKt.roundToInt((float)((float)Math.ceil($this$toIntPx)));
        return new IntPx($this$ipx$iv);
    }

    public static final /* synthetic */ TextStyle access$resolveTextStyle$0(TextStyle style, LayoutDirection layoutDirection) {
        return TextDelegateKt.resolveTextStyle(style, layoutDirection);
    }

    public static final /* synthetic */ IntPx access$toIntPx$1(float $receiver) {
        return TextDelegateKt.toIntPx($receiver);
    }

    public static final /* synthetic */ Shader access$createOverflowShader$2(TextDelegate $receiver, TextLayoutResult textLayoutResult) {
        return TextDelegateKt.createOverflowShader($receiver, textLayoutResult);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=3)
    public final class WhenMappings {
        @NotNull
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LayoutDirection.values().length];
            nArray[LayoutDirection.Ltr.ordinal()] = 1;
            nArray[LayoutDirection.Rtl.ordinal()] = 2;
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

