/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.compose.Immutable;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Shadow;
import androidx.ui.text.LocaleList;
import androidx.ui.text.ParagraphStyle;
import androidx.ui.text.SpanStyle;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.style.BaselineShift;
import androidx.ui.text.style.TextAlign;
import androidx.ui.text.style.TextDecoration;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextGeometricTransform;
import androidx.ui.text.style.TextIndent;
import androidx.ui.unit.TextUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u008a\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b6\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0005\b\u0087\b\u0018\u00002\u00020\u0001B\u0017\b\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006B\u00d7\u0001\u0012\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f\u0012\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e\u0012\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u0012\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u0012\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u0012\b\b\u0002\u0010\u0015\u001a\u00020\n\u0012\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u0012\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u0012\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u0012\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\b\u0012\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u0012\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 \u0012\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"\u0012\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$\u0012\b\b\u0002\u0010%\u001a\u00020\n\u0012\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\u0002\u0010(J\u000b\u0010J\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010K\u001a\u0004\u0018\u00010\u0019H\u00c6\u0003J\u000b\u0010L\u001a\u0004\u0018\u00010\u001bH\u00c6\u0003J\u000b\u0010M\u001a\u0004\u0018\u00010\bH\u00c6\u0003J\u000b\u0010N\u001a\u0004\u0018\u00010\u001eH\u00c6\u0003J\u000b\u0010O\u001a\u0004\u0018\u00010 H\u00c6\u0003J\u000b\u0010P\u001a\u0004\u0018\u00010\"H\u00c6\u0003J\u000b\u0010Q\u001a\u0004\u0018\u00010$H\u00c6\u0003J\t\u0010R\u001a\u00020\nH\u00c6\u0003J\u000b\u0010S\u001a\u0004\u0018\u00010'H\u00c6\u0003J\t\u0010T\u001a\u00020\nH\u00c6\u0003J\u000b\u0010U\u001a\u0004\u0018\u00010\fH\u00c6\u0003J\u000b\u0010V\u001a\u0004\u0018\u00010\u000eH\u00c6\u0003J\u000b\u0010W\u001a\u0004\u0018\u00010\u0010H\u00c6\u0003J\u000b\u0010X\u001a\u0004\u0018\u00010\u0012H\u00c6\u0003J\u000b\u0010Y\u001a\u0004\u0018\u00010\u0014H\u00c6\u0003J\t\u0010Z\u001a\u00020\nH\u00c6\u0003J\u000b\u0010[\u001a\u0004\u0018\u00010\u0017H\u00c6\u0003J\u00db\u0001\u0010\\\u001a\u00020\u00002\n\b\u0002\u0010\u0007\u001a\u0004\u0018\u00010\b2\b\b\u0002\u0010\t\u001a\u00020\n2\n\b\u0002\u0010\u000b\u001a\u0004\u0018\u00010\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\n\b\u0002\u0010\u000f\u001a\u0004\u0018\u00010\u00102\n\b\u0002\u0010\u0011\u001a\u0004\u0018\u00010\u00122\n\b\u0002\u0010\u0013\u001a\u0004\u0018\u00010\u00142\b\b\u0002\u0010\u0015\u001a\u00020\n2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\n\b\u0002\u0010\u0018\u001a\u0004\u0018\u00010\u00192\n\b\u0002\u0010\u001a\u001a\u0004\u0018\u00010\u001b2\n\b\u0002\u0010\u001c\u001a\u0004\u0018\u00010\b2\n\b\u0002\u0010\u001d\u001a\u0004\u0018\u00010\u001e2\n\b\u0002\u0010\u001f\u001a\u0004\u0018\u00010 2\n\b\u0002\u0010!\u001a\u0004\u0018\u00010\"2\n\b\u0002\u0010#\u001a\u0004\u0018\u00010$2\b\b\u0002\u0010%\u001a\u00020\n2\n\b\u0002\u0010&\u001a\u0004\u0018\u00010'H\u00c6\u0001J\u0013\u0010]\u001a\u00020^2\b\u0010_\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010`\u001a\u00020aH\u00d6\u0001J\u000e\u0010b\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0005J\u000e\u0010b\u001a\u00020\u00002\u0006\u0010_\u001a\u00020\u0003J\u0012\u0010b\u001a\u00020\u00002\n\b\u0002\u0010_\u001a\u0004\u0018\u00010\u0000J\u0006\u0010c\u001a\u00020\u0005J\u0006\u0010d\u001a\u00020\u0003J\t\u0010e\u001a\u00020\u0014H\u00d6\u0001R\u0013\u0010\u001c\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010*R\u0013\u0010\u0016\u001a\u0004\u0018\u00010\u0017\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010,R\u0013\u0010\u0007\u001a\u0004\u0018\u00010\b\u00a2\u0006\b\n\u0000\u001a\u0004\b-\u0010*R\u0013\u0010\u0011\u001a\u0004\u0018\u00010\u0012\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0013\u0010\u0013\u001a\u0004\u0018\u00010\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b0\u00101R\u0011\u0010\t\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b2\u00103R\u0013\u0010\r\u001a\u0004\u0018\u00010\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b4\u00105R\u0013\u0010\u000f\u001a\u0004\u0018\u00010\u0010\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0013\u0010\u000b\u001a\u0004\u0018\u00010\f\u00a2\u0006\b\n\u0000\u001a\u0004\b8\u00109R\u0011\u0010\u0015\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u00103R\u0011\u0010%\u001a\u00020\n\u00a2\u0006\b\n\u0000\u001a\u0004\b;\u00103R\u0013\u0010\u001a\u001a\u0004\u0018\u00010\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b<\u0010=R\u0013\u0010\u001f\u001a\u0004\u0018\u00010 \u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0013\u0010!\u001a\u0004\u0018\u00010\"\u00a2\u0006\b\n\u0000\u001a\u0004\b@\u0010AR\u0013\u0010\u001d\u001a\u0004\u0018\u00010\u001e\u00a2\u0006\b\n\u0000\u001a\u0004\bB\u0010CR\u0013\u0010#\u001a\u0004\u0018\u00010$\u00a2\u0006\b\n\u0000\u001a\u0004\bD\u0010ER\u0013\u0010\u0018\u001a\u0004\u0018\u00010\u0019\u00a2\u0006\b\n\u0000\u001a\u0004\bF\u0010GR\u0013\u0010&\u001a\u0004\u0018\u00010'\u00a2\u0006\b\n\u0000\u001a\u0004\bH\u0010I\u00a8\u0006f"}, d2={"Landroidx/ui/text/TextStyle;", "", "spanStyle", "Landroidx/ui/text/SpanStyle;", "paragraphStyle", "Landroidx/ui/text/ParagraphStyle;", "(Landroidx/ui/text/SpanStyle;Landroidx/ui/text/ParagraphStyle;)V", "color", "Landroidx/ui/graphics/Color;", "fontSize", "Landroidx/ui/unit/TextUnit;", "fontWeight", "Landroidx/ui/text/font/FontWeight;", "fontStyle", "Landroidx/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/ui/text/font/FontSynthesis;", "fontFamily", "Landroidx/ui/text/font/FontFamily;", "fontFeatureSettings", "", "letterSpacing", "baselineShift", "Landroidx/ui/text/style/BaselineShift;", "textGeometricTransform", "Landroidx/ui/text/style/TextGeometricTransform;", "localeList", "Landroidx/ui/text/LocaleList;", "background", "textDecoration", "Landroidx/ui/text/style/TextDecoration;", "shadow", "Landroidx/ui/graphics/Shadow;", "textAlign", "Landroidx/ui/text/style/TextAlign;", "textDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "lineHeight", "textIndent", "Landroidx/ui/text/style/TextIndent;", "(Landroidx/ui/graphics/Color;Landroidx/ui/unit/TextUnit;Landroidx/ui/text/font/FontWeight;Landroidx/ui/text/font/FontStyle;Landroidx/ui/text/font/FontSynthesis;Landroidx/ui/text/font/FontFamily;Ljava/lang/String;Landroidx/ui/unit/TextUnit;Landroidx/ui/text/style/BaselineShift;Landroidx/ui/text/style/TextGeometricTransform;Landroidx/ui/text/LocaleList;Landroidx/ui/graphics/Color;Landroidx/ui/text/style/TextDecoration;Landroidx/ui/graphics/Shadow;Landroidx/ui/text/style/TextAlign;Landroidx/ui/text/style/TextDirectionAlgorithm;Landroidx/ui/unit/TextUnit;Landroidx/ui/text/style/TextIndent;)V", "getBackground", "()Landroidx/ui/graphics/Color;", "getBaselineShift", "()Landroidx/ui/text/style/BaselineShift;", "getColor", "getFontFamily", "()Landroidx/ui/text/font/FontFamily;", "getFontFeatureSettings", "()Ljava/lang/String;", "getFontSize", "()Landroidx/ui/unit/TextUnit;", "getFontStyle", "()Landroidx/ui/text/font/FontStyle;", "getFontSynthesis", "()Landroidx/ui/text/font/FontSynthesis;", "getFontWeight", "()Landroidx/ui/text/font/FontWeight;", "getLetterSpacing", "getLineHeight", "getLocaleList", "()Landroidx/ui/text/LocaleList;", "getShadow", "()Landroidx/ui/graphics/Shadow;", "getTextAlign", "()Landroidx/ui/text/style/TextAlign;", "getTextDecoration", "()Landroidx/ui/text/style/TextDecoration;", "getTextDirectionAlgorithm", "()Landroidx/ui/text/style/TextDirectionAlgorithm;", "getTextGeometricTransform", "()Landroidx/ui/text/style/TextGeometricTransform;", "getTextIndent", "()Landroidx/ui/text/style/TextIndent;", "component1", "component10", "component11", "component12", "component13", "component14", "component15", "component16", "component17", "component18", "component2", "component3", "component4", "component5", "component6", "component7", "component8", "component9", "copy", "equals", "", "other", "hashCode", "", "merge", "toParagraphStyle", "toSpanStyle", "toString", "ui-text_release"})
@Immutable
public final class TextStyle {
    private final Color color;
    private final TextUnit fontSize;
    private final FontWeight fontWeight;
    private final FontStyle fontStyle;
    private final FontSynthesis fontSynthesis;
    private final FontFamily fontFamily;
    private final String fontFeatureSettings;
    private final TextUnit letterSpacing;
    private final BaselineShift baselineShift;
    private final TextGeometricTransform textGeometricTransform;
    private final LocaleList localeList;
    private final Color background;
    private final TextDecoration textDecoration;
    private final Shadow shadow;
    private final TextAlign textAlign;
    private final TextDirectionAlgorithm textDirectionAlgorithm;
    private final TextUnit lineHeight;
    private final TextIndent textIndent;

    public TextStyle(@Nullable Color color, @NotNull TextUnit fontSize, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, @Nullable FontFamily fontFamily, @Nullable String fontFeatureSettings, @NotNull TextUnit letterSpacing, @Nullable BaselineShift baselineShift, @Nullable TextGeometricTransform textGeometricTransform, @Nullable LocaleList localeList, @Nullable Color background, @Nullable TextDecoration textDecoration, @Nullable Shadow shadow, @Nullable TextAlign textAlign, @Nullable TextDirectionAlgorithm textDirectionAlgorithm, @NotNull TextUnit lineHeight, @Nullable TextIndent textIndent) {
        Intrinsics.checkParameterIsNotNull((Object)fontSize, (String)"fontSize");
        Intrinsics.checkParameterIsNotNull((Object)letterSpacing, (String)"letterSpacing");
        Intrinsics.checkParameterIsNotNull((Object)lineHeight, (String)"lineHeight");
        this.color = color;
        this.fontSize = fontSize;
        this.fontWeight = fontWeight;
        this.fontStyle = fontStyle;
        this.fontSynthesis = fontSynthesis;
        this.fontFamily = fontFamily;
        this.fontFeatureSettings = fontFeatureSettings;
        this.letterSpacing = letterSpacing;
        this.baselineShift = baselineShift;
        this.textGeometricTransform = textGeometricTransform;
        this.localeList = localeList;
        this.background = background;
        this.textDecoration = textDecoration;
        this.shadow = shadow;
        this.textAlign = textAlign;
        this.textDirectionAlgorithm = textDirectionAlgorithm;
        this.lineHeight = lineHeight;
        this.textIndent = textIndent;
        if (!Intrinsics.areEqual((Object)this.getLineHeight(), (Object)TextUnit.Companion.getInherit())) {
            boolean bl = this.getLineHeight().getValue() >= 0.0f;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                String string = "lineHeight can't be negative (" + this.getLineHeight().getValue() + ")";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    public /* synthetic */ TextStyle(Color color, TextUnit fontSize, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, FontFamily fontFamily, String fontFeatureSettings, TextUnit letterSpacing, BaselineShift baselineShift, TextGeometricTransform textGeometricTransform, LocaleList localeList, Color background, TextDecoration textDecoration, Shadow shadow, TextAlign textAlign, TextDirectionAlgorithm textDirectionAlgorithm, TextUnit lineHeight, TextIndent textIndent, int $mask0, DefaultConstructorMarker $marker) {
        Color color2 = ($mask0 & 1) != 0 ? (Color)null : color;
        TextUnit textUnit = ($mask0 & 2) != 0 ? TextUnit.Companion.getInherit() : fontSize;
        FontWeight fontWeight2 = ($mask0 & 4) != 0 ? (FontWeight)null : fontWeight;
        FontStyle fontStyle2 = ($mask0 & 8) != 0 ? (FontStyle)null : fontStyle;
        FontSynthesis fontSynthesis2 = ($mask0 & 0x10) != 0 ? (FontSynthesis)null : fontSynthesis;
        FontFamily fontFamily2 = ($mask0 & 0x20) != 0 ? (FontFamily)null : fontFamily;
        String string = ($mask0 & 0x40) != 0 ? (String)null : fontFeatureSettings;
        TextUnit textUnit2 = ($mask0 & 0x80) != 0 ? TextUnit.Companion.getInherit() : letterSpacing;
        BaselineShift baselineShift2 = ($mask0 & 0x100) != 0 ? (BaselineShift)null : baselineShift;
        TextGeometricTransform textGeometricTransform2 = ($mask0 & 0x200) != 0 ? (TextGeometricTransform)null : textGeometricTransform;
        LocaleList localeList2 = ($mask0 & 0x400) != 0 ? (LocaleList)null : localeList;
        Color color3 = ($mask0 & 0x800) != 0 ? (Color)null : background;
        TextDecoration textDecoration2 = ($mask0 & 0x1000) != 0 ? (TextDecoration)null : textDecoration;
        Shadow shadow2 = ($mask0 & 0x2000) != 0 ? (Shadow)null : shadow;
        TextAlign textAlign2 = ($mask0 & 0x4000) != 0 ? (TextAlign)null : textAlign;
        TextDirectionAlgorithm textDirectionAlgorithm2 = ($mask0 & 0x8000) != 0 ? (TextDirectionAlgorithm)null : textDirectionAlgorithm;
        TextUnit textUnit3 = ($mask0 & 0x10000) != 0 ? TextUnit.Companion.getInherit() : lineHeight;
        TextIndent textIndent2 = ($mask0 & 0x20000) != 0 ? (TextIndent)null : textIndent;
        this(color2, textUnit, fontWeight2, fontStyle2, fontSynthesis2, fontFamily2, string, textUnit2, baselineShift2, textGeometricTransform2, localeList2, color3, textDecoration2, shadow2, textAlign2, textDirectionAlgorithm2, textUnit3, textIndent2);
    }

    @Nullable
    public final Color getColor() {
        return this.color;
    }

    @NotNull
    public final TextUnit getFontSize() {
        return this.fontSize;
    }

    @Nullable
    public final FontWeight getFontWeight() {
        return this.fontWeight;
    }

    @Nullable
    public final FontStyle getFontStyle() {
        return this.fontStyle;
    }

    @Nullable
    public final FontSynthesis getFontSynthesis() {
        return this.fontSynthesis;
    }

    @Nullable
    public final FontFamily getFontFamily() {
        return this.fontFamily;
    }

    @Nullable
    public final String getFontFeatureSettings() {
        return this.fontFeatureSettings;
    }

    @NotNull
    public final TextUnit getLetterSpacing() {
        return this.letterSpacing;
    }

    @Nullable
    public final BaselineShift getBaselineShift() {
        return this.baselineShift;
    }

    @Nullable
    public final TextGeometricTransform getTextGeometricTransform() {
        return this.textGeometricTransform;
    }

    @Nullable
    public final LocaleList getLocaleList() {
        return this.localeList;
    }

    @Nullable
    public final Color getBackground() {
        return this.background;
    }

    @Nullable
    public final TextDecoration getTextDecoration() {
        return this.textDecoration;
    }

    @Nullable
    public final Shadow getShadow() {
        return this.shadow;
    }

    @Nullable
    public final TextAlign getTextAlign() {
        return this.textAlign;
    }

    @Nullable
    public final TextDirectionAlgorithm getTextDirectionAlgorithm() {
        return this.textDirectionAlgorithm;
    }

    @NotNull
    public final TextUnit getLineHeight() {
        return this.lineHeight;
    }

    @Nullable
    public final TextIndent getTextIndent() {
        return this.textIndent;
    }

    public TextStyle(@NotNull SpanStyle spanStyle, @NotNull ParagraphStyle paragraphStyle) {
        Intrinsics.checkParameterIsNotNull((Object)spanStyle, (String)"spanStyle");
        Intrinsics.checkParameterIsNotNull((Object)paragraphStyle, (String)"paragraphStyle");
        this(spanStyle.getColor(), spanStyle.getFontSize(), spanStyle.getFontWeight(), spanStyle.getFontStyle(), spanStyle.getFontSynthesis(), spanStyle.getFontFamily(), spanStyle.getFontFeatureSettings(), spanStyle.getLetterSpacing(), spanStyle.getBaselineShift(), spanStyle.getTextGeometricTransform(), spanStyle.getLocaleList(), spanStyle.getBackground(), spanStyle.getTextDecoration(), spanStyle.getShadow(), paragraphStyle.getTextAlign(), paragraphStyle.getTextDirectionAlgorithm(), paragraphStyle.getLineHeight(), paragraphStyle.getTextIndent());
    }

    @NotNull
    public final SpanStyle toSpanStyle() {
        return new SpanStyle(this.getColor(), this.getFontSize(), this.getFontWeight(), this.getFontStyle(), this.getFontSynthesis(), this.getFontFamily(), this.getFontFeatureSettings(), this.getLetterSpacing(), this.getBaselineShift(), this.getTextGeometricTransform(), this.getLocaleList(), this.getBackground(), this.getTextDecoration(), this.getShadow());
    }

    @NotNull
    public final ParagraphStyle toParagraphStyle() {
        return new ParagraphStyle(this.getTextAlign(), this.getTextDirectionAlgorithm(), this.getLineHeight(), this.getTextIndent());
    }

    @NotNull
    public final TextStyle merge(@Nullable TextStyle other) {
        if (other == null) {
            return this;
        }
        return new TextStyle(this.toSpanStyle().merge(other.toSpanStyle()), this.toParagraphStyle().merge(other.toParagraphStyle()));
    }

    public static /* synthetic */ TextStyle merge$default(@NotNull TextStyle this_, @Nullable TextStyle other, int $mask0, @Nullable Object $handler) {
        TextStyle textStyle = ($mask0 & 1) != 0 ? (TextStyle)null : other;
        return this_.merge(textStyle);
    }

    @NotNull
    public final TextStyle merge(@NotNull SpanStyle other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new TextStyle(this.toSpanStyle().merge(other), this.toParagraphStyle());
    }

    @NotNull
    public final TextStyle merge(@NotNull ParagraphStyle other) {
        Intrinsics.checkParameterIsNotNull((Object)other, (String)"other");
        return new TextStyle(this.toSpanStyle(), this.toParagraphStyle().merge(other));
    }

    @Nullable
    public final Color component1() {
        return this.color;
    }

    @NotNull
    public final TextUnit component2() {
        return this.fontSize;
    }

    @Nullable
    public final FontWeight component3() {
        return this.fontWeight;
    }

    @Nullable
    public final FontStyle component4() {
        return this.fontStyle;
    }

    @Nullable
    public final FontSynthesis component5() {
        return this.fontSynthesis;
    }

    @Nullable
    public final FontFamily component6() {
        return this.fontFamily;
    }

    @Nullable
    public final String component7() {
        return this.fontFeatureSettings;
    }

    @NotNull
    public final TextUnit component8() {
        return this.letterSpacing;
    }

    @Nullable
    public final BaselineShift component9() {
        return this.baselineShift;
    }

    @Nullable
    public final TextGeometricTransform component10() {
        return this.textGeometricTransform;
    }

    @Nullable
    public final LocaleList component11() {
        return this.localeList;
    }

    @Nullable
    public final Color component12() {
        return this.background;
    }

    @Nullable
    public final TextDecoration component13() {
        return this.textDecoration;
    }

    @Nullable
    public final Shadow component14() {
        return this.shadow;
    }

    @Nullable
    public final TextAlign component15() {
        return this.textAlign;
    }

    @Nullable
    public final TextDirectionAlgorithm component16() {
        return this.textDirectionAlgorithm;
    }

    @NotNull
    public final TextUnit component17() {
        return this.lineHeight;
    }

    @Nullable
    public final TextIndent component18() {
        return this.textIndent;
    }

    @NotNull
    public final TextStyle copy(@Nullable Color color, @NotNull TextUnit fontSize, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, @Nullable FontFamily fontFamily, @Nullable String fontFeatureSettings, @NotNull TextUnit letterSpacing, @Nullable BaselineShift baselineShift, @Nullable TextGeometricTransform textGeometricTransform, @Nullable LocaleList localeList, @Nullable Color background, @Nullable TextDecoration textDecoration, @Nullable Shadow shadow, @Nullable TextAlign textAlign, @Nullable TextDirectionAlgorithm textDirectionAlgorithm, @NotNull TextUnit lineHeight, @Nullable TextIndent textIndent) {
        Intrinsics.checkParameterIsNotNull((Object)fontSize, (String)"fontSize");
        Intrinsics.checkParameterIsNotNull((Object)letterSpacing, (String)"letterSpacing");
        Intrinsics.checkParameterIsNotNull((Object)lineHeight, (String)"lineHeight");
        return new TextStyle(color, fontSize, fontWeight, fontStyle, fontSynthesis, fontFamily, fontFeatureSettings, letterSpacing, baselineShift, textGeometricTransform, localeList, background, textDecoration, shadow, textAlign, textDirectionAlgorithm, lineHeight, textIndent);
    }

    public static /* synthetic */ TextStyle copy$default(@NotNull TextStyle this_, @Nullable Color color, @Nullable TextUnit fontSize, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, @Nullable FontFamily fontFamily, @Nullable String fontFeatureSettings, @Nullable TextUnit letterSpacing, @Nullable BaselineShift baselineShift, @Nullable TextGeometricTransform textGeometricTransform, @Nullable LocaleList localeList, @Nullable Color background, @Nullable TextDecoration textDecoration, @Nullable Shadow shadow, @Nullable TextAlign textAlign, @Nullable TextDirectionAlgorithm textDirectionAlgorithm, @Nullable TextUnit lineHeight, @Nullable TextIndent textIndent, int $mask0, @Nullable Object $handler) {
        Color color2 = ($mask0 & 1) != 0 ? this_.color : color;
        TextUnit textUnit = ($mask0 & 2) != 0 ? this_.fontSize : fontSize;
        FontWeight fontWeight2 = ($mask0 & 4) != 0 ? this_.fontWeight : fontWeight;
        FontStyle fontStyle2 = ($mask0 & 8) != 0 ? this_.fontStyle : fontStyle;
        FontSynthesis fontSynthesis2 = ($mask0 & 0x10) != 0 ? this_.fontSynthesis : fontSynthesis;
        FontFamily fontFamily2 = ($mask0 & 0x20) != 0 ? this_.fontFamily : fontFamily;
        String string = ($mask0 & 0x40) != 0 ? this_.fontFeatureSettings : fontFeatureSettings;
        TextUnit textUnit2 = ($mask0 & 0x80) != 0 ? this_.letterSpacing : letterSpacing;
        BaselineShift baselineShift2 = ($mask0 & 0x100) != 0 ? this_.baselineShift : baselineShift;
        TextGeometricTransform textGeometricTransform2 = ($mask0 & 0x200) != 0 ? this_.textGeometricTransform : textGeometricTransform;
        LocaleList localeList2 = ($mask0 & 0x400) != 0 ? this_.localeList : localeList;
        Color color3 = ($mask0 & 0x800) != 0 ? this_.background : background;
        TextDecoration textDecoration2 = ($mask0 & 0x1000) != 0 ? this_.textDecoration : textDecoration;
        Shadow shadow2 = ($mask0 & 0x2000) != 0 ? this_.shadow : shadow;
        TextAlign textAlign2 = ($mask0 & 0x4000) != 0 ? this_.textAlign : textAlign;
        TextDirectionAlgorithm textDirectionAlgorithm2 = ($mask0 & 0x8000) != 0 ? this_.textDirectionAlgorithm : textDirectionAlgorithm;
        TextUnit textUnit3 = ($mask0 & 0x10000) != 0 ? this_.lineHeight : lineHeight;
        TextIndent textIndent2 = ($mask0 & 0x20000) != 0 ? this_.textIndent : textIndent;
        return this_.copy(color2, textUnit, fontWeight2, fontStyle2, fontSynthesis2, fontFamily2, string, textUnit2, baselineShift2, textGeometricTransform2, localeList2, color3, textDecoration2, shadow2, textAlign2, textDirectionAlgorithm2, textUnit3, textIndent2);
    }

    @NotNull
    public String toString() {
        return "TextStyle(color=" + this.color + ", fontSize=" + this.fontSize + ", fontWeight=" + this.fontWeight + ", fontStyle=" + (Object)((Object)this.fontStyle) + ", fontSynthesis=" + (Object)((Object)this.fontSynthesis) + ", fontFamily=" + this.fontFamily + ", fontFeatureSettings=" + this.fontFeatureSettings + ", letterSpacing=" + this.letterSpacing + ", baselineShift=" + this.baselineShift + ", textGeometricTransform=" + this.textGeometricTransform + ", localeList=" + this.localeList + ", background=" + this.background + ", textDecoration=" + this.textDecoration + ", shadow=" + this.shadow + ", textAlign=" + (Object)((Object)this.textAlign) + ", textDirectionAlgorithm=" + (Object)((Object)this.textDirectionAlgorithm) + ", lineHeight=" + this.lineHeight + ", textIndent=" + this.textIndent + ")";
    }

    public int hashCode() {
        return (((((((((((((((((this.color == null ? 0 : this.color.hashCode()) * 31 + this.fontSize.hashCode()) * 31 + (this.fontWeight == null ? 0 : this.fontWeight.hashCode())) * 31 + (this.fontStyle == null ? 0 : this.fontStyle.hashCode())) * 31 + (this.fontSynthesis == null ? 0 : this.fontSynthesis.hashCode())) * 31 + (this.fontFamily == null ? 0 : this.fontFamily.hashCode())) * 31 + (this.fontFeatureSettings == null ? 0 : this.fontFeatureSettings.hashCode())) * 31 + this.letterSpacing.hashCode()) * 31 + (this.baselineShift == null ? 0 : this.baselineShift.hashCode())) * 31 + (this.textGeometricTransform == null ? 0 : this.textGeometricTransform.hashCode())) * 31 + (this.localeList == null ? 0 : this.localeList.hashCode())) * 31 + (this.background == null ? 0 : this.background.hashCode())) * 31 + (this.textDecoration == null ? 0 : this.textDecoration.hashCode())) * 31 + (this.shadow == null ? 0 : this.shadow.hashCode())) * 31 + (this.textAlign == null ? 0 : this.textAlign.hashCode())) * 31 + (this.textDirectionAlgorithm == null ? 0 : this.textDirectionAlgorithm.hashCode())) * 31 + this.lineHeight.hashCode()) * 31 + (this.textIndent == null ? 0 : this.textIndent.hashCode());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof TextStyle)) {
            return false;
        }
        Object object = other;
        TextStyle textStyle = (TextStyle)object;
        if (!Intrinsics.areEqual((Object)this.color, (Object)textStyle.color)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontSize, (Object)textStyle.fontSize)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontWeight, (Object)textStyle.fontWeight)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.fontStyle), (Object)((Object)textStyle.fontStyle))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.fontSynthesis), (Object)((Object)textStyle.fontSynthesis))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)textStyle.fontFamily)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.fontFeatureSettings, (Object)textStyle.fontFeatureSettings)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.letterSpacing, (Object)textStyle.letterSpacing)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.baselineShift, (Object)textStyle.baselineShift)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textGeometricTransform, (Object)textStyle.textGeometricTransform)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.localeList, (Object)textStyle.localeList)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.background, (Object)textStyle.background)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.textDecoration, (Object)textStyle.textDecoration)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.shadow, (Object)textStyle.shadow)) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.textAlign), (Object)((Object)textStyle.textAlign))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.textDirectionAlgorithm), (Object)((Object)textStyle.textDirectionAlgorithm))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lineHeight, (Object)textStyle.lineHeight)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textIndent, (Object)textStyle.textIndent);
    }

    public TextStyle() {
        this(null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, null, 262143, null);
    }
}

