/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.ui.input.EditOperation;
import androidx.ui.input.EditingBuffer;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u00002\u00020\u0001B\u0015\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J\t\u0010\u000b\u001a\u00020\u0003H\u00c6\u0003J\t\u0010\f\u001a\u00020\u0005H\u00c6\u0003J\u001d\u0010\r\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u0005H\u00c6\u0001J\u0013\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0011H\u00d6\u0003J\t\u0010\u0012\u001a\u00020\u0005H\u00d6\u0001J\u0010\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0016J\t\u0010\u0017\u001a\u00020\u0003H\u00d6\u0001R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u0018"}, d2={"Landroidx/ui/input/SetComposingTextEditOp;", "Landroidx/ui/input/EditOperation;", "text", "", "newCursorPosition", "", "(Ljava/lang/String;I)V", "getNewCursorPosition", "()I", "getText", "()Ljava/lang/String;", "component1", "component2", "copy", "equals", "", "other", "", "hashCode", "process", "", "buffer", "Landroidx/ui/input/EditingBuffer;", "toString", "ui-text_release"})
public final class SetComposingTextEditOp
implements EditOperation {
    private final String text;
    private final int newCursorPosition;

    public SetComposingTextEditOp(@NotNull String text, int newCursorPosition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        this.text = text;
        this.newCursorPosition = newCursorPosition;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final int getNewCursorPosition() {
        return this.newCursorPosition;
    }

    @Override
    public void process(@NotNull EditingBuffer buffer) {
        CharSequence charSequence;
        Intrinsics.checkParameterIsNotNull((Object)buffer, (String)"buffer");
        if (buffer.hasComposition$ui_text_release()) {
            int compositionStart = buffer.getCompositionStart$ui_text_release();
            buffer.replace$ui_text_release(buffer.getCompositionStart$ui_text_release(), buffer.getCompositionEnd$ui_text_release(), this.getText());
            charSequence = this.getText();
            boolean bl = false;
            if (charSequence.length() > 0) {
                buffer.setComposition$ui_text_release(compositionStart, compositionStart + this.getText().length());
            }
        } else {
            int selectionStart = buffer.getSelectionStart$ui_text_release();
            buffer.replace$ui_text_release(buffer.getSelectionStart$ui_text_release(), buffer.getSelectionEnd$ui_text_release(), this.getText());
            charSequence = this.getText();
            boolean bl = false;
            if (charSequence.length() > 0) {
                buffer.setComposition$ui_text_release(selectionStart, selectionStart + this.getText().length());
            }
        }
        int newCursor = buffer.getCursor$ui_text_release();
        int newCursorInBuffer = this.getNewCursorPosition() > 0 ? newCursor + this.getNewCursorPosition() - 1 : newCursor + this.getNewCursorPosition() - this.getText().length();
        buffer.setCursor$ui_text_release(RangesKt.coerceIn((int)newCursorInBuffer, (int)0, (int)buffer.getLength$ui_text_release()));
    }

    @NotNull
    public final String component1() {
        return this.text;
    }

    public final int component2() {
        return this.newCursorPosition;
    }

    @NotNull
    public final SetComposingTextEditOp copy(@NotNull String text, int newCursorPosition) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        return new SetComposingTextEditOp(text, newCursorPosition);
    }

    public static /* synthetic */ SetComposingTextEditOp copy$default(@NotNull SetComposingTextEditOp this_, @Nullable String text, int newCursorPosition, int $mask0, @Nullable Object $handler) {
        String string = ($mask0 & 1) != 0 ? this_.text : text;
        int n = ($mask0 & 2) != 0 ? this_.newCursorPosition : newCursorPosition;
        return this_.copy(string, n);
    }

    @NotNull
    public String toString() {
        return "SetComposingTextEditOp(text=" + this.text + ", newCursorPosition=" + this.newCursorPosition + ")";
    }

    public int hashCode() {
        return this.text.hashCode() * 31 + Integer.hashCode(this.newCursorPosition);
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof SetComposingTextEditOp)) {
            return false;
        }
        Object object = other;
        SetComposingTextEditOp setComposingTextEditOp = (SetComposingTextEditOp)object;
        if (!Intrinsics.areEqual((Object)this.text, (Object)setComposingTextEditOp.text)) {
            return false;
        }
        return this.newCursorPosition == setComposingTextEditOp.newCursorPosition;
    }
}

