/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.ui.geometry.Offset;
import androidx.ui.geometry.Rect;
import androidx.ui.graphics.Path;
import androidx.ui.text.Paragraph;
import androidx.ui.text.TextRange;
import androidx.ui.unit.Px;
import androidx.ui.unit.PxPosition;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.FloatCompanionObject;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u001d\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0080\b\u0018\u00002\u00020\u0001BE\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0007\u001a\u00020\u0005\u0012\b\b\u0002\u0010\b\u001a\u00020\u0005\u0012\b\b\u0002\u0010\t\u001a\u00020\n\u0012\b\b\u0002\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0002\u0010\fJ\t\u0010\u001f\u001a\u00020\u0003H\u00c6\u0003J\t\u0010 \u001a\u00020\u0005H\u00c6\u0003J\t\u0010!\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\"\u001a\u00020\u0005H\u00c6\u0003J\t\u0010#\u001a\u00020\u0005H\u00c6\u0003J\t\u0010$\u001a\u00020\nH\u00c6\u0003J\t\u0010%\u001a\u00020\nH\u00c6\u0003JO\u0010&\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00052\b\b\u0002\u0010\u0007\u001a\u00020\u00052\b\b\u0002\u0010\b\u001a\u00020\u00052\b\b\u0002\u0010\t\u001a\u00020\n2\b\b\u0002\u0010\u000b\u001a\u00020\nH\u00c6\u0001J\u0013\u0010'\u001a\u00020(2\b\u0010)\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010*\u001a\u00020\u0005H\u00d6\u0001J\t\u0010+\u001a\u00020,H\u00d6\u0001J\n\u0010-\u001a\u00020.*\u00020.J\n\u0010-\u001a\u00020/*\u00020/J\n\u0010-\u001a\u000200*\u000200J\n\u00101\u001a\u00020\u0005*\u00020\u0005J\n\u00102\u001a\u00020\u0005*\u00020\u0005J\n\u00103\u001a\u000204*\u000204J\n\u00105\u001a\u000206*\u000206J\n\u00107\u001a\u00020\u0005*\u00020\u0005J\n\u00108\u001a\u00020\u0005*\u00020\u0005R\u001a\u0010\u000b\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012R\u001a\u0010\b\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0012\"\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00058F\u00a2\u0006\u0006\u001a\u0004\b\u0017\u0010\u0012R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u0012R\u001a\u0010\u0007\u001a\u00020\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001b\u0010\u0012\"\u0004\b\u001c\u0010\u0015R\u001a\u0010\t\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001d\u0010\u000e\"\u0004\b\u001e\u0010\u0010\u00a8\u00069"}, d2={"Landroidx/ui/text/ParagraphInfo;", "", "paragraph", "Landroidx/ui/text/Paragraph;", "startIndex", "", "endIndex", "startLineIndex", "endLineIndex", "top", "Landroidx/ui/unit/Px;", "bottom", "(Landroidx/ui/text/Paragraph;IIIILandroidx/ui/unit/Px;Landroidx/ui/unit/Px;)V", "getBottom", "()Landroidx/ui/unit/Px;", "setBottom", "(Landroidx/ui/unit/Px;)V", "getEndIndex", "()I", "getEndLineIndex", "setEndLineIndex", "(I)V", "length", "getLength", "getParagraph", "()Landroidx/ui/text/Paragraph;", "getStartIndex", "getStartLineIndex", "setStartLineIndex", "getTop", "setTop", "component1", "component2", "component3", "component4", "component5", "component6", "component7", "copy", "equals", "", "other", "hashCode", "toString", "", "toGlobal", "Landroidx/ui/geometry/Rect;", "Landroidx/ui/graphics/Path;", "Landroidx/ui/text/TextRange;", "toGlobalIndex", "toGlobalLineIndex", "toGlobalYPosition", "", "toLocal", "Landroidx/ui/unit/PxPosition;", "toLocalIndex", "toLocalLineIndex", "ui-text_release"})
public final class ParagraphInfo {
    private final Paragraph paragraph;
    private final int startIndex;
    private final int endIndex;
    private int startLineIndex;
    private int endLineIndex;
    private Px top;
    private Px bottom;

    public ParagraphInfo(@NotNull Paragraph paragraph, int startIndex, int endIndex, int startLineIndex, int endLineIndex, @NotNull Px top, @NotNull Px bottom) {
        Intrinsics.checkParameterIsNotNull((Object)paragraph, (String)"paragraph");
        Intrinsics.checkParameterIsNotNull((Object)top, (String)"top");
        Intrinsics.checkParameterIsNotNull((Object)bottom, (String)"bottom");
        this.paragraph = paragraph;
        this.startIndex = startIndex;
        this.endIndex = endIndex;
        this.startLineIndex = startLineIndex;
        this.endLineIndex = endLineIndex;
        this.top = top;
        this.bottom = bottom;
    }

    public /* synthetic */ ParagraphInfo(Paragraph paragraph, int startIndex, int endIndex, int startLineIndex, int endLineIndex, Px top, Px bottom, int $mask0, DefaultConstructorMarker $marker) {
        Px px;
        Px px2;
        Px px3;
        int n;
        int n2 = ($mask0 & 8) != 0 ? -1 : startLineIndex;
        int n3 = n = ($mask0 & 0x10) != 0 ? -1 : endLineIndex;
        if (($mask0 & 0x20) != 0) {
            int $this$px$iv = -1;
            px3 = new Px((float)$this$px$iv);
        } else {
            px3 = px2 = top;
        }
        if (($mask0 & 0x40) != 0) {
            int $this$px$iv = -1;
            px = new Px((float)$this$px$iv);
        } else {
            px = bottom;
        }
        Px px4 = px;
        this(paragraph, startIndex, endIndex, n2, n, px2, px4);
    }

    @NotNull
    public final Paragraph getParagraph() {
        return this.paragraph;
    }

    public final int getStartIndex() {
        return this.startIndex;
    }

    public final int getEndIndex() {
        return this.endIndex;
    }

    public final int getStartLineIndex() {
        return this.startLineIndex;
    }

    public final void setStartLineIndex(int n) {
        this.startLineIndex = n;
    }

    public final int getEndLineIndex() {
        return this.endLineIndex;
    }

    public final void setEndLineIndex(int n) {
        this.endLineIndex = n;
    }

    @NotNull
    public final Px getTop() {
        return this.top;
    }

    public final void setTop(@NotNull Px px) {
        Intrinsics.checkParameterIsNotNull((Object)px, (String)"<set-?>");
        this.top = px;
    }

    @NotNull
    public final Px getBottom() {
        return this.bottom;
    }

    public final void setBottom(@NotNull Px px) {
        Intrinsics.checkParameterIsNotNull((Object)px, (String)"<set-?>");
        this.bottom = px;
    }

    public final int getLength() {
        return this.getEndIndex() - this.getStartIndex();
    }

    public final int toLocalIndex(int $this$toLocalIndex) {
        return RangesKt.coerceIn((int)$this$toLocalIndex, (int)this.getStartIndex(), (int)this.getEndIndex()) - this.getStartIndex();
    }

    public final int toGlobalIndex(int $this$toGlobalIndex) {
        return $this$toGlobalIndex + this.getStartIndex();
    }

    public final int toLocalLineIndex(int $this$toLocalLineIndex) {
        return $this$toLocalLineIndex - this.getStartLineIndex();
    }

    public final int toGlobalLineIndex(int $this$toGlobalLineIndex) {
        return $this$toGlobalLineIndex + this.getStartLineIndex();
    }

    public final float toGlobalYPosition(float $this$toGlobalYPosition) {
        return $this$toGlobalYPosition + this.getTop().getValue();
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final PxPosition toLocal(@NotNull PxPosition $this$toLocal) {
        long l;
        void val1$iv$iv;
        void x$iv;
        Intrinsics.checkParameterIsNotNull((Object)$this$toLocal, (String)"<this>");
        PxPosition this_$iv = $this$toLocal;
        long value$iv$iv = this_$iv.getValue();
        boolean $i$f$unpackFloat1 = false;
        FloatCompanionObject floatCompanionObject = FloatCompanionObject.INSTANCE;
        int n = (int)(value$iv$iv >> 32);
        int n2 = 0;
        float $this$px$iv$iv22 = Float.intBitsToFloat(n);
        this_$iv = new Px($this$px$iv$iv22);
        PxPosition this_$iv2 = $this$toLocal;
        long value$iv$iv2 = this_$iv2.getValue();
        boolean $i$f$unpackFloat2 = false;
        FloatCompanionObject floatCompanionObject2 = FloatCompanionObject.INSTANCE;
        n2 = (int)(value$iv$iv2 & 0xFFFFFFFFL);
        boolean $this$px$iv$iv22 = false;
        float $this$px$iv$iv = Float.intBitsToFloat(n2);
        this_$iv2 = new Px($this$px$iv$iv);
        Px other$iv22 = this.getTop();
        Px y$iv = new Px(this_$iv2.getValue() - other$iv22.getValue());
        float other$iv22 = x$iv.getValue();
        float val2$iv$iv = y$iv.getValue();
        boolean $i$f$packFloats = false;
        void var7_11 = val1$iv$iv;
        n2 = 0;
        long v1$iv$iv = Float.floatToIntBits((float)var7_11);
        float f = val2$iv$iv;
        boolean bl = false;
        long v2$iv$iv = Float.floatToIntBits(f);
        long l2 = l = v1$iv$iv << 32 | v2$iv$iv & 0xFFFFFFFFL;
        return new PxPosition(l2);
    }

    @NotNull
    public final Rect toGlobal(@NotNull Rect $this$toGlobal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toGlobal, (String)"<this>");
        return $this$toGlobal.shift(new Offset(0.0f, this.getTop().getValue()));
    }

    @NotNull
    public final Path toGlobal(@NotNull Path $this$toGlobal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toGlobal, (String)"<this>");
        $this$toGlobal.shift(new Offset(0.0f, this.getTop().getValue()));
        return $this$toGlobal;
    }

    @NotNull
    public final TextRange toGlobal(@NotNull TextRange $this$toGlobal) {
        Intrinsics.checkParameterIsNotNull((Object)$this$toGlobal, (String)"<this>");
        return new TextRange(this.toGlobalIndex($this$toGlobal.getStart()), this.toGlobalIndex($this$toGlobal.getEnd()));
    }

    @NotNull
    public final Paragraph component1() {
        return this.paragraph;
    }

    public final int component2() {
        return this.startIndex;
    }

    public final int component3() {
        return this.endIndex;
    }

    public final int component4() {
        return this.startLineIndex;
    }

    public final int component5() {
        return this.endLineIndex;
    }

    @NotNull
    public final Px component6() {
        return this.top;
    }

    @NotNull
    public final Px component7() {
        return this.bottom;
    }

    @NotNull
    public final ParagraphInfo copy(@NotNull Paragraph paragraph, int startIndex, int endIndex, int startLineIndex, int endLineIndex, @NotNull Px top, @NotNull Px bottom) {
        Intrinsics.checkParameterIsNotNull((Object)paragraph, (String)"paragraph");
        Intrinsics.checkParameterIsNotNull((Object)top, (String)"top");
        Intrinsics.checkParameterIsNotNull((Object)bottom, (String)"bottom");
        return new ParagraphInfo(paragraph, startIndex, endIndex, startLineIndex, endLineIndex, top, bottom);
    }

    public static /* synthetic */ ParagraphInfo copy$default(@NotNull ParagraphInfo this_, @Nullable Paragraph paragraph, int startIndex, int endIndex, int startLineIndex, int endLineIndex, @Nullable Px top, @Nullable Px bottom, int $mask0, @Nullable Object $handler) {
        Paragraph paragraph2 = ($mask0 & 1) != 0 ? this_.paragraph : paragraph;
        int n = ($mask0 & 2) != 0 ? this_.startIndex : startIndex;
        int n2 = ($mask0 & 4) != 0 ? this_.endIndex : endIndex;
        int n3 = ($mask0 & 8) != 0 ? this_.startLineIndex : startLineIndex;
        int n4 = ($mask0 & 0x10) != 0 ? this_.endLineIndex : endLineIndex;
        Px px = ($mask0 & 0x20) != 0 ? this_.top : top;
        Px px2 = ($mask0 & 0x40) != 0 ? this_.bottom : bottom;
        return this_.copy(paragraph2, n, n2, n3, n4, px, px2);
    }

    @NotNull
    public String toString() {
        return "ParagraphInfo(paragraph=" + this.paragraph + ", startIndex=" + this.startIndex + ", endIndex=" + this.endIndex + ", startLineIndex=" + this.startLineIndex + ", endLineIndex=" + this.endLineIndex + ", top=" + this.top + ", bottom=" + this.bottom + ")";
    }

    public int hashCode() {
        return (((((this.paragraph.hashCode() * 31 + Integer.hashCode(this.startIndex)) * 31 + Integer.hashCode(this.endIndex)) * 31 + Integer.hashCode(this.startLineIndex)) * 31 + Integer.hashCode(this.endLineIndex)) * 31 + this.top.hashCode()) * 31 + this.bottom.hashCode();
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParagraphInfo)) {
            return false;
        }
        Object object = other;
        ParagraphInfo paragraphInfo = (ParagraphInfo)object;
        if (!Intrinsics.areEqual((Object)this.paragraph, (Object)paragraphInfo.paragraph)) {
            return false;
        }
        if (this.startIndex != paragraphInfo.startIndex) {
            return false;
        }
        if (this.endIndex != paragraphInfo.endIndex) {
            return false;
        }
        if (this.startLineIndex != paragraphInfo.startLineIndex) {
            return false;
        }
        if (this.endLineIndex != paragraphInfo.endLineIndex) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.top, (Object)paragraphInfo.top)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.bottom, (Object)paragraphInfo.bottom);
    }
}

