/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text.platform;

import android.graphics.Typeface;
import android.os.Build;
import androidx.collection.LruCache;
import androidx.ui.text.font.DefaultFontFamily;
import androidx.ui.text.font.Font;
import androidx.ui.text.font.FontFamily;
import androidx.ui.text.font.FontListFontFamily;
import androidx.ui.text.font.FontMatcher;
import androidx.ui.text.font.FontStyle;
import androidx.ui.text.font.FontSynthesis;
import androidx.ui.text.font.FontWeight;
import androidx.ui.text.font.GenericFontFamily;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0010\u0018\u0000 \"2\u00020\u0001:\u0002!\"B\u0017\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J2\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\r\u001a\u0004\u0018\u00010\u000e2\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0016J.\u0010\u000b\u001a\u00020\f2\b\b\u0002\u0010\u0011\u001a\u00020\u00122\b\b\u0002\u0010\u000f\u001a\u00020\u00102\u0006\u0010\r\u001a\u00020\u00152\b\b\u0002\u0010\u0013\u001a\u00020\u0014H\u0002J(\u0010\u000b\u001a\u00020\f2\n\b\u0002\u0010\u0016\u001a\u0004\u0018\u00010\u00172\b\b\u0002\u0010\u000f\u001a\u00020\u00102\b\b\u0002\u0010\u0011\u001a\u00020\u0012H\u0002J\u0016\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u0012J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u001bH\u0002J0\u0010\u001d\u001a\u00020\f2\u0006\u0010\u001e\u001a\u00020\f2\u0006\u0010\u001f\u001a\u00020 2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006#"}, d2={"Landroidx/ui/text/platform/TypefaceAdapter;", "", "fontMatcher", "Landroidx/ui/text/font/FontMatcher;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "(Landroidx/ui/text/font/FontMatcher;Landroidx/ui/text/font/Font$ResourceLoader;)V", "getFontMatcher", "()Landroidx/ui/text/font/FontMatcher;", "getResourceLoader", "()Landroidx/ui/text/font/Font$ResourceLoader;", "create", "Landroid/graphics/Typeface;", "fontFamily", "Landroidx/ui/text/font/FontFamily;", "fontWeight", "Landroidx/ui/text/font/FontWeight;", "fontStyle", "Landroidx/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/ui/text/font/FontSynthesis;", "Landroidx/ui/text/font/FontListFontFamily;", "genericFontFamily", "", "getTypefaceStyle", "", "isBold", "", "isItalic", "synthesize", "typeface", "font", "Landroidx/ui/text/font/Font;", "CacheKey", "Companion", "ui-text_release"})
public class TypefaceAdapter {
    private final FontMatcher fontMatcher;
    private final Font.ResourceLoader resourceLoader;
    private static final FontWeight ANDROID_BOLD;
    private static final LruCache<CacheKey, Typeface> typefaceCache;
    @NotNull
    public static final Companion Companion;

    public TypefaceAdapter(@NotNull FontMatcher fontMatcher, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)fontMatcher, (String)"fontMatcher");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this.fontMatcher = fontMatcher;
        this.resourceLoader = resourceLoader;
    }

    public /* synthetic */ TypefaceAdapter(FontMatcher fontMatcher, Font.ResourceLoader resourceLoader, int $mask0, DefaultConstructorMarker $marker) {
        FontMatcher fontMatcher2 = ($mask0 & 1) != 0 ? new FontMatcher() : fontMatcher;
        this(fontMatcher2, resourceLoader);
    }

    @NotNull
    public final FontMatcher getFontMatcher() {
        return this.fontMatcher;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public Typeface create(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
        Typeface typeface;
        Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fontSynthesis), (String)"fontSynthesis");
        CacheKey cacheKey = new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis);
        Typeface cachedTypeface = (Typeface)Companion.getTypefaceCache().get((Object)cacheKey);
        if (cachedTypeface != null) {
            return cachedTypeface;
        }
        FontFamily fontFamily2 = fontFamily;
        if (fontFamily2 instanceof FontListFontFamily) {
            FontFamily fontFamily3 = fontFamily;
            FontWeight fontWeight2 = fontWeight;
            FontStyle fontStyle2 = fontStyle;
            FontSynthesis fontSynthesis2 = fontSynthesis;
            typeface = this.create(fontStyle2, fontWeight2, (FontListFontFamily)fontFamily3, fontSynthesis2);
        } else if (fontFamily2 instanceof GenericFontFamily) {
            typeface = this.create(((GenericFontFamily)fontFamily).getName(), fontWeight, fontStyle);
        } else if (fontFamily2 instanceof DefaultFontFamily ? true : fontFamily2 == null) {
            typeface = this.create(null, fontWeight, fontStyle);
        } else {
            throw new NoWhenBranchMatchedException();
        }
        Typeface typeface2 = typeface;
        Typeface cfr_ignored_0 = (Typeface)Companion.getTypefaceCache().put((Object)cacheKey, (Object)typeface2);
        return typeface2;
    }

    public static /* synthetic */ Typeface create$default(@NotNull TypefaceAdapter this_, @Nullable FontFamily fontFamily, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, int $mask0, @Nullable Object $handler) {
        FontFamily fontFamily2 = ($mask0 & 1) != 0 ? (FontFamily)null : fontFamily;
        FontWeight fontWeight2 = ($mask0 & 2) != 0 ? FontWeight.Companion.getNormal() : fontWeight;
        FontStyle fontStyle2 = ($mask0 & 4) != 0 ? FontStyle.Normal : fontStyle;
        FontSynthesis fontSynthesis2 = ($mask0 & 8) != 0 ? FontSynthesis.All : fontSynthesis;
        return this_.create(fontFamily2, fontWeight2, fontStyle2, fontSynthesis2);
    }

    private final Typeface create(String genericFontFamily, FontWeight fontWeight, FontStyle fontStyle) {
        Typeface typeface;
        boolean bl;
        if (Intrinsics.areEqual((Object)((Object)fontStyle), (Object)((Object)FontStyle.Normal)) && Intrinsics.areEqual((Object)fontWeight, (Object)FontWeight.Companion.getNormal())) {
            CharSequence charSequence = genericFontFamily;
            boolean bl2 = false;
            bl = false;
            if (charSequence == null || charSequence.length() == 0) {
                return Typeface.DEFAULT;
            }
        }
        if (Build.VERSION.SDK_INT < 28) {
            int targetStyle = this.getTypefaceStyle(fontWeight, fontStyle);
            CharSequence charSequence = genericFontFamily;
            bl = false;
            boolean bl3 = false;
            typeface = charSequence == null || charSequence.length() == 0 ? Typeface.defaultFromStyle((int)targetStyle) : Typeface.create((String)genericFontFamily, (int)targetStyle);
        } else {
            Typeface familyTypeface = genericFontFamily == null ? Typeface.DEFAULT : Typeface.create((String)genericFontFamily, (int)0);
            typeface = Typeface.create((Typeface)familyTypeface, (int)fontWeight.getWeight$ui_text_release(), (boolean)Intrinsics.areEqual((Object)((Object)fontStyle), (Object)((Object)FontStyle.Italic)));
        }
        return typeface;
    }

    public static /* synthetic */ Typeface create$default(TypefaceAdapter this_, String genericFontFamily, FontWeight fontWeight, FontStyle fontStyle, int $mask0, Object $handler) {
        String string = ($mask0 & 1) != 0 ? (String)null : genericFontFamily;
        FontWeight fontWeight2 = ($mask0 & 2) != 0 ? FontWeight.Companion.getNormal() : fontWeight;
        FontStyle fontStyle2 = ($mask0 & 4) != 0 ? FontStyle.Normal : fontStyle;
        return this_.create(string, fontWeight2, fontStyle2);
    }

    private final Typeface create(FontStyle fontStyle, FontWeight fontWeight, FontListFontFamily fontFamily, FontSynthesis fontSynthesis) {
        boolean loadedFontIsSameAsRequest;
        Typeface typeface;
        Font font = this.getFontMatcher().matchFont(fontFamily, fontWeight, fontStyle);
        try {
            typeface = (Typeface)this.getResourceLoader().load(font);
        }
        catch (Exception e) {
            throw new IllegalStateException(Intrinsics.stringPlus((String)"Cannot create Typeface from ", (Object)font));
        }
        Typeface typeface2 = typeface;
        boolean bl = loadedFontIsSameAsRequest = Intrinsics.areEqual((Object)fontWeight, (Object)font.getWeight()) && Intrinsics.areEqual((Object)((Object)fontStyle), (Object)((Object)font.getStyle()));
        if (Intrinsics.areEqual((Object)((Object)fontSynthesis), (Object)((Object)FontSynthesis.None)) || loadedFontIsSameAsRequest) {
            return typeface2;
        }
        return this.synthesize(typeface2, font, fontWeight, fontStyle, fontSynthesis);
    }

    public static /* synthetic */ Typeface create$default(TypefaceAdapter this_, FontStyle fontStyle, FontWeight fontWeight, FontListFontFamily fontFamily, FontSynthesis fontSynthesis, int $mask0, Object $handler) {
        FontStyle fontStyle2 = ($mask0 & 1) != 0 ? FontStyle.Normal : fontStyle;
        FontWeight fontWeight2 = ($mask0 & 2) != 0 ? FontWeight.Companion.getNormal() : fontWeight;
        FontSynthesis fontSynthesis2 = ($mask0 & 8) != 0 ? FontSynthesis.All : fontSynthesis;
        return this_.create(fontStyle2, fontWeight2, fontFamily, fontSynthesis2);
    }

    /*
     * Unable to fully structure code
     */
    private final Typeface synthesize(Typeface typeface, Font font, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis) {
        if (!fontSynthesis.isWeightOn$ui_text_release()) ** GOTO lbl-1000
        if (fontWeight.compareTo(TypefaceAdapter.ANDROID_BOLD) < 0) ** GOTO lbl-1000
        if (font.getWeight().compareTo(TypefaceAdapter.ANDROID_BOLD) < 0) {
            v0 = true;
        } else lbl-1000:
        // 3 sources

        {
            v0 = false;
        }
        synthesizeWeight = v0;
        v1 = synthesizeStyle = fontSynthesis.isStyleOn$ui_text_release() != false && Intrinsics.areEqual((Object)fontStyle, (Object)font.getStyle()) == false;
        if (!synthesizeStyle && !synthesizeWeight) {
            return typeface;
        }
        if (Build.VERSION.SDK_INT < 28) {
            targetStyle = this.getTypefaceStyle(synthesizeWeight, synthesizeStyle != false && Intrinsics.areEqual((Object)fontStyle, (Object)FontStyle.Italic) != false);
            v2 = Typeface.create((Typeface)typeface, (int)targetStyle);
        } else {
            finalFontWeight = synthesizeWeight != false ? fontWeight.getWeight$ui_text_release() : font.getWeight().getWeight$ui_text_release();
            finalFontStyle = synthesizeStyle != false ? Intrinsics.areEqual((Object)fontStyle, (Object)FontStyle.Italic) : Intrinsics.areEqual((Object)font.getStyle(), (Object)FontStyle.Italic);
            v2 = Typeface.create((Typeface)typeface, (int)finalFontWeight, (boolean)finalFontStyle);
        }
        return v2;
    }

    public final int getTypefaceStyle(@NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle) {
        Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
        Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
        return this.getTypefaceStyle(fontWeight.compareTo(ANDROID_BOLD) >= 0, Intrinsics.areEqual((Object)((Object)fontStyle), (Object)((Object)FontStyle.Italic)));
    }

    private final int getTypefaceStyle(boolean isBold, boolean isItalic) {
        return isItalic && isBold ? 3 : (isBold ? 1 : (isItalic ? 2 : 0));
    }

    static {
        Companion = new Companion(null);
        ANDROID_BOLD = FontWeight.Companion.getW600();
        typefaceCache = new LruCache(16);
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000f\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\b\u0086\b\u0018\u00002\u00020\u0001B)\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u00a2\u0006\u0002\u0010\nJ\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0005H\u00c6\u0003J\t\u0010\u0015\u001a\u00020\u0007H\u00c6\u0003J\t\u0010\u0016\u001a\u00020\tH\u00c6\u0003J3\u0010\u0017\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\b\b\u0002\u0010\u0004\u001a\u00020\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\b\b\u0002\u0010\b\u001a\u00020\tH\u00c6\u0001J\u0013\u0010\u0018\u001a\u00020\u00192\b\u0010\u001a\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001b\u001a\u00020\u001cH\u00d6\u0001J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000eR\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u001f"}, d2={"Landroidx/ui/text/platform/TypefaceAdapter$CacheKey;", "", "fontFamily", "Landroidx/ui/text/font/FontFamily;", "fontWeight", "Landroidx/ui/text/font/FontWeight;", "fontStyle", "Landroidx/ui/text/font/FontStyle;", "fontSynthesis", "Landroidx/ui/text/font/FontSynthesis;", "(Landroidx/ui/text/font/FontFamily;Landroidx/ui/text/font/FontWeight;Landroidx/ui/text/font/FontStyle;Landroidx/ui/text/font/FontSynthesis;)V", "getFontFamily", "()Landroidx/ui/text/font/FontFamily;", "getFontStyle", "()Landroidx/ui/text/font/FontStyle;", "getFontSynthesis", "()Landroidx/ui/text/font/FontSynthesis;", "getFontWeight", "()Landroidx/ui/text/font/FontWeight;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "toString", "", "ui-text_release"})
    public static final class CacheKey {
        private final FontFamily fontFamily;
        private final FontWeight fontWeight;
        private final FontStyle fontStyle;
        private final FontSynthesis fontSynthesis;

        public CacheKey(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
            Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontSynthesis), (String)"fontSynthesis");
            this.fontFamily = fontFamily;
            this.fontWeight = fontWeight;
            this.fontStyle = fontStyle;
            this.fontSynthesis = fontSynthesis;
        }

        public /* synthetic */ CacheKey(FontFamily fontFamily, FontWeight fontWeight, FontStyle fontStyle, FontSynthesis fontSynthesis, int $mask0, DefaultConstructorMarker $marker) {
            FontFamily fontFamily2 = ($mask0 & 1) != 0 ? (FontFamily)null : fontFamily;
            this(fontFamily2, fontWeight, fontStyle, fontSynthesis);
        }

        @Nullable
        public final FontFamily getFontFamily() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight getFontWeight() {
            return this.fontWeight;
        }

        @NotNull
        public final FontStyle getFontStyle() {
            return this.fontStyle;
        }

        @NotNull
        public final FontSynthesis getFontSynthesis() {
            return this.fontSynthesis;
        }

        @Nullable
        public final FontFamily component1() {
            return this.fontFamily;
        }

        @NotNull
        public final FontWeight component2() {
            return this.fontWeight;
        }

        @NotNull
        public final FontStyle component3() {
            return this.fontStyle;
        }

        @NotNull
        public final FontSynthesis component4() {
            return this.fontSynthesis;
        }

        @NotNull
        public final CacheKey copy(@Nullable FontFamily fontFamily, @NotNull FontWeight fontWeight, @NotNull FontStyle fontStyle, @NotNull FontSynthesis fontSynthesis) {
            Intrinsics.checkParameterIsNotNull((Object)fontWeight, (String)"fontWeight");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontStyle), (String)"fontStyle");
            Intrinsics.checkParameterIsNotNull((Object)((Object)fontSynthesis), (String)"fontSynthesis");
            return new CacheKey(fontFamily, fontWeight, fontStyle, fontSynthesis);
        }

        public static /* synthetic */ CacheKey copy$default(@NotNull CacheKey this_, @Nullable FontFamily fontFamily, @Nullable FontWeight fontWeight, @Nullable FontStyle fontStyle, @Nullable FontSynthesis fontSynthesis, int $mask0, @Nullable Object $handler) {
            FontFamily fontFamily2 = ($mask0 & 1) != 0 ? this_.fontFamily : fontFamily;
            FontWeight fontWeight2 = ($mask0 & 2) != 0 ? this_.fontWeight : fontWeight;
            FontStyle fontStyle2 = ($mask0 & 4) != 0 ? this_.fontStyle : fontStyle;
            FontSynthesis fontSynthesis2 = ($mask0 & 8) != 0 ? this_.fontSynthesis : fontSynthesis;
            return this_.copy(fontFamily2, fontWeight2, fontStyle2, fontSynthesis2);
        }

        @NotNull
        public String toString() {
            return "CacheKey(fontFamily=" + this.fontFamily + ", fontWeight=" + this.fontWeight + ", fontStyle=" + (Object)((Object)this.fontStyle) + ", fontSynthesis=" + (Object)((Object)this.fontSynthesis) + ")";
        }

        public int hashCode() {
            return (((this.fontFamily == null ? 0 : this.fontFamily.hashCode()) * 31 + this.fontWeight.hashCode()) * 31 + this.fontStyle.hashCode()) * 31 + this.fontSynthesis.hashCode();
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CacheKey)) {
                return false;
            }
            Object object = other;
            CacheKey cacheKey = (CacheKey)object;
            if (!Intrinsics.areEqual((Object)this.fontFamily, (Object)cacheKey.fontFamily)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)this.fontWeight, (Object)cacheKey.fontWeight)) {
                return false;
            }
            if (!Intrinsics.areEqual((Object)((Object)this.fontStyle), (Object)((Object)cacheKey.fontStyle))) {
                return false;
            }
            return Intrinsics.areEqual((Object)((Object)this.fontSynthesis), (Object)((Object)cacheKey.fontSynthesis));
        }
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001d\u0010\u0005\u001a\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\b0\u0006\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\n\u00a8\u0006\u000b"}, d2={"Landroidx/ui/text/platform/TypefaceAdapter$Companion;", "", "()V", "ANDROID_BOLD", "Landroidx/ui/text/font/FontWeight;", "typefaceCache", "Landroidx/collection/LruCache;", "Landroidx/ui/text/platform/TypefaceAdapter$CacheKey;", "Landroid/graphics/Typeface;", "getTypefaceCache", "()Landroidx/collection/LruCache;", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final LruCache<CacheKey, Typeface> getTypefaceCache() {
            return typefaceCache;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

