/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.input;

import androidx.ui.input.PartialGapBuffer;
import androidx.ui.text.TextRange;
import kotlin.Metadata;
import kotlin.NotImplementedError;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\n\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u0002\n\u0002\b\b\n\u0002\u0010\f\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u000b\u0018\u0000 12\u00020\u0001:\u00011B\u0010\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005J\r\u0010\u0019\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001bJ\r\u0010\u001c\u001a\u00020\u001aH\u0000\u00a2\u0006\u0002\b\u001dJ\u001d\u0010\u001e\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b!J\u0016\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u0007H\u0080\u0002\u00a2\u0006\u0002\b%J\r\u0010&\u001a\u00020'H\u0000\u00a2\u0006\u0002\b(J%\u0010)\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u00072\u0006\u0010*\u001a\u00020\u0003H\u0000\u00a2\u0006\u0002\b+J\u001d\u0010,\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b-J\u001d\u0010.\u001a\u00020\u001a2\u0006\u0010\u001f\u001a\u00020\u00072\u0006\u0010 \u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b/J\b\u00100\u001a\u00020\u0003H\u0016R\u001e\u0010\b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u001e\u0010\u000b\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\nR$\u0010\r\u001a\u00020\u00072\u0006\u0010\r\u001a\u00020\u00078@@@X\u0080\u000e\u00a2\u0006\f\u001a\u0004\b\u000e\u0010\n\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0013\u001a\u00020\u00078@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u001e\u0010\u0015\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0016\u0010\nR\u001e\u0010\u0017\u001a\u00020\u00072\u0006\u0010\u0006\u001a\u00020\u0007@BX\u0080\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0018\u0010\n\u00a8\u00062"}, d2={"Landroidx/ui/input/EditingBuffer;", "", "initialText", "", "initialSelection", "Landroidx/ui/text/TextRange;", "<set-?>", "", "compositionEnd", "getCompositionEnd$ui_text_release", "()I", "compositionStart", "getCompositionStart$ui_text_release", "cursor", "getCursor$ui_text_release", "setCursor$ui_text_release", "(I)V", "gapBuffer", "Landroidx/ui/input/PartialGapBuffer;", "length", "getLength$ui_text_release", "selectionEnd", "getSelectionEnd$ui_text_release", "selectionStart", "getSelectionStart$ui_text_release", "cancelComposition", "", "cancelComposition$ui_text_release", "commitComposition", "commitComposition$ui_text_release", "delete", "start", "end", "delete$ui_text_release", "get", "", "index", "get$ui_text_release", "hasComposition", "", "hasComposition$ui_text_release", "replace", "text", "replace$ui_text_release", "setComposition", "setComposition$ui_text_release", "setSelection", "setSelection$ui_text_release", "toString", "Companion", "ui-text_release"})
public final class EditingBuffer {
    private final PartialGapBuffer gapBuffer;
    private int selectionStart;
    private int selectionEnd;
    private int compositionStart;
    private int compositionEnd;
    public static final int NOWHERE = -1;
    @NotNull
    public static final Companion Companion = new Companion(null);

    public EditingBuffer(@NotNull String initialText, @NotNull TextRange initialSelection) {
        Intrinsics.checkParameterIsNotNull((Object)initialText, (String)"initialText");
        Intrinsics.checkParameterIsNotNull((Object)initialSelection, (String)"initialSelection");
        this.gapBuffer = new PartialGapBuffer(initialText);
        this.selectionStart = initialSelection.getMin();
        this.selectionEnd = initialSelection.getMax();
        this.compositionStart = -1;
        this.compositionEnd = -1;
        int start = initialSelection.getMin();
        int end = initialSelection.getMax();
        if (start < 0 || start > initialText.length()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + initialText.length());
        }
        if (end < 0 || end > initialText.length()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + initialText.length());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
    }

    public final int getSelectionStart$ui_text_release() {
        return this.selectionStart;
    }

    public final int getSelectionEnd$ui_text_release() {
        return this.selectionEnd;
    }

    public final int getCompositionStart$ui_text_release() {
        return this.compositionStart;
    }

    public final int getCompositionEnd$ui_text_release() {
        return this.compositionEnd;
    }

    public final boolean hasComposition$ui_text_release() {
        return this.getCompositionStart$ui_text_release() != -1;
    }

    public final int getCursor$ui_text_release() {
        return this.getSelectionStart$ui_text_release() == this.getSelectionEnd$ui_text_release() ? this.getSelectionEnd$ui_text_release() : -1;
    }

    public final void setCursor$ui_text_release(int cursor) {
        this.setSelection$ui_text_release(cursor, cursor);
    }

    public final char get$ui_text_release(int index) {
        return this.gapBuffer.get(index);
    }

    public final int getLength$ui_text_release() {
        return this.gapBuffer.getLength();
    }

    public final void replace$ui_text_release(int start, int end, @NotNull String text) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.gapBuffer.replace(start, end, text);
        this.selectionStart = start + text.length();
        this.selectionEnd = start + text.length();
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void delete$ui_text_release(int start, int end) {
        TextRange deleteRange = new TextRange(start, end);
        if (deleteRange.intersects(new TextRange(this.getSelectionStart$ui_text_release(), this.getSelectionEnd$ui_text_release()))) {
            String string = "support deletion within selection range.";
            boolean bl = false;
            throw (Throwable)new NotImplementedError("An operation is not implemented: " + string);
        }
        this.gapBuffer.replace(start, end, "");
        if (end <= this.getSelectionStart$ui_text_release()) {
            EditingBuffer editingBuffer = this;
            editingBuffer.selectionStart = editingBuffer.getSelectionStart$ui_text_release() - deleteRange.getLength();
            editingBuffer = this;
            editingBuffer.selectionEnd = editingBuffer.getSelectionEnd$ui_text_release() - deleteRange.getLength();
        }
        if (!this.hasComposition$ui_text_release()) {
            return;
        }
        TextRange compositionRange = new TextRange(this.getCompositionStart$ui_text_release(), this.getCompositionEnd$ui_text_release());
        if (deleteRange.intersects(compositionRange)) {
            if (deleteRange.contains(compositionRange)) {
                this.compositionStart = -1;
                this.compositionEnd = -1;
            } else if (compositionRange.contains(deleteRange)) {
                EditingBuffer editingBuffer = this;
                editingBuffer.compositionEnd = editingBuffer.getCompositionEnd$ui_text_release() - deleteRange.getLength();
            } else if (deleteRange.contains(this.getCompositionStart$ui_text_release())) {
                this.compositionStart = deleteRange.getMin();
                EditingBuffer editingBuffer = this;
                editingBuffer.compositionEnd = editingBuffer.getCompositionEnd$ui_text_release() - deleteRange.getLength();
            } else {
                this.compositionEnd = deleteRange.getMin();
            }
        } else if (this.getCompositionStart$ui_text_release() > deleteRange.getMin()) {
            EditingBuffer editingBuffer = this;
            editingBuffer.compositionStart = editingBuffer.getCompositionStart$ui_text_release() - deleteRange.getLength();
            editingBuffer = this;
            editingBuffer.compositionEnd = editingBuffer.getCompositionEnd$ui_text_release() - deleteRange.getLength();
        }
    }

    public final void setSelection$ui_text_release(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start > end) {
            throw new IllegalArgumentException("Do not set reversed range: " + start + " > " + end);
        }
        this.selectionStart = start;
        this.selectionEnd = end;
    }

    public final void setComposition$ui_text_release(int start, int end) {
        if (start < 0 || start > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("start (" + start + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (end < 0 || end > this.gapBuffer.getLength()) {
            throw new IndexOutOfBoundsException("end (" + end + ") offset is outside of text region " + this.gapBuffer.getLength());
        }
        if (start >= end) {
            throw new IllegalArgumentException("Do not set reversed or empty range: " + start + " > " + end);
        }
        this.compositionStart = start;
        this.compositionEnd = end;
    }

    public final void cancelComposition$ui_text_release() {
        this.replace$ui_text_release(this.getCompositionStart$ui_text_release(), this.getCompositionEnd$ui_text_release(), "");
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    public final void commitComposition$ui_text_release() {
        this.compositionStart = -1;
        this.compositionEnd = -1;
    }

    @NotNull
    public String toString() {
        return this.gapBuffer.toString();
    }

    @Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0010\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\b\u0080\u0003\u0018\u00002\u00020\u0001B\u0002\b\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0086T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0004"}, d2={"Landroidx/ui/input/EditingBuffer$Companion;", "", "NOWHERE", "", "ui-text_release"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker marker) {
            this();
        }
    }
}

