/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.compose.Immutable;
import androidx.ui.text.style.TextAlign;
import androidx.ui.text.style.TextDirectionAlgorithm;
import androidx.ui.text.style.TextIndent;
import androidx.ui.unit.TextUnit;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\b\u0087\b\u0018\u00002\u00020\u0001B.\u0012\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tJ\u000b\u0010\u0012\u001a\u0004\u0018\u00010\u0003H\u00c6\u0003J\u000b\u0010\u0013\u001a\u0004\u0018\u00010\u0005H\u00c6\u0003J\t\u0010\u0014\u001a\u00020\u0007H\u00c6\u0003J\u000b\u0010\u0015\u001a\u0004\u0018\u00010\tH\u00c6\u0003J7\u0010\u0016\u001a\u00020\u00002\n\b\u0002\u0010\u0002\u001a\u0004\u0018\u00010\u00032\n\b\u0002\u0010\u0004\u001a\u0004\u0018\u00010\u00052\b\b\u0002\u0010\u0006\u001a\u00020\u00072\n\b\u0002\u0010\b\u001a\u0004\u0018\u00010\tH\u00c6\u0001J\u0013\u0010\u0017\u001a\u00020\u00182\b\u0010\u0019\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003J\t\u0010\u001a\u001a\u00020\u001bH\u00d6\u0001J\u0012\u0010\u001c\u001a\u00020\u00002\n\b\u0002\u0010\u0019\u001a\u0004\u0018\u00010\u0000J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000fR\u0013\u0010\b\u001a\u0004\u0018\u00010\t\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011\u00a8\u0006\u001f"}, d2={"Landroidx/ui/text/ParagraphStyle;", "", "textAlign", "Landroidx/ui/text/style/TextAlign;", "textDirectionAlgorithm", "Landroidx/ui/text/style/TextDirectionAlgorithm;", "lineHeight", "Landroidx/ui/unit/TextUnit;", "textIndent", "Landroidx/ui/text/style/TextIndent;", "getLineHeight", "()Landroidx/ui/unit/TextUnit;", "getTextAlign", "()Landroidx/ui/text/style/TextAlign;", "getTextDirectionAlgorithm", "()Landroidx/ui/text/style/TextDirectionAlgorithm;", "getTextIndent", "()Landroidx/ui/text/style/TextIndent;", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "hashCode", "", "merge", "toString", "", "ui-text_release"})
@Immutable
public final class ParagraphStyle {
    private final TextAlign textAlign;
    private final TextDirectionAlgorithm textDirectionAlgorithm;
    private final TextUnit lineHeight;
    private final TextIndent textIndent;

    public ParagraphStyle(@Nullable TextAlign textAlign, @Nullable TextDirectionAlgorithm textDirectionAlgorithm, @NotNull TextUnit lineHeight, @Nullable TextIndent textIndent) {
        Intrinsics.checkParameterIsNotNull((Object)lineHeight, (String)"lineHeight");
        this.textAlign = textAlign;
        this.textDirectionAlgorithm = textDirectionAlgorithm;
        this.lineHeight = lineHeight;
        this.textIndent = textIndent;
        if (!Intrinsics.areEqual((Object)this.getLineHeight(), (Object)TextUnit.Companion.getInherit())) {
            boolean bl = this.getLineHeight().getValue() >= 0.0f;
            boolean bl2 = false;
            if (_Assertions.ENABLED && !bl) {
                String string = "lineHeight can't be negative (" + this.getLineHeight().getValue() + ")";
                throw (Throwable)((Object)new AssertionError((Object)string));
            }
        }
    }

    public /* synthetic */ ParagraphStyle(TextAlign textAlign, TextDirectionAlgorithm textDirectionAlgorithm, TextUnit lineHeight, TextIndent textIndent, int $mask0, DefaultConstructorMarker $marker) {
        TextAlign textAlign2 = ($mask0 & 1) != 0 ? (TextAlign)null : textAlign;
        TextDirectionAlgorithm textDirectionAlgorithm2 = ($mask0 & 2) != 0 ? (TextDirectionAlgorithm)null : textDirectionAlgorithm;
        TextUnit textUnit = ($mask0 & 4) != 0 ? TextUnit.Companion.getInherit() : lineHeight;
        TextIndent textIndent2 = ($mask0 & 8) != 0 ? (TextIndent)null : textIndent;
        this(textAlign2, textDirectionAlgorithm2, textUnit, textIndent2);
    }

    @Nullable
    public final TextAlign getTextAlign() {
        return this.textAlign;
    }

    @Nullable
    public final TextDirectionAlgorithm getTextDirectionAlgorithm() {
        return this.textDirectionAlgorithm;
    }

    @NotNull
    public final TextUnit getLineHeight() {
        return this.lineHeight;
    }

    @Nullable
    public final TextIndent getTextIndent() {
        return this.textIndent;
    }

    @NotNull
    public final ParagraphStyle merge(@Nullable ParagraphStyle other) {
        if (other == null) {
            return this;
        }
        TextUnit textUnit = Intrinsics.areEqual((Object)other.getLineHeight(), (Object)TextUnit.Companion.getInherit()) ? this.getLineHeight() : other.getLineHeight();
        Object object = other.getTextIndent();
        TextIndent textIndent = object == null ? this.getTextIndent() : object;
        Enum enum_ = other.getTextAlign();
        object = enum_ == null ? this.getTextAlign() : enum_;
        TextDirectionAlgorithm textDirectionAlgorithm = other.getTextDirectionAlgorithm();
        enum_ = textDirectionAlgorithm == null ? this.getTextDirectionAlgorithm() : textDirectionAlgorithm;
        return new ParagraphStyle((TextAlign)((Object)object), (TextDirectionAlgorithm)enum_, textUnit, textIndent);
    }

    public static /* synthetic */ ParagraphStyle merge$default(@NotNull ParagraphStyle this_, @Nullable ParagraphStyle other, int $mask0, @Nullable Object $handler) {
        ParagraphStyle paragraphStyle = ($mask0 & 1) != 0 ? (ParagraphStyle)null : other;
        return this_.merge(paragraphStyle);
    }

    @Nullable
    public final TextAlign component1() {
        return this.textAlign;
    }

    @Nullable
    public final TextDirectionAlgorithm component2() {
        return this.textDirectionAlgorithm;
    }

    @NotNull
    public final TextUnit component3() {
        return this.lineHeight;
    }

    @Nullable
    public final TextIndent component4() {
        return this.textIndent;
    }

    @NotNull
    public final ParagraphStyle copy(@Nullable TextAlign textAlign, @Nullable TextDirectionAlgorithm textDirectionAlgorithm, @NotNull TextUnit lineHeight, @Nullable TextIndent textIndent) {
        Intrinsics.checkParameterIsNotNull((Object)lineHeight, (String)"lineHeight");
        return new ParagraphStyle(textAlign, textDirectionAlgorithm, lineHeight, textIndent);
    }

    public static /* synthetic */ ParagraphStyle copy$default(@NotNull ParagraphStyle this_, @Nullable TextAlign textAlign, @Nullable TextDirectionAlgorithm textDirectionAlgorithm, @Nullable TextUnit lineHeight, @Nullable TextIndent textIndent, int $mask0, @Nullable Object $handler) {
        TextAlign textAlign2 = ($mask0 & 1) != 0 ? this_.textAlign : textAlign;
        TextDirectionAlgorithm textDirectionAlgorithm2 = ($mask0 & 2) != 0 ? this_.textDirectionAlgorithm : textDirectionAlgorithm;
        TextUnit textUnit = ($mask0 & 4) != 0 ? this_.lineHeight : lineHeight;
        TextIndent textIndent2 = ($mask0 & 8) != 0 ? this_.textIndent : textIndent;
        return this_.copy(textAlign2, textDirectionAlgorithm2, textUnit, textIndent2);
    }

    @NotNull
    public String toString() {
        return "ParagraphStyle(textAlign=" + (Object)((Object)this.textAlign) + ", textDirectionAlgorithm=" + (Object)((Object)this.textDirectionAlgorithm) + ", lineHeight=" + this.lineHeight + ", textIndent=" + this.textIndent + ")";
    }

    public int hashCode() {
        return (((this.textAlign == null ? 0 : this.textAlign.hashCode()) * 31 + (this.textDirectionAlgorithm == null ? 0 : this.textDirectionAlgorithm.hashCode())) * 31 + this.lineHeight.hashCode()) * 31 + (this.textIndent == null ? 0 : this.textIndent.hashCode());
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof ParagraphStyle)) {
            return false;
        }
        Object object = other;
        ParagraphStyle paragraphStyle = (ParagraphStyle)object;
        if (!Intrinsics.areEqual((Object)((Object)this.textAlign), (Object)((Object)paragraphStyle.textAlign))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)((Object)this.textDirectionAlgorithm), (Object)((Object)paragraphStyle.textDirectionAlgorithm))) {
            return false;
        }
        if (!Intrinsics.areEqual((Object)this.lineHeight, (Object)paragraphStyle.lineHeight)) {
            return false;
        }
        return Intrinsics.areEqual((Object)this.textIndent, (Object)paragraphStyle.textIndent);
    }

    public ParagraphStyle() {
        this(null, null, null, null, 15, null);
    }
}

