/*
 * Decompiled with CFR 0.152.
 */
package androidx.ui.text;

import androidx.annotation.RestrictTo;
import androidx.annotation.VisibleForTesting;
import androidx.ui.core.Constraints;
import androidx.ui.core.ConstraintsKt;
import androidx.ui.core.LayoutDirection;
import androidx.ui.graphics.Canvas;
import androidx.ui.graphics.Color;
import androidx.ui.graphics.Paint;
import androidx.ui.graphics.Path;
import androidx.ui.text.AnnotatedString;
import androidx.ui.text.MultiParagraph;
import androidx.ui.text.MultiParagraphIntrinsics;
import androidx.ui.text.ParagraphConstraints;
import androidx.ui.text.TextLayoutHelperKt;
import androidx.ui.text.TextLayoutInput;
import androidx.ui.text.TextLayoutResult;
import androidx.ui.text.TextPainter;
import androidx.ui.text.TextStyle;
import androidx.ui.text.TextStyleKt;
import androidx.ui.text.font.Font;
import androidx.ui.text.style.TextOverflow;
import androidx.ui.unit.Density;
import androidx.ui.unit.IntPx;
import androidx.ui.unit.IntPxSize;
import androidx.ui.unit.Px;
import kotlin.Metadata;
import kotlin._Assertions;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=1, d1={"\u0000\u0084\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0011\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001BF\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u0012\b\b\u0002\u0010\b\u001a\u00020\t\u0012\b\b\u0002\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011J(\u00100\u001a\u0002H1\"\u0004\b\u0000\u001012\u0012\u00102\u001a\u000e\u0012\u0004\u0012\u00020!\u0012\u0004\u0012\u0002H103H\u0082\b\u00a2\u0006\u0002\u00104J\u001a\u00105\u001a\u0002062\u0006\u00107\u001a\u0002082\n\b\u0002\u00109\u001a\u0004\u0018\u000106J\u0006\u0010:\u001a\u00020;J\u0018\u0010<\u001a\u00020=2\u0006\u0010>\u001a\u00020?2\u0006\u0010@\u001a\u00020?H\u0002J\u0016\u0010A\u001a\u00020;2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u000206J.\u0010E\u001a\u00020;2\u0006\u0010F\u001a\u00020\u00072\u0006\u0010G\u001a\u00020\u00072\u0006\u0010H\u001a\u00020I2\u0006\u0010B\u001a\u00020C2\u0006\u0010D\u001a\u000206R\u0011\u0010\f\u001a\u00020\r\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u000e\u001a\u00020\u000f\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0014\u0010\u0015R\u0011\u0010\u0016\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001a\u0010\u001bR\u0011\u0010\u001c\u001a\u00020\u00178F\u00a2\u0006\u0006\u001a\u0004\b\u001d\u0010\u0019R\u0011\u0010\n\u001a\u00020\u000b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001fR&\u0010 \u001a\u0004\u0018\u00010!8\u0000@\u0000X\u0081\u000e\u00a2\u0006\u0014\n\u0000\u0012\u0004\b\"\u0010#\u001a\u0004\b$\u0010%\"\u0004\b&\u0010'R\u0011\u0010\u0010\u001a\u00020\u0011\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0011\u0010\b\u001a\u00020\t\u00a2\u0006\b\n\u0000\u001a\u0004\b*\u0010+R\u0011\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b,\u0010-R\u0011\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/\u00a8\u0006J"}, d2={"Landroidx/ui/text/TextDelegate;", "", "text", "Landroidx/ui/text/AnnotatedString;", "style", "Landroidx/ui/text/TextStyle;", "maxLines", "", "softWrap", "", "overflow", "Landroidx/ui/text/style/TextOverflow;", "density", "Landroidx/ui/unit/Density;", "layoutDirection", "Landroidx/ui/core/LayoutDirection;", "resourceLoader", "Landroidx/ui/text/font/Font$ResourceLoader;", "getDensity", "()Landroidx/ui/unit/Density;", "getLayoutDirection", "()Landroidx/ui/core/LayoutDirection;", "maxIntrinsicWidth", "Landroidx/ui/unit/IntPx;", "getMaxIntrinsicWidth", "()Landroidx/ui/unit/IntPx;", "getMaxLines", "()I", "minIntrinsicWidth", "getMinIntrinsicWidth", "getOverflow", "()Landroidx/ui/text/style/TextOverflow;", "paragraphIntrinsics", "Landroidx/ui/text/MultiParagraphIntrinsics;", "paragraphIntrinsics$annotations$ui_text_release", "()V", "getParagraphIntrinsics$ui_text_release", "()Landroidx/ui/text/MultiParagraphIntrinsics;", "setParagraphIntrinsics$ui_text_release", "(Landroidx/ui/text/MultiParagraphIntrinsics;)V", "getResourceLoader", "()Landroidx/ui/text/font/Font$ResourceLoader;", "getSoftWrap", "()Z", "getStyle", "()Landroidx/ui/text/TextStyle;", "getText", "()Landroidx/ui/text/AnnotatedString;", "assumeIntrinsics", "T", "block", "Lkotlin/Function1;", "(Lkotlin/jvm/functions/Function1;)Ljava/lang/Object;", "layout", "Landroidx/ui/text/TextLayoutResult;", "constraints", "Landroidx/ui/core/Constraints;", "prevResult", "layoutIntrinsics", "", "layoutText", "Landroidx/ui/text/MultiParagraph;", "minWidth", "", "maxWidth", "paint", "canvas", "Landroidx/ui/graphics/Canvas;", "textLayoutResult", "paintBackground", "start", "end", "color", "Landroidx/ui/graphics/Color;", "ui-text_release"})
@RestrictTo(value={RestrictTo.Scope.LIBRARY})
public final class TextDelegate {
    private final AnnotatedString text;
    private final int maxLines;
    private final boolean softWrap;
    private final TextOverflow overflow;
    private final Density density;
    private final LayoutDirection layoutDirection;
    private final Font.ResourceLoader resourceLoader;
    private final TextStyle style;
    private MultiParagraphIntrinsics paragraphIntrinsics;

    public TextDelegate(@NotNull AnnotatedString text, @NotNull TextStyle style, int maxLines, boolean softWrap, @NotNull TextOverflow overflow, @NotNull Density density, @NotNull LayoutDirection layoutDirection, @NotNull Font.ResourceLoader resourceLoader) {
        Intrinsics.checkParameterIsNotNull((Object)text, (String)"text");
        Intrinsics.checkParameterIsNotNull((Object)style, (String)"style");
        Intrinsics.checkParameterIsNotNull((Object)((Object)overflow), (String)"overflow");
        Intrinsics.checkParameterIsNotNull((Object)density, (String)"density");
        Intrinsics.checkParameterIsNotNull((Object)layoutDirection, (String)"layoutDirection");
        Intrinsics.checkParameterIsNotNull((Object)resourceLoader, (String)"resourceLoader");
        this.text = text;
        this.maxLines = maxLines;
        this.softWrap = softWrap;
        this.overflow = overflow;
        this.density = density;
        this.layoutDirection = layoutDirection;
        this.resourceLoader = resourceLoader;
        this.style = TextStyleKt.resolveDefaults(style, this.getLayoutDirection());
        boolean bl = this.getMaxLines() > 0;
        boolean bl2 = false;
        boolean bl3 = false;
        if (_Assertions.ENABLED && !bl) {
            boolean bl4 = false;
            String string = "Assertion failed";
            throw (Throwable)((Object)new AssertionError((Object)string));
        }
    }

    public /* synthetic */ TextDelegate(AnnotatedString text, TextStyle style, int maxLines, boolean softWrap, TextOverflow overflow, Density density, LayoutDirection layoutDirection, Font.ResourceLoader resourceLoader, int $mask0, DefaultConstructorMarker $marker) {
        int n = ($mask0 & 4) != 0 ? Integer.MAX_VALUE : maxLines;
        boolean bl = ($mask0 & 8) != 0 ? true : softWrap;
        TextOverflow textOverflow = ($mask0 & 0x10) != 0 ? TextOverflow.Clip : overflow;
        this(text, style, n, bl, textOverflow, density, layoutDirection, resourceLoader);
    }

    @NotNull
    public final AnnotatedString getText() {
        return this.text;
    }

    public final int getMaxLines() {
        return this.maxLines;
    }

    public final boolean getSoftWrap() {
        return this.softWrap;
    }

    @NotNull
    public final TextOverflow getOverflow() {
        return this.overflow;
    }

    @NotNull
    public final Density getDensity() {
        return this.density;
    }

    @NotNull
    public final LayoutDirection getLayoutDirection() {
        return this.layoutDirection;
    }

    @NotNull
    public final Font.ResourceLoader getResourceLoader() {
        return this.resourceLoader;
    }

    @NotNull
    public final TextStyle getStyle() {
        return this.style;
    }

    @Nullable
    public final MultiParagraphIntrinsics getParagraphIntrinsics$ui_text_release() {
        return this.paragraphIntrinsics;
    }

    public final void setParagraphIntrinsics$ui_text_release(@Nullable MultiParagraphIntrinsics multiParagraphIntrinsics) {
        this.paragraphIntrinsics = multiParagraphIntrinsics;
    }

    @VisibleForTesting
    public static /* synthetic */ void paragraphIntrinsics$annotations$ui_text_release() {
    }

    private final <T> T assumeIntrinsics(Function1<? super MultiParagraphIntrinsics, ? extends T> block) {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        return (T)block.invoke((Object)multiParagraphIntrinsics);
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntPx getMinIntrinsicWidth() {
        IntPx intPx;
        void $this$ceil$iv;
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        float $this$px$iv22 = it.getMinIntrinsicWidth();
        Px $this$px$iv22 = new Px($this$px$iv22);
        float f = $this$ceil$iv.getValue();
        boolean bl = false;
        if (Float.isInfinite(f)) {
            intPx = IntPx.Companion.getInfinity();
        } else {
            f = $this$ceil$iv.getValue();
            bl = false;
            float f2 = (float)Math.ceil(f);
            int n = (int)f2;
            intPx = new IntPx(n);
        }
        return intPx;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final IntPx getMaxIntrinsicWidth() {
        IntPx intPx;
        void $this$ceil$iv;
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics it = multiParagraphIntrinsics;
        float $this$px$iv22 = it.getMaxIntrinsicWidth();
        Px $this$px$iv22 = new Px($this$px$iv22);
        float f = $this$ceil$iv.getValue();
        boolean bl = false;
        if (Float.isInfinite(f)) {
            intPx = IntPx.Companion.getInfinity();
        } else {
            f = $this$ceil$iv.getValue();
            bl = false;
            float f2 = (float)Math.ceil(f);
            int n = (int)f2;
            intPx = new IntPx(n);
        }
        return intPx;
    }

    public final void layoutIntrinsics() {
        MultiParagraphIntrinsics multiParagraphIntrinsics = this.getParagraphIntrinsics$ui_text_release();
        MultiParagraphIntrinsics intrinsics = multiParagraphIntrinsics == null ? new MultiParagraphIntrinsics(this.getText(), this.getStyle(), this.getDensity(), this.getResourceLoader()) : multiParagraphIntrinsics;
        this.setParagraphIntrinsics$ui_text_release(intrinsics);
    }

    private final MultiParagraph layoutText(float minWidth, float maxWidth) {
        this.layoutIntrinsics();
        TextDelegate this_$iv = this;
        MultiParagraphIntrinsics multiParagraphIntrinsics = this_$iv.getParagraphIntrinsics$ui_text_release();
        if (multiParagraphIntrinsics == null) {
            throw new AssertionError((Object)"layoutForIntrinsics must be called first");
        }
        MultiParagraphIntrinsics paragraphIntrinsics = multiParagraphIntrinsics;
        float width = minWidth == maxWidth ? maxWidth : RangesKt.coerceIn((float)paragraphIntrinsics.getMaxIntrinsicWidth(), (float)minWidth, (float)maxWidth);
        return new MultiParagraph(paragraphIntrinsics, this.getMaxLines(), Intrinsics.areEqual((Object)((Object)this.getOverflow()), (Object)((Object)TextOverflow.Ellipsis)), new ParagraphConstraints(width));
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final TextLayoutResult layout(@NotNull Constraints constraints, @Nullable TextLayoutResult prevResult) {
        void val1$iv$iv;
        long l;
        void height$iv;
        void width$iv;
        IntPx intPx;
        Px $this$ceil$iv;
        void $this$px$iv52;
        IntPx intPx2;
        Px $this$ceil$iv2;
        void $this$px$iv42;
        Px px;
        IntPx maxWidth;
        Intrinsics.checkParameterIsNotNull((Object)constraints, (String)"constraints");
        IntPx minWidth = constraints.getMinWidth();
        boolean widthMatters = this.getSoftWrap() || Intrinsics.areEqual((Object)((Object)this.getOverflow()), (Object)((Object)TextOverflow.Ellipsis));
        IntPx intPx3 = maxWidth = widthMatters ? constraints.getMaxWidth() : IntPx.Companion.getInfinity();
        if (prevResult != null && TextLayoutHelperKt.canReuse(prevResult, this.getText(), this.getStyle(), this.getMaxLines(), this.getSoftWrap(), this.getOverflow(), this.getDensity(), this.getLayoutDirection(), this.getResourceLoader(), constraints)) {
            void val1$iv$iv2;
            long l2;
            void height$iv2;
            void width$iv2;
            IntPx intPx4;
            Px $this$ceil$iv3;
            void $this$px$iv32;
            IntPx intPx5;
            Px $this$ceil$iv4;
            void $this$px$iv22;
            Px px2;
            boolean bl = false;
            boolean bl2 = false;
            TextLayoutResult $this$layout_u24lambda_u2d3 = prevResult;
            float f = $this$layout_u24lambda_u2d3.getMultiParagraph$ui_text_release().getWidth();
            Constraints constraints2 = constraints;
            MultiParagraph multiParagraph = null;
            TextLayoutInput textLayoutInput = TextLayoutInput.copy$default($this$layout_u24lambda_u2d3.getLayoutInput(), null, null, 0, false, null, null, null, null, constraints, 255, null);
            TextLayoutResult textLayoutResult = $this$layout_u24lambda_u2d3;
            Px $this$px$iv22 = px2 = new Px((float)$this$px$iv22);
            float f2 = $this$ceil$iv4.getValue();
            boolean bl3 = false;
            if (Float.isInfinite(f2)) {
                intPx5 = IntPx.Companion.getInfinity();
            } else {
                f2 = $this$ceil$iv4.getValue();
                bl3 = false;
                float f3 = (float)Math.ceil(f2);
                int n = (int)f3;
                intPx5 = new IntPx(n);
            }
            $this$ceil$iv4 = px2 = intPx5;
            f2 = $this$layout_u24lambda_u2d3.getMultiParagraph$ui_text_release().getHeight();
            Px $this$px$iv32 = px2 = new Px((float)$this$px$iv32);
            float f4 = $this$ceil$iv3.getValue();
            boolean bl4 = false;
            if (Float.isInfinite(f4)) {
                intPx4 = IntPx.Companion.getInfinity();
            } else {
                f4 = $this$ceil$iv3.getValue();
                bl4 = false;
                float f5 = (float)Math.ceil(f4);
                int n = (int)f5;
                intPx4 = new IntPx(n);
            }
            $this$ceil$iv3 = px2 = intPx4;
            int n = width$iv2.getValue();
            int val2$iv$iv = height$iv2.getValue();
            boolean $i$f$packInts = false;
            long l3 = l2 = (long)val1$iv$iv2 << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
            px2 = new IntPxSize(l3);
            return TextLayoutResult.copy$default(textLayoutResult, textLayoutInput, multiParagraph, ConstraintsKt.constrain((Constraints)constraints2, (IntPxSize)px2), 2, null);
        }
        MultiParagraph multiParagraph = this.layoutText(minWidth.getValue(), maxWidth.getValue());
        float $this$layout_u24lambda_u2d3 = multiParagraph.getWidth();
        Constraints constraints3 = constraints;
        Px $this$px$iv42 = px = new Px((float)$this$px$iv42);
        float width$iv2 = $this$ceil$iv2.getValue();
        boolean bl = false;
        if (Float.isInfinite(width$iv2)) {
            intPx2 = IntPx.Companion.getInfinity();
        } else {
            width$iv2 = $this$ceil$iv2.getValue();
            bl = false;
            float f = (float)Math.ceil(width$iv2);
            int n = (int)f;
            intPx2 = new IntPx(n);
        }
        $this$ceil$iv2 = px = intPx2;
        width$iv2 = multiParagraph.getHeight();
        Px $this$px$iv52 = px = new Px((float)$this$px$iv52);
        float f = $this$ceil$iv.getValue();
        boolean bl5 = false;
        if (Float.isInfinite(f)) {
            intPx = IntPx.Companion.getInfinity();
        } else {
            f = $this$ceil$iv.getValue();
            bl5 = false;
            float f6 = (float)Math.ceil(f);
            int n = (int)f6;
            intPx = new IntPx(n);
        }
        $this$ceil$iv = px = intPx;
        int n = width$iv.getValue();
        int val2$iv$iv = height$iv.getValue();
        boolean $i$f$packInts = false;
        long l4 = l = (long)val1$iv$iv << 32 | (long)val2$iv$iv & 0xFFFFFFFFL;
        px = new IntPxSize(l4);
        IntPxSize size = ConstraintsKt.constrain((Constraints)constraints3, (IntPxSize)px);
        return new TextLayoutResult(new TextLayoutInput(this.getText(), this.getStyle(), this.getMaxLines(), this.getSoftWrap(), this.getOverflow(), this.getDensity(), this.getLayoutDirection(), this.getResourceLoader(), constraints), multiParagraph, size);
    }

    public static /* synthetic */ TextLayoutResult layout$default(@NotNull TextDelegate this_, @NotNull Constraints constraints, @Nullable TextLayoutResult prevResult, int $mask0, @Nullable Object $handler) {
        TextLayoutResult textLayoutResult = ($mask0 & 2) != 0 ? (TextLayoutResult)null : prevResult;
        return this_.layout(constraints, textLayoutResult);
    }

    public final void paint(@NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
        TextPainter.INSTANCE.paint(canvas, textLayoutResult);
    }

    public final void paintBackground(int start, int end, @NotNull Color color, @NotNull Canvas canvas, @NotNull TextLayoutResult textLayoutResult) {
        Intrinsics.checkParameterIsNotNull((Object)color, (String)"color");
        Intrinsics.checkParameterIsNotNull((Object)canvas, (String)"canvas");
        Intrinsics.checkParameterIsNotNull((Object)textLayoutResult, (String)"textLayoutResult");
        if (start == end) {
            return;
        }
        Path selectionPath = textLayoutResult.getMultiParagraph$ui_text_release().getPathForRange(start, end);
        Paint paint = new Paint();
        Path path = selectionPath;
        Canvas canvas2 = canvas;
        boolean bl = false;
        boolean bl2 = false;
        Paint $this$paintBackground_u24lambda_u2d4 = paint;
        $this$paintBackground_u24lambda_u2d4.setColor(color);
        Paint paint2 = paint;
        canvas2.drawPath(path, paint2);
    }
}

